class Observable:
    def __init__(self, observable, name):
        raise DeprecationWarning(
            "The Observable class is deprecated and should no longer be used. "
            "The new approach involves using a dictionary format for observables instead of a list of Observable instances. "
            "Please update your code as follows:\n\n"
            "Old code example:\n"
            "-----------------\n"
            "from qcshared.observables.observables import Observable\n"
            "paulis = ...  # your Qiskit or Cirq observable\n"
            "observable = Observable(observable=paulis, name='observable_name')\n"
            "config = standard_config(circuit)\n"
            "output_config = {\n"
            "    'expectation_values': {\n"
            "        'enabled': True,\n"
            "        'observables': [observable],  # list of Observable instances\n"
            "    }\n"
            "}\n"
            "config['output'] = output_config\n\n"
            "New code example:\n"
            "-----------------\n"
            "paulis = ...  # your Qiskit or Cirq observable\n"
            "config = standard_config(circuit)\n"
            "output_config = {\n"
            "    'expectation_values': {\n"
            "        'enabled': True,\n"
            "        'observables': {'observable_name': paulis},  # dict of names to qiskit Pauli operators\n"
            "    }\n"
            "}\n"
            "config['output'] = output_config\n\n"
            "Changes:\n"
            "--------\n"
            "1. Replace the Observable class with a direct use of Qiskit of Cirq Pauli operators.\n"
            "2. Use a dictionary to map observable names to their corresponding Pauli operators.\n"
            "3. In the output config, change from a list of Observable instances to a dictionary of observable names to Qiskit or Cirq Pauli operators.\n\n"
        )
