from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersCore
import vtkmodules.vtkFiltersExtraction
import vtkmodules.vtkFiltersGeneral
import vtkmodules.vtkFiltersGeometry
import vtkmodules.vtkFiltersHybrid
import vtkmodules.vtkFiltersModeling
import vtkmodules.vtkFiltersSources
import vtkmodules.vtkFiltersTexture

VTK_ITERATION_MODE_DIRECT_NB:int
VTK_ITERATION_MODE_MAX:int
VTK_ROTATION_MODE_ARRAY_VALUE:int
VTK_ROTATION_MODE_DIRECT_ANGLE:int

class vtkAdaptiveTemporalInterpolator(vtkmodules.vtkFiltersHybrid.vtkTemporalInterpolator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAdaptiveTemporalInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAdaptiveTemporalInterpolator': ...

class vtkAggregateDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    merge_points:'getset_descriptor'
    number_of_target_processes:'getset_descriptor'
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTargetProcesses(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAggregateDataSetFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAggregateDataSetFilter': ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetNumberOfTargetProcesses(self, __a:int) -> None: ...

class vtkAlignImageDataSetFilter(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    controller:'getset_descriptor'
    minimum_extent:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetMinimumExtent(self) -> Tuple[int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAlignImageDataSetFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAlignImageDataSetFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    @overload
    def SetMinimumExtent(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetMinimumExtent(self, _arg:Sequence[int]) -> None: ...

class vtkPeriodicFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    iteration_mode:'getset_descriptor'
    number_of_periods:'getset_descriptor'
    def AddIndex(self, index:int) -> None: ...
    def GetIterationMode(self) -> int: ...
    def GetIterationModeMaxValue(self) -> int: ...
    def GetIterationModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPeriods(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPeriodicFilter': ...
    def RemoveAllIndices(self) -> None: ...
    def RemoveIndex(self, index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPeriodicFilter': ...
    def SetIterationMode(self, _arg:int) -> None: ...
    def SetIterationModeToDirectNb(self) -> None: ...
    def SetIterationModeToMax(self) -> None: ...
    def SetNumberOfPeriods(self, _arg:int) -> None: ...

class vtkAngularPeriodicFilter(vtkPeriodicFilter):
    center:'getset_descriptor'
    compute_rotations_on_the_fly:'getset_descriptor'
    rotation_angle:'getset_descriptor'
    rotation_array_name:'getset_descriptor'
    rotation_axis:'getset_descriptor'
    rotation_mode:'getset_descriptor'
    def ComputeRotationsOnTheFlyOff(self) -> None: ...
    def ComputeRotationsOnTheFlyOn(self) -> None: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetComputeRotationsOnTheFly(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRotationAngle(self) -> float: ...
    def GetRotationArrayName(self) -> str: ...
    def GetRotationAxis(self) -> int: ...
    def GetRotationAxisMaxValue(self) -> int: ...
    def GetRotationAxisMinValue(self) -> int: ...
    def GetRotationMode(self) -> int: ...
    def GetRotationModeMaxValue(self) -> int: ...
    def GetRotationModeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAngularPeriodicFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAngularPeriodicFilter': ...
    @overload
    def SetCenter(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCenter(self, _arg:Sequence[float]) -> None: ...
    def SetComputeRotationsOnTheFly(self, _arg:bool) -> None: ...
    def SetRotationAngle(self, _arg:float) -> None: ...
    def SetRotationArrayName(self, _arg:str) -> None: ...
    def SetRotationAxis(self, _arg:int) -> None: ...
    def SetRotationAxisToX(self) -> None: ...
    def SetRotationAxisToY(self) -> None: ...
    def SetRotationAxisToZ(self) -> None: ...
    def SetRotationMode(self, _arg:int) -> None: ...
    def SetRotationModeToArrayValue(self) -> None: ...
    def SetRotationModeToDirectAngle(self) -> None: ...

class vtkBlockDistribution(object):
    num_elements:'getset_descriptor'
    num_processors:'getset_descriptor'
    @overload
    def __init__(self, N:int, P:int) -> None: ...
    @overload
    def __init__(self, __a:'vtkBlockDistribution') -> None: ...
    def GetBlockSize(self, rank:int) -> int: ...
    def GetFirstGlobalIndexOnProcessor(self, rank:int) -> int: ...
    def GetGlobalIndex(self, localIndex:int, rank:int) -> int: ...
    def GetLocalIndexOfElement(self, globalIndex:int) -> int: ...
    def GetNumElements(self) -> int: ...
    def GetNumProcessors(self) -> int: ...
    def GetProcessorOfElement(self, globalIndex:int) -> int: ...

class vtkCleanArrays(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    controller:'getset_descriptor'
    fill_partial_arrays:'getset_descriptor'
    mark_filled_partial_arrays:'getset_descriptor'
    def FillPartialArraysOff(self) -> None: ...
    def FillPartialArraysOn(self) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetFillPartialArrays(self) -> bool: ...
    def GetMarkFilledPartialArrays(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MarkFilledPartialArraysOff(self) -> None: ...
    def MarkFilledPartialArraysOn(self) -> None: ...
    def NewInstance(self) -> 'vtkCleanArrays': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCleanArrays': ...
    def SetController(self, controller:'vtkMultiProcessController') -> None: ...
    def SetFillPartialArrays(self, _arg:bool) -> None: ...
    def SetMarkFilledPartialArrays(self, _arg:bool) -> None: ...

class vtkCollectGraph(vtkmodules.vtkCommonExecutionModel.vtkGraphAlgorithm):
    DIRECTED_OUTPUT:int
    UNDIRECTED_OUTPUT:int
    USE_INPUT_TYPE:int
    controller:'getset_descriptor'
    output_type:'getset_descriptor'
    pass_through:'getset_descriptor'
    socket_controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputType(self) -> int: ...
    def GetPassThrough(self) -> int: ...
    def GetSocketController(self) -> 'vtkSocketController': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollectGraph': ...
    def PassThroughOff(self) -> None: ...
    def PassThroughOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollectGraph': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetOutputType(self, _arg:int) -> None: ...
    def SetPassThrough(self, _arg:int) -> None: ...
    def SetSocketController(self, __a:'vtkSocketController') -> None: ...

class vtkCollectPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    controller:'getset_descriptor'
    pass_through:'getset_descriptor'
    socket_controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassThrough(self) -> int: ...
    def GetSocketController(self) -> 'vtkSocketController': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollectPolyData': ...
    def PassThroughOff(self) -> None: ...
    def PassThroughOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollectPolyData': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetPassThrough(self, _arg:int) -> None: ...
    def SetSocketController(self, __a:'vtkSocketController') -> None: ...

class vtkCollectTable(vtkmodules.vtkCommonExecutionModel.vtkTableAlgorithm):
    controller:'getset_descriptor'
    pass_through:'getset_descriptor'
    socket_controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassThrough(self) -> int: ...
    def GetSocketController(self) -> 'vtkSocketController': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollectTable': ...
    def PassThroughOff(self) -> None: ...
    def PassThroughOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollectTable': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetPassThrough(self, _arg:int) -> None: ...
    def SetSocketController(self, __a:'vtkSocketController') -> None: ...

class vtkCutMaterial(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    array_name:'getset_descriptor'
    center_point:'getset_descriptor'
    material:'getset_descriptor'
    material_array_name:'getset_descriptor'
    maximum_point:'getset_descriptor'
    normal:'getset_descriptor'
    up_vector:'getset_descriptor'
    def GetArrayName(self) -> str: ...
    def GetCenterPoint(self) -> Tuple[float, float, float]: ...
    def GetMaterial(self) -> int: ...
    def GetMaterialArrayName(self) -> str: ...
    def GetMaximumPoint(self) -> Tuple[float, float, float]: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUpVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCutMaterial': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCutMaterial': ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetMaterial(self, _arg:int) -> None: ...
    def SetMaterialArrayName(self, _arg:str) -> None: ...
    @overload
    def SetUpVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUpVector(self, _arg:Sequence[float]) -> None: ...

class vtkDistributedDataFilter(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    class BoundaryModes(int): ...
    ASSIGN_TO_ALL_INTERSECTING_REGIONS:'BoundaryModes'
    ASSIGN_TO_ONE_REGION:'BoundaryModes'
    SPLIT_BOUNDARY_CELLS:'BoundaryModes'
    boundary_mode:'getset_descriptor'
    clip_cells:'getset_descriptor'
    controller:'getset_descriptor'
    cuts:'getset_descriptor'
    include_all_intersecting_cells:'getset_descriptor'
    kdtree:'getset_descriptor'
    minimum_ghost_level:'getset_descriptor'
    retain_kdtree:'getset_descriptor'
    timing:'getset_descriptor'
    use_minimal_memory:'getset_descriptor'
    def ClipCellsOff(self) -> None: ...
    def ClipCellsOn(self) -> None: ...
    def GetBoundaryMode(self) -> int: ...
    def GetClipCells(self) -> int: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetCuts(self) -> 'vtkBSPCuts': ...
    def GetIncludeAllIntersectingCells(self) -> int: ...
    def GetKdtree(self) -> 'vtkPKdTree': ...
    def GetMinimumGhostLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRetainKdtree(self) -> int: ...
    def GetTiming(self) -> int: ...
    def GetUseMinimalMemory(self) -> int: ...
    def IncludeAllIntersectingCellsOff(self) -> None: ...
    def IncludeAllIntersectingCellsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDistributedDataFilter': ...
    def RetainKdtreeOff(self) -> None: ...
    def RetainKdtreeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistributedDataFilter': ...
    def SetBoundaryMode(self, mode:int) -> None: ...
    def SetBoundaryModeToAssignToAllIntersectingRegions(self) -> None: ...
    def SetBoundaryModeToAssignToOneRegion(self) -> None: ...
    def SetBoundaryModeToSplitBoundaryCells(self) -> None: ...
    def SetClipCells(self, _arg:int) -> None: ...
    def SetController(self, c:'vtkMultiProcessController') -> None: ...
    def SetCuts(self, cuts:'vtkBSPCuts') -> None: ...
    def SetIncludeAllIntersectingCells(self, _arg:int) -> None: ...
    def SetMinimumGhostLevel(self, _arg:int) -> None: ...
    def SetRetainKdtree(self, _arg:int) -> None: ...
    def SetTiming(self, _arg:int) -> None: ...
    def SetUseMinimalMemory(self, _arg:int) -> None: ...
    def SetUserRegionAssignments(self, map:Sequence[int], numRegions:int) -> None: ...
    def TimingOff(self) -> None: ...
    def TimingOn(self) -> None: ...
    def UseMinimalMemoryOff(self) -> None: ...
    def UseMinimalMemoryOn(self) -> None: ...

class vtkDuplicatePolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    client_flag:'getset_descriptor'
    controller:'getset_descriptor'
    memory_size:'getset_descriptor'
    socket_controller:'getset_descriptor'
    synchronous:'getset_descriptor'
    def GetClientFlag(self) -> int: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetMemorySize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSocketController(self) -> 'vtkSocketController': ...
    def GetSynchronous(self) -> int: ...
    def InitializeSchedule(self, numProcs:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDuplicatePolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDuplicatePolyData': ...
    def SetClientFlag(self, _arg:int) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetSocketController(self, controller:'vtkSocketController') -> None: ...
    def SetSynchronous(self, _arg:int) -> None: ...
    def SynchronousOff(self) -> None: ...
    def SynchronousOn(self) -> None: ...

class vtkExtractCTHPart(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    capping:'getset_descriptor'
    clip_plane:'getset_descriptor'
    controller:'getset_descriptor'
    generate_solid_geometry:'getset_descriptor'
    generate_triangles:'getset_descriptor'
    m_time:'getset_descriptor'
    remove_ghost_cells:'getset_descriptor'
    volume_fraction_surface_value:'getset_descriptor'
    def AddVolumeArrayName(self, __a:str) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GenerateSolidGeometryOff(self) -> None: ...
    def GenerateSolidGeometryOn(self) -> None: ...
    def GenerateTrianglesOff(self) -> None: ...
    def GenerateTrianglesOn(self) -> None: ...
    def GetCapping(self) -> bool: ...
    def GetClipPlane(self) -> 'vtkPlane': ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetGenerateSolidGeometry(self) -> bool: ...
    def GetGenerateTriangles(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfVolumeArrayNames(self) -> int: ...
    def GetRemoveGhostCells(self) -> bool: ...
    def GetVolumeArrayName(self, idx:int) -> str: ...
    def GetVolumeFractionSurfaceValue(self) -> float: ...
    def GetVolumeFractionSurfaceValueMaxValue(self) -> float: ...
    def GetVolumeFractionSurfaceValueMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractCTHPart': ...
    def RemoveGhostCellsOff(self) -> None: ...
    def RemoveGhostCellsOn(self) -> None: ...
    def RemoveVolumeArrayNames(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractCTHPart': ...
    def SetCapping(self, _arg:bool) -> None: ...
    def SetClipPlane(self, clipPlane:'vtkPlane') -> None: ...
    def SetController(self, controller:'vtkMultiProcessController') -> None: ...
    def SetGenerateSolidGeometry(self, _arg:bool) -> None: ...
    def SetGenerateTriangles(self, _arg:bool) -> None: ...
    def SetRemoveGhostCells(self, _arg:bool) -> None: ...
    def SetVolumeFractionSurfaceValue(self, _arg:float) -> None: ...

class vtkExtractPolyDataPiece(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    create_ghost_cells:'getset_descriptor'
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractPolyDataPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractPolyDataPiece': ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkExtractUnstructuredGridPiece(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    create_ghost_cells:'getset_descriptor'
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractUnstructuredGridPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractUnstructuredGridPiece': ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkExtractUserDefinedPiece(vtkExtractUnstructuredGridPiece):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkExtractUserDefinedPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkExtractUserDefinedPiece': ...
    def SetConstantData(self, data:Pointer, len:int) -> None: ...

class vtkGenerateProcessIds(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    controller:'getset_descriptor'
    generate_cell_data:'getset_descriptor'
    generate_point_data:'getset_descriptor'
    def GenerateCellDataOff(self) -> None: ...
    def GenerateCellDataOn(self) -> None: ...
    def GeneratePointDataOff(self) -> None: ...
    def GeneratePointDataOn(self) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetGenerateCellData(self) -> bool: ...
    def GetGeneratePointData(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenerateProcessIds': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenerateProcessIds': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetGenerateCellData(self, _arg:bool) -> None: ...
    def SetGeneratePointData(self, _arg:bool) -> None: ...

class vtkHyperTreeGridGenerateGlobalIds(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridGenerateGlobalIds': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridGenerateGlobalIds': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkHyperTreeGridGenerateProcessIds(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridGenerateProcessIds': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridGenerateProcessIds': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkHyperTreeGridGhostCellsGenerator(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridGhostCellsGenerator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridGhostCellsGenerator': ...

class vtkIntegrateAttributes(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    class CommunicationIds(int): ...
    IntegrateAttrData:'CommunicationIds'
    IntegrateAttrInfo:'CommunicationIds'
    controller:'getset_descriptor'
    divide_all_cell_data_by_volume:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetDivideAllCellDataByVolume(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIntegrateAttributes': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIntegrateAttributes': ...
    def SetController(self, controller:'vtkMultiProcessController') -> None: ...
    def SetDivideAllCellDataByVolume(self, _arg:bool) -> None: ...

class vtkMergeBlocks(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    merge_partitions_only:'getset_descriptor'
    merge_points:'getset_descriptor'
    output_data_set_type:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_is_absolute:'getset_descriptor'
    def GetMergePartitionsOnly(self) -> bool: ...
    def GetMergePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputDataSetType(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceIsAbsolute(self) -> bool: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePartitionsOnlyOff(self) -> None: ...
    def MergePartitionsOnlyOn(self) -> None: ...
    def MergePointsOff(self) -> None: ...
    def MergePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMergeBlocks': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMergeBlocks': ...
    def SetMergePartitionsOnly(self, _arg:bool) -> None: ...
    def SetMergePoints(self, _arg:bool) -> None: ...
    def SetOutputDataSetType(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceIsAbsolute(self, _arg:bool) -> None: ...
    def ToleranceIsAbsoluteOff(self) -> None: ...
    def ToleranceIsAbsoluteOn(self) -> None: ...

class vtkMultiProcessControllerHelper(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @staticmethod
    def MergePieces(pieces:MutableSequence['vtkDataObject'], result:'vtkDataObject') -> bool: ...
    def NewInstance(self) -> 'vtkMultiProcessControllerHelper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMultiProcessControllerHelper': ...

class vtkPCellDataToPointData(vtkmodules.vtkFiltersCore.vtkCellDataToPointData):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPCellDataToPointData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPCellDataToPointData': ...

class vtkPConvertToMultiBlockDataSet(vtkmodules.vtkFiltersCore.vtkConvertToMultiBlockDataSet):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPConvertToMultiBlockDataSet': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPConvertToMultiBlockDataSet': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPExtractDataArraysOverTime(vtkmodules.vtkFiltersExtraction.vtkExtractDataArraysOverTime):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPExtractDataArraysOverTime': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPExtractDataArraysOverTime': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPExtractExodusGlobalTemporalVariables(vtkmodules.vtkFiltersExtraction.vtkExtractExodusGlobalTemporalVariables):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPExtractExodusGlobalTemporalVariables': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPExtractExodusGlobalTemporalVariables': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPExtractSelectedArraysOverTime(vtkmodules.vtkFiltersExtraction.vtkExtractSelectedArraysOverTime):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPExtractSelectedArraysOverTime': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPExtractSelectedArraysOverTime': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPHyperTreeGridProbeFilter(vtkmodules.vtkFiltersCore.vtkHyperTreeGridProbeFilter):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPHyperTreeGridProbeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPHyperTreeGridProbeFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPKdTree(vtkmodules.vtkCommonDataModel.vtkKdTree):
    controller:'getset_descriptor'
    region_assignment:'getset_descriptor'
    region_assignment_map:'getset_descriptor'
    region_assignment_map_length:'getset_descriptor'
    total_number_of_cells:'getset_descriptor'
    def AssignRegions(self, map:MutableSequence[int], numRegions:int) -> int: ...
    def AssignRegionsContiguous(self) -> int: ...
    def AssignRegionsRoundRobin(self) -> int: ...
    def BuildLocator(self) -> None: ...
    def CreateGlobalDataArrayBounds(self) -> int: ...
    def CreateProcessCellCountData(self) -> int: ...
    def GetAllProcessesBorderingOnPoint(self, x:float, y:float, z:float, list:'vtkIntArray') -> None: ...
    @overload
    def GetCellArrayGlobalRange(self, name:str, range:MutableSequence[float]) -> int: ...
    @overload
    def GetCellArrayGlobalRange(self, arrayIndex:int, range:MutableSequence[float]) -> int: ...
    @overload
    def GetCellListsForProcessRegions(self, ProcessId:int, set:int, inRegionCells:'vtkIdList', onBoundaryCells:'vtkIdList') -> int: ...
    @overload
    def GetCellListsForProcessRegions(self, ProcessId:int, set:'vtkDataSet', inRegionCells:'vtkIdList', onBoundaryCells:'vtkIdList') -> int: ...
    @overload
    def GetCellListsForProcessRegions(self, ProcessId:int, inRegionCells:'vtkIdList', onBoundaryCells:'vtkIdList') -> int: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPointArrayGlobalRange(self, name:str, range:MutableSequence[float]) -> int: ...
    @overload
    def GetPointArrayGlobalRange(self, arrayIndex:int, range:MutableSequence[float]) -> int: ...
    def GetProcessAssignedToRegion(self, regionId:int) -> int: ...
    def GetProcessCellCountForRegion(self, processId:int, regionId:int) -> int: ...
    def GetProcessListForRegion(self, regionId:int, processes:'vtkIntArray') -> int: ...
    def GetProcessesCellCountForRegion(self, regionId:int, count:MutableSequence[int], len:int) -> int: ...
    def GetRegionAssignment(self) -> int: ...
    def GetRegionAssignmentList(self, procId:int, list:'vtkIntArray') -> int: ...
    def GetRegionAssignmentMap(self) -> Pointer: ...
    def GetRegionAssignmentMapLength(self) -> int: ...
    def GetRegionListForProcess(self, processId:int, regions:'vtkIntArray') -> int: ...
    def GetRegionsCellCountForProcess(self, ProcessId:int, count:MutableSequence[int], len:int) -> int: ...
    def GetTotalNumberOfCells(self) -> int: ...
    def GetTotalProcessesInRegion(self, regionId:int) -> int: ...
    def GetTotalRegionsForProcess(self, processId:int) -> int: ...
    def HasData(self, processId:int, regionId:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPKdTree': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPKdTree': ...
    def SetController(self, c:'vtkMultiProcessController') -> None: ...
    def ViewOrderAllProcessesFromPosition(self, cameraPosition:Sequence[float], orderedList:'vtkIntArray') -> int: ...
    def ViewOrderAllProcessesInDirection(self, directionOfProjection:Sequence[float], orderedList:'vtkIntArray') -> int: ...

class vtkPLinearExtrusionFilter(vtkmodules.vtkFiltersModeling.vtkLinearExtrusionFilter):
    piece_invariant:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPLinearExtrusionFilter': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPLinearExtrusionFilter': ...
    def SetPieceInvariant(self, _arg:int) -> None: ...

class vtkPMaskPoints(vtkmodules.vtkFiltersCore.vtkMaskPoints):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPMaskPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPMaskPoints': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPMergeArrays(vtkmodules.vtkFiltersGeneral.vtkMergeArrays):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPMergeArrays': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPMergeArrays': ...

class vtkPOutlineCornerFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    controller:'getset_descriptor'
    corner_factor:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetCornerFactor(self) -> float: ...
    def GetCornerFactorMaxValue(self) -> float: ...
    def GetCornerFactorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPOutlineCornerFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPOutlineCornerFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetCornerFactor(self, cornerFactor:float) -> None: ...

class vtkPOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPOutlineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPOutlineFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPOutlineFilterInternals(object):
    controller:'getset_descriptor'
    corner_factor:'getset_descriptor'
    is_corner_source:'getset_descriptor'
    def __init__(self) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetCornerFactor(self, cornerFactor:float) -> None: ...
    def SetIsCornerSource(self, value:bool) -> None: ...

class vtkPPolyDataNormals(vtkmodules.vtkFiltersCore.vtkPolyDataNormals):
    piece_invariant:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPieceInvariant(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPPolyDataNormals': ...
    def PieceInvariantOff(self) -> None: ...
    def PieceInvariantOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPPolyDataNormals': ...
    def SetPieceInvariant(self, _arg:int) -> None: ...

class vtkPProbeFilter(vtkmodules.vtkFiltersCore.vtkCompositeDataProbeFilter):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPProbeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPProbeFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPProjectSphereFilter(vtkmodules.vtkFiltersGeometry.vtkProjectSphereFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPProjectSphereFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPProjectSphereFilter': ...

class vtkPReflectionFilter(vtkmodules.vtkFiltersGeneral.vtkReflectionFilter):
    controller:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPReflectionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPReflectionFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPResampleFilter(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    controller:'getset_descriptor'
    custom_sampling_bounds:'getset_descriptor'
    sampling_dimension:'getset_descriptor'
    use_input_bounds:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetCustomSamplingBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSamplingDimension(self) -> Tuple[int, int, int]: ...
    def GetUseInputBounds(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPResampleFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPResampleFilter': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    @overload
    def SetCustomSamplingBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetCustomSamplingBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSamplingDimension(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSamplingDimension(self, _arg:Sequence[int]) -> None: ...
    def SetUseInputBounds(self, _arg:int) -> None: ...
    def UseInputBoundsOff(self) -> None: ...
    def UseInputBoundsOn(self) -> None: ...

class vtkPSphereSource(vtkmodules.vtkFiltersSources.vtkSphereSource):
    estimated_memory_size:'getset_descriptor'
    def GetEstimatedMemorySize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPSphereSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPSphereSource': ...

class vtkPTextureMapToSphere(vtkmodules.vtkFiltersTexture.vtkTextureMapToSphere):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPTextureMapToSphere': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPTextureMapToSphere': ...

class vtkPYoungsMaterialInterface(vtkmodules.vtkFiltersGeneral.vtkYoungsMaterialInterface):
    controller:'getset_descriptor'
    def Aggregate(self, __a:int, __b:MutableSequence[int]) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPYoungsMaterialInterface': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPYoungsMaterialInterface': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...

class vtkPartitionBalancer(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetAlgorithm):
    class Mode(int): ...
    Expand:'Mode'
    Squash:'Mode'
    controller:'getset_descriptor'
    mode:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetMode(self) -> int: ...
    def GetModeMaxValue(self) -> int: ...
    def GetModeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPartitionBalancer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPartitionBalancer': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetMode(self, _arg:int) -> None: ...
    def SetModeToExpand(self) -> None: ...
    def SetModeToSquash(self) -> None: ...

class vtkPieceRequestFilter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    input_data:'getset_descriptor'
    number_of_pieces_max_value:'getset_descriptor'
    number_of_pieces_min_value:'getset_descriptor'
    output:'getset_descriptor'
    piece:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfPiecesMaxValue(self) -> int: ...
    def GetNumberOfPiecesMinValue(self) -> int: ...
    @overload
    def GetOutput(self) -> 'vtkDataObject': ...
    @overload
    def GetOutput(self, __a:int) -> 'vtkDataObject': ...
    def GetPiece(self) -> int: ...
    def GetPieceMaxValue(self) -> int: ...
    def GetPieceMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPieceRequestFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPieceRequestFilter': ...
    @overload
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    @overload
    def SetInputData(self, __a:int, __b:'vtkDataObject') -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetPiece(self, _arg:int) -> None: ...

class vtkPieceScalars(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    random_mode:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomMode(self) -> int: ...
    def GetScalarMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPieceScalars': ...
    def RandomModeOff(self) -> None: ...
    def RandomModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPieceScalars': ...
    def SetRandomMode(self, _arg:int) -> None: ...
    def SetScalarModeToCellData(self) -> None: ...
    def SetScalarModeToPointData(self) -> None: ...

class vtkPipelineSize(vtkmodules.vtkCommonCore.vtkObject):
    def GetEstimatedSize(self, input:'vtkAlgorithm', inputPort:int, connection:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSubPieces(self, memoryLimit:int, mapper:'vtkAlgorithm', piece:int, numPieces:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPipelineSize': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPipelineSize': ...

class vtkProcessIdScalars(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    cell_scalars_flag:'getset_descriptor'
    controller:'getset_descriptor'
    random_mode:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRandomMode(self) -> int: ...
    def GetScalarMode(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProcessIdScalars': ...
    def RandomModeOff(self) -> None: ...
    def RandomModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProcessIdScalars': ...
    def SetCellScalarsFlag(self, _arg:int) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetRandomMode(self, _arg:int) -> None: ...
    def SetScalarModeToCellData(self) -> None: ...
    def SetScalarModeToPointData(self) -> None: ...

class vtkRectilinearGridOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearGridOutlineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearGridOutlineFilter': ...

class vtkRemoveGhosts(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRemoveGhosts': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRemoveGhosts': ...

class vtkTransmitPolyDataPiece(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    controller:'getset_descriptor'
    create_ghost_cells:'getset_descriptor'
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransmitPolyDataPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransmitPolyDataPiece': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkTransmitStructuredDataPiece(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    controller:'getset_descriptor'
    create_ghost_cells:'getset_descriptor'
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransmitStructuredDataPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransmitStructuredDataPiece': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

class vtkTransmitRectilinearGridPiece(vtkTransmitStructuredDataPiece):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransmitRectilinearGridPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransmitRectilinearGridPiece': ...

class vtkTransmitStructuredGridPiece(vtkTransmitStructuredDataPiece):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransmitStructuredGridPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransmitStructuredGridPiece': ...

class vtkTransmitUnstructuredGridPiece(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    controller:'getset_descriptor'
    create_ghost_cells:'getset_descriptor'
    def CreateGhostCellsOff(self) -> None: ...
    def CreateGhostCellsOn(self) -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetCreateGhostCells(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransmitUnstructuredGridPiece': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransmitUnstructuredGridPiece': ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetCreateGhostCells(self, _arg:int) -> None: ...

