from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOCore

class vtkCesium3DTilesReader(vtkmodules.vtkCommonExecutionModel.vtkPartitionedDataSetCollectionAlgorithm):
    file_name:'getset_descriptor'
    level:'getset_descriptor'
    def CanReadFile(self, name:str) -> int: ...
    def GetFileName(self) -> str: ...
    def GetLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTileReader(self, index:int) -> 'vtkGLTFReader': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCesium3DTilesReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCesium3DTilesReader': ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetLevel(self, _arg:int) -> None: ...

class vtkCesium3DTilesWriter(vtkmodules.vtkIOCore.vtkWriter):
    class InputType(int): ...
    Buildings:'InputType'
    Mesh:'InputType'
    Points:'InputType'
    content_gltf:'getset_descriptor'
    content_gltf_save_glb:'getset_descriptor'
    crs:'getset_descriptor'
    directory_name:'getset_descriptor'
    input_type:'getset_descriptor'
    merge_tile_poly_data:'getset_descriptor'
    merged_texture_width:'getset_descriptor'
    number_of_features_per_tile:'getset_descriptor'
    offset:'getset_descriptor'
    property_texture_file:'getset_descriptor'
    save_textures:'getset_descriptor'
    save_tiles:'getset_descriptor'
    texture_base_directory:'getset_descriptor'
    def ContentGLTFOff(self) -> None: ...
    def ContentGLTFOn(self) -> None: ...
    def ContentGLTFSaveGLBOff(self) -> None: ...
    def ContentGLTFSaveGLBOn(self) -> None: ...
    def GetCRS(self) -> str: ...
    def GetContentGLTF(self) -> bool: ...
    def GetContentGLTFSaveGLB(self) -> bool: ...
    def GetDirectoryName(self) -> str: ...
    def GetInputType(self) -> int: ...
    def GetMergeTilePolyData(self) -> bool: ...
    def GetMergedTextureWidth(self) -> int: ...
    def GetNumberOfFeaturesPerTile(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> Tuple[float, float, float]: ...
    def GetPropertyTextureFile(self) -> str: ...
    def GetSaveTextures(self) -> bool: ...
    def GetSaveTiles(self) -> bool: ...
    def GetTextureBaseDirectory(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergeTilePolyDataOff(self) -> None: ...
    def MergeTilePolyDataOn(self) -> None: ...
    def NewInstance(self) -> 'vtkCesium3DTilesWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCesium3DTilesWriter': ...
    def SaveTexturesOff(self) -> None: ...
    def SaveTexturesOn(self) -> None: ...
    def SaveTilesOff(self) -> None: ...
    def SaveTilesOn(self) -> None: ...
    def SetCRS(self, _arg:str) -> None: ...
    def SetContentGLTF(self, _arg:bool) -> None: ...
    def SetContentGLTFSaveGLB(self, _arg:bool) -> None: ...
    def SetDirectoryName(self, _arg:str) -> None: ...
    def SetInputType(self, _arg:int) -> None: ...
    def SetMergeTilePolyData(self, _arg:bool) -> None: ...
    def SetMergedTextureWidth(self, _arg:int) -> None: ...
    def SetNumberOfFeaturesPerTile(self, _arg:int) -> None: ...
    @overload
    def SetOffset(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOffset(self, _arg:Sequence[float]) -> None: ...
    def SetPropertyTextureFile(self, _arg:str) -> None: ...
    def SetSaveTextures(self, _arg:bool) -> None: ...
    def SetSaveTiles(self, _arg:bool) -> None: ...
    def SetTextureBaseDirectory(self, _arg:str) -> None: ...

class vtkCesiumB3DMReader(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    file_name:'getset_descriptor'
    gltf_reader:'getset_descriptor'
    def GetFileName(self) -> str: ...
    def GetGLTFReader(self) -> 'vtkGLTFReader': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCesiumB3DMReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCesiumB3DMReader': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkCesiumPointCloudWriter(vtkmodules.vtkIOCore.vtkWriter):
    file_name:'getset_descriptor'
    point_ids:'getset_descriptor'
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIds(self) -> 'vtkIdList': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCesiumPointCloudWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCesiumPointCloudWriter': ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetPointIds(self, _arg:'vtkIdList') -> None: ...

