from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkIOExodus

class vtkPExodusIIReader(vtkmodules.vtkIOExodus.vtkExodusIIReader):
    controller:'getset_descriptor'
    file_name:'getset_descriptor'
    file_pattern:'getset_descriptor'
    file_prefix:'getset_descriptor'
    file_range:'getset_descriptor'
    number_of_file_names:'getset_descriptor'
    number_of_files:'getset_descriptor'
    total_number_of_elements:'getset_descriptor'
    total_number_of_nodes:'getset_descriptor'
    variable_cache_size:'getset_descriptor'
    def Broadcast(self, ctrl:'vtkMultiProcessController') -> None: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetFilePattern(self) -> str: ...
    def GetFilePrefix(self) -> str: ...
    def GetFileRange(self) -> Tuple[int, int]: ...
    def GetNumberOfFileNames(self) -> int: ...
    def GetNumberOfFiles(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTotalNumberOfElements(self) -> int: ...
    def GetTotalNumberOfNodes(self) -> int: ...
    def GetVariableCacheSize(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPExodusIIReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPExodusIIReader': ...
    def SetController(self, c:'vtkMultiProcessController') -> None: ...
    def SetFileName(self, name:str) -> None: ...
    def SetFilePattern(self, _arg:str) -> None: ...
    def SetFilePrefix(self, _arg:str) -> None: ...
    @overload
    def SetFileRange(self, __a:int, __b:int) -> None: ...
    @overload
    def SetFileRange(self, r:MutableSequence[int]) -> None: ...
    def SetVariableCacheSize(self, _arg:float) -> None: ...

class vtkPExodusIIWriter(vtkmodules.vtkIOExodus.vtkExodusIIWriter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPExodusIIWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPExodusIIWriter': ...

