from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkImagingCore

class vtkImageHSIToRGB(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    maximum:'getset_descriptor'
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageHSIToRGB': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageHSIToRGB': ...
    def SetMaximum(self, _arg:float) -> None: ...

class vtkImageHSVToRGB(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    maximum:'getset_descriptor'
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageHSVToRGB': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageHSVToRGB': ...
    def SetMaximum(self, _arg:float) -> None: ...

class vtkImageLuminance(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageLuminance': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageLuminance': ...

class vtkImageMapToRGBA(vtkmodules.vtkImagingCore.vtkImageMapToColors):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMapToRGBA': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMapToRGBA': ...

class vtkImageMapToWindowLevelColors(vtkmodules.vtkImagingCore.vtkImageMapToColors):
    level:'getset_descriptor'
    window:'getset_descriptor'
    def GetLevel(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWindow(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMapToWindowLevelColors': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMapToWindowLevelColors': ...
    def SetLevel(self, _arg:float) -> None: ...
    def SetWindow(self, _arg:float) -> None: ...

class vtkImageQuantizeRGBToIndex(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    build_tree_execute_time:'getset_descriptor'
    initialize_execute_time:'getset_descriptor'
    input_type:'getset_descriptor'
    lookup_index_execute_time:'getset_descriptor'
    lookup_table:'getset_descriptor'
    number_of_colors:'getset_descriptor'
    number_of_colors_max_value:'getset_descriptor'
    number_of_colors_min_value:'getset_descriptor'
    sampling_rate:'getset_descriptor'
    sort_index_by_luminance:'getset_descriptor'
    def GetBuildTreeExecuteTime(self) -> float: ...
    def GetInitializeExecuteTime(self) -> float: ...
    def GetInputType(self) -> int: ...
    def GetLookupIndexExecuteTime(self) -> float: ...
    def GetLookupTable(self) -> 'vtkLookupTable': ...
    def GetNumberOfColors(self) -> int: ...
    def GetNumberOfColorsMaxValue(self) -> int: ...
    def GetNumberOfColorsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSamplingRate(self) -> Tuple[int, int, int]: ...
    def GetSortIndexByLuminance(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageQuantizeRGBToIndex': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageQuantizeRGBToIndex': ...
    def SetBuildTreeExecuteTime(self, _arg:float) -> None: ...
    def SetInitializeExecuteTime(self, _arg:float) -> None: ...
    def SetLookupIndexExecuteTime(self, _arg:float) -> None: ...
    def SetNumberOfColors(self, _arg:int) -> None: ...
    @overload
    def SetSamplingRate(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetSamplingRate(self, _arg:Sequence[int]) -> None: ...
    def SetSortIndexByLuminance(self, _arg:bool) -> None: ...
    def SortIndexByLuminanceOff(self) -> None: ...
    def SortIndexByLuminanceOn(self) -> None: ...

class vtkImageRGBToHSI(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    maximum:'getset_descriptor'
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageRGBToHSI': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageRGBToHSI': ...
    def SetMaximum(self, _arg:float) -> None: ...

class vtkImageRGBToHSV(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    maximum:'getset_descriptor'
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageRGBToHSV': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageRGBToHSV': ...
    def SetMaximum(self, _arg:float) -> None: ...

class vtkImageRGBToXYZ(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageRGBToXYZ': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageRGBToXYZ': ...

class vtkImageRGBToYIQ(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    maximum:'getset_descriptor'
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageRGBToYIQ': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageRGBToYIQ': ...
    def SetMaximum(self, _arg:float) -> None: ...

class vtkImageXYZToLAB(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageXYZToLAB': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageXYZToLAB': ...

class vtkImageYIQToRGB(vtkmodules.vtkCommonExecutionModel.vtkThreadedImageAlgorithm):
    maximum:'getset_descriptor'
    def GetMaximum(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageYIQToRGB': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageYIQToRGB': ...
    def SetMaximum(self, _arg:float) -> None: ...

