from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersSources
import vtkmodules.vtkRenderingContext2D
import vtkmodules.vtkRenderingCore

VTK_CUBIC_RESLICE:int
VTK_IMAGE_PLANE_WIDGET_MAX_TEXTBUFF:int
VTK_ITW_PROJECTION_XY:int
VTK_ITW_PROJECTION_XZ:int
VTK_ITW_PROJECTION_YZ:int
VTK_ITW_SNAP_CELLS:int
VTK_ITW_SNAP_POINTS:int
VTK_LINEAR_RESLICE:int
VTK_MAX_ANNULUS_RESOLUTION:int
VTK_MAX_CONE_RESOLUTION:int
VTK_MAX_CYL_RESOLUTION:int
VTK_NEAREST_RESLICE:int
VTK_PLANE_OFF:int
VTK_PLANE_OUTLINE:int
VTK_PLANE_SURFACE:int
VTK_PLANE_WIREFRAME:int
VTK_PROJECTION_OBLIQUE:int
VTK_PROJECTION_XY:int
VTK_PROJECTION_XZ:int
VTK_PROJECTION_YZ:int
VTK_RESLICE_CURSOR_REPRESENTATION_MAX_TEXTBUFF:int
VTK_SPHERE_OFF:int
VTK_SPHERE_SURFACE:int
VTK_SPHERE_WIREFRAME:int

class vtkWidgetRepresentation(vtkmodules.vtkRenderingCore.vtkProp):
    class Axis(int): ...
    Custom:'Axis'
    NONE:'Axis'
    XAxis:'Axis'
    YAxis:'Axis'
    ZAxis:'Axis'
    bounds:'getset_descriptor'
    handle_size:'getset_descriptor'
    interaction_state:'getset_descriptor'
    need_to_render:'getset_descriptor'
    picking_managed:'getset_descriptor'
    place_factor:'getset_descriptor'
    renderer:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, __a:'vtkRenderWindowInteractor', __b:'vtkAbstractWidget', __c:int, __d:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, callData:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def EndComplexInteraction(self, __a:'vtkRenderWindowInteractor', __b:'vtkAbstractWidget', __c:int, __d:Pointer) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetHandleSize(self) -> float: ...
    def GetHandleSizeMaxValue(self) -> float: ...
    def GetHandleSizeMinValue(self) -> float: ...
    def GetInteractionState(self) -> int: ...
    def GetNeedToRender(self) -> int: ...
    def GetNeedToRenderMaxValue(self) -> int: ...
    def GetNeedToRenderMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickingManaged(self) -> bool: ...
    def GetPlaceFactor(self) -> float: ...
    def GetPlaceFactorMaxValue(self) -> float: ...
    def GetPlaceFactorMinValue(self) -> float: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetVolumes(self, __a:'vtkPropCollection') -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlightOn:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NeedToRenderOff(self) -> None: ...
    def NeedToRenderOn(self) -> None: ...
    def NewInstance(self) -> 'vtkWidgetRepresentation': ...
    def PickingManagedOff(self) -> None: ...
    def PickingManagedOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWidgetRepresentation': ...
    def SetHandleSize(self, _arg:float) -> None: ...
    def SetNeedToRender(self, _arg:int) -> None: ...
    def SetPickingManaged(self, managed:bool) -> None: ...
    def SetPlaceFactor(self, _arg:float) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StartComplexInteraction(self, __a:'vtkRenderWindowInteractor', __b:'vtkAbstractWidget', __c:int, __d:Pointer) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def UnRegisterPickers(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtk3DCursorRepresentation(vtkWidgetRepresentation):
    class CursorShape(int): ...
    CROSS_SHAPE:'CursorShape'
    CUSTOM_SHAPE:'CursorShape'
    SPHERE_SHAPE:'CursorShape'
    cursor:'getset_descriptor'
    cursor_shape:'getset_descriptor'
    custom_cursor:'getset_descriptor'
    shape:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetCursor(self) -> 'vtkActor': ...
    def GetCustomCursor(self) -> 'vtkActor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShape(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtk3DCursorRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DCursorRepresentation': ...
    def SetCursor(self, cursor:'vtkActor') -> None: ...
    def SetCursorShape(self, shape:int) -> None: ...
    def SetCustomCursor(self, customCursor:'vtkActor') -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkAbstractWidget(vtkmodules.vtkRenderingCore.vtkInteractorObserver):
    enabled:'getset_descriptor'
    event_translator:'getset_descriptor'
    manages_cursor:'getset_descriptor'
    parent:'getset_descriptor'
    priority:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetEventTranslator(self) -> 'vtkWidgetEventTranslator': ...
    def GetManagesCursor(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParent(self) -> 'vtkAbstractWidget': ...
    def GetProcessEvents(self) -> int: ...
    def GetProcessEventsMaxValue(self) -> int: ...
    def GetProcessEventsMinValue(self) -> int: ...
    def GetRepresentation(self) -> 'vtkWidgetRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ManagesCursorOff(self) -> None: ...
    def ManagesCursorOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAbstractWidget': ...
    def ProcessEventsOff(self) -> None: ...
    def ProcessEventsOn(self) -> None: ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetManagesCursor(self, _arg:int) -> None: ...
    def SetParent(self, parent:'vtkAbstractWidget') -> None: ...
    def SetPriority(self, __a:float) -> None: ...
    def SetProcessEvents(self, _arg:int) -> None: ...

class vtk3DCursorWidget(vtkAbstractWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def Get3DCursorRepresentation(self) -> 'vtk3DCursorRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtk3DCursorWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DCursorWidget': ...
    def SetRepresentation(self, r:'vtk3DCursorRepresentation') -> None: ...

class vtk3DWidget(vtkmodules.vtkRenderingCore.vtkInteractorObserver):
    handle_size:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    place_factor:'getset_descriptor'
    prop3d:'getset_descriptor'
    def GetHandleSize(self) -> float: ...
    def GetHandleSizeMaxValue(self) -> float: ...
    def GetHandleSizeMinValue(self) -> float: ...
    def GetInput(self) -> 'vtkDataSet': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlaceFactor(self) -> float: ...
    def GetPlaceFactorMaxValue(self) -> float: ...
    def GetPlaceFactorMinValue(self) -> float: ...
    def GetProp3D(self) -> 'vtkProp3D': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtk3DWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtk3DWidget': ...
    def SetHandleSize(self, _arg:float) -> None: ...
    def SetInputConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, __a:'vtkDataSet') -> None: ...
    def SetPlaceFactor(self, _arg:float) -> None: ...
    def SetProp3D(self, __a:'vtkProp3D') -> None: ...

class vtkHandleRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Nearby:'InteractionStateType'
    Outside:'InteractionStateType'
    Scaling:'InteractionStateType'
    Selecting:'InteractionStateType'
    Translating:'InteractionStateType'
    active_representation:'getset_descriptor'
    constrained:'getset_descriptor'
    custom_translation_axis:'getset_descriptor'
    custom_translation_axis_on:'getset_descriptor'
    display_position:'getset_descriptor'
    interaction_state:'getset_descriptor'
    m_time:'getset_descriptor'
    point_placer:'getset_descriptor'
    renderer:'getset_descriptor'
    tolerance:'getset_descriptor'
    translation_axis:'getset_descriptor'
    world_position:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def ActiveRepresentationOff(self) -> None: ...
    def ActiveRepresentationOn(self) -> None: ...
    def CheckConstraint(self, renderer:'vtkRenderer', pos:MutableSequence[float]) -> int: ...
    def ConstrainedOff(self) -> None: ...
    def ConstrainedOn(self) -> None: ...
    def DeepCopy(self, prop:'vtkProp') -> None: ...
    def GetActiveRepresentation(self) -> int: ...
    def GetConstrained(self) -> int: ...
    def GetCustomTranslationAxis(self) -> Tuple[float, float, float]: ...
    @overload
    def GetDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetDisplayPosition(self) -> Tuple[float, float]: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointPlacer(self) -> 'vtkPointPlacer': ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def GetTranslationVector(self, p1:Sequence[float], p2:Sequence[float], v:MutableSequence[float]) -> None: ...
    @overload
    def GetWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetWorldPosition(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHandleRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHandleRepresentation': ...
    def SetActiveRepresentation(self, _arg:int) -> None: ...
    def SetConstrained(self, _arg:int) -> None: ...
    @overload
    def SetCustomTranslationAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCustomTranslationAxis(self, _arg:Sequence[float]) -> None: ...
    def SetCustomTranslationAxisOn(self) -> None: ...
    def SetDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetPointPlacer(self, __a:'vtkPointPlacer') -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    @overload
    def Translate(self, p1:Sequence[float], p2:Sequence[float]) -> None: ...
    @overload
    def Translate(self, v:Sequence[float]) -> None: ...

class vtkAbstractPolygonalHandleRepresentation3D(vtkHandleRepresentation):
    bounds:'getset_descriptor'
    display_position:'getset_descriptor'
    handle:'getset_descriptor'
    handle_visibility:'getset_descriptor'
    label_text:'getset_descriptor'
    label_text_actor:'getset_descriptor'
    label_text_scale:'getset_descriptor'
    label_visibility:'getset_descriptor'
    property:'getset_descriptor'
    selected_property:'getset_descriptor'
    smooth_motion:'getset_descriptor'
    transform:'getset_descriptor'
    uniform_scale:'getset_descriptor'
    world_position:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DeepCopy(self, prop:'vtkProp') -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetHandle(self) -> 'vtkPolyData': ...
    def GetHandleVisibility(self) -> int: ...
    def GetLabelText(self) -> str: ...
    def GetLabelTextActor(self) -> 'vtkFollower': ...
    def GetLabelTextScale(self) -> Pointer: ...
    def GetLabelVisibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def GetSmoothMotion(self) -> int: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def HandleVisibilityOff(self) -> None: ...
    def HandleVisibilityOn(self) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlight:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAbstractPolygonalHandleRepresentation3D': ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractPolygonalHandleRepresentation3D': ...
    def SetDisplayPosition(self, p:MutableSequence[float]) -> None: ...
    def SetHandle(self, __a:'vtkPolyData') -> None: ...
    def SetHandleVisibility(self, _arg:int) -> None: ...
    def SetLabelText(self, label:str) -> None: ...
    @overload
    def SetLabelTextScale(self, scale:MutableSequence[float]) -> None: ...
    @overload
    def SetLabelTextScale(self, x:float, y:float, z:float) -> None: ...
    def SetLabelVisibility(self, _arg:int) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetSelectedProperty(self, __a:'vtkProperty') -> None: ...
    def SetSmoothMotion(self, _arg:int) -> None: ...
    def SetUniformScale(self, scale:float) -> None: ...
    def SetWorldPosition(self, p:MutableSequence[float]) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def SmoothMotionOff(self) -> None: ...
    def SmoothMotionOn(self) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def Translate(self, v:Sequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkCurveRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Erasing:'InteractionStateType'
    Inserting:'InteractionStateType'
    Moving:'InteractionStateType'
    OnHandle:'InteractionStateType'
    OnLine:'InteractionStateType'
    Outside:'InteractionStateType'
    Pushing:'InteractionStateType'
    Scaling:'InteractionStateType'
    Spinning:'InteractionStateType'
    bounds:'getset_descriptor'
    closed:'getset_descriptor'
    current_handle_index:'getset_descriptor'
    directional:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_positions:'getset_descriptor'
    handle_property:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    line_color:'getset_descriptor'
    line_property:'getset_descriptor'
    number_of_handles:'getset_descriptor'
    plane_source:'getset_descriptor'
    project_to_plane:'getset_descriptor'
    projection_normal:'getset_descriptor'
    projection_position:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    summed_length:'getset_descriptor'
    translation_axis:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ClosedOff(self) -> None: ...
    def ClosedOn(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DirectionalOff(self) -> None: ...
    def DirectionalOn(self) -> None: ...
    def EndWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetClosed(self) -> int: ...
    def GetCurrentHandleIndex(self) -> int: ...
    def GetDirectional(self) -> bool: ...
    @overload
    def GetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetHandlePosition(self, handle:int) -> Pointer: ...
    def GetHandlePositions(self) -> 'vtkDoubleArray': ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHandles(self) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetProjectToPlane(self) -> int: ...
    def GetProjectionNormal(self) -> int: ...
    def GetProjectionNormalMaxValue(self) -> int: ...
    def GetProjectionNormalMinValue(self) -> int: ...
    def GetProjectionPosition(self) -> float: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedLineProperty(self) -> 'vtkProperty': ...
    def GetSummedLength(self) -> float: ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitializeHandles(self, points:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsClosed(self) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCurveRepresentation': ...
    def ProjectToPlaneOff(self) -> None: ...
    def ProjectToPlaneOn(self) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCurveRepresentation': ...
    def SetClosed(self, closed:int) -> None: ...
    def SetCurrentHandleIndex(self, index:int) -> None: ...
    def SetDirectional(self, val:bool) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, x:float, y:float, z:float) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLineColor(self, r:float, g:float, b:float) -> None: ...
    def SetNumberOfHandles(self, npts:int) -> None: ...
    def SetPlaneSource(self, plane:'vtkPlaneSource') -> None: ...
    def SetProjectToPlane(self, _arg:int) -> None: ...
    def SetProjectionNormal(self, _arg:int) -> None: ...
    def SetProjectionNormalToOblique(self) -> None: ...
    def SetProjectionNormalToXAxes(self) -> None: ...
    def SetProjectionNormalToYAxes(self) -> None: ...
    def SetProjectionNormalToZAxes(self) -> None: ...
    def SetProjectionPosition(self, position:float) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkAbstractSplineRepresentation(vtkCurveRepresentation):
    handle_positions:'getset_descriptor'
    parametric_spline:'getset_descriptor'
    resolution:'getset_descriptor'
    summed_length:'getset_descriptor'
    def GetHandlePositions(self) -> 'vtkDoubleArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParametricSpline(self) -> 'vtkParametricSpline': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetResolution(self) -> int: ...
    def GetSummedLength(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractSplineRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractSplineRepresentation': ...
    def SetParametricSpline(self, spline:'vtkParametricSpline') -> None: ...
    def SetResolution(self, resolution:int) -> None: ...

class vtkAffineRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    MoveOrigin:'InteractionStateType'
    MoveOriginX:'InteractionStateType'
    MoveOriginY:'InteractionStateType'
    Outside:'InteractionStateType'
    Rotate:'InteractionStateType'
    ScaleEEdge:'InteractionStateType'
    ScaleNE:'InteractionStateType'
    ScaleNEdge:'InteractionStateType'
    ScaleNW:'InteractionStateType'
    ScaleSE:'InteractionStateType'
    ScaleSEdge:'InteractionStateType'
    ScaleSW:'InteractionStateType'
    ScaleWEdge:'InteractionStateType'
    ShearEEdge:'InteractionStateType'
    ShearNEdge:'InteractionStateType'
    ShearSEdge:'InteractionStateType'
    ShearWEdge:'InteractionStateType'
    Translate:'InteractionStateType'
    TranslateX:'InteractionStateType'
    TranslateY:'InteractionStateType'
    tolerance:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def GetTransform(self, t:'vtkTransform') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAffineRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAffineRepresentation': ...
    def SetTolerance(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkAffineRepresentation2D(vtkAffineRepresentation):
    axes_width:'getset_descriptor'
    box_width:'getset_descriptor'
    circle_width:'getset_descriptor'
    display_text:'getset_descriptor'
    origin:'getset_descriptor'
    property:'getset_descriptor'
    selected_property:'getset_descriptor'
    text_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DisplayTextOff(self) -> None: ...
    def DisplayTextOn(self) -> None: ...
    def EndWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetAxesWidth(self) -> int: ...
    def GetAxesWidthMaxValue(self) -> int: ...
    def GetAxesWidthMinValue(self) -> int: ...
    def GetBoxWidth(self) -> int: ...
    def GetBoxWidthMaxValue(self) -> int: ...
    def GetBoxWidthMinValue(self) -> int: ...
    def GetCircleWidth(self) -> int: ...
    def GetCircleWidthMaxValue(self) -> int: ...
    def GetCircleWidthMinValue(self) -> int: ...
    def GetDisplayText(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetSelectedProperty(self) -> 'vtkProperty2D': ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetTransform(self, t:'vtkTransform') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAffineRepresentation2D': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAffineRepresentation2D': ...
    def SetAxesWidth(self, _arg:int) -> None: ...
    def SetBoxWidth(self, _arg:int) -> None: ...
    def SetCircleWidth(self, _arg:int) -> None: ...
    def SetDisplayText(self, _arg:int) -> None: ...
    @overload
    def SetOrigin(self, o:Sequence[float]) -> None: ...
    @overload
    def SetOrigin(self, ox:float, oy:float, oz:float) -> None: ...
    def SetProperty(self, __a:'vtkProperty2D') -> None: ...
    def SetSelectedProperty(self, __a:'vtkProperty2D') -> None: ...
    def SetTextProperty(self, __a:'vtkTextProperty') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkAffineWidget(vtkAbstractWidget):
    affine_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetAffineRepresentation(self) -> 'vtkAffineRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAffineWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAffineWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkAffineRepresentation') -> None: ...

class vtkAngleRepresentation(vtkWidgetRepresentation):
    NearCenter:int
    NearP1:int
    NearP2:int
    Outside:int
    angle:'getset_descriptor'
    arc_visibility:'getset_descriptor'
    center_display_position:'getset_descriptor'
    center_representation:'getset_descriptor'
    handle_representation:'getset_descriptor'
    label_format:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_representation:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_representation:'getset_descriptor'
    ray1_visibility:'getset_descriptor'
    ray2_visibility:'getset_descriptor'
    renderer:'getset_descriptor'
    scale:'getset_descriptor'
    tolerance:'getset_descriptor'
    def ArcVisibilityOff(self) -> None: ...
    def ArcVisibilityOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def CenterWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetAngle(self) -> float: ...
    def GetArcVisibility(self) -> int: ...
    def GetCenterDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetCenterRepresentation(self) -> 'vtkHandleRepresentation': ...
    def GetCenterWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetLabelFormat(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint1Representation(self) -> 'vtkHandleRepresentation': ...
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2Representation(self) -> 'vtkHandleRepresentation': ...
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetRay1Visibility(self) -> int: ...
    def GetRay2Visibility(self) -> int: ...
    def GetScale(self) -> float: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def InstantiateHandleRepresentation(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAngleRepresentation': ...
    def Ray1VisibilityOff(self) -> None: ...
    def Ray1VisibilityOn(self) -> None: ...
    def Ray2VisibilityOff(self) -> None: ...
    def Ray2VisibilityOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAngleRepresentation': ...
    def SetArcVisibility(self, _arg:int) -> None: ...
    def SetCenterDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetHandleRepresentation(self, handle:'vtkHandleRepresentation') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetRay1Visibility(self, _arg:int) -> None: ...
    def SetRay2Visibility(self, _arg:int) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetScale(self, _arg:float) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkAngleRepresentation2D(vtkAngleRepresentation):
    angle:'getset_descriptor'
    arc:'getset_descriptor'
    center_display_position:'getset_descriptor'
    center_world_position:'getset_descriptor'
    force3d_arc_placement:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    ray1:'getset_descriptor'
    ray2:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetAngle(self) -> float: ...
    def GetArc(self) -> 'vtkLeaderActor2D': ...
    def GetCenterDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetCenterWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetForce3DArcPlacement(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetRay1(self) -> 'vtkLeaderActor2D': ...
    def GetRay2(self) -> 'vtkLeaderActor2D': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAngleRepresentation2D': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAngleRepresentation2D': ...
    def SetCenterDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetCenterWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetForce3DArcPlacement(self, _arg:bool) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...

class vtkAngleRepresentation3D(vtkAngleRepresentation):
    angle:'getset_descriptor'
    arc:'getset_descriptor'
    center_display_position:'getset_descriptor'
    center_world_position:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    ray1:'getset_descriptor'
    ray2:'getset_descriptor'
    text_actor:'getset_descriptor'
    text_actor_scale:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetAngle(self) -> float: ...
    def GetArc(self) -> 'vtkActor': ...
    def GetCenterDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetCenterWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetRay1(self) -> 'vtkActor': ...
    def GetRay2(self) -> 'vtkActor': ...
    def GetTextActor(self) -> 'vtkFollower': ...
    def GetTextActorScale(self) -> Pointer: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAngleRepresentation3D': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAngleRepresentation3D': ...
    def SetCenterDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetCenterWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetTextActorScale(self, scale:MutableSequence[float]) -> None: ...

class vtkAngleWidget(vtkAbstractWidget):
    Define:int
    Manipulate:int
    Start:int
    angle_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    widget_state:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetAngleRepresentation(self) -> 'vtkAngleRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAngleValid(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAngleWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAngleWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkAngleRepresentation') -> None: ...
    def SetWidgetStateToManipulate(self) -> None: ...
    def SetWidgetStateToStart(self) -> None: ...

class vtkAxesTransformRepresentation(vtkWidgetRepresentation):
    OnOrigin:int
    OnX:int
    OnXEnd:int
    OnY:int
    OnYEnd:int
    OnZ:int
    OnZEnd:int
    Outside:int
    bounds:'getset_descriptor'
    interaction_state:'getset_descriptor'
    label_format:'getset_descriptor'
    label_property:'getset_descriptor'
    label_scale:'getset_descriptor'
    origin_display_position:'getset_descriptor'
    origin_representation:'getset_descriptor'
    origin_world_position:'getset_descriptor'
    selection_representation:'getset_descriptor'
    tolerance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelProperty(self) -> 'vtkProperty': ...
    def GetLabelScale(self) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOriginDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetOriginRepresentation(self) -> 'vtkHandleRepresentation': ...
    @overload
    def GetOriginWorldPosition(self) -> Pointer: ...
    @overload
    def GetOriginWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetSelectionRepresentation(self) -> 'vtkHandleRepresentation': ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAxesTransformRepresentation': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxesTransformRepresentation': ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    @overload
    def SetLabelScale(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetLabelScale(self, scale:MutableSequence[float]) -> None: ...
    def SetOriginDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetOriginWorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkAxesTransformWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    line_representation:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetLineRepresentation(self) -> 'vtkAxesTransformRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAxesTransformWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxesTransformWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkAxesTransformRepresentation') -> None: ...

class vtkBalloonRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    ImageBottom:int
    ImageLeft:int
    ImageRight:int
    ImageTop:int
    OnImage:'InteractionStateType'
    OnText:'InteractionStateType'
    Outside:'InteractionStateType'
    balloon_image:'getset_descriptor'
    balloon_layout:'getset_descriptor'
    balloon_text:'getset_descriptor'
    frame_property:'getset_descriptor'
    image_property:'getset_descriptor'
    image_size:'getset_descriptor'
    offset:'getset_descriptor'
    padding:'getset_descriptor'
    text_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def EndWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def GetBalloonImage(self) -> 'vtkImageData': ...
    def GetBalloonLayout(self) -> int: ...
    def GetBalloonText(self) -> str: ...
    def GetFrameProperty(self) -> 'vtkProperty2D': ...
    def GetImageProperty(self) -> 'vtkProperty2D': ...
    def GetImageSize(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> Tuple[int, int]: ...
    def GetPadding(self) -> int: ...
    def GetPaddingMaxValue(self) -> int: ...
    def GetPaddingMinValue(self) -> int: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBalloonRepresentation': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBalloonRepresentation': ...
    def SetBalloonImage(self, img:'vtkImageData') -> None: ...
    def SetBalloonLayout(self, _arg:int) -> None: ...
    def SetBalloonLayoutToImageBottom(self) -> None: ...
    def SetBalloonLayoutToImageLeft(self) -> None: ...
    def SetBalloonLayoutToImageRight(self) -> None: ...
    def SetBalloonLayoutToImageTop(self) -> None: ...
    def SetBalloonLayoutToTextBottom(self) -> None: ...
    def SetBalloonLayoutToTextLeft(self) -> None: ...
    def SetBalloonLayoutToTextRight(self) -> None: ...
    def SetBalloonLayoutToTextTop(self) -> None: ...
    def SetBalloonText(self, _arg:str) -> None: ...
    def SetFrameProperty(self, p:'vtkProperty2D') -> None: ...
    def SetImageProperty(self, p:'vtkProperty2D') -> None: ...
    @overload
    def SetImageSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetImageSize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetOffset(self, _arg:Sequence[int]) -> None: ...
    def SetPadding(self, _arg:int) -> None: ...
    def SetTextProperty(self, p:'vtkTextProperty') -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkHoverWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    timer_duration:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTimerDuration(self) -> int: ...
    def GetTimerDurationMaxValue(self) -> int: ...
    def GetTimerDurationMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHoverWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHoverWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetTimerDuration(self, _arg:int) -> None: ...

class vtkBalloonWidget(vtkHoverWidget):
    balloon_representation:'getset_descriptor'
    current_prop:'getset_descriptor'
    enabled:'getset_descriptor'
    picker:'getset_descriptor'
    representation:'getset_descriptor'
    @overload
    def AddBalloon(self, prop:'vtkProp', str:str, img:'vtkImageData') -> None: ...
    @overload
    def AddBalloon(self, prop:'vtkProp', str:str) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def GetBalloonImage(self, prop:'vtkProp') -> 'vtkImageData': ...
    def GetBalloonRepresentation(self) -> 'vtkBalloonRepresentation': ...
    def GetBalloonString(self, prop:'vtkProp') -> str: ...
    def GetCurrentProp(self) -> 'vtkProp': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPicker(self) -> 'vtkAbstractPropPicker': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBalloonWidget': ...
    def RegisterPickers(self) -> None: ...
    def RemoveBalloon(self, prop:'vtkProp') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBalloonWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetPicker(self, __a:'vtkAbstractPropPicker') -> None: ...
    def SetRepresentation(self, r:'vtkBalloonRepresentation') -> None: ...
    def UpdateBalloonImage(self, prop:'vtkProp', image:'vtkImageData') -> None: ...
    def UpdateBalloonString(self, prop:'vtkProp', str:str) -> None: ...

class vtkContourLineInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpan(self, nodeIndex:int, nodeIndices:'vtkIntArray', rep:'vtkContourRepresentation') -> None: ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourLineInterpolator': ...
    def UpdateNode(self, __a:'vtkRenderer', __b:'vtkContourRepresentation', node:MutableSequence[float], idx:int) -> int: ...

class vtkBezierContourLineInterpolator(vtkContourLineInterpolator):
    maximum_curve_error:'getset_descriptor'
    maximum_curve_line_segments:'getset_descriptor'
    def GetMaximumCurveError(self) -> float: ...
    def GetMaximumCurveErrorMaxValue(self) -> float: ...
    def GetMaximumCurveErrorMinValue(self) -> float: ...
    def GetMaximumCurveLineSegments(self) -> int: ...
    def GetMaximumCurveLineSegmentsMaxValue(self) -> int: ...
    def GetMaximumCurveLineSegmentsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSpan(self, nodeIndex:int, nodeIndices:'vtkIntArray', rep:'vtkContourRepresentation') -> None: ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBezierContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBezierContourLineInterpolator': ...
    def SetMaximumCurveError(self, _arg:float) -> None: ...
    def SetMaximumCurveLineSegments(self, _arg:int) -> None: ...

class vtkBiDimensionalRepresentation(vtkWidgetRepresentation):
    NearP1:int
    NearP2:int
    NearP3:int
    NearP4:int
    OnCenter:int
    OnL1Inner:int
    OnL1Outer:int
    OnL2Inner:int
    OnL2Outer:int
    Outside:int
    handle_representation:'getset_descriptor'
    id:'getset_descriptor'
    label_format:'getset_descriptor'
    label_text:'getset_descriptor'
    length1:'getset_descriptor'
    length2:'getset_descriptor'
    line1_visibility:'getset_descriptor'
    line2_visibility:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_representation:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_representation:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    point3_display_position:'getset_descriptor'
    point3_representation:'getset_descriptor'
    point3_world_position:'getset_descriptor'
    point4_display_position:'getset_descriptor'
    point4_representation:'getset_descriptor'
    point4_world_position:'getset_descriptor'
    show_label_above_widget:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetID(self) -> int: ...
    def GetLabelFormat(self) -> str: ...
    @overload
    def GetLabelPosition(self) -> Pointer: ...
    @overload
    def GetLabelPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetLabelText(self) -> str: ...
    def GetLength1(self) -> float: ...
    def GetLength2(self) -> float: ...
    def GetLine1Visibility(self) -> int: ...
    def GetLine2Visibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint1Representation(self) -> 'vtkHandleRepresentation': ...
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2Representation(self) -> 'vtkHandleRepresentation': ...
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint3DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint3Representation(self) -> 'vtkHandleRepresentation': ...
    def GetPoint3WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint4DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint4Representation(self) -> 'vtkHandleRepresentation': ...
    def GetPoint4WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetShowLabelAboveWidget(self) -> int: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def GetWorldLabelPosition(self, pos:MutableSequence[float]) -> None: ...
    def InstantiateHandleRepresentation(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Line1VisibilityOff(self) -> None: ...
    def Line1VisibilityOn(self) -> None: ...
    def Line2VisibilityOff(self) -> None: ...
    def Line2VisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkBiDimensionalRepresentation': ...
    def Point2WidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def Point3WidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiDimensionalRepresentation': ...
    def SetHandleRepresentation(self, handle:'vtkHandleRepresentation') -> None: ...
    def SetID(self, id:int) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLine1Visibility(self, _arg:int) -> None: ...
    def SetLine2Visibility(self, _arg:int) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint3DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint3WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint4DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint4WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetShowLabelAboveWidget(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def ShowLabelAboveWidgetOff(self) -> None: ...
    def ShowLabelAboveWidgetOn(self) -> None: ...
    def StartWidgetDefinition(self, e:MutableSequence[float]) -> None: ...
    def StartWidgetManipulation(self, e:MutableSequence[float]) -> None: ...

class vtkBiDimensionalRepresentation2D(vtkBiDimensionalRepresentation):
    NearP1:int
    NearP2:int
    NearP3:int
    NearP4:int
    OnCenter:int
    OnL1Inner:int
    OnL1Outer:int
    OnL2Inner:int
    OnL2Outer:int
    Outside:int
    label_text:'getset_descriptor'
    line_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    text_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    @overload
    def GetLabelPosition(self) -> Pointer: ...
    @overload
    def GetLabelPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetLabelText(self) -> str: ...
    def GetLineProperty(self) -> 'vtkProperty2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectedLineProperty(self) -> 'vtkProperty2D': ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetWorldLabelPosition(self, pos:MutableSequence[float]) -> None: ...
    def Highlight(self, highlightOn:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBiDimensionalRepresentation2D': ...
    def Point2WidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def Point3WidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiDimensionalRepresentation2D': ...
    def StartWidgetDefinition(self, e:MutableSequence[float]) -> None: ...
    def StartWidgetManipulation(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkBiDimensionalWidget(vtkAbstractWidget):
    Define:int
    EndWidgetSelectEvent:int
    Manipulate:int
    Start:int
    bi_dimensional_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    widget_state:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetBiDimensionalRepresentation(self) -> 'vtkBiDimensionalRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsMeasureValid(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBiDimensionalWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBiDimensionalWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkBiDimensionalRepresentation') -> None: ...
    def SetWidgetStateToManipulate(self) -> None: ...
    def SetWidgetStateToStart(self) -> None: ...

class vtkBorderRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    AdjustingE0:'InteractionStateType'
    AdjustingE1:'InteractionStateType'
    AdjustingE2:'InteractionStateType'
    AdjustingE3:'InteractionStateType'
    AdjustingP0:'InteractionStateType'
    AdjustingP1:'InteractionStateType'
    AdjustingP2:'InteractionStateType'
    AdjustingP3:'InteractionStateType'
    AnyLocation:int
    BORDER_ACTIVE:int
    BORDER_OFF:int
    BORDER_ON:int
    Inside:'InteractionStateType'
    LowerCenter:int
    LowerLeftCorner:int
    LowerRightCorner:int
    Outside:'InteractionStateType'
    UpperCenter:int
    UpperLeftCorner:int
    UpperRightCorner:int
    border_color:'getset_descriptor'
    border_property:'getset_descriptor'
    border_thickness:'getset_descriptor'
    bw_actor_display_overlay_edges:'getset_descriptor'
    bw_actor_display_overlay_polygon:'getset_descriptor'
    corner_radius_strength:'getset_descriptor'
    corner_resolution:'getset_descriptor'
    enforce_normalized_viewport_bounds:'getset_descriptor'
    interaction_state:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_size:'getset_descriptor'
    minimum_normalized_viewport_size:'getset_descriptor'
    minimum_size:'getset_descriptor'
    moving:'getset_descriptor'
    polygon_color:'getset_descriptor'
    polygon_opacity:'getset_descriptor'
    polygon_rgba:'getset_descriptor'
    position:'getset_descriptor'
    position2:'getset_descriptor'
    position2_coordinate:'getset_descriptor'
    position_coordinate:'getset_descriptor'
    proportional_resize:'getset_descriptor'
    selection_point:'getset_descriptor'
    show_border:'getset_descriptor'
    show_horizontal_border:'getset_descriptor'
    show_polygon:'getset_descriptor'
    show_polygon_background:'getset_descriptor'
    show_vertical_border:'getset_descriptor'
    tolerance:'getset_descriptor'
    window_location:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def EnforceNormalizedViewportBoundsOff(self) -> None: ...
    def EnforceNormalizedViewportBoundsOn(self) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetBorderColor(self) -> Tuple[float, float, float]: ...
    def GetBorderProperty(self) -> 'vtkProperty2D': ...
    def GetBorderThickness(self) -> float: ...
    def GetBorderThicknessMaxValue(self) -> float: ...
    def GetBorderThicknessMinValue(self) -> float: ...
    def GetCornerRadiusStrength(self) -> float: ...
    def GetCornerRadiusStrengthMaxValue(self) -> float: ...
    def GetCornerRadiusStrengthMinValue(self) -> float: ...
    def GetCornerResolution(self) -> int: ...
    def GetCornerResolutionMaxValue(self) -> int: ...
    def GetCornerResolutionMinValue(self) -> int: ...
    def GetEnforceNormalizedViewportBounds(self) -> int: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMaximumSize(self) -> Tuple[int, int]: ...
    def GetMinimumNormalizedViewportSize(self) -> Tuple[float, float]: ...
    def GetMinimumSize(self) -> Tuple[int, int]: ...
    def GetMoving(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolygonColor(self) -> Tuple[float, float, float]: ...
    def GetPolygonOpacity(self) -> float: ...
    def GetPolygonOpacityMaxValue(self) -> float: ...
    def GetPolygonOpacityMinValue(self) -> float: ...
    @overload
    def GetPolygonRGBA(self, rgba:MutableSequence[float]) -> None: ...
    @overload
    def GetPolygonRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def GetPosition2(self) -> Tuple[float, float]: ...
    def GetPosition2Coordinate(self) -> 'vtkCoordinate': ...
    def GetPositionCoordinate(self) -> 'vtkCoordinate': ...
    def GetProportionalResize(self) -> int: ...
    def GetSelectionPoint(self) -> Tuple[float, float]: ...
    def GetShowBorder(self) -> int: ...
    def GetShowBorderMaxValue(self) -> int: ...
    def GetShowBorderMinValue(self) -> int: ...
    def GetShowHorizontalBorder(self) -> int: ...
    def GetShowHorizontalBorderMaxValue(self) -> int: ...
    def GetShowHorizontalBorderMinValue(self) -> int: ...
    def GetShowPolygon(self) -> int: ...
    def GetShowPolygonBackground(self) -> int: ...
    def GetShowPolygonBackgroundMaxValue(self) -> int: ...
    def GetShowPolygonBackgroundMinValue(self) -> int: ...
    def GetShowVerticalBorder(self) -> int: ...
    def GetShowVerticalBorderMaxValue(self) -> int: ...
    def GetShowVerticalBorderMinValue(self) -> int: ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def GetWindowLocation(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MovingOff(self) -> None: ...
    def MovingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkBorderRepresentation': ...
    def ProportionalResizeOff(self) -> None: ...
    def ProportionalResizeOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBorderRepresentation': ...
    def SetBWActorDisplayOverlayEdges(self, __a:bool) -> None: ...
    def SetBWActorDisplayOverlayPolygon(self, __a:bool) -> None: ...
    @overload
    def SetBorderColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBorderColor(self, _arg:Sequence[float]) -> None: ...
    def SetBorderThickness(self, _arg:float) -> None: ...
    def SetCornerRadiusStrength(self, _arg:float) -> None: ...
    def SetCornerResolution(self, _arg:int) -> None: ...
    def SetEnforceNormalizedViewportBounds(self, _arg:int) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    @overload
    def SetMaximumSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetMaximumSize(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetMinimumNormalizedViewportSize(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetMinimumNormalizedViewportSize(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetMinimumSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetMinimumSize(self, _arg:Sequence[int]) -> None: ...
    def SetMoving(self, _arg:int) -> None: ...
    @overload
    def SetPolygonColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPolygonColor(self, _arg:Sequence[float]) -> None: ...
    def SetPolygonOpacity(self, _arg:float) -> None: ...
    @overload
    def SetPolygonRGBA(self, rgba:MutableSequence[float]) -> None: ...
    @overload
    def SetPolygonRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetPosition(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float) -> None: ...
    @overload
    def SetPosition2(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPosition2(self, x:float, y:float) -> None: ...
    def SetProportionalResize(self, _arg:int) -> None: ...
    def SetShowBorder(self, border:int) -> None: ...
    def SetShowBorderToActive(self) -> None: ...
    def SetShowBorderToOff(self) -> None: ...
    def SetShowBorderToOn(self) -> None: ...
    def SetShowHorizontalBorder(self, _arg:int) -> None: ...
    def SetShowPolygon(self, border:int) -> None: ...
    def SetShowPolygonBackground(self, _arg:int) -> None: ...
    def SetShowPolygonToActive(self) -> None: ...
    def SetShowPolygonToOff(self) -> None: ...
    def SetShowPolygonToOn(self) -> None: ...
    def SetShowVerticalBorder(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def SetWindowLocation(self, enumLocation:int) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def UpdateWindowLocation(self) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkBorderWidget(vtkAbstractWidget):
    border_representation:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    resizable:'getset_descriptor'
    selectable:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetBorderRepresentation(self) -> 'vtkBorderRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProcessEvents(self) -> int: ...
    def GetResizable(self) -> int: ...
    def GetSelectable(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBorderWidget': ...
    def ResizableOff(self) -> None: ...
    def ResizableOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBorderWidget': ...
    def SelectableOff(self) -> None: ...
    def SelectableOn(self) -> None: ...
    def SetRepresentation(self, r:'vtkBorderRepresentation') -> None: ...
    def SetResizable(self, _arg:int) -> None: ...
    def SetSelectable(self, _arg:int) -> None: ...

class vtkPointPlacer(vtkmodules.vtkCommonCore.vtkObject):
    pixel_tolerance:'getset_descriptor'
    world_tolerance:'getset_descriptor'
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelTolerance(self) -> int: ...
    def GetPixelToleranceMaxValue(self) -> int: ...
    def GetPixelToleranceMinValue(self) -> int: ...
    def GetWorldTolerance(self) -> float: ...
    def GetWorldToleranceMaxValue(self) -> float: ...
    def GetWorldToleranceMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointPlacer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointPlacer': ...
    def SetPixelTolerance(self, _arg:int) -> None: ...
    def SetWorldTolerance(self, _arg:float) -> None: ...
    def UpdateInternalState(self) -> int: ...
    def UpdateNodeWorldPosition(self, worldPos:MutableSequence[float], nodePointId:int) -> int: ...
    def UpdateWorldPosition(self, ren:'vtkRenderer', worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def ValidateDisplayPosition(self, __a:'vtkRenderer', displayPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkBoundedPlanePointPlacer(vtkPointPlacer):
    Oblique:int
    XAxis:int
    YAxis:int
    ZAxis:int
    bounding_planes:'getset_descriptor'
    oblique_plane:'getset_descriptor'
    projection_normal:'getset_descriptor'
    projection_position:'getset_descriptor'
    def AddBoundingPlane(self, plane:'vtkPlane') -> None: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetBoundingPlanes(self) -> 'vtkPlaneCollection': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObliquePlane(self) -> 'vtkPlane': ...
    def GetProjectionNormal(self) -> int: ...
    def GetProjectionNormalMaxValue(self) -> int: ...
    def GetProjectionNormalMinValue(self) -> int: ...
    def GetProjectionPosition(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBoundedPlanePointPlacer': ...
    def RemoveAllBoundingPlanes(self) -> None: ...
    def RemoveBoundingPlane(self, plane:'vtkPlane') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoundedPlanePointPlacer': ...
    @overload
    def SetBoundingPlanes(self, __a:'vtkPlaneCollection') -> None: ...
    @overload
    def SetBoundingPlanes(self, planes:'vtkPlanes') -> None: ...
    def SetObliquePlane(self, __a:'vtkPlane') -> None: ...
    def SetProjectionNormal(self, _arg:int) -> None: ...
    def SetProjectionNormalToOblique(self) -> None: ...
    def SetProjectionNormalToXAxis(self) -> None: ...
    def SetProjectionNormalToYAxis(self) -> None: ...
    def SetProjectionNormalToZAxis(self) -> None: ...
    def SetProjectionPosition(self, position:float) -> None: ...
    def UpdateWorldPosition(self, ren:'vtkRenderer', worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkBoxRepresentation(vtkWidgetRepresentation):
    MoveF0:int
    MoveF1:int
    MoveF2:int
    MoveF3:int
    MoveF4:int
    MoveF5:int
    Outside:int
    Rotating:int
    Scaling:int
    Translating:int
    bounds:'getset_descriptor'
    corners:'getset_descriptor'
    face_property:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_property:'getset_descriptor'
    inside_out:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    outline_cursor_wires:'getset_descriptor'
    outline_face_wires:'getset_descriptor'
    outline_property:'getset_descriptor'
    selected_face_property:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    snap_to_axes:'getset_descriptor'
    transform:'getset_descriptor'
    translation_axis:'getset_descriptor'
    two_plane_mode:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def EndComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCorners(self) -> Tuple[float, float]: ...
    def GetFaceProperty(self) -> 'vtkProperty': ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetInsideOut(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineCursorWires(self) -> int: ...
    def GetOutlineFaceWires(self) -> int: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetPlanes(self, planes:'vtkPlanes') -> None: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetSelectedFaceProperty(self) -> 'vtkProperty': ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetSnapToAxes(self) -> bool: ...
    def GetTransform(self, t:'vtkTransform') -> None: ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def GetTwoPlaneMode(self) -> bool: ...
    def GetUnderlyingPlane(self, i:int) -> 'vtkPlane': ...
    def HandlesOff(self) -> None: ...
    def HandlesOn(self) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBoxRepresentation': ...
    def OutlineCursorWiresOff(self) -> None: ...
    def OutlineCursorWiresOn(self) -> None: ...
    def OutlineFaceWiresOff(self) -> None: ...
    def OutlineFaceWiresOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoxRepresentation': ...
    def SetCorners(self, points:MutableSequence[float]) -> None: ...
    @overload
    def SetForegroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetForegroundColor(self, _arg:Sequence[float]) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    @overload
    def SetInteractionColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetInteractionColor(self, _arg:Sequence[float]) -> None: ...
    def SetInteractionState(self, state:int) -> None: ...
    def SetOutlineCursorWires(self, __a:int) -> None: ...
    def SetOutlineFaceWires(self, __a:int) -> None: ...
    def SetSnapToAxes(self, _arg:bool) -> None: ...
    def SetTransform(self, t:'vtkTransform') -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetTwoPlaneMode(self, __a:bool) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def StepBackward(self) -> None: ...
    def StepForward(self) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkBoxWidget(vtk3DWidget):
    enabled:'getset_descriptor'
    face_property:'getset_descriptor'
    handle_property:'getset_descriptor'
    inside_out:'getset_descriptor'
    outline_cursor_wires:'getset_descriptor'
    outline_face_wires:'getset_descriptor'
    outline_property:'getset_descriptor'
    rotation_enabled:'getset_descriptor'
    scaling_enabled:'getset_descriptor'
    selected_face_property:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    transform:'getset_descriptor'
    translation_enabled:'getset_descriptor'
    def GetFaceProperty(self) -> 'vtkProperty': ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetInsideOut(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineCursorWires(self) -> int: ...
    def GetOutlineFaceWires(self) -> int: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetPlanes(self, planes:'vtkPlanes') -> None: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRotationEnabled(self) -> int: ...
    def GetScalingEnabled(self) -> int: ...
    def GetSelectedFaceProperty(self) -> 'vtkProperty': ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetTransform(self, t:'vtkTransform') -> None: ...
    def GetTranslationEnabled(self) -> int: ...
    def HandlesOff(self) -> None: ...
    def HandlesOn(self) -> None: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBoxWidget': ...
    def OutlineCursorWiresOff(self) -> None: ...
    def OutlineCursorWiresOn(self) -> None: ...
    def OutlineFaceWiresOff(self) -> None: ...
    def OutlineFaceWiresOn(self) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def RotationEnabledOff(self) -> None: ...
    def RotationEnabledOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoxWidget': ...
    def ScalingEnabledOff(self) -> None: ...
    def ScalingEnabledOn(self) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetOutlineCursorWires(self, __a:int) -> None: ...
    def SetOutlineFaceWires(self, __a:int) -> None: ...
    def SetRotationEnabled(self, _arg:int) -> None: ...
    def SetScalingEnabled(self, _arg:int) -> None: ...
    def SetTransform(self, t:'vtkTransform') -> None: ...
    def SetTranslationEnabled(self, _arg:int) -> None: ...
    def TranslationEnabledOff(self) -> None: ...
    def TranslationEnabledOn(self) -> None: ...

class vtkBoxWidget2(vtkAbstractWidget):
    enabled:'getset_descriptor'
    move_faces_enabled:'getset_descriptor'
    representation:'getset_descriptor'
    rotation_enabled:'getset_descriptor'
    scaling_enabled:'getset_descriptor'
    translation_enabled:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetMoveFacesEnabled(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRotationEnabled(self) -> int: ...
    def GetScalingEnabled(self) -> int: ...
    def GetTranslationEnabled(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MoveFacesEnabledOff(self) -> None: ...
    def MoveFacesEnabledOn(self) -> None: ...
    def NewInstance(self) -> 'vtkBoxWidget2': ...
    def RotationEnabledOff(self) -> None: ...
    def RotationEnabledOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBoxWidget2': ...
    def ScalingEnabledOff(self) -> None: ...
    def ScalingEnabledOn(self) -> None: ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetMoveFacesEnabled(self, _arg:int) -> None: ...
    def SetRepresentation(self, r:'vtkBoxRepresentation') -> None: ...
    def SetRotationEnabled(self, _arg:int) -> None: ...
    def SetScalingEnabled(self, _arg:int) -> None: ...
    def SetTranslationEnabled(self, _arg:int) -> None: ...
    def TranslationEnabledOff(self) -> None: ...
    def TranslationEnabledOn(self) -> None: ...

class vtkBrokenLineWidget(vtk3DWidget):
    enabled:'getset_descriptor'
    handle_property:'getset_descriptor'
    handle_size_factor:'getset_descriptor'
    line_property:'getset_descriptor'
    number_of_handles:'getset_descriptor'
    plane_source:'getset_descriptor'
    process_events:'getset_descriptor'
    project_to_plane:'getset_descriptor'
    projection_normal:'getset_descriptor'
    projection_position:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    summed_length:'getset_descriptor'
    @overload
    def GetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetHandlePosition(self, handle:int) -> Pointer: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetHandleSizeFactor(self) -> float: ...
    def GetHandleSizeFactorMaxValue(self) -> float: ...
    def GetHandleSizeFactorMinValue(self) -> float: ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHandles(self) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetProcessEvents(self) -> int: ...
    def GetProcessEventsMaxValue(self) -> int: ...
    def GetProcessEventsMinValue(self) -> int: ...
    def GetProjectToPlane(self) -> int: ...
    def GetProjectionNormal(self) -> int: ...
    def GetProjectionNormalMaxValue(self) -> int: ...
    def GetProjectionNormalMinValue(self) -> int: ...
    def GetProjectionPosition(self) -> float: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedLineProperty(self) -> 'vtkProperty': ...
    def GetSummedLength(self) -> float: ...
    def InitializeHandles(self, points:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBrokenLineWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def ProcessEventsOff(self) -> None: ...
    def ProcessEventsOn(self) -> None: ...
    def ProjectToPlaneOff(self) -> None: ...
    def ProjectToPlaneOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBrokenLineWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, x:float, y:float, z:float) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    def SetHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetHandleSizeFactor(self, _arg:float) -> None: ...
    def SetLineProperty(self, __a:'vtkProperty') -> None: ...
    def SetNumberOfHandles(self, npts:int) -> None: ...
    def SetPlaneSource(self, plane:'vtkPlaneSource') -> None: ...
    def SetProcessEvents(self, _arg:int) -> None: ...
    def SetProjectToPlane(self, _arg:int) -> None: ...
    def SetProjectionNormal(self, _arg:int) -> None: ...
    def SetProjectionNormalToOblique(self) -> None: ...
    def SetProjectionNormalToXAxes(self) -> None: ...
    def SetProjectionNormalToYAxes(self) -> None: ...
    def SetProjectionNormalToZAxes(self) -> None: ...
    def SetProjectionPosition(self, position:float) -> None: ...
    def SetSelectedHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetSelectedLineProperty(self, __a:'vtkProperty') -> None: ...

class vtkButtonRepresentation(vtkWidgetRepresentation):
    class HighlightStateType(int): ...
    class InteractionStateType(int): ...
    HighlightHovering:'HighlightStateType'
    HighlightNormal:'HighlightStateType'
    HighlightSelecting:'HighlightStateType'
    Inside:'InteractionStateType'
    Outside:'InteractionStateType'
    highlight_state:'getset_descriptor'
    number_of_states_max_value:'getset_descriptor'
    number_of_states_min_value:'getset_descriptor'
    state:'getset_descriptor'
    def GetHighlightState(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfStatesMaxValue(self) -> int: ...
    def GetNumberOfStatesMinValue(self) -> int: ...
    def GetState(self) -> int: ...
    def Highlight(self, __a:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkButtonRepresentation': ...
    def NextState(self) -> None: ...
    def PreviousState(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkButtonRepresentation': ...
    def SetNumberOfStates(self, _arg:int) -> None: ...
    def SetState(self, state:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkButtonWidget(vtkAbstractWidget):
    button_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    slider_representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetButtonRepresentation(self) -> 'vtkButtonRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSliderRepresentation(self) -> 'vtkButtonRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkButtonWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkButtonWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkButtonRepresentation') -> None: ...

class vtkCamera3DRepresentation(vtkWidgetRepresentation):
    Outside:int
    Scaling:int
    Translating:int
    TranslatingNearTarget:int
    TranslatingPosition:int
    TranslatingTarget:int
    TranslatingUp:int
    bounds:'getset_descriptor'
    camera:'getset_descriptor'
    front_handle_distance:'getset_descriptor'
    frustum_visibility:'getset_descriptor'
    interaction_state:'getset_descriptor'
    secondary_handles_visibility:'getset_descriptor'
    translating_all:'getset_descriptor'
    translation_axis:'getset_descriptor'
    up_handle_distance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def FrustumVisibilityOff(self) -> None: ...
    def FrustumVisibilityOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetFrontHandleDistance(self) -> float: ...
    def GetFrontHandleDistanceMaxValue(self) -> float: ...
    def GetFrontHandleDistanceMinValue(self) -> float: ...
    def GetFrustumVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSecondaryHandlesVisibility(self) -> bool: ...
    def GetTranslatingAll(self) -> bool: ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def GetUpHandleDistance(self) -> float: ...
    def GetUpHandleDistanceMaxValue(self) -> float: ...
    def GetUpHandleDistanceMinValue(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCamera3DRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCamera3DRepresentation': ...
    def SecondaryHandlesVisibilityOff(self) -> None: ...
    def SecondaryHandlesVisibilityOn(self) -> None: ...
    def SetCamera(self, camera:'vtkCamera') -> None: ...
    def SetFrontHandleDistance(self, _arg:float) -> None: ...
    def SetFrustumVisibility(self, visible:bool) -> None: ...
    def SetInteractionState(self, state:int) -> None: ...
    def SetSecondaryHandlesVisibility(self, visible:bool) -> None: ...
    def SetTranslatingAll(self, _arg:bool) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisToNone(self) -> None: ...
    def SetTranslationAxisToXAxis(self) -> None: ...
    def SetTranslationAxisToYAxis(self) -> None: ...
    def SetTranslationAxisToZAxis(self) -> None: ...
    def SetUpHandleDistance(self, _arg:float) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def TranslatingAllOff(self) -> None: ...
    def TranslatingAllOn(self) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkCamera3DWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCamera3DWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCamera3DWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkCamera3DRepresentation') -> None: ...

class vtkCameraHandleSource(vtkmodules.vtkFiltersSources.vtkHandleSource):
    camera:'getset_descriptor'
    direction:'getset_descriptor'
    position:'getset_descriptor'
    @overload
    def GetDirection(self) -> Pointer: ...
    @overload
    def GetDirection(self, dir:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPosition(self) -> Pointer: ...
    @overload
    def GetPosition(self, pos:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraHandleSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraHandleSource': ...
    def SetCamera(self, cam:'vtkCamera') -> None: ...
    @overload
    def SetDirection(self, xTarget:float, yTarget:float, zTarget:float) -> None: ...
    @overload
    def SetDirection(self, dir:Sequence[float]) -> None: ...
    @overload
    def SetPosition(self, xPos:float, yPos:float, zPos:float) -> None: ...
    @overload
    def SetPosition(self, pos:Sequence[float]) -> None: ...

class vtkCameraOrientationRepresentation(vtkWidgetRepresentation):
    class AnchorType(int):
        LowerLeft:'AnchorType'
        LowerRight:'AnchorType'
        UpperLeft:'AnchorType'
        UpperRight:'AnchorType'
    class InteractionStateType(int):
        Hovering:'InteractionStateType'
        Outside:'InteractionStateType'
        Rotating:'InteractionStateType'
    anchor_position:'getset_descriptor'
    azimuth:'getset_descriptor'
    back:'getset_descriptor'
    bounds:'getset_descriptor'
    container_circumferential_resolution:'getset_descriptor'
    container_property:'getset_descriptor'
    container_radial_resolution:'getset_descriptor'
    container_visibility:'getset_descriptor'
    elevation:'getset_descriptor'
    handle_circumferential_resolution:'getset_descriptor'
    interaction_state_as_enum:'getset_descriptor'
    normalized_handle_dia:'getset_descriptor'
    padding:'getset_descriptor'
    picked_axis:'getset_descriptor'
    picked_dir:'getset_descriptor'
    shaft_resolution:'getset_descriptor'
    size:'getset_descriptor'
    total_length:'getset_descriptor'
    transform:'getset_descriptor'
    up:'getset_descriptor'
    x_minus_label_property:'getset_descriptor'
    x_plus_label_property:'getset_descriptor'
    y_minus_label_property:'getset_descriptor'
    y_plus_label_property:'getset_descriptor'
    z_minus_label_property:'getset_descriptor'
    z_plus_label_property:'getset_descriptor'
    def AnchorToLowerLeft(self) -> None: ...
    def AnchorToLowerRight(self) -> None: ...
    def AnchorToUpperLeft(self) -> None: ...
    def AnchorToUpperRight(self) -> None: ...
    @overload
    def ApplyInteractionState(self, state:'InteractionStateType') -> None: ...
    @overload
    def ApplyInteractionState(self, state:int) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def ContainerVisibilityOff(self) -> None: ...
    def ContainerVisibilityOn(self) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAnchorPosition(self) -> 'AnchorType': ...
    def GetAzimuth(self) -> float: ...
    def GetBack(self) -> Tuple[float, float, float]: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetContainerCircumferentialResolution(self) -> int: ...
    def GetContainerCircumferentialResolutionMaxValue(self) -> int: ...
    def GetContainerCircumferentialResolutionMinValue(self) -> int: ...
    def GetContainerProperty(self) -> 'vtkProperty': ...
    def GetContainerRadialResolution(self) -> int: ...
    def GetContainerRadialResolutionMaxValue(self) -> int: ...
    def GetContainerRadialResolutionMinValue(self) -> int: ...
    def GetContainerVisibility(self) -> bool: ...
    def GetElevation(self) -> float: ...
    def GetHandleCircumferentialResolution(self) -> int: ...
    def GetHandleCircumferentialResolutionMaxValue(self) -> int: ...
    def GetHandleCircumferentialResolutionMinValue(self) -> int: ...
    def GetInteractionStateAsEnum(self) -> 'InteractionStateType': ...
    def GetNormalizedHandleDia(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPadding(self) -> Tuple[int, int]: ...
    def GetPickedAxis(self) -> int: ...
    def GetPickedDir(self) -> int: ...
    def GetShaftResolution(self) -> int: ...
    def GetShaftResolutionMaxValue(self) -> int: ...
    def GetShaftResolutionMinValue(self) -> int: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetTotalLength(self) -> float: ...
    def GetTransform(self) -> 'vtkTransform': ...
    def GetUp(self) -> Tuple[float, float, float]: ...
    def GetXMinusLabelProperty(self) -> 'vtkTextProperty': ...
    def GetXPlusLabelProperty(self) -> 'vtkTextProperty': ...
    def GetYMinusLabelProperty(self) -> 'vtkTextProperty': ...
    def GetYPlusLabelProperty(self) -> 'vtkTextProperty': ...
    def GetZMinusLabelProperty(self) -> 'vtkTextProperty': ...
    def GetZPlusLabelProperty(self) -> 'vtkTextProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAnyHandleSelected(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraOrientationRepresentation': ...
    def PlaceWidget(self, __a:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraOrientationRepresentation': ...
    def SetContainerCircumferentialResolution(self, _arg:int) -> None: ...
    def SetContainerRadialResolution(self, _arg:int) -> None: ...
    def SetContainerVisibility(self, state:bool) -> None: ...
    def SetHandleCircumferentialResolution(self, _arg:int) -> None: ...
    def SetNormalizedHandleDia(self, _arg:float) -> None: ...
    @overload
    def SetPadding(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetPadding(self, _arg:Sequence[int]) -> None: ...
    def SetShaftResolution(self, _arg:int) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:Sequence[int]) -> None: ...
    def SetTotalLength(self, _arg:float) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkCameraOrientationWidget(vtkAbstractWidget):
    animate:'getset_descriptor'
    animator_total_frames:'getset_descriptor'
    parent_renderer:'getset_descriptor'
    def AnimateOff(self) -> None: ...
    def AnimateOn(self) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def GetAnimate(self) -> bool: ...
    def GetAnimatorTotalFrames(self) -> int: ...
    def GetAnimatorTotalFramesMaxValue(self) -> int: ...
    def GetAnimatorTotalFramesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParentRenderer(self) -> 'vtkRenderer': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraOrientationWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraOrientationWidget': ...
    def SetAnimate(self, _arg:bool) -> None: ...
    def SetAnimatorTotalFrames(self, _arg:int) -> None: ...
    def SetParentRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SquareResize(self) -> None: ...

class vtkCameraPathRepresentation(vtkAbstractSplineRepresentation):
    directional:'getset_descriptor'
    number_of_handles:'getset_descriptor'
    parametric_spline:'getset_descriptor'
    def AddCameraAt(self, camera:'vtkCamera', index:int) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def DeleteCameraAt(self, index:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitializeHandles(self, points:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraPathRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraPathRepresentation': ...
    def SetDirectional(self, val:bool) -> None: ...
    def SetNumberOfHandles(self, npts:int) -> None: ...
    def SetParametricSpline(self, spline:'vtkParametricSpline') -> None: ...

class vtkCameraPathWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraPathWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraPathWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkCameraPathRepresentation') -> None: ...

class vtkCameraRepresentation(vtkBorderRepresentation):
    camera:'getset_descriptor'
    interpolator:'getset_descriptor'
    number_of_frames:'getset_descriptor'
    number_of_frames_max_value:'getset_descriptor'
    number_of_frames_min_value:'getset_descriptor'
    property:'getset_descriptor'
    def AddCameraToPath(self) -> None: ...
    def AnimatePath(self, rwi:'vtkRenderWindowInteractor') -> None: ...
    def BuildRepresentation(self) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetInterpolator(self) -> 'vtkCameraInterpolator': ...
    def GetNumberOfFrames(self) -> int: ...
    def GetNumberOfFramesMaxValue(self) -> int: ...
    def GetNumberOfFramesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitializePath(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraRepresentation': ...
    def SetCamera(self, camera:'vtkCamera') -> None: ...
    def SetInterpolator(self, camInt:'vtkCameraInterpolator') -> None: ...
    def SetNumberOfFrames(self, _arg:int) -> None: ...

class vtkCameraWidget(vtkBorderWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraWidget': ...
    def SetRepresentation(self, r:'vtkCameraRepresentation') -> None: ...

class vtkCaptionRepresentation(vtkBorderRepresentation):
    class FitType(int): ...
    VTK_FIT_TO_BORDER:'FitType'
    VTK_FIT_TO_TEXT:'FitType'
    anchor_position:'getset_descriptor'
    anchor_representation:'getset_descriptor'
    caption_actor2d:'getset_descriptor'
    fit:'getset_descriptor'
    font_factor:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetAnchorPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetAnchorRepresentation(self) -> 'vtkPointHandleRepresentation3D': ...
    def GetCaptionActor2D(self) -> 'vtkCaptionActor2D': ...
    def GetFit(self) -> int: ...
    def GetFitAsString(self) -> str: ...
    def GetFitMaxValue(self) -> int: ...
    def GetFitMinValue(self) -> int: ...
    def GetFontFactor(self) -> float: ...
    def GetFontFactorMaxValue(self) -> float: ...
    def GetFontFactorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCaptionRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCaptionRepresentation': ...
    def SetAnchorPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetAnchorRepresentation(self, __a:'vtkPointHandleRepresentation3D') -> None: ...
    def SetCaptionActor2D(self, captionActor:'vtkCaptionActor2D') -> None: ...
    def SetFit(self, _arg:int) -> None: ...
    def SetFitToBorder(self) -> None: ...
    def SetFitToText(self) -> None: ...
    def SetFontFactor(self, _arg:float) -> None: ...

class vtkCaptionWidget(vtkBorderWidget):
    caption_actor2d:'getset_descriptor'
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetCaptionActor2D(self) -> 'vtkCaptionActor2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCaptionWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCaptionWidget': ...
    def SetCaptionActor2D(self, capActor:'vtkCaptionActor2D') -> None: ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkCaptionRepresentation') -> None: ...

class vtkCellCentersPointPlacer(vtkPointPlacer):
    CellPointsMean:int
    None_:int
    ParametricCenter:int
    cell_picker:'getset_descriptor'
    mode:'getset_descriptor'
    number_of_props:'getset_descriptor'
    def AddProp(self, __a:'vtkProp') -> None: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetCellPicker(self) -> 'vtkCellPicker': ...
    def GetMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfProps(self) -> int: ...
    def HasProp(self, __a:'vtkProp') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellCentersPointPlacer': ...
    def RemoveAllProps(self) -> None: ...
    def RemoveViewProp(self, prop:'vtkProp') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellCentersPointPlacer': ...
    def SetMode(self, _arg:int) -> None: ...
    def ValidateDisplayPosition(self, __a:'vtkRenderer', displayPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkSliderRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    LeftCap:'InteractionStateType'
    Outside:'InteractionStateType'
    RightCap:'InteractionStateType'
    Slider:'InteractionStateType'
    Tube:'InteractionStateType'
    current_t:'getset_descriptor'
    end_cap_length:'getset_descriptor'
    end_cap_width:'getset_descriptor'
    label_format:'getset_descriptor'
    label_height:'getset_descriptor'
    maximum_value:'getset_descriptor'
    minimum_value:'getset_descriptor'
    picked_t:'getset_descriptor'
    show_slider_label:'getset_descriptor'
    slider_length:'getset_descriptor'
    slider_width:'getset_descriptor'
    title_height:'getset_descriptor'
    title_text:'getset_descriptor'
    tube_width:'getset_descriptor'
    value:'getset_descriptor'
    def GetCurrentT(self) -> float: ...
    def GetEndCapLength(self) -> float: ...
    def GetEndCapLengthMaxValue(self) -> float: ...
    def GetEndCapLengthMinValue(self) -> float: ...
    def GetEndCapWidth(self) -> float: ...
    def GetEndCapWidthMaxValue(self) -> float: ...
    def GetEndCapWidthMinValue(self) -> float: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelHeight(self) -> float: ...
    def GetLabelHeightMaxValue(self) -> float: ...
    def GetLabelHeightMinValue(self) -> float: ...
    def GetMaximumValue(self) -> float: ...
    def GetMinimumValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickedT(self) -> float: ...
    def GetShowSliderLabel(self) -> int: ...
    def GetSliderLength(self) -> float: ...
    def GetSliderLengthMaxValue(self) -> float: ...
    def GetSliderLengthMinValue(self) -> float: ...
    def GetSliderWidth(self) -> float: ...
    def GetSliderWidthMaxValue(self) -> float: ...
    def GetSliderWidthMinValue(self) -> float: ...
    def GetTitleHeight(self) -> float: ...
    def GetTitleHeightMaxValue(self) -> float: ...
    def GetTitleHeightMinValue(self) -> float: ...
    def GetTitleText(self) -> str: ...
    def GetTubeWidth(self) -> float: ...
    def GetTubeWidthMaxValue(self) -> float: ...
    def GetTubeWidthMinValue(self) -> float: ...
    def GetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSliderRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSliderRepresentation': ...
    def SetEndCapLength(self, _arg:float) -> None: ...
    def SetEndCapWidth(self, _arg:float) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelHeight(self, _arg:float) -> None: ...
    def SetMaximumValue(self, value:float) -> None: ...
    def SetMinimumValue(self, value:float) -> None: ...
    def SetShowSliderLabel(self, _arg:int) -> None: ...
    def SetSliderLength(self, _arg:float) -> None: ...
    def SetSliderWidth(self, _arg:float) -> None: ...
    def SetTitleHeight(self, _arg:float) -> None: ...
    def SetTitleText(self, __a:str) -> None: ...
    def SetTubeWidth(self, _arg:float) -> None: ...
    def SetValue(self, value:float) -> None: ...
    def ShowSliderLabelOff(self) -> None: ...
    def ShowSliderLabelOn(self) -> None: ...

class vtkCenteredSliderRepresentation(vtkSliderRepresentation):
    label_property:'getset_descriptor'
    point1_coordinate:'getset_descriptor'
    point2_coordinate:'getset_descriptor'
    selected_property:'getset_descriptor'
    slider_property:'getset_descriptor'
    title_text:'getset_descriptor'
    tube_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetActors(self, propCollections:'vtkPropCollection') -> None: ...
    def GetLabelProperty(self) -> 'vtkTextProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1Coordinate(self) -> 'vtkCoordinate': ...
    def GetPoint2Coordinate(self) -> 'vtkCoordinate': ...
    def GetSelectedProperty(self) -> 'vtkProperty2D': ...
    def GetSliderProperty(self) -> 'vtkProperty2D': ...
    def GetTitleText(self) -> str: ...
    def GetTubeProperty(self) -> 'vtkProperty2D': ...
    def Highlight(self, __a:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCenteredSliderRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCenteredSliderRepresentation': ...
    def SetTitleText(self, __a:str) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkCenteredSliderWidget(vtkAbstractWidget):
    representation:'getset_descriptor'
    slider_representation:'getset_descriptor'
    value:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSliderRepresentation(self) -> 'vtkSliderRepresentation': ...
    def GetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCenteredSliderWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCenteredSliderWidget': ...
    def SetRepresentation(self, r:'vtkSliderRepresentation') -> None: ...

class vtkCheckerboardRepresentation(vtkWidgetRepresentation):
    BottomSlider:int
    LeftSlider:int
    RightSlider:int
    TopSlider:int
    bottom_representation:'getset_descriptor'
    checkerboard:'getset_descriptor'
    corner_offset:'getset_descriptor'
    image_actor:'getset_descriptor'
    left_representation:'getset_descriptor'
    right_representation:'getset_descriptor'
    top_representation:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBottomRepresentation(self) -> 'vtkSliderRepresentation3D': ...
    def GetCheckerboard(self) -> 'vtkImageCheckerboard': ...
    def GetCornerOffset(self) -> float: ...
    def GetCornerOffsetMaxValue(self) -> float: ...
    def GetCornerOffsetMinValue(self) -> float: ...
    def GetImageActor(self) -> 'vtkImageActor': ...
    def GetLeftRepresentation(self) -> 'vtkSliderRepresentation3D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRightRepresentation(self) -> 'vtkSliderRepresentation3D': ...
    def GetTopRepresentation(self) -> 'vtkSliderRepresentation3D': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCheckerboardRepresentation': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCheckerboardRepresentation': ...
    def SetBottomRepresentation(self, __a:'vtkSliderRepresentation3D') -> None: ...
    def SetCheckerboard(self, chkrbrd:'vtkImageCheckerboard') -> None: ...
    def SetCornerOffset(self, _arg:float) -> None: ...
    def SetImageActor(self, imageActor:'vtkImageActor') -> None: ...
    def SetLeftRepresentation(self, __a:'vtkSliderRepresentation3D') -> None: ...
    def SetRightRepresentation(self, __a:'vtkSliderRepresentation3D') -> None: ...
    def SetTopRepresentation(self, __a:'vtkSliderRepresentation3D') -> None: ...
    def SliderValueChanged(self, sliderNum:int) -> None: ...

class vtkCheckerboardWidget(vtkAbstractWidget):
    checkerboard_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetCheckerboardRepresentation(self) -> 'vtkCheckerboardRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCheckerboardWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCheckerboardWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkCheckerboardRepresentation') -> None: ...

class vtkClosedSurfacePointPlacer(vtkPointPlacer):
    bounding_planes:'getset_descriptor'
    minimum_distance:'getset_descriptor'
    def AddBoundingPlane(self, plane:'vtkPlane') -> None: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetBoundingPlanes(self) -> 'vtkPlaneCollection': ...
    def GetMinimumDistance(self) -> float: ...
    def GetMinimumDistanceMaxValue(self) -> float: ...
    def GetMinimumDistanceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkClosedSurfacePointPlacer': ...
    def RemoveAllBoundingPlanes(self) -> None: ...
    def RemoveBoundingPlane(self, plane:'vtkPlane') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkClosedSurfacePointPlacer': ...
    @overload
    def SetBoundingPlanes(self, __a:'vtkPlaneCollection') -> None: ...
    @overload
    def SetBoundingPlanes(self, planes:'vtkPlanes') -> None: ...
    def SetMinimumDistance(self, _arg:float) -> None: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkContinuousValueWidgetRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Adjusting:'InteractionStateType'
    Inside:'InteractionStateType'
    Outside:'InteractionStateType'
    value:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContinuousValueWidgetRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContinuousValueWidgetRepresentation': ...
    def SetValue(self, value:float) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkCompassRepresentation(vtkContinuousValueWidgetRepresentation):
    class InteractionStateType(int): ...
    Adjusting:'InteractionStateType'
    DistanceAdjusting:'InteractionStateType'
    DistanceIn:'InteractionStateType'
    DistanceOut:'InteractionStateType'
    Inside:'InteractionStateType'
    Outside:'InteractionStateType'
    TiltAdjusting:'InteractionStateType'
    TiltDown:'InteractionStateType'
    TiltUp:'InteractionStateType'
    distance:'getset_descriptor'
    heading:'getset_descriptor'
    label_property:'getset_descriptor'
    maximum_distance:'getset_descriptor'
    maximum_tilt_angle:'getset_descriptor'
    minimum_distance:'getset_descriptor'
    minimum_tilt_angle:'getset_descriptor'
    point1_coordinate:'getset_descriptor'
    point2_coordinate:'getset_descriptor'
    renderer:'getset_descriptor'
    ring_property:'getset_descriptor'
    selected_property:'getset_descriptor'
    tilt:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DistanceWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def EndDistance(self) -> None: ...
    def EndTilt(self) -> None: ...
    def GetActors(self, propCollection:'vtkPropCollection') -> None: ...
    def GetDistance(self) -> float: ...
    def GetHeading(self) -> float: ...
    def GetLabelProperty(self) -> 'vtkTextProperty': ...
    def GetMaximumDistance(self) -> float: ...
    def GetMaximumTiltAngle(self) -> float: ...
    def GetMinimumDistance(self) -> float: ...
    def GetMinimumTiltAngle(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1Coordinate(self) -> 'vtkCoordinate': ...
    def GetPoint2Coordinate(self) -> 'vtkCoordinate': ...
    def GetRingProperty(self) -> 'vtkProperty2D': ...
    def GetSelectedProperty(self) -> 'vtkProperty2D': ...
    def GetTilt(self) -> float: ...
    def Highlight(self, __a:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompassRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewPort:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompassRepresentation': ...
    def SetDistance(self, distance:float) -> None: ...
    def SetHeading(self, heading:float) -> None: ...
    def SetMaximumDistance(self, distance:float) -> None: ...
    def SetMaximumTiltAngle(self, angle:float) -> None: ...
    def SetMinimumDistance(self, distance:float) -> None: ...
    def SetMinimumTiltAngle(self, angle:float) -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetTilt(self, tilt:float) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def TiltWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def UpdateDistance(self, deltaDistance:float=0) -> None: ...
    def UpdateTilt(self, deltaTilt:float=0) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkCompassWidget(vtkAbstractWidget):
    distance:'getset_descriptor'
    distance_speed:'getset_descriptor'
    heading:'getset_descriptor'
    representation:'getset_descriptor'
    tilt:'getset_descriptor'
    tilt_speed:'getset_descriptor'
    timer_duration:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetDistance(self) -> float: ...
    def GetDistanceSpeed(self) -> float: ...
    def GetHeading(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTilt(self) -> float: ...
    def GetTiltSpeed(self) -> float: ...
    def GetTimerDuration(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompassWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompassWidget': ...
    def SetDistance(self, distance:float) -> None: ...
    def SetDistanceSpeed(self, _arg:float) -> None: ...
    def SetHeading(self, v:float) -> None: ...
    def SetRepresentation(self, r:'vtkCompassRepresentation') -> None: ...
    def SetTilt(self, tilt:float) -> None: ...
    def SetTiltSpeed(self, _arg:float) -> None: ...
    def SetTimerDuration(self, _arg:int) -> None: ...

class vtkConstrainedPointHandleRepresentation(vtkHandleRepresentation):
    Oblique:int
    XAxis:int
    YAxis:int
    ZAxis:int
    active_cursor_shape:'getset_descriptor'
    active_property:'getset_descriptor'
    bounding_planes:'getset_descriptor'
    cursor_shape:'getset_descriptor'
    display_position:'getset_descriptor'
    oblique_plane:'getset_descriptor'
    position:'getset_descriptor'
    projection_normal:'getset_descriptor'
    projection_position:'getset_descriptor'
    property:'getset_descriptor'
    renderer:'getset_descriptor'
    selected_property:'getset_descriptor'
    def AddBoundingPlane(self, plane:'vtkPlane') -> None: ...
    def BuildRepresentation(self) -> None: ...
    def CheckConstraint(self, renderer:'vtkRenderer', pos:MutableSequence[float]) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int) -> int: ...
    def GetActiveCursorShape(self) -> 'vtkPolyData': ...
    def GetActiveProperty(self) -> 'vtkProperty': ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBoundingPlanes(self) -> 'vtkPlaneCollection': ...
    def GetCursorShape(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObliquePlane(self) -> 'vtkPlane': ...
    @overload
    def GetPosition(self) -> Pointer: ...
    @overload
    def GetPosition(self, xyz:MutableSequence[float]) -> None: ...
    def GetProjectionNormal(self) -> int: ...
    def GetProjectionNormalMaxValue(self) -> int: ...
    def GetProjectionNormalMinValue(self) -> int: ...
    def GetProjectionPosition(self) -> float: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlight:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConstrainedPointHandleRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllBoundingPlanes(self) -> None: ...
    def RemoveBoundingPlane(self, plane:'vtkPlane') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConstrainedPointHandleRepresentation': ...
    def SetActiveCursorShape(self, activeShape:'vtkPolyData') -> None: ...
    @overload
    def SetBoundingPlanes(self, __a:'vtkPlaneCollection') -> None: ...
    @overload
    def SetBoundingPlanes(self, planes:'vtkPlanes') -> None: ...
    def SetCursorShape(self, cursorShape:'vtkPolyData') -> None: ...
    def SetDisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetObliquePlane(self, __a:'vtkPlane') -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, xyz:MutableSequence[float]) -> None: ...
    def SetProjectionNormal(self, _arg:int) -> None: ...
    def SetProjectionNormalToOblique(self) -> None: ...
    def SetProjectionNormalToXAxis(self) -> None: ...
    def SetProjectionNormalToYAxis(self) -> None: ...
    def SetProjectionNormalToZAxis(self) -> None: ...
    def SetProjectionPosition(self, position:float) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def Translate(self, p1:Sequence[float], p2:Sequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkContinuousValueWidget(vtkAbstractWidget):
    continuous_value_widget_representation:'getset_descriptor'
    representation:'getset_descriptor'
    value:'getset_descriptor'
    def GetContinuousValueWidgetRepresentation(self) -> 'vtkContinuousValueWidgetRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContinuousValueWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContinuousValueWidget': ...
    def SetRepresentation(self, r:'vtkContinuousValueWidgetRepresentation') -> None: ...
    def SetValue(self, v:float) -> None: ...

class vtkContourRepresentation(vtkWidgetRepresentation):
    Inactive:int
    Nearby:int
    Outside:int
    Scale:int
    Shift:int
    Translate:int
    active_node_selected:'getset_descriptor'
    closed_loop:'getset_descriptor'
    contour_representation_as_poly_data:'getset_descriptor'
    current_operation:'getset_descriptor'
    line_interpolator:'getset_descriptor'
    pixel_tolerance:'getset_descriptor'
    point_placer:'getset_descriptor'
    rebuild_locator:'getset_descriptor'
    show_selected_nodes:'getset_descriptor'
    world_tolerance:'getset_descriptor'
    @overload
    def ActivateNode(self, displayPos:MutableSequence[float]) -> int: ...
    @overload
    def ActivateNode(self, displayPos:MutableSequence[int]) -> int: ...
    @overload
    def ActivateNode(self, X:int, Y:int) -> int: ...
    @overload
    def AddIntermediatePointWorldPosition(self, n:int, point:MutableSequence[float]) -> int: ...
    @overload
    def AddIntermediatePointWorldPosition(self, n:int, point:MutableSequence[float], ptId:int) -> int: ...
    @overload
    def AddNodeAtDisplayPosition(self, displayPos:MutableSequence[float]) -> int: ...
    @overload
    def AddNodeAtDisplayPosition(self, displayPos:MutableSequence[int]) -> int: ...
    @overload
    def AddNodeAtDisplayPosition(self, X:int, Y:int) -> int: ...
    @overload
    def AddNodeAtWorldPosition(self, x:float, y:float, z:float) -> int: ...
    @overload
    def AddNodeAtWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def AddNodeAtWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def AddNodeOnContour(self, X:int, Y:int) -> int: ...
    def BuildRepresentation(self) -> None: ...
    def ClearAllNodes(self) -> None: ...
    def ClosedLoopOff(self) -> None: ...
    def ClosedLoopOn(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modified:int=0) -> int: ...
    def DeleteActiveNode(self) -> int: ...
    def DeleteLastNode(self) -> int: ...
    def DeleteNthNode(self, n:int) -> int: ...
    def GetActiveNodeDisplayPosition(self, pos:MutableSequence[float]) -> int: ...
    def GetActiveNodeSelected(self) -> int: ...
    def GetActiveNodeWorldOrientation(self, orient:MutableSequence[float]) -> int: ...
    def GetActiveNodeWorldPosition(self, pos:MutableSequence[float]) -> int: ...
    def GetClosedLoop(self) -> int: ...
    def GetContourRepresentationAsPolyData(self) -> 'vtkPolyData': ...
    def GetCurrentOperation(self) -> int: ...
    def GetCurrentOperationMaxValue(self) -> int: ...
    def GetCurrentOperationMinValue(self) -> int: ...
    def GetIntermediatePointWorldPosition(self, n:int, idx:int, point:MutableSequence[float]) -> int: ...
    def GetLineInterpolator(self) -> 'vtkContourLineInterpolator': ...
    def GetNodePolyData(self, poly:'vtkPolyData') -> None: ...
    def GetNthNodeDisplayPosition(self, n:int, pos:MutableSequence[float]) -> int: ...
    def GetNthNodeSelected(self, __a:int) -> int: ...
    def GetNthNodeSlope(self, idx:int, slope:MutableSequence[float]) -> int: ...
    def GetNthNodeWorldOrientation(self, n:int, orient:MutableSequence[float]) -> int: ...
    def GetNthNodeWorldPosition(self, n:int, pos:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIntermediatePoints(self, n:int) -> int: ...
    def GetNumberOfNodes(self) -> int: ...
    def GetPixelTolerance(self) -> int: ...
    def GetPixelToleranceMaxValue(self) -> int: ...
    def GetPixelToleranceMinValue(self) -> int: ...
    def GetPointPlacer(self) -> 'vtkPointPlacer': ...
    def GetShowSelectedNodes(self) -> int: ...
    def GetWorldTolerance(self) -> float: ...
    def GetWorldToleranceMaxValue(self) -> float: ...
    def GetWorldToleranceMinValue(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourRepresentation': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourRepresentation': ...
    @overload
    def SetActiveNodeToDisplayPosition(self, pos:MutableSequence[float]) -> int: ...
    @overload
    def SetActiveNodeToDisplayPosition(self, pos:MutableSequence[int]) -> int: ...
    @overload
    def SetActiveNodeToDisplayPosition(self, X:int, Y:int) -> int: ...
    @overload
    def SetActiveNodeToWorldPosition(self, pos:MutableSequence[float]) -> int: ...
    @overload
    def SetActiveNodeToWorldPosition(self, pos:MutableSequence[float], orient:MutableSequence[float]) -> int: ...
    def SetClosedLoop(self, val:int) -> None: ...
    def SetCurrentOperation(self, _arg:int) -> None: ...
    def SetCurrentOperationToInactive(self) -> None: ...
    def SetCurrentOperationToScale(self) -> None: ...
    def SetCurrentOperationToShift(self) -> None: ...
    def SetCurrentOperationToTranslate(self) -> None: ...
    def SetLineInterpolator(self, __a:'vtkContourLineInterpolator') -> None: ...
    @overload
    def SetNthNodeDisplayPosition(self, n:int, X:int, Y:int) -> int: ...
    @overload
    def SetNthNodeDisplayPosition(self, n:int, pos:MutableSequence[int]) -> int: ...
    @overload
    def SetNthNodeDisplayPosition(self, n:int, pos:MutableSequence[float]) -> int: ...
    def SetNthNodeSelected(self, __a:int) -> int: ...
    @overload
    def SetNthNodeWorldPosition(self, n:int, pos:MutableSequence[float]) -> int: ...
    @overload
    def SetNthNodeWorldPosition(self, n:int, pos:MutableSequence[float], orient:MutableSequence[float]) -> int: ...
    def SetPixelTolerance(self, _arg:int) -> None: ...
    def SetPointPlacer(self, __a:'vtkPointPlacer') -> None: ...
    def SetRebuildLocator(self, _arg:bool) -> None: ...
    def SetShowSelectedNodes(self, __a:int) -> None: ...
    def SetWorldTolerance(self, _arg:float) -> None: ...
    def ShowSelectedNodesOff(self) -> None: ...
    def ShowSelectedNodesOn(self) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def ToggleActiveNodeSelected(self) -> int: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkContourRepresentationInternals(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkContourRepresentationInternals') -> None: ...
    def ClearNodes(self) -> None: ...

class vtkContourRepresentationNode(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkContourRepresentationNode') -> None: ...

class vtkContourRepresentationPoint(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkContourRepresentationPoint') -> None: ...

class vtkContourWidget(vtkAbstractWidget):
    Define:int
    Manipulate:int
    Start:int
    allow_node_picking:'getset_descriptor'
    continuous_draw:'getset_descriptor'
    contour_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    follow_cursor:'getset_descriptor'
    representation:'getset_descriptor'
    widget_state:'getset_descriptor'
    def AllowNodePickingOff(self) -> None: ...
    def AllowNodePickingOn(self) -> None: ...
    def CloseLoop(self) -> None: ...
    def ContinuousDrawOff(self) -> None: ...
    def ContinuousDrawOn(self) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def FollowCursorOff(self) -> None: ...
    def FollowCursorOn(self) -> None: ...
    def GetAllowNodePicking(self) -> int: ...
    def GetContinuousDraw(self) -> int: ...
    def GetContourRepresentation(self) -> 'vtkContourRepresentation': ...
    def GetFollowCursor(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidgetState(self) -> int: ...
    @overload
    def Initialize(self, poly:'vtkPolyData', state:int=1, idList:'vtkIdList'=...) -> None: ...
    @overload
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourWidget': ...
    def SetAllowNodePicking(self, __a:int) -> None: ...
    def SetContinuousDraw(self, _arg:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetFollowCursor(self, _arg:int) -> None: ...
    def SetRepresentation(self, r:'vtkContourRepresentation') -> None: ...
    def SetWidgetState(self, _arg:int) -> None: ...

class vtkCoordinateFrameRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    ModifyingLockerXVector:'InteractionStateType'
    ModifyingLockerYVector:'InteractionStateType'
    ModifyingLockerZVector:'InteractionStateType'
    Moving:'InteractionStateType'
    MovingOrigin:'InteractionStateType'
    Outside:'InteractionStateType'
    RotatingXVector:'InteractionStateType'
    RotatingYVector:'InteractionStateType'
    RotatingZVector:'InteractionStateType'
    bounds:'getset_descriptor'
    direction:'getset_descriptor'
    interaction_state:'getset_descriptor'
    length_factor:'getset_descriptor'
    lock_normal_to_camera:'getset_descriptor'
    locked_axis:'getset_descriptor'
    locked_x_vector_property:'getset_descriptor'
    locked_y_vector_property:'getset_descriptor'
    locked_z_vector_property:'getset_descriptor'
    normal:'getset_descriptor'
    origin:'getset_descriptor'
    origin_property:'getset_descriptor'
    pick_camera_focal_info:'getset_descriptor'
    representation_state:'getset_descriptor'
    selected_locked_x_vector_property:'getset_descriptor'
    selected_locked_y_vector_property:'getset_descriptor'
    selected_locked_z_vector_property:'getset_descriptor'
    selected_origin_property:'getset_descriptor'
    selected_unlocked_x_vector_property:'getset_descriptor'
    selected_unlocked_y_vector_property:'getset_descriptor'
    selected_unlocked_z_vector_property:'getset_descriptor'
    selected_x_vector_property:'getset_descriptor'
    selected_y_vector_property:'getset_descriptor'
    selected_z_vector_property:'getset_descriptor'
    translation_axis_off:'getset_descriptor'
    unlocked_x_vector_property:'getset_descriptor'
    unlocked_y_vector_property:'getset_descriptor'
    unlocked_z_vector_property:'getset_descriptor'
    x_axis_vector:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    x_vector_normal:'getset_descriptor'
    x_vector_property:'getset_descriptor'
    y_axis_vector:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    y_vector_normal:'getset_descriptor'
    y_vector_property:'getset_descriptor'
    z_axis_vector:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    z_vector_normal:'getset_descriptor'
    z_vector_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetLengthFactor(self) -> float: ...
    def GetLengthFactorMaxValue(self) -> float: ...
    def GetLengthFactorMinValue(self) -> float: ...
    def GetLockNormalToCamera(self) -> int: ...
    def GetLockedAxis(self) -> int: ...
    def GetLockedXVectorProperty(self) -> 'vtkProperty': ...
    def GetLockedYVectorProperty(self) -> 'vtkProperty': ...
    def GetLockedZVectorProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetOriginProperty(self) -> 'vtkProperty': ...
    def GetPickCameraFocalInfo(self) -> bool: ...
    def GetRepresentationState(self) -> int: ...
    def GetSelectedLockedXVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedLockedYVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedLockedZVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedOriginProperty(self) -> 'vtkProperty': ...
    def GetSelectedUnlockedXVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedUnlockedYVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedUnlockedZVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedXVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedYVectorProperty(self) -> 'vtkProperty': ...
    def GetSelectedZVectorProperty(self) -> 'vtkProperty': ...
    def GetUnlockedXVectorProperty(self) -> 'vtkProperty': ...
    def GetUnlockedYVectorProperty(self) -> 'vtkProperty': ...
    def GetUnlockedZVectorProperty(self) -> 'vtkProperty': ...
    def GetXVectorNormal(self) -> Tuple[float, float, float]: ...
    def GetXVectorProperty(self) -> 'vtkProperty': ...
    def GetYVectorNormal(self) -> Tuple[float, float, float]: ...
    def GetYVectorProperty(self) -> 'vtkProperty': ...
    def GetZVectorNormal(self) -> Tuple[float, float, float]: ...
    def GetZVectorProperty(self) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockNormalToCameraOff(self) -> None: ...
    def LockNormalToCameraOn(self) -> None: ...
    def NewInstance(self) -> 'vtkCoordinateFrameRepresentation': ...
    def PickCameraFocalInfoOff(self) -> None: ...
    def PickCameraFocalInfoOn(self) -> None: ...
    def PickDirectionPoint(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool: ...
    def PickNormal(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool: ...
    def PickOrigin(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    def Reset(self) -> None: ...
    def ResetAxes(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCoordinateFrameRepresentation': ...
    @overload
    def SetDirection(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDirection(self, d:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLengthFactor(self, _arg:float) -> None: ...
    def SetLockNormalToCamera(self, __a:int) -> None: ...
    def SetLockedAxis(self, axis:int) -> None: ...
    @overload
    def SetNormal(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormal(self, n:MutableSequence[float]) -> None: ...
    def SetNormalToCamera(self) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetPickCameraFocalInfo(self, _arg:bool) -> None: ...
    def SetRepresentationState(self, __a:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    @overload
    def SetXAxisVector(self, v:Sequence[float]) -> None: ...
    @overload
    def SetXAxisVector(self, x:float, y:float, z:float) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    @overload
    def SetYAxisVector(self, v:Sequence[float]) -> None: ...
    @overload
    def SetYAxisVector(self, x:float, y:float, z:float) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    @overload
    def SetZAxisVector(self, v:Sequence[float]) -> None: ...
    @overload
    def SetZAxisVector(self, x:float, y:float, z:float) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkCoordinateFrameWidget(vtkAbstractWidget):
    coordinate_frame_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetCoordinateFrameRepresentation(self) -> 'vtkCoordinateFrameRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCoordinateFrameWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCoordinateFrameWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, rep:'vtkCoordinateFrameRepresentation') -> None: ...

class vtkDijkstraImageContourLineInterpolator(vtkContourLineInterpolator):
    cost_image:'getset_descriptor'
    dijkstra_image_geodesic_path:'getset_descriptor'
    def GetCostImage(self) -> 'vtkImageData': ...
    def GetDijkstraImageGeodesicPath(self) -> 'vtkDijkstraImageGeodesicPath': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDijkstraImageContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDijkstraImageContourLineInterpolator': ...
    def SetCostImage(self, __a:'vtkImageData') -> None: ...

class vtkDisplaySizedImplicitPlaneRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Moving:'InteractionStateType'
    MovingOrigin:'InteractionStateType'
    MovingOutline:'InteractionStateType'
    Outside:'InteractionStateType'
    Pushing:'InteractionStateType'
    ResizeDiskRadius:'InteractionStateType'
    Rotating:'InteractionStateType'
    Scaling:'InteractionStateType'
    always_snap_to_nearest_axis:'getset_descriptor'
    bounds:'getset_descriptor'
    bump_distance:'getset_descriptor'
    constrain_maximum_size_to_widget_bounds:'getset_descriptor'
    constrain_to_widget_bounds:'getset_descriptor'
    draw_intersection_edges:'getset_descriptor'
    draw_outline:'getset_descriptor'
    draw_plane:'getset_descriptor'
    edges_property:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_color:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    intersection_edges_property:'getset_descriptor'
    lock_normal_to_camera:'getset_descriptor'
    normal:'getset_descriptor'
    normal_property:'getset_descriptor'
    normal_to_x_axis:'getset_descriptor'
    normal_to_y_axis:'getset_descriptor'
    normal_to_z_axis:'getset_descriptor'
    origin:'getset_descriptor'
    outline_property:'getset_descriptor'
    outline_translation:'getset_descriptor'
    outside_bounds:'getset_descriptor'
    pick_camera_focal_info:'getset_descriptor'
    plane:'getset_descriptor'
    plane_property:'getset_descriptor'
    poly_data_algorithm:'getset_descriptor'
    radius_multiplier:'getset_descriptor'
    representation_state:'getset_descriptor'
    scale_enabled:'getset_descriptor'
    selected_edges_property:'getset_descriptor'
    selected_normal_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    selected_plane_property:'getset_descriptor'
    selected_sphere_property:'getset_descriptor'
    selected_widget_color:'getset_descriptor'
    snap_to_axes:'getset_descriptor'
    sphere_property:'getset_descriptor'
    translation_axis_off:'getset_descriptor'
    underlying_plane:'getset_descriptor'
    unselected_widget_color:'getset_descriptor'
    widget_bounds:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def BumpPlane(self, dir:int, factor:float) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def ConstrainMaximumSizeToWidgetBoundsOff(self) -> None: ...
    def ConstrainMaximumSizeToWidgetBoundsOn(self) -> None: ...
    def ConstrainToWidgetBoundsOff(self) -> None: ...
    def ConstrainToWidgetBoundsOn(self) -> None: ...
    def DrawIntersectionEdgesOff(self) -> None: ...
    def DrawIntersectionEdgesOn(self) -> None: ...
    def DrawOutlineOff(self) -> None: ...
    def DrawOutlineOn(self) -> None: ...
    def DrawPlaneOff(self) -> None: ...
    def DrawPlaneOn(self) -> None: ...
    def EndComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetAlwaysSnapToNearestAxis(self) -> bool: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetBumpDistance(self) -> float: ...
    def GetBumpDistanceMaxValue(self) -> float: ...
    def GetBumpDistanceMinValue(self) -> float: ...
    def GetConstrainMaximumSizeToWidgetBounds(self) -> int: ...
    def GetConstrainToWidgetBounds(self) -> int: ...
    def GetDrawIntersectionEdges(self) -> int: ...
    def GetDrawOutline(self) -> int: ...
    def GetDrawPlane(self) -> int: ...
    def GetEdgesProperty(self) -> 'vtkProperty': ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetIntersectionEdgesProperty(self) -> 'vtkProperty': ...
    def GetLockNormalToCamera(self) -> int: ...
    @overload
    def GetNormal(self) -> Tuple[float, float, float]: ...
    @overload
    def GetNormal(self, xyz:MutableSequence[float]) -> None: ...
    def GetNormalProperty(self) -> 'vtkProperty': ...
    def GetNormalToXAxis(self) -> int: ...
    def GetNormalToYAxis(self) -> int: ...
    def GetNormalToZAxis(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetOutlineTranslation(self) -> int: ...
    def GetOutsideBounds(self) -> int: ...
    def GetPickCameraFocalInfo(self) -> bool: ...
    def GetPlane(self, plane:'vtkPlane') -> None: ...
    def GetPlaneProperty(self) -> 'vtkProperty': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetPolyDataAlgorithm(self) -> 'vtkPolyDataAlgorithm': ...
    def GetRadiusMultiplier(self) -> float: ...
    def GetRadiusMultiplierMaxValue(self) -> float: ...
    def GetRadiusMultiplierMinValue(self) -> float: ...
    def GetRepresentationState(self) -> int: ...
    def GetScaleEnabled(self) -> int: ...
    def GetSelectedEdgesProperty(self) -> 'vtkProperty': ...
    def GetSelectedNormalProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetSelectedPlaneProperty(self) -> 'vtkProperty': ...
    def GetSelectedSphereProperty(self) -> 'vtkProperty': ...
    def GetSnapToAxes(self) -> bool: ...
    def GetSphereProperty(self) -> 'vtkProperty': ...
    def GetUnderlyingPlane(self) -> 'vtkPlane': ...
    def GetWidgetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockNormalToCameraOff(self) -> None: ...
    def LockNormalToCameraOn(self) -> None: ...
    def NewInstance(self) -> 'vtkDisplaySizedImplicitPlaneRepresentation': ...
    def NormalToXAxisOff(self) -> None: ...
    def NormalToXAxisOn(self) -> None: ...
    def NormalToYAxisOff(self) -> None: ...
    def NormalToYAxisOn(self) -> None: ...
    def NormalToZAxisOff(self) -> None: ...
    def NormalToZAxisOn(self) -> None: ...
    def OutlineTranslationOff(self) -> None: ...
    def OutlineTranslationOn(self) -> None: ...
    def OutsideBoundsOff(self) -> None: ...
    def OutsideBoundsOn(self) -> None: ...
    def PickCameraFocalInfoOff(self) -> None: ...
    def PickCameraFocalInfoOn(self) -> None: ...
    def PickNormal(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool: ...
    def PickOrigin(self, X:int, Y:int, snapToMeshPoint:bool=False) -> bool: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PushPlane(self, distance:float) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDisplaySizedImplicitPlaneRepresentation': ...
    def ScaleEnabledOff(self) -> None: ...
    def ScaleEnabledOn(self) -> None: ...
    def SetAlwaysSnapToNearestAxis(self, snap:bool) -> None: ...
    def SetBumpDistance(self, _arg:float) -> None: ...
    def SetConstrainMaximumSizeToWidgetBounds(self, _arg:int) -> None: ...
    def SetConstrainToWidgetBounds(self, _arg:int) -> None: ...
    def SetDrawIntersectionEdges(self, intersectionEdges:int) -> None: ...
    def SetDrawOutline(self, outline:int) -> None: ...
    def SetDrawPlane(self, plane:int) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetHandleColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLockNormalToCamera(self, __a:int) -> None: ...
    @overload
    def SetNormal(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormal(self, n:MutableSequence[float]) -> None: ...
    def SetNormalToCamera(self) -> None: ...
    def SetNormalToXAxis(self, __a:int) -> None: ...
    def SetNormalToYAxis(self, __a:int) -> None: ...
    def SetNormalToZAxis(self, __a:int) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetOutlineTranslation(self, _arg:int) -> None: ...
    def SetOutsideBounds(self, _arg:int) -> None: ...
    def SetPickCameraFocalInfo(self, _arg:bool) -> None: ...
    def SetPlane(self, plane:'vtkPlane') -> None: ...
    def SetRadiusMultiplier(self, radiusMultiplier:float) -> None: ...
    def SetRepresentationState(self, __a:int) -> None: ...
    def SetScaleEnabled(self, _arg:int) -> None: ...
    @overload
    def SetSelectedWidgetColor(self, a:float, b:float, c:float) -> None: ...
    @overload
    def SetSelectedWidgetColor(self, c:MutableSequence[float]) -> None: ...
    def SetSnapToAxes(self, _arg:bool) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    @overload
    def SetUnselectedWidgetColor(self, a:float, b:float, c:float) -> None: ...
    @overload
    def SetUnselectedWidgetColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def SnapToAxesOff(self) -> None: ...
    def SnapToAxesOn(self) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkDisplaySizedImplicitPlaneWidget(vtkAbstractWidget):
    display_sized_implicit_plane_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    lock_normal_to_camera:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetDisplaySizedImplicitPlaneRepresentation(self) -> 'vtkDisplaySizedImplicitPlaneRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDisplaySizedImplicitPlaneWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDisplaySizedImplicitPlaneWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetLockNormalToCamera(self, lock:int) -> None: ...
    def SetRepresentation(self, rep:'vtkDisplaySizedImplicitPlaneRepresentation') -> None: ...

class vtkDistanceRepresentation(vtkWidgetRepresentation):
    NearP1:int
    NearP2:int
    Outside:int
    distance:'getset_descriptor'
    handle_representation:'getset_descriptor'
    label_format:'getset_descriptor'
    number_of_ruler_ticks:'getset_descriptor'
    number_of_ruler_ticks_max_value:'getset_descriptor'
    number_of_ruler_ticks_min_value:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_representation:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_representation:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    ruler_distance:'getset_descriptor'
    ruler_mode:'getset_descriptor'
    scale:'getset_descriptor'
    tolerance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetDistance(self) -> float: ...
    def GetLabelFormat(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRulerTicks(self) -> int: ...
    def GetNumberOfRulerTicksMaxValue(self) -> int: ...
    def GetNumberOfRulerTicksMinValue(self) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint1Representation(self) -> 'vtkHandleRepresentation': ...
    @overload
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint1WorldPosition(self) -> Tuple[float, float, float]: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2Representation(self) -> 'vtkHandleRepresentation': ...
    @overload
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2WorldPosition(self) -> Tuple[float, float, float]: ...
    def GetRulerDistance(self) -> float: ...
    def GetRulerDistanceMaxValue(self) -> float: ...
    def GetRulerDistanceMinValue(self) -> float: ...
    def GetRulerMode(self) -> int: ...
    def GetScale(self) -> float: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def InstantiateHandleRepresentation(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDistanceRepresentation': ...
    def RulerModeOff(self) -> None: ...
    def RulerModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistanceRepresentation': ...
    def SetHandleRepresentation(self, handle:'vtkHandleRepresentation') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetNumberOfRulerTicks(self, _arg:int) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetRulerDistance(self, _arg:float) -> None: ...
    def SetRulerMode(self, _arg:int) -> None: ...
    def SetScale(self, _arg:float) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkDistanceRepresentation2D(vtkDistanceRepresentation):
    axis:'getset_descriptor'
    axis_property:'getset_descriptor'
    distance:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetAxis(self) -> 'vtkAxisActor2D': ...
    def GetAxisProperty(self) -> 'vtkProperty2D': ...
    def GetDistance(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint1WorldPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2WorldPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDistanceRepresentation2D': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistanceRepresentation2D': ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...

class vtkDistanceRepresentation3D(vtkDistanceRepresentation):
    bounds:'getset_descriptor'
    distance:'getset_descriptor'
    glyph_actor:'getset_descriptor'
    glyph_scale:'getset_descriptor'
    label_actor:'getset_descriptor'
    label_position:'getset_descriptor'
    label_property:'getset_descriptor'
    label_scale:'getset_descriptor'
    line_property:'getset_descriptor'
    maximum_number_of_ruler_ticks:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetDistance(self) -> float: ...
    def GetGlyphActor(self) -> 'vtkActor': ...
    def GetGlyphScale(self) -> float: ...
    def GetLabelActor(self) -> 'vtkFollower': ...
    def GetLabelPosition(self) -> float: ...
    def GetLabelProperty(self) -> 'vtkProperty': ...
    def GetLabelScale(self) -> Pointer: ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetMaximumNumberOfRulerTicks(self) -> int: ...
    def GetMaximumNumberOfRulerTicksMaxValue(self) -> int: ...
    def GetMaximumNumberOfRulerTicksMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint1WorldPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2WorldPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDistanceRepresentation3D': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistanceRepresentation3D': ...
    def SetGlyphScale(self, scale:float) -> None: ...
    def SetLabelActor(self, __a:'vtkFollower') -> None: ...
    def SetLabelPosition(self, labelPosition:float) -> None: ...
    @overload
    def SetLabelScale(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetLabelScale(self, scale:MutableSequence[float]) -> None: ...
    def SetMaximumNumberOfRulerTicks(self, _arg:int) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...

class vtkDistanceWidget(vtkAbstractWidget):
    Define:int
    Manipulate:int
    Start:int
    distance_representation:'getset_descriptor'
    enabled:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    widget_state:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetDistanceRepresentation(self) -> 'vtkDistanceRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDistanceWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistanceWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkDistanceRepresentation') -> None: ...
    def SetWidgetStateToManipulate(self) -> None: ...
    def SetWidgetStateToStart(self) -> None: ...

class vtkTensorProbeRepresentation(vtkWidgetRepresentation):
    probe_cell_id:'getset_descriptor'
    probe_position:'getset_descriptor'
    trajectory:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProbeCellId(self) -> int: ...
    def GetProbePosition(self) -> Tuple[float, float, float]: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Move(self, motionVector:MutableSequence[float]) -> int: ...
    def NewInstance(self) -> 'vtkTensorProbeRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTensorProbeRepresentation': ...
    def SelectProbe(self, pos:MutableSequence[int]) -> int: ...
    def SetProbeCellId(self, _arg:int) -> None: ...
    @overload
    def SetProbePosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetProbePosition(self, _arg:Sequence[float]) -> None: ...
    def SetTrajectory(self, __a:'vtkPolyData') -> None: ...

class vtkEllipsoidTensorProbeRepresentation(vtkTensorProbeRepresentation):
    def BuildRepresentation(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEllipsoidTensorProbeRepresentation': ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEllipsoidTensorProbeRepresentation': ...
    def SelectProbe(self, pos:MutableSequence[int]) -> int: ...

class vtkEqualizerContextItem(vtkmodules.vtkRenderingContext2D.vtkContextItem):
    points:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoints(self) -> str: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseEnterEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseLeaveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkEqualizerContextItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEqualizerContextItem': ...
    def SetPoints(self, points:str) -> None: ...

class vtkEvent(vtkmodules.vtkCommonCore.vtkObject):
    class EventModifiers(int): ...
    AltModifier:'EventModifiers'
    AnyModifier:'EventModifiers'
    ControlModifier:'EventModifiers'
    NoModifier:'EventModifiers'
    ShiftModifier:'EventModifiers'
    event_id:'getset_descriptor'
    key_code:'getset_descriptor'
    key_sym:'getset_descriptor'
    modifier:'getset_descriptor'
    repeat_count:'getset_descriptor'
    def GetEventId(self) -> int: ...
    def GetKeyCode(self) -> str: ...
    def GetKeySym(self) -> str: ...
    @overload
    def GetModifier(self) -> int: ...
    @overload
    @staticmethod
    def GetModifier(__a:'vtkRenderWindowInteractor') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRepeatCount(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEvent': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEvent': ...
    def SetEventId(self, _arg:int) -> None: ...
    def SetKeyCode(self, _arg:str) -> None: ...
    def SetKeySym(self, _arg:str) -> None: ...
    def SetModifier(self, _arg:int) -> None: ...
    def SetRepeatCount(self, _arg:int) -> None: ...

class vtkFinitePlaneRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    ModifyV1:'InteractionStateType'
    ModifyV2:'InteractionStateType'
    MoveOrigin:'InteractionStateType'
    Moving:'InteractionStateType'
    Outside:'InteractionStateType'
    Pushing:'InteractionStateType'
    Rotating:'InteractionStateType'
    bounds:'getset_descriptor'
    draw_plane:'getset_descriptor'
    handles:'getset_descriptor'
    interaction_state:'getset_descriptor'
    normal:'getset_descriptor'
    normal_property:'getset_descriptor'
    origin:'getset_descriptor'
    plane_property:'getset_descriptor'
    rectangular_shape:'getset_descriptor'
    representation_state:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_normal_property:'getset_descriptor'
    selected_plane_property:'getset_descriptor'
    tubing:'getset_descriptor'
    v1:'getset_descriptor'
    v1_handle_property:'getset_descriptor'
    v2:'getset_descriptor'
    v2_handle_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DrawPlaneOff(self) -> None: ...
    def DrawPlaneOn(self) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetDrawPlane(self) -> bool: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNormalProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetPlaneProperty(self) -> 'vtkProperty': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRectangularShape(self) -> bool: ...
    def GetRepresentationState(self) -> int: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedNormalProperty(self) -> 'vtkProperty': ...
    def GetSelectedPlaneProperty(self) -> 'vtkProperty': ...
    def GetTubing(self) -> bool: ...
    def GetV1(self) -> Tuple[float, float]: ...
    def GetV1HandleProperty(self) -> 'vtkProperty': ...
    def GetV2(self) -> Tuple[float, float]: ...
    def GetV2HandleProperty(self) -> 'vtkProperty': ...
    def HandlesOff(self) -> None: ...
    def HandlesOn(self) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MovePoint1(self, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    def MovePoint2(self, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    def NewInstance(self) -> 'vtkFinitePlaneRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def Push(self, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    def RectangularShapeOff(self) -> None: ...
    def RectangularShapeOn(self) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    def Rotate(self, X:int, Y:int, p1:MutableSequence[float], p2:MutableSequence[float], vpn:MutableSequence[float]) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFinitePlaneRepresentation': ...
    def SetDrawPlane(self, plane:bool) -> None: ...
    def SetHandles(self, handles:bool) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    @overload
    def SetNormal(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormal(self, n:MutableSequence[float]) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetRectangularShape(self, _arg:bool) -> None: ...
    def SetRepresentationState(self, __a:int) -> None: ...
    def SetTubing(self, _arg:bool) -> None: ...
    @overload
    def SetV1(self, x:float, y:float) -> None: ...
    @overload
    def SetV1(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetV2(self, x:float, y:float) -> None: ...
    @overload
    def SetV2(self, x:MutableSequence[float]) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def TranslateOrigin(self, p1:MutableSequence[float], p2:MutableSequence[float]) -> None: ...
    def TubingOff(self) -> None: ...
    def TubingOn(self) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkFinitePlaneWidget(vtkAbstractWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFinitePlaneWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFinitePlaneWidget': ...
    def SetRepresentation(self, r:'vtkFinitePlaneRepresentation') -> None: ...

class vtkPolygonalHandleRepresentation3D(vtkAbstractPolygonalHandleRepresentation3D):
    offset:'getset_descriptor'
    world_position:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolygonalHandleRepresentation3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolygonalHandleRepresentation3D': ...
    @overload
    def SetOffset(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOffset(self, _arg:Sequence[float]) -> None: ...
    def SetWorldPosition(self, p:MutableSequence[float]) -> None: ...

class vtkFixedSizeHandleRepresentation3D(vtkPolygonalHandleRepresentation3D):
    handle_size_in_pixels:'getset_descriptor'
    handle_size_tolerance_in_pixels:'getset_descriptor'
    sphere_source:'getset_descriptor'
    def GetHandleSizeInPixels(self) -> float: ...
    def GetHandleSizeToleranceInPixels(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSphereSource(self) -> 'vtkSphereSource': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFixedSizeHandleRepresentation3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFixedSizeHandleRepresentation3D': ...
    def SetHandleSizeInPixels(self, _arg:float) -> None: ...
    def SetHandleSizeToleranceInPixels(self, _arg:float) -> None: ...

class vtkFocalPlaneContourRepresentation(vtkContourRepresentation):
    def GetIntermediatePointDisplayPosition(self, n:int, idx:int, point:MutableSequence[float]) -> int: ...
    def GetIntermediatePointWorldPosition(self, n:int, idx:int, point:MutableSequence[float]) -> int: ...
    def GetNthNodeDisplayPosition(self, n:int, pos:MutableSequence[float]) -> int: ...
    def GetNthNodeWorldPosition(self, n:int, pos:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFocalPlaneContourRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFocalPlaneContourRepresentation': ...
    def UpdateContour(self) -> int: ...
    def UpdateContourWorldPositionsBasedOnDisplayPositions(self) -> None: ...
    def UpdateLines(self, index:int) -> None: ...

class vtkFocalPlanePointPlacer(vtkPointPlacer):
    offset:'getset_descriptor'
    point_bounds:'getset_descriptor'
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetPointBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFocalPlanePointPlacer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFocalPlanePointPlacer': ...
    def SetOffset(self, _arg:float) -> None: ...
    @overload
    def SetPointBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetPointBounds(self, _arg:Sequence[float]) -> None: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkHandleWidget(vtkAbstractWidget):
    class WidgetStateType(int): ...
    Active:'WidgetStateType'
    Inactive:'WidgetStateType'
    Start:'WidgetStateType'
    allow_handle_resize:'getset_descriptor'
    enable_axis_constraint:'getset_descriptor'
    enable_translation:'getset_descriptor'
    enabled:'getset_descriptor'
    handle_representation:'getset_descriptor'
    representation:'getset_descriptor'
    show_inactive:'getset_descriptor'
    widget_state:'getset_descriptor'
    def AllowHandleResizeOff(self) -> None: ...
    def AllowHandleResizeOn(self) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def EnableAxisConstraintOff(self) -> None: ...
    def EnableAxisConstraintOn(self) -> None: ...
    def EnableTranslationOff(self) -> None: ...
    def EnableTranslationOn(self) -> None: ...
    def GetAllowHandleResize(self) -> int: ...
    def GetEnableAxisConstraint(self) -> int: ...
    def GetEnableTranslation(self) -> int: ...
    def GetHandleRepresentation(self) -> 'vtkHandleRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShowInactive(self) -> int: ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHandleWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHandleWidget': ...
    def SetAllowHandleResize(self, _arg:int) -> None: ...
    def SetEnableAxisConstraint(self, _arg:int) -> None: ...
    def SetEnableTranslation(self, _arg:int) -> None: ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkHandleRepresentation') -> None: ...
    def SetShowInactive(self, _arg:int) -> None: ...
    def ShowInactiveOff(self) -> None: ...
    def ShowInactiveOn(self) -> None: ...

class vtkImageActorPointPlacer(vtkPointPlacer):
    bounds:'getset_descriptor'
    image_actor:'getset_descriptor'
    world_tolerance:'getset_descriptor'
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetImageActor(self) -> 'vtkImageActor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageActorPointPlacer': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageActorPointPlacer': ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetImageActor(self, __a:'vtkImageActor') -> None: ...
    def SetWorldTolerance(self, tol:float) -> None: ...
    def UpdateInternalState(self) -> int: ...
    def UpdateWorldPosition(self, ren:'vtkRenderer', worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkImageCroppingRegionsWidget(vtk3DWidget):
    class WidgetEventIds(int): ...
    CroppingPlanesPositionChangedEvent:'WidgetEventIds'
    SLICE_ORIENTATION_XY:int
    SLICE_ORIENTATION_XZ:int
    SLICE_ORIENTATION_YZ:int
    cropping_region_flags:'getset_descriptor'
    enabled:'getset_descriptor'
    line1_color:'getset_descriptor'
    line2_color:'getset_descriptor'
    line3_color:'getset_descriptor'
    line4_color:'getset_descriptor'
    plane_positions:'getset_descriptor'
    slice:'getset_descriptor'
    slice_orientation:'getset_descriptor'
    volume_mapper:'getset_descriptor'
    def GetCroppingRegionFlags(self) -> int: ...
    @overload
    def GetLine1Color(self) -> Pointer: ...
    @overload
    def GetLine1Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def GetLine2Color(self) -> Pointer: ...
    @overload
    def GetLine2Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def GetLine3Color(self) -> Pointer: ...
    @overload
    def GetLine3Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def GetLine4Color(self) -> Pointer: ...
    @overload
    def GetLine4Color(self, rgb:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlanePositions(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetSlice(self) -> int: ...
    def GetSliceOrientation(self) -> int: ...
    def GetVolumeMapper(self) -> 'vtkVolumeMapper': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MoveHorizontalLine(self) -> None: ...
    def MoveIntersectingLines(self) -> None: ...
    def MoveVerticalLine(self) -> None: ...
    def NewInstance(self) -> 'vtkImageCroppingRegionsWidget': ...
    def OnButtonPress(self) -> None: ...
    def OnButtonRelease(self) -> None: ...
    def OnMouseMove(self) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageCroppingRegionsWidget': ...
    def SetCroppingRegionFlags(self, flags:int) -> None: ...
    def SetEnabled(self, enabling:int) -> None: ...
    @overload
    def SetLine1Color(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetLine1Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def SetLine2Color(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetLine2Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def SetLine3Color(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetLine3Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def SetLine4Color(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetLine4Color(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def SetPlanePositions(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def SetPlanePositions(self, xMin:float, xMax:float, yMin:float, yMax:float, zMin:float, zMax:float) -> None: ...
    def SetSlice(self, num:int) -> None: ...
    def SetSliceOrientation(self, orientation:int) -> None: ...
    def SetSliceOrientationToXY(self) -> None: ...
    def SetSliceOrientationToXZ(self) -> None: ...
    def SetSliceOrientationToYZ(self) -> None: ...
    def SetVolumeMapper(self, mapper:'vtkVolumeMapper') -> None: ...
    def UpdateAccordingToInput(self) -> None: ...
    def UpdateCursorIcon(self) -> None: ...

class vtkImageOrthoPlanes(vtkmodules.vtkCommonCore.vtkObject):
    transform:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self, i:int) -> 'vtkImagePlaneWidget': ...
    def GetTransform(self) -> 'vtkTransform': ...
    def HandlePlaneEvent(self, imagePlaneWidget:'vtkImagePlaneWidget') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageOrthoPlanes': ...
    def ResetPlanes(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageOrthoPlanes': ...
    def SetPlane(self, i:int, imagePlaneWidget:'vtkImagePlaneWidget') -> None: ...

class vtkPolyDataSourceWidget(vtk3DWidget):
    poly_data_algorithm:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataAlgorithm(self) -> 'vtkPolyDataAlgorithm': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataSourceWidget': ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataSourceWidget': ...
    def UpdatePlacement(self) -> None: ...

class vtkImagePlaneWidget(vtkPolyDataSourceWidget):
    VTK_CONTROL_MODIFIER:int
    VTK_CURSOR_ACTION:int
    VTK_NO_MODIFIER:int
    VTK_SHIFT_MODIFIER:int
    VTK_SLICE_MOTION_ACTION:int
    VTK_WINDOW_LEVEL_ACTION:int
    center:'getset_descriptor'
    color_map:'getset_descriptor'
    current_cursor_position:'getset_descriptor'
    current_image_value:'getset_descriptor'
    cursor_data_status:'getset_descriptor'
    cursor_property:'getset_descriptor'
    display_text:'getset_descriptor'
    enabled:'getset_descriptor'
    input_connection:'getset_descriptor'
    interaction:'getset_descriptor'
    left_button_action:'getset_descriptor'
    left_button_auto_modifier:'getset_descriptor'
    level:'getset_descriptor'
    lookup_table:'getset_descriptor'
    margin_property:'getset_descriptor'
    margin_size_x:'getset_descriptor'
    margin_size_y:'getset_descriptor'
    middle_button_action:'getset_descriptor'
    middle_button_auto_modifier:'getset_descriptor'
    normal:'getset_descriptor'
    origin:'getset_descriptor'
    picker:'getset_descriptor'
    plane_orientation:'getset_descriptor'
    plane_property:'getset_descriptor'
    point1:'getset_descriptor'
    point2:'getset_descriptor'
    poly_data_algorithm:'getset_descriptor'
    reslice:'getset_descriptor'
    reslice_axes:'getset_descriptor'
    reslice_interpolate:'getset_descriptor'
    reslice_output:'getset_descriptor'
    restrict_plane_to_volume:'getset_descriptor'
    right_button_action:'getset_descriptor'
    right_button_auto_modifier:'getset_descriptor'
    selected_plane_property:'getset_descriptor'
    slice_index:'getset_descriptor'
    slice_position:'getset_descriptor'
    text_property:'getset_descriptor'
    texture:'getset_descriptor'
    texture_interpolate:'getset_descriptor'
    texture_plane_property:'getset_descriptor'
    texture_visibility:'getset_descriptor'
    use_continuous_cursor:'getset_descriptor'
    user_controlled_lookup_table:'getset_descriptor'
    window:'getset_descriptor'
    def DisplayTextOff(self) -> None: ...
    def DisplayTextOn(self) -> None: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    def GetColorMap(self) -> 'vtkImageMapToColors': ...
    def GetCurrentCursorPosition(self) -> Tuple[float, float, float]: ...
    def GetCurrentImageValue(self) -> float: ...
    def GetCursorData(self, xyzv:MutableSequence[float]) -> int: ...
    def GetCursorDataStatus(self) -> int: ...
    def GetCursorProperty(self) -> 'vtkProperty': ...
    def GetDisplayText(self) -> int: ...
    def GetInteraction(self) -> int: ...
    def GetLeftButtonAction(self) -> int: ...
    def GetLeftButtonActionMaxValue(self) -> int: ...
    def GetLeftButtonActionMinValue(self) -> int: ...
    def GetLeftButtonAutoModifier(self) -> int: ...
    def GetLeftButtonAutoModifierMaxValue(self) -> int: ...
    def GetLeftButtonAutoModifierMinValue(self) -> int: ...
    def GetLevel(self) -> float: ...
    def GetLookupTable(self) -> 'vtkLookupTable': ...
    def GetMarginProperty(self) -> 'vtkProperty': ...
    def GetMarginSizeX(self) -> float: ...
    def GetMarginSizeXMaxValue(self) -> float: ...
    def GetMarginSizeXMinValue(self) -> float: ...
    def GetMarginSizeY(self) -> float: ...
    def GetMarginSizeYMaxValue(self) -> float: ...
    def GetMarginSizeYMinValue(self) -> float: ...
    def GetMiddleButtonAction(self) -> int: ...
    def GetMiddleButtonActionMaxValue(self) -> int: ...
    def GetMiddleButtonActionMinValue(self) -> int: ...
    def GetMiddleButtonAutoModifier(self) -> int: ...
    def GetMiddleButtonAutoModifierMaxValue(self) -> int: ...
    def GetMiddleButtonAutoModifierMinValue(self) -> int: ...
    @overload
    def GetNormal(self) -> Tuple[float, float, float]: ...
    @overload
    def GetNormal(self, xyz:MutableSequence[float]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def GetPlaneOrientation(self) -> int: ...
    def GetPlaneProperty(self) -> 'vtkProperty': ...
    @overload
    def GetPoint1(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint1(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint2(self, xyz:MutableSequence[float]) -> None: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetPolyDataAlgorithm(self) -> 'vtkPolyDataAlgorithm': ...
    def GetReslice(self) -> 'vtkImageReslice': ...
    def GetResliceAxes(self) -> 'vtkMatrix4x4': ...
    def GetResliceInterpolate(self) -> int: ...
    def GetResliceOutput(self) -> 'vtkImageData': ...
    def GetRestrictPlaneToVolume(self) -> int: ...
    def GetRightButtonAction(self) -> int: ...
    def GetRightButtonActionMaxValue(self) -> int: ...
    def GetRightButtonActionMinValue(self) -> int: ...
    def GetRightButtonAutoModifier(self) -> int: ...
    def GetRightButtonAutoModifierMaxValue(self) -> int: ...
    def GetRightButtonAutoModifierMinValue(self) -> int: ...
    def GetSelectedPlaneProperty(self) -> 'vtkProperty': ...
    def GetSliceIndex(self) -> int: ...
    def GetSlicePosition(self) -> float: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetTexture(self) -> 'vtkTexture': ...
    def GetTextureInterpolate(self) -> int: ...
    def GetTexturePlaneProperty(self) -> 'vtkProperty': ...
    def GetTextureVisibility(self) -> int: ...
    def GetUseContinuousCursor(self) -> int: ...
    def GetUserControlledLookupTable(self) -> int: ...
    def GetVector1(self, v1:MutableSequence[float]) -> None: ...
    def GetVector2(self, v2:MutableSequence[float]) -> None: ...
    def GetWindow(self) -> float: ...
    def GetWindowLevel(self, wl:MutableSequence[float]) -> None: ...
    def InteractionOff(self) -> None: ...
    def InteractionOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImagePlaneWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def RestrictPlaneToVolumeOff(self) -> None: ...
    def RestrictPlaneToVolumeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImagePlaneWidget': ...
    def SetColorMap(self, __a:'vtkImageMapToColors') -> None: ...
    def SetCursorProperty(self, __a:'vtkProperty') -> None: ...
    def SetDisplayText(self, _arg:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetInputConnection(self, aout:'vtkAlgorithmOutput') -> None: ...
    def SetInteraction(self, interact:int) -> None: ...
    def SetLeftButtonAction(self, _arg:int) -> None: ...
    def SetLeftButtonAutoModifier(self, _arg:int) -> None: ...
    def SetLookupTable(self, __a:'vtkLookupTable') -> None: ...
    def SetMarginProperty(self, __a:'vtkProperty') -> None: ...
    def SetMarginSizeX(self, _arg:float) -> None: ...
    def SetMarginSizeY(self, _arg:float) -> None: ...
    def SetMiddleButtonAction(self, _arg:int) -> None: ...
    def SetMiddleButtonAutoModifier(self, _arg:int) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def SetPicker(self, __a:'vtkAbstractPropPicker') -> None: ...
    def SetPlaneOrientation(self, __a:int) -> None: ...
    def SetPlaneOrientationToXAxes(self) -> None: ...
    def SetPlaneOrientationToYAxes(self) -> None: ...
    def SetPlaneOrientationToZAxes(self) -> None: ...
    def SetPlaneProperty(self, __a:'vtkProperty') -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint1(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint2(self, xyz:MutableSequence[float]) -> None: ...
    def SetResliceInterpolate(self, __a:int) -> None: ...
    def SetResliceInterpolateToCubic(self) -> None: ...
    def SetResliceInterpolateToLinear(self) -> None: ...
    def SetResliceInterpolateToNearestNeighbour(self) -> None: ...
    def SetRestrictPlaneToVolume(self, _arg:int) -> None: ...
    def SetRightButtonAction(self, _arg:int) -> None: ...
    def SetRightButtonAutoModifier(self, _arg:int) -> None: ...
    def SetSelectedPlaneProperty(self, __a:'vtkProperty') -> None: ...
    def SetSliceIndex(self, index:int) -> None: ...
    def SetSlicePosition(self, position:float) -> None: ...
    def SetTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    def SetTextureInterpolate(self, _arg:int) -> None: ...
    def SetTexturePlaneProperty(self, __a:'vtkProperty') -> None: ...
    def SetTextureVisibility(self, __a:int) -> None: ...
    def SetUseContinuousCursor(self, _arg:int) -> None: ...
    def SetUserControlledLookupTable(self, _arg:int) -> None: ...
    def SetWindowLevel(self, window:float, level:float, copy:int=0) -> None: ...
    def TextureInterpolateOff(self) -> None: ...
    def TextureInterpolateOn(self) -> None: ...
    def TextureVisibilityOff(self) -> None: ...
    def TextureVisibilityOn(self) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def UseContinuousCursorOff(self) -> None: ...
    def UseContinuousCursorOn(self) -> None: ...
    def UserControlledLookupTableOff(self) -> None: ...
    def UserControlledLookupTableOn(self) -> None: ...

class vtkImageTracerWidget(vtk3DWidget):
    auto_close:'getset_descriptor'
    capture_radius:'getset_descriptor'
    enabled:'getset_descriptor'
    glyph_source:'getset_descriptor'
    handle_left_mouse_button:'getset_descriptor'
    handle_middle_mouse_button:'getset_descriptor'
    handle_property:'getset_descriptor'
    handle_right_mouse_button:'getset_descriptor'
    image_snap_type:'getset_descriptor'
    interaction:'getset_descriptor'
    line_property:'getset_descriptor'
    number_of_handles:'getset_descriptor'
    project_to_plane:'getset_descriptor'
    projection_normal:'getset_descriptor'
    projection_position:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    snap_to_image:'getset_descriptor'
    view_prop:'getset_descriptor'
    def AutoCloseOff(self) -> None: ...
    def AutoCloseOn(self) -> None: ...
    def GetAutoClose(self) -> int: ...
    def GetCaptureRadius(self) -> float: ...
    def GetGlyphSource(self) -> 'vtkGlyphSource2D': ...
    def GetHandleLeftMouseButton(self) -> int: ...
    def GetHandleMiddleMouseButton(self) -> int: ...
    @overload
    def GetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetHandlePosition(self, handle:int) -> Tuple[float, float, float]: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetHandleRightMouseButton(self) -> int: ...
    def GetImageSnapType(self) -> int: ...
    def GetImageSnapTypeMaxValue(self) -> int: ...
    def GetImageSnapTypeMinValue(self) -> int: ...
    def GetInteraction(self) -> int: ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHandles(self) -> int: ...
    def GetPath(self, pd:'vtkPolyData') -> None: ...
    def GetProjectToPlane(self) -> int: ...
    def GetProjectionNormal(self) -> int: ...
    def GetProjectionNormalMaxValue(self) -> int: ...
    def GetProjectionNormalMinValue(self) -> int: ...
    def GetProjectionPosition(self) -> float: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedLineProperty(self) -> 'vtkProperty': ...
    def GetSnapToImage(self) -> int: ...
    def HandleLeftMouseButtonOff(self) -> None: ...
    def HandleLeftMouseButtonOn(self) -> None: ...
    def HandleMiddleMouseButtonOff(self) -> None: ...
    def HandleMiddleMouseButtonOn(self) -> None: ...
    def HandleRightMouseButtonOff(self) -> None: ...
    def HandleRightMouseButtonOn(self) -> None: ...
    def InitializeHandles(self, __a:'vtkPoints') -> None: ...
    def InteractionOff(self) -> None: ...
    def InteractionOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsClosed(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageTracerWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def ProjectToPlaneOff(self) -> None: ...
    def ProjectToPlaneOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageTracerWidget': ...
    def SetAutoClose(self, _arg:int) -> None: ...
    def SetCaptureRadius(self, _arg:float) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetHandleLeftMouseButton(self, _arg:int) -> None: ...
    def SetHandleMiddleMouseButton(self, _arg:int) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, x:float, y:float, z:float) -> None: ...
    def SetHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetHandleRightMouseButton(self, _arg:int) -> None: ...
    def SetImageSnapType(self, _arg:int) -> None: ...
    def SetInteraction(self, interact:int) -> None: ...
    def SetLineProperty(self, __a:'vtkProperty') -> None: ...
    def SetProjectToPlane(self, _arg:int) -> None: ...
    def SetProjectionNormal(self, _arg:int) -> None: ...
    def SetProjectionNormalToXAxes(self) -> None: ...
    def SetProjectionNormalToYAxes(self) -> None: ...
    def SetProjectionNormalToZAxes(self) -> None: ...
    def SetProjectionPosition(self, position:float) -> None: ...
    def SetSelectedHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetSelectedLineProperty(self, __a:'vtkProperty') -> None: ...
    def SetSnapToImage(self, snap:int) -> None: ...
    def SetViewProp(self, prop:'vtkProp') -> None: ...
    def SnapToImageOff(self) -> None: ...
    def SnapToImageOn(self) -> None: ...

class vtkImplicitAnnulusRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    AdjustingInnerRadius:'InteractionStateType'
    AdjustingOuterRadius:'InteractionStateType'
    Moving:'InteractionStateType'
    MovingCenter:'InteractionStateType'
    MovingOutline:'InteractionStateType'
    Outside:'InteractionStateType'
    RotatingAxis:'InteractionStateType'
    Scaling:'InteractionStateType'
    TranslatingCenter:'InteractionStateType'
    along_x_axis:'getset_descriptor'
    along_y_axis:'getset_descriptor'
    along_z_axis:'getset_descriptor'
    annulus_property:'getset_descriptor'
    axis:'getset_descriptor'
    axis_property:'getset_descriptor'
    bounds:'getset_descriptor'
    bump_distance:'getset_descriptor'
    center:'getset_descriptor'
    constrain_to_widget_bounds:'getset_descriptor'
    draw_annulus:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_color:'getset_descriptor'
    inner_radius:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    outer_radius:'getset_descriptor'
    outline_property:'getset_descriptor'
    outline_translation:'getset_descriptor'
    outside_bounds:'getset_descriptor'
    radius_handle_property:'getset_descriptor'
    representation_state:'getset_descriptor'
    resolution:'getset_descriptor'
    scale_enabled:'getset_descriptor'
    selected_annulus_property:'getset_descriptor'
    selected_axis_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    selected_radius_handle_property:'getset_descriptor'
    translation_axis:'getset_descriptor'
    tubing:'getset_descriptor'
    widget_bounds:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def AlongXAxisOff(self) -> None: ...
    def AlongXAxisOn(self) -> None: ...
    def AlongYAxisOff(self) -> None: ...
    def AlongYAxisOn(self) -> None: ...
    def AlongZAxisOff(self) -> None: ...
    def AlongZAxisOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def BumpAnnulus(self, dir:int, factor:float) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def ConstrainToWidgetBoundsOff(self) -> None: ...
    def ConstrainToWidgetBoundsOn(self) -> None: ...
    def DrawAnnulusOff(self) -> None: ...
    def DrawAnnulusOn(self) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetAlongXAxis(self) -> bool: ...
    def GetAlongYAxis(self) -> bool: ...
    def GetAlongZAxis(self) -> bool: ...
    def GetAnnulus(self, annulus:'vtkAnnulus') -> None: ...
    def GetAnnulusProperty(self) -> 'vtkProperty': ...
    @overload
    def GetAxis(self) -> Tuple[float, float, float]: ...
    @overload
    def GetAxis(self, a:MutableSequence[float]) -> None: ...
    def GetAxisProperty(self) -> 'vtkProperty': ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetBumpDistance(self) -> float: ...
    def GetBumpDistanceMaxValue(self) -> float: ...
    def GetBumpDistanceMinValue(self) -> float: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    def GetConstrainToWidgetBounds(self) -> bool: ...
    def GetDrawAnnulus(self) -> bool: ...
    def GetInnerRadius(self) -> float: ...
    def GetInteractionStateMaxValue(self) -> 'InteractionStateType': ...
    def GetInteractionStateMinValue(self) -> 'InteractionStateType': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOuterRadius(self) -> float: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetOutlineTranslation(self) -> bool: ...
    def GetOutsideBounds(self) -> bool: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRadiusHandleProperty(self) -> 'vtkProperty': ...
    def GetRepresentationState(self) -> 'InteractionStateType': ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetScaleEnabled(self) -> bool: ...
    def GetSelectedAnnulusProperty(self) -> 'vtkProperty': ...
    def GetSelectedAxisProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetSelectedRadiusHandleProperty(self) -> 'vtkProperty': ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def GetTubing(self) -> bool: ...
    def GetWidgetBounds(self) -> Pointer: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitAnnulusRepresentation': ...
    def OutlineTranslationOff(self) -> None: ...
    def OutlineTranslationOn(self) -> None: ...
    def OutsideBoundsOff(self) -> None: ...
    def OutsideBoundsOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PushAnnulus(self, distance:float) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitAnnulusRepresentation': ...
    def ScaleEnabledOff(self) -> None: ...
    def ScaleEnabledOn(self) -> None: ...
    def SetAlongXAxis(self, __a:bool) -> None: ...
    def SetAlongYAxis(self, __a:bool) -> None: ...
    def SetAlongZAxis(self, __a:bool) -> None: ...
    @overload
    def SetAxis(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetAxis(self, a:MutableSequence[float]) -> None: ...
    def SetBumpDistance(self, _arg:float) -> None: ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetCenter(self, x:MutableSequence[float]) -> None: ...
    def SetConstrainToWidgetBounds(self, _arg:bool) -> None: ...
    def SetDrawAnnulus(self, draw:bool) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetHandleColor(self, c:MutableSequence[float]) -> None: ...
    def SetInnerRadius(self, r:float) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:'InteractionStateType') -> None: ...
    def SetOuterRadius(self, r:float) -> None: ...
    def SetOutlineTranslation(self, _arg:bool) -> None: ...
    def SetOutsideBounds(self, _arg:bool) -> None: ...
    def SetRepresentationState(self, __a:'InteractionStateType') -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetScaleEnabled(self, _arg:bool) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetTubing(self, _arg:bool) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def TubingOff(self) -> None: ...
    def TubingOn(self) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkImplicitAnnulusWidget(vtkAbstractWidget):
    annulus_representation:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetAnnulusRepresentation(self) -> 'vtkImplicitAnnulusRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitAnnulusWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitAnnulusWidget': ...
    def SetRepresentation(self, rep:'vtkImplicitAnnulusRepresentation') -> None: ...

class vtkImplicitConeRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    AdjustingAngle:'InteractionStateType'
    Moving:'InteractionStateType'
    MovingOrigin:'InteractionStateType'
    MovingOutline:'InteractionStateType'
    Outside:'InteractionStateType'
    RotatingAxis:'InteractionStateType'
    Scaling:'InteractionStateType'
    TranslatingOrigin:'InteractionStateType'
    along_x_axis:'getset_descriptor'
    along_y_axis:'getset_descriptor'
    along_z_axis:'getset_descriptor'
    angle:'getset_descriptor'
    axis:'getset_descriptor'
    axis_property:'getset_descriptor'
    bounds:'getset_descriptor'
    bump_distance:'getset_descriptor'
    cone_property:'getset_descriptor'
    constrain_to_widget_bounds:'getset_descriptor'
    draw_cone:'getset_descriptor'
    edges_property:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_color:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    origin:'getset_descriptor'
    outline_property:'getset_descriptor'
    outline_translation:'getset_descriptor'
    outside_bounds:'getset_descriptor'
    representation_state:'getset_descriptor'
    resolution:'getset_descriptor'
    scale_enabled:'getset_descriptor'
    selected_axis_property:'getset_descriptor'
    selected_cone_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    translation_axis:'getset_descriptor'
    tubing:'getset_descriptor'
    widget_bounds:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def AlongXAxisOff(self) -> None: ...
    def AlongXAxisOn(self) -> None: ...
    def AlongYAxisOff(self) -> None: ...
    def AlongYAxisOn(self) -> None: ...
    def AlongZAxisOff(self) -> None: ...
    def AlongZAxisOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def BumpCone(self, dir:int, factor:float) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def ConstrainToWidgetBoundsOff(self) -> None: ...
    def ConstrainToWidgetBoundsOn(self) -> None: ...
    def DrawConeOff(self) -> None: ...
    def DrawConeOn(self) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetAlongXAxis(self) -> bool: ...
    def GetAlongYAxis(self) -> bool: ...
    def GetAlongZAxis(self) -> bool: ...
    def GetAngle(self) -> float: ...
    @overload
    def GetAxis(self) -> Tuple[float, float, float]: ...
    @overload
    def GetAxis(self, a:MutableSequence[float]) -> None: ...
    def GetAxisProperty(self) -> 'vtkProperty': ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetBumpDistance(self) -> float: ...
    def GetBumpDistanceMaxValue(self) -> float: ...
    def GetBumpDistanceMinValue(self) -> float: ...
    def GetCone(self, cone:'vtkCone') -> None: ...
    def GetConeProperty(self) -> 'vtkProperty': ...
    def GetConstrainToWidgetBounds(self) -> bool: ...
    def GetDrawCone(self) -> bool: ...
    def GetEdgesProperty(self) -> 'vtkProperty': ...
    def GetInteractionStateMaxValue(self) -> 'InteractionStateType': ...
    def GetInteractionStateMinValue(self) -> 'InteractionStateType': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetOutlineTranslation(self) -> bool: ...
    def GetOutsideBounds(self) -> bool: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRepresentationState(self) -> 'InteractionStateType': ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetScaleEnabled(self) -> bool: ...
    def GetSelectedAxisProperty(self) -> 'vtkProperty': ...
    def GetSelectedConeProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def GetTubing(self) -> bool: ...
    def GetWidgetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitConeRepresentation': ...
    def OutlineTranslationOff(self) -> None: ...
    def OutlineTranslationOn(self) -> None: ...
    def OutsideBoundsOff(self) -> None: ...
    def OutsideBoundsOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PushCone(self, distance:float) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitConeRepresentation': ...
    def ScaleEnabledOff(self) -> None: ...
    def ScaleEnabledOn(self) -> None: ...
    def SetAlongXAxis(self, __a:bool) -> None: ...
    def SetAlongYAxis(self, __a:bool) -> None: ...
    def SetAlongZAxis(self, __a:bool) -> None: ...
    def SetAngle(self, r:float) -> None: ...
    @overload
    def SetAxis(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetAxis(self, a:MutableSequence[float]) -> None: ...
    def SetBumpDistance(self, _arg:float) -> None: ...
    def SetConstrainToWidgetBounds(self, _arg:bool) -> None: ...
    def SetDrawCone(self, draw:bool) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetHandleColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:'InteractionStateType') -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetOutlineTranslation(self, _arg:bool) -> None: ...
    def SetOutsideBounds(self, _arg:bool) -> None: ...
    def SetRepresentationState(self, __a:'InteractionStateType') -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetScaleEnabled(self, _arg:bool) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetTubing(self, _arg:bool) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def TubingOff(self) -> None: ...
    def TubingOn(self) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkImplicitConeWidget(vtkAbstractWidget):
    cone_representation:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetConeRepresentation(self) -> 'vtkImplicitConeRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitConeWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitConeWidget': ...
    def SetRepresentation(self, rep:'vtkImplicitConeRepresentation') -> None: ...

class vtkImplicitCylinderRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    AdjustingRadius:'InteractionStateType'
    Moving:'InteractionStateType'
    MovingCenter:'InteractionStateType'
    MovingOutline:'InteractionStateType'
    Outside:'InteractionStateType'
    RotatingAxis:'InteractionStateType'
    Scaling:'InteractionStateType'
    TranslatingCenter:'InteractionStateType'
    along_x_axis:'getset_descriptor'
    along_y_axis:'getset_descriptor'
    along_z_axis:'getset_descriptor'
    axis:'getset_descriptor'
    axis_property:'getset_descriptor'
    bounds:'getset_descriptor'
    bump_distance:'getset_descriptor'
    center:'getset_descriptor'
    constrain_to_widget_bounds:'getset_descriptor'
    cylinder_property:'getset_descriptor'
    draw_cylinder:'getset_descriptor'
    edge_color:'getset_descriptor'
    edges_property:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_color:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    max_radius:'getset_descriptor'
    min_radius:'getset_descriptor'
    outline_property:'getset_descriptor'
    outline_translation:'getset_descriptor'
    outside_bounds:'getset_descriptor'
    radius:'getset_descriptor'
    representation_state:'getset_descriptor'
    resolution:'getset_descriptor'
    scale_enabled:'getset_descriptor'
    selected_axis_property:'getset_descriptor'
    selected_cylinder_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    translation_axis:'getset_descriptor'
    tubing:'getset_descriptor'
    widget_bounds:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def AlongXAxisOff(self) -> None: ...
    def AlongXAxisOn(self) -> None: ...
    def AlongYAxisOff(self) -> None: ...
    def AlongYAxisOn(self) -> None: ...
    def AlongZAxisOff(self) -> None: ...
    def AlongZAxisOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def BumpCylinder(self, dir:int, factor:float) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def ConstrainToWidgetBoundsOff(self) -> None: ...
    def ConstrainToWidgetBoundsOn(self) -> None: ...
    def DrawCylinderOff(self) -> None: ...
    def DrawCylinderOn(self) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetAlongXAxis(self) -> int: ...
    def GetAlongYAxis(self) -> int: ...
    def GetAlongZAxis(self) -> int: ...
    @overload
    def GetAxis(self) -> Tuple[float, float, float]: ...
    @overload
    def GetAxis(self, a:MutableSequence[float]) -> None: ...
    def GetAxisProperty(self) -> 'vtkProperty': ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetBumpDistance(self) -> float: ...
    def GetBumpDistanceMaxValue(self) -> float: ...
    def GetBumpDistanceMinValue(self) -> float: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    def GetConstrainToWidgetBounds(self) -> int: ...
    def GetCylinder(self, cyl:'vtkCylinder') -> None: ...
    def GetCylinderProperty(self) -> 'vtkProperty': ...
    def GetDrawCylinder(self) -> int: ...
    def GetEdgesProperty(self) -> 'vtkProperty': ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetMaxRadius(self) -> float: ...
    def GetMaxRadiusMaxValue(self) -> float: ...
    def GetMaxRadiusMinValue(self) -> float: ...
    def GetMinRadius(self) -> float: ...
    def GetMinRadiusMaxValue(self) -> float: ...
    def GetMinRadiusMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetOutlineTranslation(self) -> int: ...
    def GetOutsideBounds(self) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRadius(self) -> float: ...
    def GetRepresentationState(self) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetScaleEnabled(self) -> int: ...
    def GetSelectedAxisProperty(self) -> 'vtkProperty': ...
    def GetSelectedCylinderProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def GetTubing(self) -> int: ...
    def GetWidgetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitCylinderRepresentation': ...
    def OutlineTranslationOff(self) -> None: ...
    def OutlineTranslationOn(self) -> None: ...
    def OutsideBoundsOff(self) -> None: ...
    def OutsideBoundsOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PushCylinder(self, distance:float) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitCylinderRepresentation': ...
    def ScaleEnabledOff(self) -> None: ...
    def ScaleEnabledOn(self) -> None: ...
    def SetAlongXAxis(self, __a:int) -> None: ...
    def SetAlongYAxis(self, __a:int) -> None: ...
    def SetAlongZAxis(self, __a:int) -> None: ...
    @overload
    def SetAxis(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetAxis(self, a:MutableSequence[float]) -> None: ...
    def SetBumpDistance(self, _arg:float) -> None: ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetCenter(self, x:MutableSequence[float]) -> None: ...
    def SetConstrainToWidgetBounds(self, _arg:int) -> None: ...
    def SetDrawCylinder(self, drawCyl:int) -> None: ...
    @overload
    def SetEdgeColor(self, __a:'vtkLookupTable') -> None: ...
    @overload
    def SetEdgeColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetEdgeColor(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetHandleColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetMaxRadius(self, _arg:float) -> None: ...
    def SetMinRadius(self, _arg:float) -> None: ...
    def SetOutlineTranslation(self, _arg:int) -> None: ...
    def SetOutsideBounds(self, _arg:int) -> None: ...
    def SetRadius(self, r:float) -> None: ...
    def SetRepresentationState(self, __a:int) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetScaleEnabled(self, _arg:int) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetTubing(self, _arg:int) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def TubingOff(self) -> None: ...
    def TubingOn(self) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkImplicitCylinderWidget(vtkAbstractWidget):
    cylinder_representation:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetCylinderRepresentation(self) -> 'vtkImplicitCylinderRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitCylinderWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitCylinderWidget': ...
    def SetRepresentation(self, rep:'vtkImplicitCylinderRepresentation') -> None: ...

class vtkImplicitPlaneRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Moving:'InteractionStateType'
    MovingOrigin:'InteractionStateType'
    MovingOutline:'InteractionStateType'
    Outside:'InteractionStateType'
    Pushing:'InteractionStateType'
    Rotating:'InteractionStateType'
    Scaling:'InteractionStateType'
    always_snap_to_nearest_axis:'getset_descriptor'
    bounds:'getset_descriptor'
    bump_distance:'getset_descriptor'
    constrain_to_widget_bounds:'getset_descriptor'
    crop_plane_to_bounding_box:'getset_descriptor'
    draw_outline:'getset_descriptor'
    draw_plane:'getset_descriptor'
    edge_color:'getset_descriptor'
    edges_property:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_color:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    lock_normal_to_camera:'getset_descriptor'
    normal:'getset_descriptor'
    normal_property:'getset_descriptor'
    normal_to_x_axis:'getset_descriptor'
    normal_to_y_axis:'getset_descriptor'
    normal_to_z_axis:'getset_descriptor'
    origin:'getset_descriptor'
    outline_property:'getset_descriptor'
    outline_translation:'getset_descriptor'
    outside_bounds:'getset_descriptor'
    plane:'getset_descriptor'
    plane_property:'getset_descriptor'
    poly_data_algorithm:'getset_descriptor'
    representation_state:'getset_descriptor'
    scale_enabled:'getset_descriptor'
    selected_normal_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    selected_plane_property:'getset_descriptor'
    snap_to_axes:'getset_descriptor'
    translation_axis_off:'getset_descriptor'
    tubing:'getset_descriptor'
    underlying_plane:'getset_descriptor'
    widget_bounds:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def BumpPlane(self, dir:int, factor:float) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def ConstrainToWidgetBoundsOff(self) -> None: ...
    def ConstrainToWidgetBoundsOn(self) -> None: ...
    def CropPlaneToBoundingBoxOff(self) -> None: ...
    def CropPlaneToBoundingBoxOn(self) -> None: ...
    def DrawOutlineOff(self) -> None: ...
    def DrawOutlineOn(self) -> None: ...
    def DrawPlaneOff(self) -> None: ...
    def DrawPlaneOn(self) -> None: ...
    def EndComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def EndWidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetAlwaysSnapToNearestAxis(self) -> bool: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetBumpDistance(self) -> float: ...
    def GetBumpDistanceMaxValue(self) -> float: ...
    def GetBumpDistanceMinValue(self) -> float: ...
    def GetConstrainToWidgetBounds(self) -> int: ...
    def GetCropPlaneToBoundingBox(self) -> bool: ...
    def GetDrawOutline(self) -> int: ...
    def GetDrawPlane(self) -> int: ...
    def GetEdgesProperty(self) -> 'vtkProperty': ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetLockNormalToCamera(self) -> int: ...
    @overload
    def GetNormal(self) -> Tuple[float, float, float]: ...
    @overload
    def GetNormal(self, xyz:MutableSequence[float]) -> None: ...
    def GetNormalProperty(self) -> 'vtkProperty': ...
    def GetNormalToXAxis(self) -> int: ...
    def GetNormalToYAxis(self) -> int: ...
    def GetNormalToZAxis(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetOutlineTranslation(self) -> int: ...
    def GetOutsideBounds(self) -> int: ...
    def GetPlane(self, plane:'vtkPlane') -> None: ...
    def GetPlaneProperty(self) -> 'vtkProperty': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetPolyDataAlgorithm(self) -> 'vtkPolyDataAlgorithm': ...
    def GetRepresentationState(self) -> int: ...
    def GetScaleEnabled(self) -> int: ...
    def GetSelectedNormalProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetSelectedPlaneProperty(self) -> 'vtkProperty': ...
    def GetSnapToAxes(self) -> bool: ...
    def GetTubing(self) -> int: ...
    def GetUnderlyingPlane(self) -> 'vtkPlane': ...
    def GetWidgetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockNormalToCameraOff(self) -> None: ...
    def LockNormalToCameraOn(self) -> None: ...
    def NewInstance(self) -> 'vtkImplicitPlaneRepresentation': ...
    def NormalToXAxisOff(self) -> None: ...
    def NormalToXAxisOn(self) -> None: ...
    def NormalToYAxisOff(self) -> None: ...
    def NormalToYAxisOn(self) -> None: ...
    def NormalToZAxisOff(self) -> None: ...
    def NormalToZAxisOn(self) -> None: ...
    def OutlineTranslationOff(self) -> None: ...
    def OutlineTranslationOn(self) -> None: ...
    def OutsideBoundsOff(self) -> None: ...
    def OutsideBoundsOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PushPlane(self, distance:float) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitPlaneRepresentation': ...
    def ScaleEnabledOff(self) -> None: ...
    def ScaleEnabledOn(self) -> None: ...
    def SetAlwaysSnapToNearestAxis(self, snap:bool) -> None: ...
    def SetBumpDistance(self, _arg:float) -> None: ...
    def SetConstrainToWidgetBounds(self, _arg:int) -> None: ...
    def SetCropPlaneToBoundingBox(self, __a:bool) -> None: ...
    def SetDrawOutline(self, plane:int) -> None: ...
    def SetDrawPlane(self, plane:int) -> None: ...
    @overload
    def SetEdgeColor(self, __a:'vtkLookupTable') -> None: ...
    @overload
    def SetEdgeColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetEdgeColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetHandleColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLockNormalToCamera(self, __a:int) -> None: ...
    @overload
    def SetNormal(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormal(self, n:MutableSequence[float]) -> None: ...
    def SetNormalToCamera(self) -> None: ...
    def SetNormalToXAxis(self, __a:int) -> None: ...
    def SetNormalToYAxis(self, __a:int) -> None: ...
    def SetNormalToZAxis(self, __a:int) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetOutlineTranslation(self, _arg:int) -> None: ...
    def SetOutsideBounds(self, _arg:int) -> None: ...
    def SetPlane(self, plane:'vtkPlane') -> None: ...
    def SetRepresentationState(self, __a:int) -> None: ...
    def SetScaleEnabled(self, _arg:int) -> None: ...
    def SetSnapToAxes(self, _arg:bool) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetTubing(self, _arg:int) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetWidgetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def TubingOff(self) -> None: ...
    def TubingOn(self) -> None: ...
    def UpdatePlacement(self) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkImplicitImageRepresentation(vtkImplicitPlaneRepresentation):
    color_map:'getset_descriptor'
    crop_plane_to_bounding_box:'getset_descriptor'
    lookup_table:'getset_descriptor'
    reslice:'getset_descriptor'
    reslice_interpolate:'getset_descriptor'
    texture_interpolate:'getset_descriptor'
    user_controlled_lookup_table:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetColorMap(self) -> 'vtkImageMapToColors': ...
    def GetLookupTable(self) -> 'vtkLookupTable': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReslice(self) -> 'vtkImageReslice': ...
    def GetResliceInterpolate(self) -> int: ...
    def GetTextureInterpolate(self) -> bool: ...
    def GetUserControlledLookupTable(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitImageRepresentation': ...
    @overload
    def PlaceImage(self, img:'vtkImageData') -> None: ...
    @overload
    def PlaceImage(self, aout:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitImageRepresentation': ...
    def SetColorMap(self, __a:'vtkImageMapToColors') -> None: ...
    def SetCropPlaneToBoundingBox(self, __a:bool) -> None: ...
    def SetLookupTable(self, __a:'vtkLookupTable') -> None: ...
    def SetResliceInterpolate(self, __a:int) -> None: ...
    def SetResliceInterpolateToCubic(self) -> None: ...
    def SetResliceInterpolateToLinear(self) -> None: ...
    def SetResliceInterpolateToNearestNeighbour(self) -> None: ...
    def SetTextureInterpolate(self, _arg:bool) -> None: ...
    def SetUserControlledLookupTable(self, _arg:bool) -> None: ...
    def TextureInterpolateOff(self) -> None: ...
    def TextureInterpolateOn(self) -> None: ...
    def UserControlledLookupTableOff(self) -> None: ...
    def UserControlledLookupTableOn(self) -> None: ...

class vtkImplicitPlaneWidget(vtkPolyDataSourceWidget):
    diagonal_ratio:'getset_descriptor'
    draw_plane:'getset_descriptor'
    edges_property:'getset_descriptor'
    enabled:'getset_descriptor'
    normal:'getset_descriptor'
    normal_property:'getset_descriptor'
    normal_to_x_axis:'getset_descriptor'
    normal_to_y_axis:'getset_descriptor'
    normal_to_z_axis:'getset_descriptor'
    origin:'getset_descriptor'
    origin_translation:'getset_descriptor'
    outline_property:'getset_descriptor'
    outline_translation:'getset_descriptor'
    outside_bounds:'getset_descriptor'
    plane_property:'getset_descriptor'
    poly_data_algorithm:'getset_descriptor'
    scale_enabled:'getset_descriptor'
    selected_normal_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    selected_plane_property:'getset_descriptor'
    tubing:'getset_descriptor'
    def DrawPlaneOff(self) -> None: ...
    def DrawPlaneOn(self) -> None: ...
    def GetDiagonalRatio(self) -> float: ...
    def GetDiagonalRatioMaxValue(self) -> float: ...
    def GetDiagonalRatioMinValue(self) -> float: ...
    def GetDrawPlane(self) -> int: ...
    def GetEdgesProperty(self) -> 'vtkProperty': ...
    @overload
    def GetNormal(self) -> Tuple[float, float, float]: ...
    @overload
    def GetNormal(self, xyz:MutableSequence[float]) -> None: ...
    def GetNormalProperty(self) -> 'vtkProperty': ...
    def GetNormalToXAxis(self) -> int: ...
    def GetNormalToYAxis(self) -> int: ...
    def GetNormalToZAxis(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def GetOriginTranslation(self) -> int: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetOutlineTranslation(self) -> int: ...
    def GetOutsideBounds(self) -> int: ...
    def GetPlane(self, plane:'vtkPlane') -> None: ...
    def GetPlaneProperty(self) -> 'vtkProperty': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetPolyDataAlgorithm(self) -> 'vtkPolyDataAlgorithm': ...
    def GetScaleEnabled(self) -> int: ...
    def GetSelectedNormalProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetSelectedPlaneProperty(self) -> 'vtkProperty': ...
    def GetTubing(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitPlaneWidget': ...
    def NormalToXAxisOff(self) -> None: ...
    def NormalToXAxisOn(self) -> None: ...
    def NormalToYAxisOff(self) -> None: ...
    def NormalToYAxisOn(self) -> None: ...
    def NormalToZAxisOff(self) -> None: ...
    def NormalToZAxisOn(self) -> None: ...
    def OriginTranslationOff(self) -> None: ...
    def OriginTranslationOn(self) -> None: ...
    def OutlineTranslationOff(self) -> None: ...
    def OutlineTranslationOn(self) -> None: ...
    def OutsideBoundsOff(self) -> None: ...
    def OutsideBoundsOn(self) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitPlaneWidget': ...
    def ScaleEnabledOff(self) -> None: ...
    def ScaleEnabledOn(self) -> None: ...
    def SetDiagonalRatio(self, _arg:float) -> None: ...
    def SetDrawPlane(self, plane:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    @overload
    def SetNormal(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormal(self, n:MutableSequence[float]) -> None: ...
    def SetNormalToXAxis(self, __a:int) -> None: ...
    def SetNormalToYAxis(self, __a:int) -> None: ...
    def SetNormalToZAxis(self, __a:int) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetOriginTranslation(self, _arg:int) -> None: ...
    def SetOutlineTranslation(self, _arg:int) -> None: ...
    def SetOutsideBounds(self, _arg:int) -> None: ...
    def SetScaleEnabled(self, _arg:int) -> None: ...
    def SetTubing(self, _arg:int) -> None: ...
    def SizeHandles(self) -> None: ...
    def TubingOff(self) -> None: ...
    def TubingOn(self) -> None: ...
    def UpdatePlacement(self) -> None: ...

class vtkImplicitPlaneWidget2(vtkAbstractWidget):
    enabled:'getset_descriptor'
    implicit_plane_representation:'getset_descriptor'
    lock_normal_to_camera:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetImplicitPlaneRepresentation(self) -> 'vtkImplicitPlaneRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImplicitPlaneWidget2': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImplicitPlaneWidget2': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetLockNormalToCamera(self, lock:int) -> None: ...
    def SetRepresentation(self, rep:'vtkImplicitPlaneRepresentation') -> None: ...

class vtkLightRepresentation(vtkWidgetRepresentation):
    MovingFocalPoint:int
    MovingLight:int
    MovingPositionalFocalPoint:int
    Outside:int
    ScalingConeAngle:int
    bounds:'getset_descriptor'
    cone_angle:'getset_descriptor'
    focal_point:'getset_descriptor'
    interaction_state:'getset_descriptor'
    light_color:'getset_descriptor'
    light_position:'getset_descriptor'
    positional:'getset_descriptor'
    property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetConeAngle(self) -> float: ...
    def GetFocalPoint(self) -> Tuple[float, float, float]: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetLightColor(self) -> Tuple[float, float, float]: ...
    def GetLightPosition(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPositional(self) -> bool: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightRepresentation': ...
    def PositionalOff(self) -> None: ...
    def PositionalOn(self) -> None: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightRepresentation': ...
    def SetConeAngle(self, angle:float) -> None: ...
    def SetFocalPoint(self, pos:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLightColor(self, color:MutableSequence[float]) -> None: ...
    def SetLightPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPositional(self, _arg:bool) -> None: ...
    def StartWidgetInteraction(self, eventPosition:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPosition:MutableSequence[float]) -> None: ...

class vtkLightWidget(vtkAbstractWidget):
    light_representation:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetLightRepresentation(self) -> 'vtkLightRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightWidget': ...
    def SetRepresentation(self, r:'vtkLightRepresentation') -> None: ...

class vtkLineRepresentation(vtkWidgetRepresentation):
    OnLine:int
    OnP1:int
    OnP2:int
    Outside:int
    RestrictNone:int
    RestrictToX:int
    RestrictToY:int
    RestrictToZ:int
    Scaling:int
    TranslatingP1:int
    TranslatingP2:int
    bounds:'getset_descriptor'
    directional_line:'getset_descriptor'
    distance:'getset_descriptor'
    distance_annotation_format:'getset_descriptor'
    distance_annotation_property:'getset_descriptor'
    distance_annotation_scale:'getset_descriptor'
    distance_annotation_visibility:'getset_descriptor'
    end_point2_property:'getset_descriptor'
    end_point_property:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_representation:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    line_color:'getset_descriptor'
    line_handle_representation:'getset_descriptor'
    line_property:'getset_descriptor'
    m_time:'getset_descriptor'
    point1_display_position:'getset_descriptor'
    point1_representation:'getset_descriptor'
    point1_world_position:'getset_descriptor'
    point2_display_position:'getset_descriptor'
    point2_representation:'getset_descriptor'
    point2_world_position:'getset_descriptor'
    renderer:'getset_descriptor'
    representation_state:'getset_descriptor'
    resolution:'getset_descriptor'
    selected_end_point2_property:'getset_descriptor'
    selected_end_point_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    text_actor:'getset_descriptor'
    tolerance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DirectionalLineOff(self) -> None: ...
    def DirectionalLineOn(self) -> None: ...
    def DistanceAnnotationVisibilityOff(self) -> None: ...
    def DistanceAnnotationVisibilityOn(self) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetDirectionalLine(self) -> bool: ...
    def GetDistance(self) -> float: ...
    def GetDistanceAnnotationFormat(self) -> str: ...
    def GetDistanceAnnotationProperty(self) -> 'vtkProperty': ...
    def GetDistanceAnnotationScale(self) -> Tuple[float, float, float]: ...
    def GetDistanceAnnotationVisibility(self) -> int: ...
    def GetEndPoint2Property(self) -> 'vtkProperty': ...
    def GetEndPointProperty(self) -> 'vtkProperty': ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetLineHandleRepresentation(self) -> 'vtkPointHandleRepresentation3D': ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint1DisplayPosition(self) -> Tuple[float, float, float]: ...
    def GetPoint1Representation(self) -> 'vtkPointHandleRepresentation3D': ...
    @overload
    def GetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint1WorldPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2DisplayPosition(self) -> Tuple[float, float, float]: ...
    def GetPoint2Representation(self) -> 'vtkPointHandleRepresentation3D': ...
    @overload
    def GetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2WorldPosition(self) -> Tuple[float, float, float]: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRepresentationState(self) -> int: ...
    def GetResolution(self) -> int: ...
    def GetSelectedEndPoint2Property(self) -> 'vtkProperty': ...
    def GetSelectedEndPointProperty(self) -> 'vtkProperty': ...
    def GetSelectedLineProperty(self) -> 'vtkProperty': ...
    def GetTextActor(self) -> 'vtkFollower': ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InstantiateHandleRepresentation(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLineRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLineRepresentation': ...
    def SetDirectionalLine(self, val:bool) -> None: ...
    def SetDistanceAnnotationFormat(self, _arg:str) -> None: ...
    @overload
    def SetDistanceAnnotationScale(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetDistanceAnnotationScale(self, scale:MutableSequence[float]) -> None: ...
    def SetDistanceAnnotationVisibility(self, _arg:int) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    def SetHandleRepresentation(self, handle:'vtkPointHandleRepresentation3D') -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetLineColor(self, r:float, g:float, b:float) -> None: ...
    def SetPoint1DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint1WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2DisplayPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPoint2WorldPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetRepresentationState(self, __a:int) -> None: ...
    def SetResolution(self, res:int) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkLineWidget(vtk3DWidget):
    align:'getset_descriptor'
    clamp_to_bounds:'getset_descriptor'
    enabled:'getset_descriptor'
    handle_property:'getset_descriptor'
    line_property:'getset_descriptor'
    point1:'getset_descriptor'
    point2:'getset_descriptor'
    resolution:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    def ClampToBoundsOff(self) -> None: ...
    def ClampToBoundsOn(self) -> None: ...
    def GetAlign(self) -> int: ...
    def GetAlignMaxValue(self) -> int: ...
    def GetAlignMinValue(self) -> int: ...
    def GetClampToBounds(self) -> int: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetPoint1(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint1(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint2(self, xyz:MutableSequence[float]) -> None: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetResolution(self) -> int: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedLineProperty(self) -> 'vtkProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLineWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLineWidget': ...
    def SetAlign(self, _arg:int) -> None: ...
    def SetAlignToNone(self) -> None: ...
    def SetAlignToXAxis(self) -> None: ...
    def SetAlignToYAxis(self) -> None: ...
    def SetAlignToZAxis(self) -> None: ...
    def SetClampToBounds(self, _arg:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint1(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint2(self, x:MutableSequence[float]) -> None: ...
    def SetResolution(self, r:int) -> None: ...

class vtkLineWidget2(vtkAbstractWidget):
    enabled:'getset_descriptor'
    line_representation:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetLineRepresentation(self) -> 'vtkLineRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLineWidget2': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLineWidget2': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkLineRepresentation') -> None: ...

class vtkLinearContourLineInterpolator(vtkContourLineInterpolator):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinearContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearContourLineInterpolator': ...

class vtkLogoRepresentation(vtkBorderRepresentation):
    image:'getset_descriptor'
    image_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors2D(self, pc:'vtkPropCollection') -> None: ...
    def GetImage(self) -> 'vtkImageData': ...
    def GetImageProperty(self) -> 'vtkProperty2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLogoRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLogoRepresentation': ...
    def SetImage(self, img:'vtkImageData') -> None: ...
    def SetImageProperty(self, p:'vtkProperty2D') -> None: ...

class vtkLogoWidget(vtkBorderWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLogoWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLogoWidget': ...
    def SetRepresentation(self, r:'vtkLogoRepresentation') -> None: ...

class vtkMagnifierRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Invisible:'InteractionStateType'
    Visible:'InteractionStateType'
    border:'getset_descriptor'
    border_property:'getset_descriptor'
    interaction_state:'getset_descriptor'
    m_time:'getset_descriptor'
    magnification_factor:'getset_descriptor'
    magnification_renderer:'getset_descriptor'
    renderer:'getset_descriptor'
    size:'getset_descriptor'
    view_props:'getset_descriptor'
    def AddViewProp(self, __a:'vtkProp') -> None: ...
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def GetBorder(self) -> bool: ...
    def GetBorderProperty(self) -> 'vtkProperty2D': ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMagnificationFactor(self) -> float: ...
    def GetMagnificationFactorMaxValue(self) -> float: ...
    def GetMagnificationFactorMinValue(self) -> float: ...
    def GetMagnificationRenderer(self) -> 'vtkRenderer': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetViewProps(self) -> 'vtkPropCollection': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def HasViewProp(self, __a:'vtkProp') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMagnifierRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllViewProps(self) -> None: ...
    def RemoveViewProp(self, __a:'vtkProp') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMagnifierRepresentation': ...
    def SetBorder(self, _arg:bool) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetMagnificationFactor(self, _arg:float) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:Sequence[int]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkMagnifierWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    key_press_decrease_value:'getset_descriptor'
    key_press_increase_value:'getset_descriptor'
    magnifier_representation:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetKeyPressDecreaseValue(self) -> str: ...
    def GetKeyPressIncreaseValue(self) -> str: ...
    def GetMagnifierRepresentation(self) -> 'vtkMagnifierRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMagnifierWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMagnifierWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetKeyPressDecreaseValue(self, _arg:str) -> None: ...
    def SetKeyPressIncreaseValue(self, _arg:str) -> None: ...
    def SetRepresentation(self, r:'vtkMagnifierRepresentation') -> None: ...

class vtkMeasurementCubeHandleRepresentation3D(vtkHandleRepresentation):
    adaptive_scaling:'getset_descriptor'
    bounds:'getset_descriptor'
    display_position:'getset_descriptor'
    handle:'getset_descriptor'
    handle_visibility:'getset_descriptor'
    label_text:'getset_descriptor'
    label_text_input:'getset_descriptor'
    label_visibility:'getset_descriptor'
    length_unit:'getset_descriptor'
    max_relative_cube_screen_area:'getset_descriptor'
    min_relative_cube_screen_area:'getset_descriptor'
    property:'getset_descriptor'
    rescale_factor:'getset_descriptor'
    selected_label_visibility:'getset_descriptor'
    selected_property:'getset_descriptor'
    side_length:'getset_descriptor'
    smooth_motion:'getset_descriptor'
    transform:'getset_descriptor'
    world_position:'getset_descriptor'
    def AdaptiveScalingOff(self) -> None: ...
    def AdaptiveScalingOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DeepCopy(self, prop:'vtkProp') -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAdaptiveScaling(self) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetHandle(self) -> 'vtkPolyData': ...
    def GetHandleVisibility(self) -> int: ...
    def GetLabelText(self) -> 'vtkBillboardTextActor3D': ...
    def GetLabelTextInput(self) -> str: ...
    def GetLabelVisibility(self) -> int: ...
    def GetLengthUnit(self) -> str: ...
    def GetMaxRelativeCubeScreenArea(self) -> float: ...
    def GetMinRelativeCubeScreenArea(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetRescaleFactor(self) -> float: ...
    def GetRescaleFactorMaxValue(self) -> float: ...
    def GetRescaleFactorMinValue(self) -> float: ...
    def GetSelectedLabelVisibility(self) -> int: ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def GetSideLength(self) -> float: ...
    def GetSmoothMotion(self) -> int: ...
    def GetTransform(self) -> 'vtkAbstractTransform': ...
    def HandleVisibilityOff(self) -> None: ...
    def HandleVisibilityOn(self) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlight:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkMeasurementCubeHandleRepresentation3D': ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMeasurementCubeHandleRepresentation3D': ...
    def SelectedLabelVisibilityOff(self) -> None: ...
    def SelectedLabelVisibilityOn(self) -> None: ...
    def SetAdaptiveScaling(self, _arg:int) -> None: ...
    def SetDisplayPosition(self, p:MutableSequence[float]) -> None: ...
    def SetHandleVisibility(self, _arg:int) -> None: ...
    def SetLabelTextInput(self, label:str) -> None: ...
    def SetLabelVisibility(self, _arg:int) -> None: ...
    def SetLengthUnit(self, _arg:str) -> None: ...
    def SetMaxRelativeCubeScreenArea(self, __a:float) -> None: ...
    def SetMinRelativeCubeScreenArea(self, __a:float) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetRescaleFactor(self, _arg:float) -> None: ...
    def SetSelectedLabelVisibility(self, _arg:int) -> None: ...
    def SetSelectedProperty(self, __a:'vtkProperty') -> None: ...
    def SetSideLength(self, __a:float) -> None: ...
    def SetSmoothMotion(self, _arg:int) -> None: ...
    def SetWorldPosition(self, p:MutableSequence[float]) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def SmoothMotionOff(self) -> None: ...
    def SmoothMotionOn(self) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkOrientationMarkerWidget(vtkmodules.vtkRenderingCore.vtkInteractorObserver):
    enabled:'getset_descriptor'
    interactive:'getset_descriptor'
    max_dimension_size:'getset_descriptor'
    min_dimension_size:'getset_descriptor'
    orientation_marker:'getset_descriptor'
    outline_color:'getset_descriptor'
    renderer:'getset_descriptor'
    should_constrain_size:'getset_descriptor'
    tolerance:'getset_descriptor'
    viewport:'getset_descriptor'
    zoom:'getset_descriptor'
    def EndInteraction(self) -> None: ...
    def ExecuteCameraUpdateEvent(self, o:'vtkObject', event:int, calldata:Pointer) -> None: ...
    def GetInteractive(self) -> int: ...
    def GetMaxDimensionSize(self) -> int: ...
    def GetMinDimensionSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientationMarker(self) -> 'vtkProp': ...
    def GetOutlineColor(self) -> Tuple[float, float, float]: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetShouldConstrainSize(self) -> int: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def GetViewport(self) -> Tuple[float, float, float, float]: ...
    def GetZoom(self) -> float: ...
    def GetZoomMaxValue(self) -> float: ...
    def GetZoomMinValue(self) -> float: ...
    def InteractiveOff(self) -> None: ...
    def InteractiveOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkOrientationMarkerWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientationMarkerWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetInteractive(self, interact:int) -> None: ...
    def SetOrientationMarker(self, prop:'vtkProp') -> None: ...
    def SetOutlineColor(self, r:float, g:float, b:float) -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetShouldConstrainSize(self, shouldConstrainSize:int) -> None: ...
    def SetSizeConstraintDimensionSizes(self, minDimensionSize:int, maxDimensionSize:int) -> bool: ...
    def SetTolerance(self, _arg:int) -> None: ...
    @overload
    def SetViewport(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetViewport(self, _arg:Sequence[float]) -> None: ...
    def SetZoom(self, _arg:float) -> None: ...

class vtkOrientationRepresentation(vtkWidgetRepresentation):
    class Axis(int): ...
    Outside:int
    RotatingX:int
    RotatingY:int
    RotatingZ:int
    X_AXIS:'Axis'
    Y_AXIS:'Axis'
    Z_AXIS:'Axis'
    arrow_distance:'getset_descriptor'
    arrow_length:'getset_descriptor'
    arrow_shaft_radius:'getset_descriptor'
    arrow_tip_length:'getset_descriptor'
    arrow_tip_radius:'getset_descriptor'
    bounds:'getset_descriptor'
    interaction_state:'getset_descriptor'
    orientation:'getset_descriptor'
    orientation_x:'getset_descriptor'
    orientation_y:'getset_descriptor'
    orientation_z:'getset_descriptor'
    show_arrows:'getset_descriptor'
    torus_length:'getset_descriptor'
    torus_thickness:'getset_descriptor'
    transform:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetArrowDistance(self) -> float: ...
    def GetArrowDistanceMaxValue(self) -> float: ...
    def GetArrowDistanceMinValue(self) -> float: ...
    def GetArrowLength(self) -> float: ...
    def GetArrowLengthMaxValue(self) -> float: ...
    def GetArrowLengthMinValue(self) -> float: ...
    def GetArrowShaftRadius(self) -> float: ...
    def GetArrowShaftRadiusMaxValue(self) -> float: ...
    def GetArrowShaftRadiusMinValue(self) -> float: ...
    def GetArrowTipLength(self) -> float: ...
    def GetArrowTipRadius(self) -> float: ...
    def GetArrowTipRadiusMaxValue(self) -> float: ...
    def GetArrowTipRadiusMinValue(self) -> float: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> Pointer: ...
    def GetOrientationX(self) -> float: ...
    def GetOrientationY(self) -> float: ...
    def GetOrientationZ(self) -> float: ...
    def GetProperty(self, axis:int, selected:bool) -> 'vtkProperty': ...
    def GetPropertyX(self, selected:bool) -> 'vtkProperty': ...
    def GetPropertyY(self, selected:bool) -> 'vtkProperty': ...
    def GetPropertyZ(self, selected:bool) -> 'vtkProperty': ...
    def GetShowArrows(self) -> bool: ...
    def GetTorusLength(self) -> float: ...
    def GetTorusLengthMaxValue(self) -> float: ...
    def GetTorusLengthMinValue(self) -> float: ...
    def GetTorusThickness(self) -> float: ...
    def GetTorusThicknessMaxValue(self) -> float: ...
    def GetTorusThicknessMinValue(self) -> float: ...
    def GetTransform(self) -> 'vtkTransform': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrientationRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientationRepresentation': ...
    def SetArrowDistance(self, _arg:float) -> None: ...
    def SetArrowLength(self, _arg:float) -> None: ...
    def SetArrowShaftRadius(self, _arg:float) -> None: ...
    def SetArrowTipLength(self, _arg:float) -> None: ...
    def SetArrowTipRadius(self, _arg:float) -> None: ...
    def SetInteractionState(self, state:int) -> None: ...
    def SetOrientation(self, values:MutableSequence[float]) -> None: ...
    def SetOrientationX(self, value:float) -> None: ...
    def SetOrientationY(self, value:float) -> None: ...
    def SetOrientationZ(self, value:float) -> None: ...
    def SetProperty(self, axis:int, selected:bool, property:'vtkProperty') -> None: ...
    def SetPropertyX(self, selected:bool, property:'vtkProperty') -> None: ...
    def SetPropertyY(self, selected:bool, property:'vtkProperty') -> None: ...
    def SetPropertyZ(self, selected:bool, property:'vtkProperty') -> None: ...
    def SetShowArrows(self, _arg:bool) -> None: ...
    def SetTorusLength(self, _arg:float) -> None: ...
    def SetTorusThickness(self, _arg:float) -> None: ...
    def ShowArrowsOff(self) -> None: ...
    def ShowArrowsOn(self) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkOrientationWidget(vtkAbstractWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrientationWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientationWidget': ...
    def SetRepresentation(self, r:'vtkOrientationRepresentation') -> None: ...

class vtkOrientedGlyphContourRepresentation(vtkContourRepresentation):
    active_cursor_shape:'getset_descriptor'
    active_property:'getset_descriptor'
    always_on_top:'getset_descriptor'
    bounds:'getset_descriptor'
    contour_representation_as_poly_data:'getset_descriptor'
    cursor_shape:'getset_descriptor'
    line_color:'getset_descriptor'
    lines_property:'getset_descriptor'
    property:'getset_descriptor'
    renderer:'getset_descriptor'
    show_selected_nodes:'getset_descriptor'
    def AlwaysOnTopOff(self) -> None: ...
    def AlwaysOnTopOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modified:int=0) -> int: ...
    def GetActiveCursorShape(self) -> 'vtkPolyData': ...
    def GetActiveProperty(self) -> 'vtkProperty': ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAlwaysOnTop(self) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetContourRepresentationAsPolyData(self) -> 'vtkPolyData': ...
    def GetCursorShape(self) -> 'vtkPolyData': ...
    def GetLinesProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrientedGlyphContourRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientedGlyphContourRepresentation': ...
    def SetActiveCursorShape(self, activeShape:'vtkPolyData') -> None: ...
    def SetAlwaysOnTop(self, _arg:int) -> None: ...
    def SetCursorShape(self, cursorShape:'vtkPolyData') -> None: ...
    def SetLineColor(self, r:float, g:float, b:float) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetShowSelectedNodes(self, __a:int) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkOrientedGlyphFocalPlaneContourRepresentation(vtkFocalPlaneContourRepresentation):
    active_cursor_shape:'getset_descriptor'
    active_property:'getset_descriptor'
    contour_representation_as_poly_data:'getset_descriptor'
    cursor_shape:'getset_descriptor'
    lines_property:'getset_descriptor'
    property:'getset_descriptor'
    renderer:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modified:int=0) -> int: ...
    def GetActiveCursorShape(self) -> 'vtkPolyData': ...
    def GetActiveProperty(self) -> 'vtkProperty2D': ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetContourPlaneDirectionCosines(self, origin:Sequence[float] ) -> 'vtkMatrix4x4': ...
    def GetContourRepresentationAsPolyData(self) -> 'vtkPolyData': ...
    def GetCursorShape(self) -> 'vtkPolyData': ...
    def GetLinesProperty(self) -> 'vtkProperty2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrientedGlyphFocalPlaneContourRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientedGlyphFocalPlaneContourRepresentation': ...
    def SetActiveCursorShape(self, activeShape:'vtkPolyData') -> None: ...
    def SetCursorShape(self, cursorShape:'vtkPolyData') -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkOrientedPolygonalHandleRepresentation3D(vtkAbstractPolygonalHandleRepresentation3D):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOrientedPolygonalHandleRepresentation3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOrientedPolygonalHandleRepresentation3D': ...

class vtkParallelopipedRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    ChairMode:'InteractionStateType'
    Inside:'InteractionStateType'
    Outside:'InteractionStateType'
    RequestChairMode:'InteractionStateType'
    RequestResizeParallelopiped:'InteractionStateType'
    RequestResizeParallelopipedAlongAnAxis:'InteractionStateType'
    RequestRotateParallelopiped:'InteractionStateType'
    RequestScaleParallelopiped:'InteractionStateType'
    RequestTranslateParallelopiped:'InteractionStateType'
    ResizingParallelopiped:'InteractionStateType'
    ResizingParallelopipedAlongAnAxis:'InteractionStateType'
    RotatingParallelopiped:'InteractionStateType'
    ScalingParallelopiped:'InteractionStateType'
    TranslatingParallelopiped:'InteractionStateType'
    bounds:'getset_descriptor'
    face_property:'getset_descriptor'
    handle_property:'getset_descriptor'
    handle_representation:'getset_descriptor'
    hovered_handle_property:'getset_descriptor'
    interaction_state:'getset_descriptor'
    minimum_thickness:'getset_descriptor'
    outline_property:'getset_descriptor'
    selected_face_property:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetBoundingPlanes(self, pc:'vtkPlaneCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetFaceProperty(self) -> 'vtkProperty': ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetHandleRepresentation(self, index:int) -> 'vtkHandleRepresentation': ...
    def GetHoveredHandleProperty(self) -> 'vtkProperty': ...
    def GetMinimumThickness(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetSelectedFaceProperty(self) -> 'vtkProperty': ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def HandlesOff(self) -> None: ...
    def HandlesOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelopipedRepresentation': ...
    @overload
    def PlaceWidget(self, corners:MutableSequence[MutableSequence[float]]) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PositionHandles(self) -> None: ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelopipedRepresentation': ...
    def Scale(self, X:int, Y:int) -> None: ...
    def SetHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetHandleRepresentation(self, handle:'vtkHandleRepresentation') -> None: ...
    def SetHoveredHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetMinimumThickness(self, _arg:float) -> None: ...
    def SetSelectedHandleProperty(self, __a:'vtkProperty') -> None: ...
    @overload
    def Translate(self, translation:MutableSequence[float]) -> None: ...
    @overload
    def Translate(self, X:int, Y:int) -> None: ...

class vtkParallelopipedWidget(vtkAbstractWidget):
    enable_chair_creation:'getset_descriptor'
    enabled:'getset_descriptor'
    parallelopiped_representation:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def EnableChairCreationOff(self) -> None: ...
    def EnableChairCreationOn(self) -> None: ...
    def GetEnableChairCreation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParallelopipedRepresentation(self) -> 'vtkParallelopipedRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelopipedWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelopipedWidget': ...
    def SetEnableChairCreation(self, _arg:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, r:'vtkParallelopipedRepresentation') -> None: ...

class vtkPlaneWidget(vtkPolyDataSourceWidget):
    center:'getset_descriptor'
    enabled:'getset_descriptor'
    handle_property:'getset_descriptor'
    normal:'getset_descriptor'
    normal_to_x_axis:'getset_descriptor'
    normal_to_y_axis:'getset_descriptor'
    normal_to_z_axis:'getset_descriptor'
    origin:'getset_descriptor'
    plane_property:'getset_descriptor'
    point1:'getset_descriptor'
    point2:'getset_descriptor'
    poly_data_algorithm:'getset_descriptor'
    representation:'getset_descriptor'
    resolution:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_plane_property:'getset_descriptor'
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    @overload
    def GetNormal(self) -> Tuple[float, float, float]: ...
    @overload
    def GetNormal(self, xyz:MutableSequence[float]) -> None: ...
    def GetNormalToXAxis(self) -> int: ...
    def GetNormalToYAxis(self) -> int: ...
    def GetNormalToZAxis(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrigin(self, xyz:MutableSequence[float]) -> None: ...
    def GetPlane(self, plane:'vtkPlane') -> None: ...
    def GetPlaneProperty(self) -> 'vtkProperty': ...
    @overload
    def GetPoint1(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint1(self, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetPoint2(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPoint2(self, xyz:MutableSequence[float]) -> None: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetPolyDataAlgorithm(self) -> 'vtkPolyDataAlgorithm': ...
    def GetRepresentation(self) -> int: ...
    def GetRepresentationMaxValue(self) -> int: ...
    def GetRepresentationMinValue(self) -> int: ...
    def GetResolution(self) -> int: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedPlaneProperty(self) -> 'vtkProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlaneWidget': ...
    def NormalToXAxisOff(self) -> None: ...
    def NormalToXAxisOn(self) -> None: ...
    def NormalToYAxisOff(self) -> None: ...
    def NormalToYAxisOn(self) -> None: ...
    def NormalToZAxisOff(self) -> None: ...
    def NormalToZAxisOn(self) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlaneWidget': ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetCenter(self, x:MutableSequence[float]) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    @overload
    def SetNormal(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormal(self, x:MutableSequence[float]) -> None: ...
    def SetNormalToXAxis(self, _arg:int) -> None: ...
    def SetNormalToYAxis(self, _arg:int) -> None: ...
    def SetNormalToZAxis(self, _arg:int) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, x:MutableSequence[float]) -> None: ...
    def SetPlaneProperty(self, __a:'vtkProperty') -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint1(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint2(self, x:MutableSequence[float]) -> None: ...
    def SetRepresentation(self, _arg:int) -> None: ...
    def SetRepresentationToOff(self) -> None: ...
    def SetRepresentationToOutline(self) -> None: ...
    def SetRepresentationToSurface(self) -> None: ...
    def SetRepresentationToWireframe(self) -> None: ...
    def SetResolution(self, r:int) -> None: ...
    def UpdatePlacement(self) -> None: ...

class vtkPlaybackRepresentation(vtkBorderRepresentation):
    property:'getset_descriptor'
    def BackwardOneFrame(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ForwardOneFrame(self) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def JumpToBeginning(self) -> None: ...
    def JumpToEnd(self) -> None: ...
    def NewInstance(self) -> 'vtkPlaybackRepresentation': ...
    def Play(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlaybackRepresentation': ...
    def Stop(self) -> None: ...

class vtkPlaybackWidget(vtkBorderWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPlaybackWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPlaybackWidget': ...
    def SetRepresentation(self, r:'vtkPlaybackRepresentation') -> None: ...

class vtkPointCloudRepresentation(vtkWidgetRepresentation):
    class PickingModeType(int): ...
    class InteractionStateType(int): ...
    HARDWARE_PICKING:'PickingModeType'
    Outside:'InteractionStateType'
    Over:'InteractionStateType'
    OverOutline:'InteractionStateType'
    SOFTWARE_PICKING:'PickingModeType'
    Selecting:'InteractionStateType'
    bounds:'getset_descriptor'
    hardware_picking_tolerance:'getset_descriptor'
    highlighting:'getset_descriptor'
    interaction_state:'getset_descriptor'
    picking_mode:'getset_descriptor'
    point_cloud_actor:'getset_descriptor'
    point_cloud_mapper:'getset_descriptor'
    point_id:'getset_descriptor'
    software_picking_tolerance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetActors2D(self, pc:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetHardwarePickingTolerance(self) -> int: ...
    def GetHighlighting(self) -> bool: ...
    def GetInteractionStateMaxValue(self) -> int: ...
    def GetInteractionStateMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickingMode(self) -> int: ...
    def GetPickingModeMaxValue(self) -> int: ...
    def GetPickingModeMinValue(self) -> int: ...
    def GetPointCloudActor(self) -> 'vtkActor': ...
    def GetPointCloudMapper(self) -> 'vtkPolyDataMapper': ...
    @overload
    def GetPointCoordinates(self) -> Pointer: ...
    @overload
    def GetPointCoordinates(self, x:MutableSequence[float]) -> None: ...
    def GetPointId(self) -> int: ...
    def GetSoftwarePickingTolerance(self) -> float: ...
    def GetSoftwarePickingToleranceMaxValue(self) -> float: ...
    def GetSoftwarePickingToleranceMinValue(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def HighlightingOff(self) -> None: ...
    def HighlightingOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointCloudRepresentation': ...
    @overload
    def PlacePointCloud(self, a:'vtkActor') -> None: ...
    @overload
    def PlacePointCloud(self, ps:'vtkPointSet') -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointCloudRepresentation': ...
    def SetHardwarePickingTolerance(self, _arg:int) -> None: ...
    def SetHighlighting(self, _arg:bool) -> None: ...
    def SetInteractionState(self, _arg:int) -> None: ...
    def SetPickingMode(self, _arg:int) -> None: ...
    def SetPickingModeToHardware(self) -> None: ...
    def SetPickingModeToSoftware(self) -> None: ...
    def SetSoftwarePickingTolerance(self, _arg:float) -> None: ...

class vtkPointCloudWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointCloudWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointCloudWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkPointCloudRepresentation') -> None: ...

class vtkPointHandleRepresentation2D(vtkHandleRepresentation):
    bounds:'getset_descriptor'
    cursor_shape:'getset_descriptor'
    display_position:'getset_descriptor'
    point_placer:'getset_descriptor'
    property:'getset_descriptor'
    selected_property:'getset_descriptor'
    visibility:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DeepCopy(self, prop:'vtkProp') -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCursorShape(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetSelectedProperty(self) -> 'vtkProperty2D': ...
    def Highlight(self, highlight:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointHandleRepresentation2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointHandleRepresentation2D': ...
    def SetCursorShape(self, cursorShape:'vtkPolyData') -> None: ...
    def SetDisplayPosition(self, xyz:MutableSequence[float]) -> None: ...
    def SetPointPlacer(self, __a:'vtkPointPlacer') -> None: ...
    def SetProperty(self, __a:'vtkProperty2D') -> None: ...
    def SetSelectedProperty(self, __a:'vtkProperty2D') -> None: ...
    def SetVisibility(self, visible:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def Translate(self, p1:Sequence[float], p2:Sequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkPointHandleRepresentation3D(vtkHandleRepresentation):
    bounds:'getset_descriptor'
    display_position:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_size:'getset_descriptor'
    hot_spot_size:'getset_descriptor'
    interaction_color:'getset_descriptor'
    outline:'getset_descriptor'
    property:'getset_descriptor'
    selected_property:'getset_descriptor'
    smooth_motion:'getset_descriptor'
    translation_mode:'getset_descriptor'
    visibility:'getset_descriptor'
    world_position:'getset_descriptor'
    x_shadows:'getset_descriptor'
    y_shadows:'getset_descriptor'
    z_shadows:'getset_descriptor'
    def AllOff(self) -> None: ...
    def AllOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DeepCopy(self, prop:'vtkProp') -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetHotSpotSize(self) -> float: ...
    def GetHotSpotSizeMaxValue(self) -> float: ...
    def GetHotSpotSizeMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutline(self) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def GetSmoothMotion(self) -> int: ...
    def GetTranslationMode(self) -> int: ...
    def GetXShadows(self) -> int: ...
    def GetYShadows(self) -> int: ...
    def GetZShadows(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlight:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointHandleRepresentation3D': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointHandleRepresentation3D': ...
    def SetDisplayPosition(self, p:MutableSequence[float]) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    def SetHandleSize(self, size:float) -> None: ...
    def SetHotSpotSize(self, _arg:float) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetOutline(self, o:int) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetSelectedProperty(self, __a:'vtkProperty') -> None: ...
    def SetSmoothMotion(self, _arg:int) -> None: ...
    def SetTranslationMode(self, mode:int) -> None: ...
    def SetVisibility(self, visible:int) -> None: ...
    def SetWorldPosition(self, p:MutableSequence[float]) -> None: ...
    def SetXShadows(self, o:int) -> None: ...
    def SetYShadows(self, o:int) -> None: ...
    def SetZShadows(self, o:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def SmoothMotionOff(self) -> None: ...
    def SmoothMotionOn(self) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def Translate(self, v:Sequence[float]) -> None: ...
    def TranslationModeOff(self) -> None: ...
    def TranslationModeOn(self) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def XShadowsOff(self) -> None: ...
    def XShadowsOn(self) -> None: ...
    def YShadowsOff(self) -> None: ...
    def YShadowsOn(self) -> None: ...
    def ZShadowsOff(self) -> None: ...
    def ZShadowsOn(self) -> None: ...

class vtkPointWidget(vtk3DWidget):
    enabled:'getset_descriptor'
    hot_spot_size:'getset_descriptor'
    outline:'getset_descriptor'
    position:'getset_descriptor'
    property:'getset_descriptor'
    selected_property:'getset_descriptor'
    translation_mode:'getset_descriptor'
    x_shadows:'getset_descriptor'
    y_shadows:'getset_descriptor'
    z_shadows:'getset_descriptor'
    def AllOff(self) -> None: ...
    def AllOn(self) -> None: ...
    def GetHotSpotSize(self) -> float: ...
    def GetHotSpotSizeMaxValue(self) -> float: ...
    def GetHotSpotSizeMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutline(self) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    @overload
    def GetPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPosition(self, xyz:MutableSequence[float]) -> None: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def GetTranslationMode(self) -> int: ...
    def GetXShadows(self) -> int: ...
    def GetYShadows(self) -> int: ...
    def GetZShadows(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointWidget': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetHotSpotSize(self, _arg:float) -> None: ...
    def SetOutline(self, o:int) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, x:MutableSequence[float]) -> None: ...
    def SetTranslationMode(self, mode:int) -> None: ...
    def SetXShadows(self, o:int) -> None: ...
    def SetYShadows(self, o:int) -> None: ...
    def SetZShadows(self, o:int) -> None: ...
    def TranslationModeOff(self) -> None: ...
    def TranslationModeOn(self) -> None: ...
    def XShadowsOff(self) -> None: ...
    def XShadowsOn(self) -> None: ...
    def YShadowsOff(self) -> None: ...
    def YShadowsOn(self) -> None: ...
    def ZShadowsOff(self) -> None: ...
    def ZShadowsOn(self) -> None: ...

class vtkPolyDataContourLineInterpolator(vtkContourLineInterpolator):
    polys:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolys(self) -> 'vtkPolyDataCollection': ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataContourLineInterpolator': ...
    def UpdateNode(self, __a:'vtkRenderer', __b:'vtkContourRepresentation', node:MutableSequence[float], idx:int) -> int: ...

class vtkPolyDataPointPlacer(vtkPointPlacer):
    number_of_props:'getset_descriptor'
    prop_picker:'getset_descriptor'
    def AddProp(self, __a:'vtkProp') -> None: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfProps(self) -> int: ...
    def GetPropPicker(self) -> 'vtkPropPicker': ...
    def HasProp(self, __a:'vtkProp') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataPointPlacer': ...
    def RemoveAllProps(self) -> None: ...
    def RemoveViewProp(self, prop:'vtkProp') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataPointPlacer': ...
    def ValidateDisplayPosition(self, __a:'vtkRenderer', displayPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkPolyLineRepresentation(vtkCurveRepresentation):
    handle_positions:'getset_descriptor'
    number_of_handles:'getset_descriptor'
    summed_length:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetHandlePositions(self) -> 'vtkDoubleArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetSummedLength(self) -> float: ...
    def InitializeHandles(self, points:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyLineRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyLineRepresentation': ...
    def SetNumberOfHandles(self, npts:int) -> None: ...

class vtkPolyLineWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyLineWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyLineWidget': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkPolyLineRepresentation') -> None: ...

class vtkPolygonalSurfaceContourLineInterpolator(vtkPolyDataContourLineInterpolator):
    distance_offset:'getset_descriptor'
    def GetContourPointIds(self, rep:'vtkContourRepresentation', ids:'vtkIdList') -> None: ...
    def GetDistanceOffset(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolygonalSurfaceContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolygonalSurfaceContourLineInterpolator': ...
    def SetDistanceOffset(self, _arg:float) -> None: ...
    def UpdateNode(self, __a:'vtkRenderer', __b:'vtkContourRepresentation', node:MutableSequence[float], idx:int) -> int: ...

class vtkPolygonalSurfacePointPlacer(vtkPolyDataPointPlacer):
    cell_picker:'getset_descriptor'
    distance_offset:'getset_descriptor'
    polys:'getset_descriptor'
    snap_to_closest_point:'getset_descriptor'
    def AddProp(self, __a:'vtkProp') -> None: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetCellPicker(self) -> 'vtkCellPicker': ...
    def GetDistanceOffset(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolys(self) -> 'vtkPolyDataCollection': ...
    def GetSnapToClosestPoint(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolygonalSurfacePointPlacer': ...
    def RemoveAllProps(self) -> None: ...
    def RemoveViewProp(self, prop:'vtkProp') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolygonalSurfacePointPlacer': ...
    def SetDistanceOffset(self, _arg:float) -> None: ...
    def SetSnapToClosestPoint(self, _arg:int) -> None: ...
    def SnapToClosestPointOff(self) -> None: ...
    def SnapToClosestPointOn(self) -> None: ...
    def UpdateNodeWorldPosition(self, worldPos:MutableSequence[float], nodePointId:int) -> int: ...
    def ValidateDisplayPosition(self, __a:'vtkRenderer', displayPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkPolygonalSurfacePointPlacerNode(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkPolygonalSurfacePointPlacerNode') -> None: ...

class vtkProgressBarRepresentation(vtkBorderRepresentation):
    background_color:'getset_descriptor'
    draw_background:'getset_descriptor'
    draw_frame:'getset_descriptor'
    padding:'getset_descriptor'
    progress_bar_color:'getset_descriptor'
    progress_rate:'getset_descriptor'
    property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def DrawBackgroundOff(self) -> None: ...
    def DrawBackgroundOn(self) -> None: ...
    def DrawFrameOff(self) -> None: ...
    def DrawFrameOn(self) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetBackgroundColor(self) -> Tuple[float, float, float]: ...
    def GetDrawBackground(self) -> bool: ...
    def GetDrawFrame(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPadding(self) -> Tuple[float, float]: ...
    def GetProgressBarColor(self) -> Tuple[float, float, float]: ...
    def GetProgressRate(self) -> float: ...
    def GetProgressRateMaxValue(self) -> float: ...
    def GetProgressRateMinValue(self) -> float: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgressBarRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgressBarRepresentation': ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:Sequence[float]) -> None: ...
    def SetDrawBackground(self, _arg:bool) -> None: ...
    def SetDrawFrame(self, _arg:bool) -> None: ...
    @overload
    def SetPadding(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPadding(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetProgressBarColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetProgressBarColor(self, _arg:Sequence[float]) -> None: ...
    def SetProgressRate(self, _arg:float) -> None: ...

class vtkProgressBarWidget(vtkBorderWidget):
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgressBarWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgressBarWidget': ...
    def SetRepresentation(self, r:'vtkProgressBarRepresentation') -> None: ...

class vtkProp3DButtonRepresentation(vtkButtonRepresentation):
    bounds:'getset_descriptor'
    follow_camera:'getset_descriptor'
    state:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def FollowCameraOff(self) -> None: ...
    def FollowCameraOn(self) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetButtonProp(self, i:int) -> 'vtkProp3D': ...
    def GetFollowCamera(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProp3DButtonRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProp3DButtonRepresentation': ...
    def SetButtonProp(self, i:int, prop:'vtkProp3D') -> None: ...
    def SetFollowCamera(self, _arg:int) -> None: ...
    def SetState(self, state:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkRectilinearWipeRepresentation(vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    MovingCenter:'InteractionStateType'
    MovingHPane:'InteractionStateType'
    MovingVPane:'InteractionStateType'
    Outside:'InteractionStateType'
    image_actor:'getset_descriptor'
    property:'getset_descriptor'
    rectilinear_wipe:'getset_descriptor'
    tolerance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetImageActor(self) -> 'vtkImageActor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetRectilinearWipe(self) -> 'vtkImageRectilinearWipe': ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearWipeRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearWipeRepresentation': ...
    def SetImageActor(self, imageActor:'vtkImageActor') -> None: ...
    def SetRectilinearWipe(self, wipe:'vtkImageRectilinearWipe') -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkRectilinearWipeWidget(vtkAbstractWidget):
    rectilinear_wipe_representation:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRectilinearWipeRepresentation(self) -> 'vtkRectilinearWipeRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRectilinearWipeWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRectilinearWipeWidget': ...
    def SetRepresentation(self, r:'vtkRectilinearWipeRepresentation') -> None: ...

class vtkResliceCursor(vtkmodules.vtkCommonCore.vtkObject):
    center:'getset_descriptor'
    hole:'getset_descriptor'
    hole_width:'getset_descriptor'
    hole_width_in_pixels:'getset_descriptor'
    image:'getset_descriptor'
    m_time:'getset_descriptor'
    poly_data:'getset_descriptor'
    thick_mode:'getset_descriptor'
    thickness:'getset_descriptor'
    x_axis:'getset_descriptor'
    x_view_up:'getset_descriptor'
    y_axis:'getset_descriptor'
    y_view_up:'getset_descriptor'
    z_axis:'getset_descriptor'
    z_view_up:'getset_descriptor'
    def GetAxis(self, i:int) -> Pointer: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetCenterlineAxisPolyData(self, axis:int) -> 'vtkPolyData': ...
    def GetHole(self) -> int: ...
    def GetHoleWidth(self) -> float: ...
    def GetHoleWidthInPixels(self) -> float: ...
    def GetImage(self) -> 'vtkImageData': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlane(self, n:int) -> 'vtkPlane': ...
    def GetPolyData(self) -> 'vtkPolyData': ...
    def GetThickMode(self) -> int: ...
    def GetThickness(self) -> Tuple[float, float, float]: ...
    def GetViewUp(self, i:int) -> Pointer: ...
    def GetXAxis(self) -> Tuple[float, float, float]: ...
    def GetXViewUp(self) -> Tuple[float, float, float]: ...
    def GetYAxis(self) -> Tuple[float, float, float]: ...
    def GetYViewUp(self) -> Tuple[float, float, float]: ...
    def GetZAxis(self) -> Tuple[float, float, float]: ...
    def GetZViewUp(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceCursor': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursor': ...
    @overload
    def SetCenter(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetCenter(self, center:MutableSequence[float]) -> None: ...
    def SetHole(self, _arg:int) -> None: ...
    def SetHoleWidth(self, _arg:float) -> None: ...
    def SetHoleWidthInPixels(self, _arg:float) -> None: ...
    def SetImage(self, __a:'vtkImageData') -> None: ...
    def SetThickMode(self, _arg:int) -> None: ...
    @overload
    def SetThickness(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetThickness(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetXAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetXAxis(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetXViewUp(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetXViewUp(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetYAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetYAxis(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetYViewUp(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetYViewUp(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetZAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetZAxis(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetZViewUp(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetZViewUp(self, _arg:Sequence[float]) -> None: ...
    def ThickModeOff(self) -> None: ...
    def ThickModeOn(self) -> None: ...
    def Update(self) -> None: ...

class vtkResliceCursorActor(vtkmodules.vtkRenderingCore.vtkProp3D):
    bounds:'getset_descriptor'
    cursor_algorithm:'getset_descriptor'
    m_time:'getset_descriptor'
    user_matrix:'getset_descriptor'
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCenterlineActor(self, axis:int) -> 'vtkActor': ...
    def GetCenterlineProperty(self, i:int) -> 'vtkProperty': ...
    def GetCursorAlgorithm(self) -> 'vtkResliceCursorPolyDataAlgorithm': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetThickSlabProperty(self, i:int) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceCursorActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorActor': ...
    def SetUserMatrix(self, matrix:'vtkMatrix4x4') -> None: ...

class vtkResliceCursorRepresentation(vtkWidgetRepresentation):
    NearAxis1:int
    NearAxis2:int
    NearCenter:int
    None_:int
    OnAxis1:int
    OnAxis2:int
    OnCenter:int
    Outside:int
    PanAndRotate:int
    ResizeThickness:int
    RotateBothAxes:int
    TranslateSingleAxis:int
    WindowLevelling:int
    color_map:'getset_descriptor'
    cursor_algorithm:'getset_descriptor'
    display_text:'getset_descriptor'
    image_actor:'getset_descriptor'
    level:'getset_descriptor'
    lookup_table:'getset_descriptor'
    manipulation_mode:'getset_descriptor'
    plane_source:'getset_descriptor'
    reslice:'getset_descriptor'
    reslice_axes:'getset_descriptor'
    reslice_cursor:'getset_descriptor'
    restrict_plane_to_volume:'getset_descriptor'
    show_resliced_image:'getset_descriptor'
    text_property:'getset_descriptor'
    thickness_label_format:'getset_descriptor'
    thickness_label_text:'getset_descriptor'
    tolerance:'getset_descriptor'
    use_image_actor:'getset_descriptor'
    window:'getset_descriptor'
    def ActivateText(self, __a:int) -> None: ...
    @staticmethod
    def BoundPlane(bounds:MutableSequence[float], origin:MutableSequence[float], p1:MutableSequence[float], p2:MutableSequence[float]) -> int: ...
    def BuildRepresentation(self) -> None: ...
    def DisplayTextOff(self) -> None: ...
    def DisplayTextOn(self) -> None: ...
    def GetColorMap(self) -> 'vtkImageMapToColors': ...
    def GetCursorAlgorithm(self) -> 'vtkResliceCursorPolyDataAlgorithm': ...
    def GetDisplayText(self) -> int: ...
    def GetImageActor(self) -> 'vtkImageActor': ...
    def GetLevel(self) -> float: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetManipulationMode(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPlaneSource(self) -> 'vtkPlaneSource': ...
    def GetReslice(self) -> 'vtkImageAlgorithm': ...
    def GetResliceAxes(self) -> 'vtkMatrix4x4': ...
    def GetResliceCursor(self) -> 'vtkResliceCursor': ...
    def GetRestrictPlaneToVolume(self) -> int: ...
    def GetShowReslicedImage(self) -> int: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetThicknessLabelFormat(self) -> str: ...
    @overload
    def GetThicknessLabelPosition(self) -> Pointer: ...
    @overload
    def GetThicknessLabelPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetThicknessLabelText(self) -> str: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def GetUseImageActor(self) -> int: ...
    def GetWindow(self) -> float: ...
    def GetWindowLevel(self, wl:MutableSequence[float]) -> None: ...
    def GetWorldThicknessLabelPosition(self, pos:MutableSequence[float]) -> None: ...
    def InitializeReslicePlane(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ManageTextDisplay(self) -> None: ...
    def NewInstance(self) -> 'vtkResliceCursorRepresentation': ...
    def ResetCamera(self) -> None: ...
    def RestrictPlaneToVolumeOff(self) -> None: ...
    def RestrictPlaneToVolumeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorRepresentation': ...
    def SetColorMap(self, __a:'vtkImageMapToColors') -> None: ...
    def SetDisplayText(self, _arg:int) -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    def SetManipulationMode(self, m:int) -> None: ...
    def SetRestrictPlaneToVolume(self, _arg:int) -> None: ...
    def SetShowReslicedImage(self, _arg:int) -> None: ...
    def SetTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    def SetThicknessLabelFormat(self, _arg:str) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...
    def SetUseImageActor(self, _arg:int) -> None: ...
    def SetWindowLevel(self, window:float, level:float, copy:int=0) -> None: ...
    def ShowReslicedImageOff(self) -> None: ...
    def ShowReslicedImageOn(self) -> None: ...
    @staticmethod
    def TransformPlane(planeToTransform:'vtkPlaneSource', targetCenter:MutableSequence[float], targetNormal:MutableSequence[float], targetViewUp:MutableSequence[float]) -> None: ...
    def UseImageActorOff(self) -> None: ...
    def UseImageActorOn(self) -> None: ...

class vtkResliceCursorLineRepresentation(vtkResliceCursorRepresentation):
    bounds:'getset_descriptor'
    reslice_cursor:'getset_descriptor'
    reslice_cursor_actor:'getset_descriptor'
    tolerance:'getset_descriptor'
    user_matrix:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResliceCursor(self) -> 'vtkResliceCursor': ...
    def GetResliceCursorActor(self) -> 'vtkResliceCursorActor': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlightOn:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceCursorLineRepresentation': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorLineRepresentation': ...
    def SetTolerance(self, t:int) -> None: ...
    def SetUserMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    def StartWidgetInteraction(self, startEventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkResliceCursorPicker(vtkmodules.vtkRenderingCore.vtkPicker):
    picked_axis1:'getset_descriptor'
    picked_axis2:'getset_descriptor'
    picked_center:'getset_descriptor'
    reslice_cursor_algorithm:'getset_descriptor'
    transform_matrix:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickedAxis1(self) -> int: ...
    def GetPickedAxis2(self) -> int: ...
    def GetPickedCenter(self) -> int: ...
    def GetResliceCursorAlgorithm(self) -> 'vtkResliceCursorPolyDataAlgorithm': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceCursorPicker': ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    @overload
    def Pick(self, displayPos:MutableSequence[float], world:MutableSequence[float], ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorPicker': ...
    def SetResliceCursorAlgorithm(self, __a:'vtkResliceCursorPolyDataAlgorithm') -> None: ...
    def SetTransformMatrix(self, __a:'vtkMatrix4x4') -> None: ...

class vtkResliceCursorPolyDataAlgorithm(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    XAxis:int
    YAxis:int
    ZAxis:int
    axis1:'getset_descriptor'
    axis2:'getset_descriptor'
    centerline_axis1:'getset_descriptor'
    centerline_axis2:'getset_descriptor'
    m_time:'getset_descriptor'
    plane_axis1:'getset_descriptor'
    plane_axis2:'getset_descriptor'
    reslice_cursor:'getset_descriptor'
    reslice_plane_normal:'getset_descriptor'
    slice_bounds:'getset_descriptor'
    thick_slab_axis1:'getset_descriptor'
    thick_slab_axis2:'getset_descriptor'
    def GetAxis1(self) -> int: ...
    def GetAxis2(self) -> int: ...
    def GetCenterlineAxis1(self) -> 'vtkPolyData': ...
    def GetCenterlineAxis2(self) -> 'vtkPolyData': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOtherPlaneForAxis(self, p:int) -> int: ...
    def GetPlaneAxis1(self) -> int: ...
    def GetPlaneAxis2(self) -> int: ...
    def GetResliceCursor(self) -> 'vtkResliceCursor': ...
    def GetReslicePlaneNormal(self) -> int: ...
    def GetSliceBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetThickSlabAxis1(self) -> 'vtkPolyData': ...
    def GetThickSlabAxis2(self) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceCursorPolyDataAlgorithm': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorPolyDataAlgorithm': ...
    def SetResliceCursor(self, __a:'vtkResliceCursor') -> None: ...
    def SetReslicePlaneNormal(self, _arg:int) -> None: ...
    def SetReslicePlaneNormalToXAxis(self) -> None: ...
    def SetReslicePlaneNormalToYAxis(self) -> None: ...
    def SetReslicePlaneNormalToZAxis(self) -> None: ...
    @overload
    def SetSliceBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetSliceBounds(self, _arg:Sequence[float]) -> None: ...

class vtkResliceCursorThickLineRepresentation(vtkResliceCursorLineRepresentation):
    def CreateDefaultResliceAlgorithm(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResliceCursorThickLineRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorThickLineRepresentation': ...
    def SetResliceParameters(self, outputSpacingX:float, outputSpacingY:float, extentX:int, extentY:int) -> None: ...

class vtkResliceCursorWidget(vtkAbstractWidget):
    ResetCursorEvent:int
    ResliceAxesChangedEvent:int
    ResliceThicknessChangedEvent:int
    WindowLevelEvent:int
    enabled:'getset_descriptor'
    manage_window_level:'getset_descriptor'
    representation:'getset_descriptor'
    reslice_cursor_representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetManageWindowLevel(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResliceCursorRepresentation(self) -> 'vtkResliceCursorRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ManageWindowLevelOff(self) -> None: ...
    def ManageWindowLevelOn(self) -> None: ...
    def NewInstance(self) -> 'vtkResliceCursorWidget': ...
    def ResetResliceCursor(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResliceCursorWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetManageWindowLevel(self, _arg:int) -> None: ...
    def SetRepresentation(self, r:'vtkResliceCursorRepresentation') -> None: ...

class vtkScalarBarRepresentation(vtkBorderRepresentation):
    auto_orient:'getset_descriptor'
    orientation:'getset_descriptor'
    scalar_bar_actor:'getset_descriptor'
    visibility:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors2D(self, collection:'vtkPropCollection') -> None: ...
    def GetAutoOrient(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetScalarBarActor(self) -> 'vtkScalarBarActor': ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def GetVisibility(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScalarBarRepresentation': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScalarBarRepresentation': ...
    def SetAutoOrient(self, _arg:bool) -> None: ...
    def SetOrientation(self, orient:int) -> None: ...
    def SetScalarBarActor(self, __a:'vtkScalarBarActor') -> None: ...
    def SetVisibility(self, __a:int) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkScalarBarWidget(vtkBorderWidget):
    process_events:'getset_descriptor'
    repositionable:'getset_descriptor'
    representation:'getset_descriptor'
    scalar_bar_actor:'getset_descriptor'
    scalar_bar_representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProcessEvents(self) -> int: ...
    def GetRepositionable(self) -> int: ...
    def GetScalarBarActor(self) -> 'vtkScalarBarActor': ...
    def GetScalarBarRepresentation(self) -> 'vtkScalarBarRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScalarBarWidget': ...
    def RepositionableOff(self) -> None: ...
    def RepositionableOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScalarBarWidget': ...
    def SetRepositionable(self, _arg:int) -> None: ...
    def SetRepresentation(self, rep:'vtkScalarBarRepresentation') -> None: ...
    def SetScalarBarActor(self, actor:'vtkScalarBarActor') -> None: ...

class vtkSeedRepresentation(vtkWidgetRepresentation):
    NearSeed:int
    Outside:int
    active_handle:'getset_descriptor'
    handle_representation:'getset_descriptor'
    number_of_seeds:'getset_descriptor'
    tolerance:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def CreateHandle(self, e:MutableSequence[float]) -> int: ...
    def GetActiveHandle(self) -> int: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    @overload
    def GetHandleRepresentation(self, num:int) -> 'vtkHandleRepresentation': ...
    @overload
    def GetHandleRepresentation(self) -> 'vtkHandleRepresentation': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfSeeds(self) -> int: ...
    def GetSeedDisplayPosition(self, seedNum:int, pos:MutableSequence[float]) -> None: ...
    def GetSeedWorldPosition(self, seedNum:int, pos:MutableSequence[float]) -> None: ...
    def GetTolerance(self) -> int: ...
    def GetToleranceMaxValue(self) -> int: ...
    def GetToleranceMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSeedRepresentation': ...
    def RemoveActiveHandle(self) -> None: ...
    def RemoveHandle(self, n:int) -> None: ...
    def RemoveLastHandle(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSeedRepresentation': ...
    def SetActiveHandle(self, handleId:int) -> None: ...
    def SetHandleRepresentation(self, handle:'vtkHandleRepresentation') -> None: ...
    def SetSeedDisplayPosition(self, seedNum:int, pos:MutableSequence[float]) -> None: ...
    def SetSeedWorldPosition(self, seedNum:int, pos:MutableSequence[float]) -> None: ...
    def SetTolerance(self, _arg:int) -> None: ...

class vtkSeedWidget(vtkAbstractWidget):
    MovingSeed:int
    PlacedSeeds:int
    PlacingSeeds:int
    Start:int
    current_renderer:'getset_descriptor'
    enabled:'getset_descriptor'
    interactor:'getset_descriptor'
    process_events:'getset_descriptor'
    representation:'getset_descriptor'
    seed_representation:'getset_descriptor'
    widget_state:'getset_descriptor'
    def CompleteInteraction(self) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def CreateNewHandle(self) -> 'vtkHandleWidget': ...
    def DeleteSeed(self, n:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSeed(self, n:int) -> 'vtkHandleWidget': ...
    def GetSeedRepresentation(self) -> 'vtkSeedRepresentation': ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSeedWidget': ...
    def RestartInteraction(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSeedWidget': ...
    def SetCurrentRenderer(self, __a:'vtkRenderer') -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetInteractor(self, __a:'vtkRenderWindowInteractor') -> None: ...
    def SetProcessEvents(self, __a:int) -> None: ...
    def SetRepresentation(self, rep:'vtkSeedRepresentation') -> None: ...

class vtkSliderRepresentation2D(vtkSliderRepresentation):
    cap_property:'getset_descriptor'
    label_property:'getset_descriptor'
    point1_coordinate:'getset_descriptor'
    point2_coordinate:'getset_descriptor'
    selected_property:'getset_descriptor'
    slider_property:'getset_descriptor'
    title_property:'getset_descriptor'
    title_text:'getset_descriptor'
    tube_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors2D(self, propCollection:'vtkPropCollection') -> None: ...
    def GetCapProperty(self) -> 'vtkProperty2D': ...
    def GetLabelProperty(self) -> 'vtkTextProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1Coordinate(self) -> 'vtkCoordinate': ...
    def GetPoint2Coordinate(self) -> 'vtkCoordinate': ...
    def GetSelectedProperty(self) -> 'vtkProperty2D': ...
    def GetSliderProperty(self) -> 'vtkProperty2D': ...
    def GetTitleProperty(self) -> 'vtkTextProperty': ...
    def GetTitleText(self) -> str: ...
    def GetTubeProperty(self) -> 'vtkProperty2D': ...
    def Highlight(self, __a:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSliderRepresentation2D': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSliderRepresentation2D': ...
    def SetTitleText(self, __a:str) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkSliderRepresentation3D(vtkSliderRepresentation):
    bounds:'getset_descriptor'
    cap_property:'getset_descriptor'
    m_time:'getset_descriptor'
    point1_coordinate:'getset_descriptor'
    point1_in_world_coordinates:'getset_descriptor'
    point2_coordinate:'getset_descriptor'
    point2_in_world_coordinates:'getset_descriptor'
    rotation:'getset_descriptor'
    selected_property:'getset_descriptor'
    slider_property:'getset_descriptor'
    slider_shape:'getset_descriptor'
    title_text:'getset_descriptor'
    tube_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetActors(self, propCollection:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCapProperty(self) -> 'vtkProperty': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPoint1Coordinate(self) -> 'vtkCoordinate': ...
    def GetPoint2Coordinate(self) -> 'vtkCoordinate': ...
    def GetRotation(self) -> float: ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def GetSliderProperty(self) -> 'vtkProperty': ...
    def GetSliderShape(self) -> int: ...
    def GetSliderShapeMaxValue(self) -> int: ...
    def GetSliderShapeMinValue(self) -> int: ...
    def GetTitleText(self) -> str: ...
    def GetTubeProperty(self) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, __a:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSliderRepresentation3D': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSliderRepresentation3D': ...
    def SetPoint1InWorldCoordinates(self, x:float, y:float, z:float) -> None: ...
    def SetPoint2InWorldCoordinates(self, x:float, y:float, z:float) -> None: ...
    def SetRotation(self, _arg:float) -> None: ...
    def SetSliderShape(self, _arg:int) -> None: ...
    def SetSliderShapeToCylinder(self) -> None: ...
    def SetSliderShapeToSphere(self) -> None: ...
    def SetTitleText(self, __a:str) -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, newEventPos:MutableSequence[float]) -> None: ...

class vtkSliderWidget(vtkAbstractWidget):
    animation_mode:'getset_descriptor'
    number_of_animation_steps:'getset_descriptor'
    number_of_animation_steps_max_value:'getset_descriptor'
    number_of_animation_steps_min_value:'getset_descriptor'
    representation:'getset_descriptor'
    slider_representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetAnimationMode(self) -> int: ...
    def GetAnimationModeMaxValue(self) -> int: ...
    def GetAnimationModeMinValue(self) -> int: ...
    def GetNumberOfAnimationSteps(self) -> int: ...
    def GetNumberOfAnimationStepsMaxValue(self) -> int: ...
    def GetNumberOfAnimationStepsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSliderRepresentation(self) -> 'vtkSliderRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSliderWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSliderWidget': ...
    def SetAnimationMode(self, _arg:int) -> None: ...
    def SetAnimationModeToAnimate(self) -> None: ...
    def SetAnimationModeToJump(self) -> None: ...
    def SetAnimationModeToOff(self) -> None: ...
    def SetNumberOfAnimationSteps(self, _arg:int) -> None: ...
    def SetRepresentation(self, r:'vtkSliderRepresentation') -> None: ...

class vtkSphereHandleRepresentation(vtkHandleRepresentation):
    bounds:'getset_descriptor'
    display_position:'getset_descriptor'
    handle_size:'getset_descriptor'
    hot_spot_size:'getset_descriptor'
    property:'getset_descriptor'
    selected_property:'getset_descriptor'
    sphere_radius:'getset_descriptor'
    translation_mode:'getset_descriptor'
    visibility:'getset_descriptor'
    world_position:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def DeepCopy(self, prop:'vtkProp') -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetHotSpotSize(self) -> float: ...
    def GetHotSpotSizeMaxValue(self) -> float: ...
    def GetHotSpotSizeMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetSelectedProperty(self) -> 'vtkProperty': ...
    def GetSphereRadius(self) -> float: ...
    def GetTranslationMode(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, highlight:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereHandleRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereHandleRepresentation': ...
    def SetDisplayPosition(self, p:MutableSequence[float]) -> None: ...
    def SetHandleSize(self, size:float) -> None: ...
    def SetHotSpotSize(self, _arg:float) -> None: ...
    def SetProperty(self, __a:'vtkProperty') -> None: ...
    def SetSelectedProperty(self, __a:'vtkProperty') -> None: ...
    def SetSphereRadius(self, __a:float) -> None: ...
    def SetTranslationMode(self, _arg:int) -> None: ...
    def SetVisibility(self, visible:int) -> None: ...
    def SetWorldPosition(self, p:MutableSequence[float]) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def StartWidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...
    def Translate(self, v:Sequence[float]) -> None: ...
    def TranslationModeOff(self) -> None: ...
    def TranslationModeOn(self) -> None: ...
    def WidgetInteraction(self, eventPos:MutableSequence[float]) -> None: ...

class vtkSphereRepresentation(vtkWidgetRepresentation):
    MovingHandle:int
    OnSphere:int
    Outside:int
    Scaling:int
    Translating:int
    bounds:'getset_descriptor'
    center:'getset_descriptor'
    center_cursor:'getset_descriptor'
    foreground_color:'getset_descriptor'
    handle_color:'getset_descriptor'
    handle_direction:'getset_descriptor'
    handle_position:'getset_descriptor'
    handle_property:'getset_descriptor'
    handle_text:'getset_descriptor'
    handle_text_property:'getset_descriptor'
    handle_visibility:'getset_descriptor'
    interaction_color:'getset_descriptor'
    interaction_state:'getset_descriptor'
    phi_resolution:'getset_descriptor'
    radial_line:'getset_descriptor'
    radial_line_property:'getset_descriptor'
    radius:'getset_descriptor'
    representation:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_sphere_property:'getset_descriptor'
    sphere_property:'getset_descriptor'
    theta_resolution:'getset_descriptor'
    translation_axis:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def CenterCursorOff(self) -> None: ...
    def CenterCursorOn(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    def GetCenterCursor(self) -> bool: ...
    def GetHandleDirection(self) -> Tuple[float, float, float]: ...
    def GetHandlePosition(self) -> Tuple[float, float, float]: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetHandleText(self) -> int: ...
    def GetHandleTextProperty(self) -> 'vtkTextProperty': ...
    def GetHandleVisibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhiResolution(self) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRadialLine(self) -> int: ...
    def GetRadialLineProperty(self) -> 'vtkProperty': ...
    def GetRadius(self) -> float: ...
    def GetRepresentation(self) -> int: ...
    def GetRepresentationMaxValue(self) -> int: ...
    def GetRepresentationMinValue(self) -> int: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedSphereProperty(self) -> 'vtkProperty': ...
    def GetSphere(self, sphere:'vtkSphere') -> None: ...
    def GetSphereProperty(self) -> 'vtkProperty': ...
    def GetThetaResolution(self) -> int: ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def HandleTextOff(self) -> None: ...
    def HandleTextOn(self) -> None: ...
    def HandleVisibilityOff(self) -> None: ...
    def HandleVisibilityOn(self) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereRepresentation': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self, center:MutableSequence[float], handlePosition:MutableSequence[float]) -> None: ...
    def RadialLineOff(self) -> None: ...
    def RadialLineOn(self) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereRepresentation': ...
    @overload
    def SetCenter(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    def SetCenterCursor(self, _arg:bool) -> None: ...
    @overload
    def SetForegroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetForegroundColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetHandleColor(self, c:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleDirection(self, dir:MutableSequence[float]) -> None: ...
    @overload
    def SetHandleDirection(self, dx:float, dy:float, dz:float) -> None: ...
    @overload
    def SetHandlePosition(self, handle:MutableSequence[float]) -> None: ...
    @overload
    def SetHandlePosition(self, x:float, y:float, z:float) -> None: ...
    def SetHandleText(self, _arg:int) -> None: ...
    def SetHandleVisibility(self, _arg:int) -> None: ...
    @overload
    def SetInteractionColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetInteractionColor(self, c:MutableSequence[float]) -> None: ...
    def SetInteractionState(self, state:int) -> None: ...
    def SetPhiResolution(self, r:int) -> None: ...
    def SetRadialLine(self, _arg:int) -> None: ...
    def SetRadius(self, r:float) -> None: ...
    def SetRepresentation(self, _arg:int) -> None: ...
    def SetRepresentationToOff(self) -> None: ...
    def SetRepresentationToSurface(self) -> None: ...
    def SetRepresentationToWireframe(self) -> None: ...
    def SetThetaResolution(self, r:int) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkSphereWidget(vtk3DWidget):
    center:'getset_descriptor'
    enabled:'getset_descriptor'
    handle_direction:'getset_descriptor'
    handle_position:'getset_descriptor'
    handle_property:'getset_descriptor'
    handle_visibility:'getset_descriptor'
    phi_resolution:'getset_descriptor'
    radius:'getset_descriptor'
    representation:'getset_descriptor'
    scale:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_sphere_property:'getset_descriptor'
    sphere_property:'getset_descriptor'
    theta_resolution:'getset_descriptor'
    translation:'getset_descriptor'
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, xyz:MutableSequence[float]) -> None: ...
    def GetHandleDirection(self) -> Tuple[float, float, float]: ...
    def GetHandlePosition(self) -> Tuple[float, float, float]: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetHandleVisibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhiResolution(self) -> int: ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetRadius(self) -> float: ...
    def GetRepresentation(self) -> int: ...
    def GetRepresentationMaxValue(self) -> int: ...
    def GetRepresentationMinValue(self) -> int: ...
    def GetScale(self) -> int: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedSphereProperty(self) -> 'vtkProperty': ...
    def GetSphere(self, sphere:'vtkSphere') -> None: ...
    def GetSphereProperty(self) -> 'vtkProperty': ...
    def GetThetaResolution(self) -> int: ...
    def GetTranslation(self) -> int: ...
    def HandleVisibilityOff(self) -> None: ...
    def HandleVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereWidget': ...
    def ScaleOff(self) -> None: ...
    def ScaleOn(self) -> None: ...
    @overload
    def SetCenter(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetCenter(self, x:MutableSequence[float]) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    @overload
    def SetHandleDirection(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHandleDirection(self, _arg:Sequence[float]) -> None: ...
    def SetHandleVisibility(self, _arg:int) -> None: ...
    def SetPhiResolution(self, r:int) -> None: ...
    def SetRadius(self, r:float) -> None: ...
    def SetRepresentation(self, _arg:int) -> None: ...
    def SetRepresentationToOff(self) -> None: ...
    def SetRepresentationToSurface(self) -> None: ...
    def SetRepresentationToWireframe(self) -> None: ...
    def SetScale(self, _arg:int) -> None: ...
    def SetThetaResolution(self, r:int) -> None: ...
    def SetTranslation(self, _arg:int) -> None: ...
    def TranslationOff(self) -> None: ...
    def TranslationOn(self) -> None: ...

class vtkSphereWidget2(vtkAbstractWidget):
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    scaling_enabled:'getset_descriptor'
    translation_enabled:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalingEnabled(self) -> int: ...
    def GetTranslationEnabled(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSphereWidget2': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSphereWidget2': ...
    def ScalingEnabledOff(self) -> None: ...
    def ScalingEnabledOn(self) -> None: ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkSphereRepresentation') -> None: ...
    def SetScalingEnabled(self, _arg:int) -> None: ...
    def SetTranslationEnabled(self, _arg:int) -> None: ...
    def TranslationEnabledOff(self) -> None: ...
    def TranslationEnabledOn(self) -> None: ...

class vtkSplineRepresentation(vtkAbstractSplineRepresentation):
    number_of_handles:'getset_descriptor'
    parametric_spline:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitializeHandles(self, points:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplineRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplineRepresentation': ...
    def SetNumberOfHandles(self, npts:int) -> None: ...
    def SetParametricSpline(self, spline:'vtkParametricSpline') -> None: ...

class vtkSplineWidget(vtk3DWidget):
    closed:'getset_descriptor'
    enabled:'getset_descriptor'
    handle_property:'getset_descriptor'
    line_property:'getset_descriptor'
    number_of_handles:'getset_descriptor'
    parametric_spline:'getset_descriptor'
    plane_source:'getset_descriptor'
    process_events:'getset_descriptor'
    project_to_plane:'getset_descriptor'
    projection_normal:'getset_descriptor'
    projection_position:'getset_descriptor'
    resolution:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_line_property:'getset_descriptor'
    summed_length:'getset_descriptor'
    def ClosedOff(self) -> None: ...
    def ClosedOn(self) -> None: ...
    def GetClosed(self) -> int: ...
    @overload
    def GetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    @overload
    def GetHandlePosition(self, handle:int) -> Tuple[float, float, float]: ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetLineProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHandles(self) -> int: ...
    def GetParametricSpline(self) -> 'vtkParametricSpline': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetProcessEvents(self) -> int: ...
    def GetProcessEventsMaxValue(self) -> int: ...
    def GetProcessEventsMinValue(self) -> int: ...
    def GetProjectToPlane(self) -> int: ...
    def GetProjectionNormal(self) -> int: ...
    def GetProjectionNormalMaxValue(self) -> int: ...
    def GetProjectionNormalMinValue(self) -> int: ...
    def GetProjectionPosition(self) -> float: ...
    def GetResolution(self) -> int: ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedLineProperty(self) -> 'vtkProperty': ...
    def GetSummedLength(self) -> float: ...
    def InitializeHandles(self, points:'vtkPoints') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsClosed(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplineWidget': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self) -> None: ...
    @overload
    def PlaceWidget(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def ProcessEventsOff(self) -> None: ...
    def ProcessEventsOn(self) -> None: ...
    def ProjectToPlaneOff(self) -> None: ...
    def ProjectToPlaneOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplineWidget': ...
    def SetClosed(self, closed:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, x:float, y:float, z:float) -> None: ...
    @overload
    def SetHandlePosition(self, handle:int, xyz:MutableSequence[float]) -> None: ...
    def SetHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetLineProperty(self, __a:'vtkProperty') -> None: ...
    def SetNumberOfHandles(self, npts:int) -> None: ...
    def SetParametricSpline(self, __a:'vtkParametricSpline') -> None: ...
    def SetPlaneSource(self, plane:'vtkPlaneSource') -> None: ...
    def SetProcessEvents(self, _arg:int) -> None: ...
    def SetProjectToPlane(self, _arg:int) -> None: ...
    def SetProjectionNormal(self, _arg:int) -> None: ...
    def SetProjectionNormalToOblique(self) -> None: ...
    def SetProjectionNormalToXAxes(self) -> None: ...
    def SetProjectionNormalToYAxes(self) -> None: ...
    def SetProjectionNormalToZAxes(self) -> None: ...
    def SetProjectionPosition(self, position:float) -> None: ...
    def SetResolution(self, resolution:int) -> None: ...
    def SetSelectedHandleProperty(self, __a:'vtkProperty') -> None: ...
    def SetSelectedLineProperty(self, __a:'vtkProperty') -> None: ...

class vtkSplineWidget2(vtkAbstractWidget):
    enabled:'getset_descriptor'
    representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSplineWidget2': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSplineWidget2': ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetRepresentation(self, r:'vtkSplineRepresentation') -> None: ...

class vtkTensorProbeWidget(vtkAbstractWidget):
    representation:'getset_descriptor'
    tensor_probe_representation:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTensorProbeRepresentation(self) -> 'vtkTensorProbeRepresentation': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTensorProbeWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTensorProbeWidget': ...
    def SetRepresentation(self, r:'vtkTensorProbeRepresentation') -> None: ...

class vtkTensorRepresentation(vtkWidgetRepresentation):
    MoveF0:int
    MoveF1:int
    MoveF2:int
    MoveF3:int
    MoveF4:int
    MoveF5:int
    Outside:int
    Rotating:int
    Scaling:int
    Translating:int
    bounds:'getset_descriptor'
    ellipsoid_property:'getset_descriptor'
    face_property:'getset_descriptor'
    handle_property:'getset_descriptor'
    interaction_state:'getset_descriptor'
    outline_cursor_wires:'getset_descriptor'
    outline_face_wires:'getset_descriptor'
    outline_property:'getset_descriptor'
    position:'getset_descriptor'
    selected_face_property:'getset_descriptor'
    selected_handle_property:'getset_descriptor'
    selected_outline_property:'getset_descriptor'
    snap_to_axes:'getset_descriptor'
    symmetric_tensor:'getset_descriptor'
    tensor:'getset_descriptor'
    tensor_ellipsoid:'getset_descriptor'
    translation_axis:'getset_descriptor'
    x_translation_axis_on:'getset_descriptor'
    y_translation_axis_on:'getset_descriptor'
    z_translation_axis_on:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def EndComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetEigenvalues(self, evals:MutableSequence[float]) -> None: ...
    def GetEigenvector(self, n:int, ev:MutableSequence[float]) -> None: ...
    def GetEllipsoidProperty(self) -> 'vtkProperty': ...
    def GetFaceProperty(self) -> 'vtkProperty': ...
    def GetHandleProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineCursorWires(self) -> bool: ...
    def GetOutlineFaceWires(self) -> bool: ...
    def GetOutlineProperty(self) -> 'vtkProperty': ...
    def GetPolyData(self, pd:'vtkPolyData') -> None: ...
    def GetPosition(self, pos:MutableSequence[float]) -> None: ...
    def GetSelectedFaceProperty(self) -> 'vtkProperty': ...
    def GetSelectedHandleProperty(self) -> 'vtkProperty': ...
    def GetSelectedOutlineProperty(self) -> 'vtkProperty': ...
    def GetSnapToAxes(self) -> bool: ...
    def GetSymmetricTensor(self, symTensor:MutableSequence[float]) -> None: ...
    def GetTensor(self, tensor:MutableSequence[float]) -> None: ...
    def GetTensorEllipsoid(self) -> bool: ...
    def GetTranslationAxis(self) -> int: ...
    def GetTranslationAxisMaxValue(self) -> int: ...
    def GetTranslationAxisMinValue(self) -> int: ...
    def HandlesOff(self) -> None: ...
    def HandlesOn(self) -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslationConstrained(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTensorRepresentation': ...
    def OutlineCursorWiresOff(self) -> None: ...
    def OutlineCursorWiresOn(self) -> None: ...
    def OutlineFaceWiresOff(self) -> None: ...
    def OutlineFaceWiresOn(self) -> None: ...
    def PlaceTensor(self, tensor:MutableSequence[float], position:MutableSequence[float]) -> None: ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTensorRepresentation': ...
    def SetInteractionState(self, state:int) -> None: ...
    def SetOutlineCursorWires(self, __a:bool) -> None: ...
    def SetOutlineFaceWires(self, __a:bool) -> None: ...
    def SetPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetSnapToAxes(self, _arg:bool) -> None: ...
    def SetSymmetricTensor(self, symTensor:MutableSequence[float]) -> None: ...
    def SetTensor(self, tensor:MutableSequence[float]) -> None: ...
    def SetTensorEllipsoid(self, __a:bool) -> None: ...
    def SetTranslationAxis(self, _arg:int) -> None: ...
    def SetTranslationAxisOff(self) -> None: ...
    def SetXTranslationAxisOn(self) -> None: ...
    def SetYTranslationAxisOn(self) -> None: ...
    def SetZTranslationAxisOn(self) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def StartWidgetInteraction(self, e:MutableSequence[float]) -> None: ...
    def StepBackward(self) -> None: ...
    def StepForward(self) -> None: ...
    def TensorEllipsoidOff(self) -> None: ...
    def TensorEllipsoidOn(self) -> None: ...
    def WidgetInteraction(self, e:MutableSequence[float]) -> None: ...

class vtkTensorWidget(vtkAbstractWidget):
    enabled:'getset_descriptor'
    move_faces_enabled:'getset_descriptor'
    representation:'getset_descriptor'
    rotation_enabled:'getset_descriptor'
    scaling_enabled:'getset_descriptor'
    translation_enabled:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetMoveFacesEnabled(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRotationEnabled(self) -> int: ...
    def GetScalingEnabled(self) -> int: ...
    def GetTranslationEnabled(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MoveFacesEnabledOff(self) -> None: ...
    def MoveFacesEnabledOn(self) -> None: ...
    def NewInstance(self) -> 'vtkTensorWidget': ...
    def RotationEnabledOff(self) -> None: ...
    def RotationEnabledOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTensorWidget': ...
    def ScalingEnabledOff(self) -> None: ...
    def ScalingEnabledOn(self) -> None: ...
    def SetEnabled(self, enabling:int) -> None: ...
    def SetMoveFacesEnabled(self, _arg:int) -> None: ...
    def SetRepresentation(self, r:'vtkTensorRepresentation') -> None: ...
    def SetRotationEnabled(self, _arg:int) -> None: ...
    def SetScalingEnabled(self, _arg:int) -> None: ...
    def SetTranslationEnabled(self, _arg:int) -> None: ...
    def TranslationEnabledOff(self) -> None: ...
    def TranslationEnabledOn(self) -> None: ...

class vtkTerrainContourLineInterpolator(vtkContourLineInterpolator):
    image_data:'getset_descriptor'
    projector:'getset_descriptor'
    def GetImageData(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProjector(self) -> 'vtkProjectedTerrainPath': ...
    def InterpolateLine(self, ren:'vtkRenderer', rep:'vtkContourRepresentation', idx1:int, idx2:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTerrainContourLineInterpolator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTerrainContourLineInterpolator': ...
    def SetImageData(self, __a:'vtkImageData') -> None: ...
    def UpdateNode(self, __a:'vtkRenderer', __b:'vtkContourRepresentation', node:MutableSequence[float], idx:int) -> int: ...

class vtkTerrainDataPointPlacer(vtkPointPlacer):
    height_offset:'getset_descriptor'
    prop_picker:'getset_descriptor'
    def AddProp(self, __a:'vtkProp') -> None: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    @overload
    def ComputeWorldPosition(self, ren:'vtkRenderer', displayPos:MutableSequence[float], refWorldPos:MutableSequence[float], worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...
    def GetHeightOffset(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPropPicker(self) -> 'vtkPropPicker': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTerrainDataPointPlacer': ...
    def RemoveAllProps(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTerrainDataPointPlacer': ...
    def SetHeightOffset(self, _arg:float) -> None: ...
    def ValidateDisplayPosition(self, __a:'vtkRenderer', displayPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float]) -> int: ...
    @overload
    def ValidateWorldPosition(self, worldPos:MutableSequence[float], worldOrient:MutableSequence[float]) -> int: ...

class vtkTextRepresentation(vtkBorderRepresentation):
    padding:'getset_descriptor'
    padding_bottom:'getset_descriptor'
    padding_left:'getset_descriptor'
    padding_right:'getset_descriptor'
    padding_top:'getset_descriptor'
    position:'getset_descriptor'
    text:'getset_descriptor'
    text_actor:'getset_descriptor'
    window_location:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ExecuteTextActorModifiedEvent(self, obj:'vtkObject', enumEvent:int, p:Pointer) -> None: ...
    def ExecuteTextPropertyModifiedEvent(self, obj:'vtkObject', enumEvent:int, p:Pointer) -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPaddingBottom(self) -> int: ...
    def GetPaddingBottomMaxValue(self) -> int: ...
    def GetPaddingBottomMinValue(self) -> int: ...
    def GetPaddingLeft(self) -> int: ...
    def GetPaddingLeftMaxValue(self) -> int: ...
    def GetPaddingLeftMinValue(self) -> int: ...
    def GetPaddingRight(self) -> int: ...
    def GetPaddingRightMaxValue(self) -> int: ...
    def GetPaddingRightMinValue(self) -> int: ...
    def GetPaddingTop(self) -> int: ...
    def GetPaddingTopMaxValue(self) -> int: ...
    def GetPaddingTopMinValue(self) -> int: ...
    def GetSize(self, size:MutableSequence[float]) -> None: ...
    def GetText(self) -> str: ...
    def GetTextActor(self) -> 'vtkTextActor': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextRepresentation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextRepresentation': ...
    def SetPadding(self, padding:int) -> None: ...
    def SetPaddingBottom(self, _arg:int) -> None: ...
    def SetPaddingLeft(self, _arg:int) -> None: ...
    def SetPaddingRight(self, _arg:int) -> None: ...
    def SetPaddingTop(self, _arg:int) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float) -> None: ...
    @overload
    def SetPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetText(self, text:str) -> None: ...
    def SetTextActor(self, textActor:'vtkTextActor') -> None: ...
    def SetWindowLocation(self, enumLocation:int) -> None: ...

class vtkTextWidget(vtkBorderWidget):
    representation:'getset_descriptor'
    text_actor:'getset_descriptor'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextActor(self) -> 'vtkTextActor': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextWidget': ...
    def SetRepresentation(self, r:'vtkTextRepresentation') -> None: ...
    def SetTextActor(self, textActor:'vtkTextActor') -> None: ...

class vtkTexturedButtonRepresentation(vtkButtonRepresentation):
    bounds:'getset_descriptor'
    button_geometry:'getset_descriptor'
    button_geometry_connection:'getset_descriptor'
    follow_camera:'getset_descriptor'
    hovering_property:'getset_descriptor'
    property:'getset_descriptor'
    selecting_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def FollowCameraOff(self) -> None: ...
    def FollowCameraOn(self) -> None: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetButtonGeometry(self) -> 'vtkPolyData': ...
    def GetButtonTexture(self, i:int) -> 'vtkImageData': ...
    def GetFollowCamera(self) -> int: ...
    def GetHoveringProperty(self) -> 'vtkProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetSelectingProperty(self) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, state:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTexturedButtonRepresentation': ...
    @overload
    def PlaceWidget(self, scale:float, point:MutableSequence[float], normal:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def RegisterPickers(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTexturedButtonRepresentation': ...
    def SetButtonGeometry(self, pd:'vtkPolyData') -> None: ...
    def SetButtonGeometryConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetButtonTexture(self, i:int, image:'vtkImageData') -> None: ...
    def SetFollowCamera(self, _arg:int) -> None: ...
    def SetHoveringProperty(self, p:'vtkProperty') -> None: ...
    def SetProperty(self, p:'vtkProperty') -> None: ...
    def SetSelectingProperty(self, p:'vtkProperty') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkTexturedButtonRepresentation2D(vtkButtonRepresentation):
    balloon:'getset_descriptor'
    bounds:'getset_descriptor'
    hovering_property:'getset_descriptor'
    property:'getset_descriptor'
    selecting_property:'getset_descriptor'
    def BuildRepresentation(self) -> None: ...
    def ComputeInteractionState(self, X:int, Y:int, modify:int=0) -> int: ...
    def GetActors(self, pc:'vtkPropCollection') -> None: ...
    def GetBalloon(self) -> 'vtkBalloonRepresentation': ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetButtonTexture(self, i:int) -> 'vtkImageData': ...
    def GetHoveringProperty(self) -> 'vtkProperty2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetSelectingProperty(self) -> 'vtkProperty2D': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def Highlight(self, state:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTexturedButtonRepresentation2D': ...
    @overload
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def PlaceWidget(self, anchor:MutableSequence[float], size:MutableSequence[int]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTexturedButtonRepresentation2D': ...
    def SetButtonTexture(self, i:int, image:'vtkImageData') -> None: ...
    def SetHoveringProperty(self, p:'vtkProperty2D') -> None: ...
    def SetProperty(self, p:'vtkProperty2D') -> None: ...
    def SetSelectingProperty(self, p:'vtkProperty2D') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkWidgetCallbackMapper(vtkmodules.vtkCommonCore.vtkObject):
    event_translator:'getset_descriptor'
    def GetEventTranslator(self) -> 'vtkWidgetEventTranslator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InvokeCallback(self, widgetEvent:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWidgetCallbackMapper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWidgetCallbackMapper': ...
    def SetEventTranslator(self, t:'vtkWidgetEventTranslator') -> None: ...

class vtkWidgetEvent(vtkmodules.vtkCommonCore.vtkObject):
    class WidgetEventIds(int): ...
    AddFinalPoint:'WidgetEventIds'
    AddFinalPoint3D:'WidgetEventIds'
    AddPoint:'WidgetEventIds'
    AddPoint3D:'WidgetEventIds'
    Completed:'WidgetEventIds'
    Delete:'WidgetEventIds'
    Down:'WidgetEventIds'
    EndResize:'WidgetEventIds'
    EndRotate:'WidgetEventIds'
    EndScale:'WidgetEventIds'
    EndSelect:'WidgetEventIds'
    EndSelect3D:'WidgetEventIds'
    EndTranslate:'WidgetEventIds'
    HoverLeave:'WidgetEventIds'
    Left:'WidgetEventIds'
    ModifyEvent:'WidgetEventIds'
    Move:'WidgetEventIds'
    Move3D:'WidgetEventIds'
    NoEvent:'WidgetEventIds'
    PickDirectionPoint:'WidgetEventIds'
    PickNormal:'WidgetEventIds'
    PickPoint:'WidgetEventIds'
    Reset:'WidgetEventIds'
    Resize:'WidgetEventIds'
    Right:'WidgetEventIds'
    Rotate:'WidgetEventIds'
    Scale:'WidgetEventIds'
    Select:'WidgetEventIds'
    Select3D:'WidgetEventIds'
    SizeHandles:'WidgetEventIds'
    TimedOut:'WidgetEventIds'
    Translate:'WidgetEventIds'
    Up:'WidgetEventIds'
    @staticmethod
    def GetEventIdFromString(event:str) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetStringFromEventId(event:int) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWidgetEvent': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWidgetEvent': ...

class vtkWidgetEventTranslator(vtkmodules.vtkCommonCore.vtkObject):
    translation:'getset_descriptor'
    def AddEventsToInteractor(self, __a:'vtkRenderWindowInteractor', __b:'vtkCallbackCommand', priority:float) -> None: ...
    def AddEventsToParent(self, __a:'vtkAbstractWidget', __b:'vtkCallbackCommand', priority:float) -> None: ...
    def ClearEvents(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetTranslation(self, VTKEvent:int) -> int: ...
    @overload
    def GetTranslation(self, VTKEvent:str) -> str: ...
    @overload
    def GetTranslation(self, VTKEvent:int, modifier:int, keyCode:str, repeatCount:int, keySym:str) -> int: ...
    @overload
    def GetTranslation(self, VTKEvent:int, edata:'vtkEventData') -> int: ...
    @overload
    def GetTranslation(self, VTKEvent:'vtkEvent') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWidgetEventTranslator': ...
    @overload
    def RemoveTranslation(self, VTKEvent:int, modifier:int, keyCode:str, repeatCount:int, keySym:str) -> int: ...
    @overload
    def RemoveTranslation(self, e:'vtkEvent') -> int: ...
    @overload
    def RemoveTranslation(self, e:'vtkEventData') -> int: ...
    @overload
    def RemoveTranslation(self, VTKEvent:int) -> int: ...
    @overload
    def RemoveTranslation(self, VTKEvent:str) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWidgetEventTranslator': ...
    @overload
    def SetTranslation(self, VTKEvent:int, widgetEvent:int) -> None: ...
    @overload
    def SetTranslation(self, VTKEvent:str, widgetEvent:str) -> None: ...
    @overload
    def SetTranslation(self, VTKEvent:int, modifier:int, keyCode:str, repeatCount:int, keySym:str, widgetEvent:int) -> None: ...
    @overload
    def SetTranslation(self, VTKevent:'vtkEvent', widgetEvent:int) -> None: ...
    @overload
    def SetTranslation(self, VTKEvent:int, edata:'vtkEventData', widgetEvent:int) -> None: ...

class vtkWidgetSet(vtkmodules.vtkCommonCore.vtkObject):
    enabled:'getset_descriptor'
    number_of_widgets:'getset_descriptor'
    def AddWidget(self, __a:'vtkAbstractWidget') -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetNthWidget(self, __a:int) -> 'vtkAbstractWidget': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfWidgets(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWidgetSet': ...
    def RemoveWidget(self, __a:'vtkAbstractWidget') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWidgetSet': ...
    def SetEnabled(self, __a:int) -> None: ...

class vtkXYPlotWidget(vtkmodules.vtkRenderingCore.vtkInteractorObserver):
    enabled:'getset_descriptor'
    xy_plot_actor:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetXYPlotActor(self) -> 'vtkXYPlotActor': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkXYPlotWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXYPlotWidget': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetXYPlotActor(self, __a:'vtkXYPlotActor') -> None: ...

