# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Merchant Management API

    API for merchant management operations in DANA

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.merchant_management.v1.models.address_info import AddressInfo
from dana.merchant_management.v1.models.business_docs import BusinessDocs
from dana.merchant_management.v1.models.mobile_no_info import MobileNoInfo
from dana.merchant_management.v1.models.pic_info import PicInfo
from dana.merchant_management.v1.models.user_name import UserName
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class CreateShopRequest(BaseModel, BaseSdkModel):
    """
    CreateShopRequest
    """ # noqa: E501
    merchant_id: Annotated[str, Field(strict=True, max_length=21)] = Field(description="Merchant id")
    parent_division_id: Optional[StrictStr] = Field(default=None, description="Parent division ID. Required when shopParentType is DIVISION or EXTERNAL_DIVISION")
    shop_parent_type: StrictStr = Field(description="Parent type for the shop")
    main_name: Annotated[str, Field(strict=True, max_length=256)] = Field(description="Shop name")
    shop_address: Optional[AddressInfo] = Field(default=None)
    shop_desc: Optional[StrictStr] = Field(default=None, description="Shop description")
    external_shop_id: Annotated[str, Field(strict=True, max_length=64)] = Field(description="External shop identifier")
    logo_url_map: Optional[Dict[str, StrictStr]] = Field(default=None, description="Logo images encoded in base64. Keys can be LOGO, PC_LOGO, MOBILE_LOGO. Images must be PNG format.")
    mcc_codes: Optional[List[StrictStr]] = Field(default=None, description="MCC codes")
    size_type: StrictStr = Field(description="Size type of the shop")
    ln: Optional[StrictStr] = Field(default=None, description="Longitude")
    lat: Optional[StrictStr] = Field(default=None, description="Latitude")
    tax_no: Optional[Annotated[str, Field(strict=True)]] = Field(default=None, description="Tax number (NPWP). Must be 15 digits")
    brand_name: Optional[StrictStr] = Field(default=None, description="Legal name/tax name")
    tax_address: Optional[AddressInfo] = Field(default=None)
    loyalty: Optional[StrictStr] = Field(default=None, description="Flag for loyalty category")
    api_version: Optional[StrictStr] = Field(default=None, description="API version flag. Use > 2 for new attributes")
    business_entity: Optional[StrictStr] = Field(default=None, description="Business entity type. Required if apiVersion > 2")
    business_docs: Optional[List[BusinessDocs]] = Field(default=None, description="Business documents. Required if apiVersion > 2")
    owner_name: Optional[UserName] = Field(default=None)
    owner_id_type: Optional[StrictStr] = Field(default=None, description="Owner ID type. Required if apiVersion > 2")
    owner_id_no: Optional[StrictStr] = Field(default=None, description="Owner ID number. Required if apiVersion > 2")
    owner_address: Optional[AddressInfo] = Field(default=None)
    owner_phone_number: Optional[MobileNoInfo] = Field(default=None)
    shop_owning: Optional[StrictStr] = Field(default=None, description="Shop ownership type. Required if apiVersion > 2")
    device_number: Optional[StrictStr] = Field(default=None, description="Device number. Required if apiVersion > 2")
    pos_number: Optional[StrictStr] = Field(default=None, description="POS number. Required if apiVersion > 2")
    director_pics: Optional[List[PicInfo]] = Field(default=None, description="Director PICs. Required if apiVersion > 2")
    non_director_pics: Optional[List[PicInfo]] = Field(default=None, description="Non-director PICs. Required if apiVersion > 2")
    shop_biz_type: Optional[StrictStr] = Field(default=None, description="Shop business type")
    ext_info: Optional[Dict[str, Any]] = Field(default=None, description="Extended information")
    __properties: ClassVar[List[str]] = ["merchantId", "parentDivisionId", "shopParentType", "mainName", "shopAddress", "shopDesc", "externalShopId", "logoUrlMap", "mccCodes", "sizeType", "ln", "lat", "taxNo", "brandName", "taxAddress", "loyalty", "apiVersion", "businessEntity", "businessDocs", "ownerName", "ownerIdType", "ownerIdNo", "ownerAddress", "ownerPhoneNumber", "shopOwning", "deviceNumber", "posNumber", "directorPics", "nonDirectorPics", "shopBizType", "extInfo"]

    @field_validator('shop_parent_type')
    def shop_parent_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['MERCHANT', 'DIVISION', 'EXTERNAL_DIVISION']):
            raise ValueError("must be one of enum values ('MERCHANT', 'DIVISION', 'EXTERNAL_DIVISION')")
        return value

    @field_validator('size_type')
    def size_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['UMI', 'UKE', 'UME', 'UBE']):
            raise ValueError("must be one of enum values ('UMI', 'UKE', 'UME', 'UBE')")
        return value

    @field_validator('tax_no')
    def tax_no_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]{15}$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]{15}$/")
        return value

    @field_validator('loyalty')
    def loyalty_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['true', 'false']):
            raise ValueError("must be one of enum values ('true', 'false')")
        return value

    @field_validator('business_entity')
    def business_entity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['pt', 'cv', 'individu', 'usaha_dagang', 'yayasan', 'koperasi']):
            raise ValueError("must be one of enum values ('pt', 'cv', 'individu', 'usaha_dagang', 'yayasan', 'koperasi')")
        return value

    @field_validator('owner_id_type')
    def owner_id_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['KTP', 'SIM', 'PASSPORT', 'SIUP', 'NIB']):
            raise ValueError("must be one of enum values ('KTP', 'SIM', 'PASSPORT', 'SIUP', 'NIB')")
        return value

    @field_validator('shop_owning')
    def shop_owning_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['DIRECT_OWNED', 'FRANCHISED']):
            raise ValueError("must be one of enum values ('DIRECT_OWNED', 'FRANCHISED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateShopRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of shop_address
        if self.shop_address:
            _dict['shopAddress'] = self.shop_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tax_address
        if self.tax_address:
            _dict['taxAddress'] = self.tax_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in business_docs (list)
        _items = []
        if self.business_docs:
            for _item_business_docs in self.business_docs:
                if _item_business_docs:
                    _items.append(_item_business_docs.to_dict())
            _dict['businessDocs'] = _items
        # override the default output from pydantic by calling `to_dict()` of owner_name
        if self.owner_name:
            _dict['ownerName'] = self.owner_name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner_address
        if self.owner_address:
            _dict['ownerAddress'] = self.owner_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner_phone_number
        if self.owner_phone_number:
            _dict['ownerPhoneNumber'] = self.owner_phone_number.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in director_pics (list)
        _items = []
        if self.director_pics:
            for _item_director_pics in self.director_pics:
                if _item_director_pics:
                    _items.append(_item_director_pics.to_dict())
            _dict['directorPics'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in non_director_pics (list)
        _items = []
        if self.non_director_pics:
            for _item_non_director_pics in self.non_director_pics:
                if _item_non_director_pics:
                    _items.append(_item_non_director_pics.to_dict())
            _dict['nonDirectorPics'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateShopRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            # If it's a string (JSON), try to parse it
            if isinstance(obj, str):
                try:
                    obj = json.loads(obj)
                except json.JSONDecodeError:
                    return cls.model_validate(obj)
            else:
                return cls.model_validate(obj)

        
        # Handle OPEN_API nested response format: {"response": {"head": {...}, "body": {...}}}
        # Check if this is a response model and has nested structure
        if "CreateShopRequest".endswith("Response") and "response" in obj and "body" in obj["response"]:
            # For OPEN_API nested format, pass the nested response structure directly
            _obj = cls.model_validate({
                "merchantId": obj.get("merchantId"),
                "parentDivisionId": obj.get("parentDivisionId"),
                "shopParentType": obj.get("shopParentType"),
                "mainName": obj.get("mainName"),
                "shopAddress": AddressInfo.from_dict(obj["shopAddress"]) if obj.get("shopAddress") is not None else None,
                "shopDesc": obj.get("shopDesc"),
                "externalShopId": obj.get("externalShopId"),
                "logoUrlMap": obj.get("logoUrlMap"),
                "mccCodes": obj.get("mccCodes"),
                "sizeType": obj.get("sizeType"),
                "ln": obj.get("ln"),
                "lat": obj.get("lat"),
                "taxNo": obj.get("taxNo"),
                "brandName": obj.get("brandName"),
                "taxAddress": AddressInfo.from_dict(obj["taxAddress"]) if obj.get("taxAddress") is not None else None,
                "loyalty": obj.get("loyalty"),
                "apiVersion": obj.get("apiVersion"),
                "businessEntity": obj.get("businessEntity"),
                "businessDocs": [BusinessDocs.from_dict(_item) for _item in obj["businessDocs"]] if obj.get("businessDocs") is not None else None,
                "ownerName": UserName.from_dict(obj["ownerName"]) if obj.get("ownerName") is not None else None,
                "ownerIdType": obj.get("ownerIdType"),
                "ownerIdNo": obj.get("ownerIdNo"),
                "ownerAddress": AddressInfo.from_dict(obj["ownerAddress"]) if obj.get("ownerAddress") is not None else None,
                "ownerPhoneNumber": MobileNoInfo.from_dict(obj["ownerPhoneNumber"]) if obj.get("ownerPhoneNumber") is not None else None,
                "shopOwning": obj.get("shopOwning"),
                "deviceNumber": obj.get("deviceNumber"),
                "posNumber": obj.get("posNumber"),
                "directorPics": [PicInfo.from_dict(_item) for _item in obj["directorPics"]] if obj.get("directorPics") is not None else None,
                "nonDirectorPics": [PicInfo.from_dict(_item) for _item in obj["nonDirectorPics"]] if obj.get("nonDirectorPics") is not None else None,
                "shopBizType": obj.get("shopBizType"),
                "extInfo": obj.get("extInfo")
            })
        else:
            # For flat format, pass the object as-is
            _obj = cls.model_validate({
                "merchantId": obj.get("merchantId"),
                "parentDivisionId": obj.get("parentDivisionId"),
                "shopParentType": obj.get("shopParentType"),
                "mainName": obj.get("mainName"),
                "shopAddress": AddressInfo.from_dict(obj["shopAddress"]) if obj.get("shopAddress") is not None else None,
                "shopDesc": obj.get("shopDesc"),
                "externalShopId": obj.get("externalShopId"),
                "logoUrlMap": obj.get("logoUrlMap"),
                "mccCodes": obj.get("mccCodes"),
                "sizeType": obj.get("sizeType"),
                "ln": obj.get("ln"),
                "lat": obj.get("lat"),
                "taxNo": obj.get("taxNo"),
                "brandName": obj.get("brandName"),
                "taxAddress": AddressInfo.from_dict(obj["taxAddress"]) if obj.get("taxAddress") is not None else None,
                "loyalty": obj.get("loyalty"),
                "apiVersion": obj.get("apiVersion"),
                "businessEntity": obj.get("businessEntity"),
                "businessDocs": [BusinessDocs.from_dict(_item) for _item in obj["businessDocs"]] if obj.get("businessDocs") is not None else None,
                "ownerName": UserName.from_dict(obj["ownerName"]) if obj.get("ownerName") is not None else None,
                "ownerIdType": obj.get("ownerIdType"),
                "ownerIdNo": obj.get("ownerIdNo"),
                "ownerAddress": AddressInfo.from_dict(obj["ownerAddress"]) if obj.get("ownerAddress") is not None else None,
                "ownerPhoneNumber": MobileNoInfo.from_dict(obj["ownerPhoneNumber"]) if obj.get("ownerPhoneNumber") is not None else None,
                "shopOwning": obj.get("shopOwning"),
                "deviceNumber": obj.get("deviceNumber"),
                "posNumber": obj.get("posNumber"),
                "directorPics": [PicInfo.from_dict(_item) for _item in obj["directorPics"]] if obj.get("directorPics") is not None else None,
                "nonDirectorPics": [PicInfo.from_dict(_item) for _item in obj["nonDirectorPics"]] if obj.get("nonDirectorPics") is not None else None,
                "shopBizType": obj.get("shopBizType"),
                "extInfo": obj.get("extInfo")
            })
        
        return _obj


