# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Payment Gateway API

    API for doing operations in DANA Payment Gateway (Gapura)

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.payment_gateway.v1.models.actor_context import ActorContext
from dana.payment_gateway.v1.models.audit_info import AuditInfo
from dana.payment_gateway.v1.models.env_info import EnvInfo
from dana.payment_gateway.v1.models.refund_option_bill import RefundOptionBill
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class RefundOrderRequestAdditionalInfo(BaseModel, BaseSdkModel):
    """
    RefundOrderRequestAdditionalInfo
    """ # noqa: E501
    payout_account_no: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of payout account number. This param need to be filled if want to refund to specific payout account not that specified by DANA")
    refund_applied_time: Optional[Annotated[str, Field(strict=True, max_length=25)]] = Field(default=None, description="Additional information of refund applied time, in format YYYY-MM-DDTHH:mm:ss+07:00. Time must be in GMT+7 (Jakarta time)")
    actor_type: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of actor type. The enums:<br> * USER - User<br> * MERCHANT - Merchant<br> * MERCHANT_OPERATOR - Merchant operator<br> * BACK_OFFICE - Back office<br> * SYSTEM - System<br> ")
    return_charge_to_payer: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of return charge to payer")
    destination: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Additional information of destination")
    env_info: Optional[EnvInfo] = Field(default=None, description="Additional information of environment")
    audit_info: Optional[AuditInfo] = Field(default=None, description="Additional information of audit")
    actor_context: Optional[ActorContext] = Field(default=None, description="Additional information of actor context")
    refund_option_bill: Optional[List[RefundOptionBill]] = Field(default=None, description="Additional information of refund option bill")
    extend_info: Optional[Annotated[str, Field(strict=True, max_length=4096)]] = Field(default=None, description="Additional information of extend")
    async_refund: Optional[Annotated[str, Field(strict=True, max_length=5)]] = Field(default=None, description="Additional information of async refund to determine the process of refund whether sync or async. The values is true/false")
    __properties: ClassVar[List[str]] = ["payoutAccountNo", "refundAppliedTime", "actorType", "returnChargeToPayer", "destination", "envInfo", "auditInfo", "actorContext", "refundOptionBill", "extendInfo", "asyncRefund"]

    @field_validator('actor_type')
    def actor_type_validate_enum(cls, value):
        """Validates the enum"""
        if not value:
            return value

        if value not in set(['USER', 'MERCHANT', 'MERCHANT_OPERATOR', 'BACK_OFFICE', 'SYSTEM']):
            raise ValueError("must be one of enum values ('USER', 'MERCHANT', 'MERCHANT_OPERATOR', 'BACK_OFFICE', 'SYSTEM')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RefundOrderRequestAdditionalInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of env_info
        if self.env_info:
            _dict['envInfo'] = self.env_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of audit_info
        if self.audit_info:
            _dict['auditInfo'] = self.audit_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of actor_context
        if self.actor_context:
            _dict['actorContext'] = self.actor_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in refund_option_bill (list)
        _items = []
        if self.refund_option_bill:
            for _item_refund_option_bill in self.refund_option_bill:
                if _item_refund_option_bill:
                    _items.append(_item_refund_option_bill.to_dict())
            _dict['refundOptionBill'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RefundOrderRequestAdditionalInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "payoutAccountNo": obj.get("payoutAccountNo"),
            "refundAppliedTime": obj.get("refundAppliedTime"),
            "actorType": obj.get("actorType"),
            "returnChargeToPayer": obj.get("returnChargeToPayer"),
            "destination": obj.get("destination"),
            "envInfo": EnvInfo.from_dict(obj["envInfo"]) if obj.get("envInfo") is not None else None,
            "auditInfo": AuditInfo.from_dict(obj["auditInfo"]) if obj.get("auditInfo") is not None else None,
            "actorContext": ActorContext.from_dict(obj["actorContext"]) if obj.get("actorContext") is not None else None,
            "refundOptionBill": [RefundOptionBill.from_dict(_item) for _item in obj["refundOptionBill"]] if obj.get("refundOptionBill") is not None else None,
            "extendInfo": obj.get("extendInfo"),
            "asyncRefund": obj.get("asyncRefund")
        })
        return _obj


