import jpype 
from asposepdf import Assist 


class PdfFormat(Assist.BaseJavaClass):
    """!This class represents an pdf format."""

    java_class_name = "com.aspose.python.pdf.PdfFormat"
    java_class = jpype.JClass(java_class_name)

    PDF_A_1A = java_class.PDF_A_1A
    """!
     Pdf/A-1a format
    
    """

    PDF_A_1B = java_class.PDF_A_1B
    """!
     Pdf/A-1b format
    
    """

    PDF_A_2A = java_class.PDF_A_2A
    """!
     Pdf/A-2a format
    
    """

    PDF_A_3A = java_class.PDF_A_3A
    """!
     Pdf/A-3a format
    
    """

    PDF_A_2B = java_class.PDF_A_2B
    """!
     Pdf/A-2b
    
    """

    PDF_A_2U = java_class.PDF_A_2U
    """!
     Pdf/A-2u format
    
    """

    PDF_A_3B = java_class.PDF_A_3B
    """!
     Pdf/A-3b format
    
    """

    PDF_A_3U = java_class.PDF_A_3U
    """!
     Pdf/A-3u format
    
    """

    v_1_0 = java_class.v_1_0
    """!
     Adobe version 1.0
    
    """

    v_1_1 = java_class.v_1_1
    """!
     Adobe version 1.1
    
    """

    v_1_2 = java_class.v_1_2
    """!
     Adobe version 1.2
    
    """

    v_1_3 = java_class.v_1_3
    """!
     Adobe version 1.3
    
    """

    v_1_4 = java_class.v_1_4
    """!
     Adobe version 1.4
    
    """

    v_1_5 = java_class.v_1_5
    """!
     Adobe version 1.5
    
    """

    v_1_6 = java_class.v_1_6
    """!
     Adobe version 1.6
    
    """

    v_1_7 = java_class.v_1_7
    """!
     Adobe version 1.7
    
    """

    v_2_0 = java_class.v_2_0
    """!
     ISO Standard PDF 2.0
    
    """

    PDF_UA_1 = java_class.PDF_UA_1
    """!
     PDF/UA-1 format
    
    """

    PDF_X_1A_2001 = java_class.PDF_X_1A_2001
    """!
     PDF/X-1a-2001 format
    
    """

    PDF_X_1A = java_class.PDF_X_1A
    """!
     PDF/X-1a format
    
    """

    PDF_X_3 = java_class.PDF_X_3
    """!
     PDF/X-3 format
    
    """

    ZUGFeRD = java_class.ZUGFeRD
    """!
     ZUGFeRD format
    
    """

    PDF_A_4 = java_class.PDF_A_4
    """!
     PDF/A-4 format
    
    """

    PDF_A_4E = java_class.PDF_A_4E
    """!
     PDF/A-4e format
    
    """

    PDF_A_4F = java_class.PDF_A_4F
    """!
     PDF/A-4f format
    
    """

