# AUTOGENERATED! DO NOT EDIT! File to edit: ../01_toolloop.ipynb.

# %% auto 0
__all__ = []

# %% ../01_toolloop.ipynb
from .core import *
from fastcore.utils import *
from fastcore.meta import delegates

import google.generativeai as genai

# %% ../01_toolloop.ipynb
@patch
@delegates(genai.GenerativeModel.generate_content)
def toolloop(self:Chat,
             pr, # Prompt to pass to model
             max_steps=10, # Maximum number of tool requests to loop through
             trace_func:Optional[callable]=None, # Function to trace tool use steps (e.g `print`)
             cont_func:Optional[callable]=noop, # Function that stops loop if returns False
             **kwargs):
    "Add prompt `pr` to dialog and get a response from the model, automatically following up with `tool_use` messages"
    r = self(pr, **kwargs)
    for i in range(max_steps):
        pt = r.parts[0]
        if not pt.function_call: break
        if trace_func: trace_func(r)
        r = self(**kwargs)
        if not (cont_func or noop)(self.h[-2]): break
    if trace_func: trace_func(r)
    return r
