# %%
from tensorflow.keras.models import load_model
import pickle
from cut_sent_utils import inference_cut_sentence

model_loaded = load_model("cut_sentence.h5")
with open('stoi.pickle', 'rb') as f:
    stoi = pickle.load(f)
with open('stoi_pos.pickle', 'rb') as f:
    stoi_pos = pickle.load(f)

if __name__ == '__main__':
    test1 = "ในปลายปี 2529 กระทรวงวิทยาศาสตร์ เทคโนโลยีและการพลังงาน โดยมติคณะรัฐมนตรีได้จัดตั้งศูนย์เทคโนโลยีอิเล็กทรอนิกส์และคอมพิวเตอร์แห่งชาติขึ้น เพื่อพัฒนาเทคโนโลยีอิเล็กทรอนิกส์ในประเทศ และเทคโนโลยีด้านคอมพิวเตอร์ทั้งซอฟต์แวร์และฮาร์ดแวร์ โดยการสนับสนุนให้มีการวิจัยและพัฒนาในด้านนี้ จนถึงขั้นพัฒนาผลของการวิจัยและพัฒนาไปสู่การผลิตในเชิงอุตสาหกรรมและพาณิชย์ ตลอดจนสามารถแข่งขันได้ในตลาดภายในและต่างประเทศ"
    test2 = "จากรากฐานทางเทคโนโลยีเดิมที่มีอยู่ รวมกับเทคโนโลยีใหม่ ทั้งด้านฮาร์ดแวร์และซอฟต์แวร์ที่รุดหน้าไปทุกวัน คณะผู้วิจัยได้พัฒนาระบบภาษาไทยระดับแก่นเป็นรูปแบบ System Call ที่เป็นมาตรฐานร่วมบนเครื่องไมโครคอมพิวเตอร์ และพร้อมที่จะขยายไปติดตั้งบนเครื่องคอมพิวเตอร์ในระดับที่สูงขึ้นของเวอร์กสเตชั่น มินิและเมนเฟรมในอนาคตอันใกล้นี้"
    test3 = "ในการมองภาษาไทยที่ขยายออกมาเป็น 2 ไบต์นั้นมีทางออกได้หลายรูปแบบ เช่น อาจจะมองคำหนึ่งคำเป็น 2 ไบต์ เหมือนภาษาญี่ปุ่น (kanji) เช่น กิน ข้าว ในงานวิจัยนี้ เสนอแนวทางโครงสร้างรหัส 2 ไบต์ แบบ pictorial สำหรับใช้กับเทคโนโลยีทางตะวันออกในอนาคต ดังรูปที่ 1"
    test4 = "ทั้งนี้ หลังจากที่คณะกรรมการกิจการกระจายเสียง กิจการโทรทัศน์ และกิจการโทรคมนาคมแห่งชาติ หรือ กสทช. ได้จัดงานประมูลคลื่น 5 จี ขึ้นเมื่อวันที่ 16 ก.พ.2563 เอไอเอสได้คลื่นความถี่แบรนด์ 41 (TDD, 2600 MHz) รวม 100 MHz (10 ใบอนุญาต) และทรูมูฟเอช ได้รวม 90 MHz (9 ใบอนุญาต) Opensignal พบว่า ระหว่างวันที่ 1 เม.ย.-30 มิ.ย.2563 ทั้งเอไอเอสและทรูมูฟเอช ได้ใช้คลื่น 2600 MHz ที่ได้มาใหม่จำนวน 20-40 MHz สำหรับให้บริการ 4 จีในบางพื้นที่ ทำให้ผู้ใช้คลื่นความถี่ Band 41 ได้รับประสบการณ์ความเร็วในการดาวน์โหลด 4 จี ดีกว่าอย่างเห็นได้ชัดทั้งบนเครือข่ายของเอไอเอสและทรูมูฟเอช"
    test5 = """
        “เอไอเอสไฟเบอร์” ประคองตัวรอดโควิด-19 เดินหน้าอัพเกรด “เทคโนโลยี-คอนเทนต์-บริการ” เพิ่มดีกรีเขย่าสมรภูมิไฮสปีดเน็ต เร่งเก็บมาร์เก็ตแชร์ทั่วประเทศ มั่นใจกวาดลูกค้าใหม่ทั้งปี 3 แสนราย ผนึก “แอปเปิล” หั่นราคาสมาร์ททีวี 30% กระตุ้นตลาด เล็งดึง 5G เจาะตลาดคอนโดฯ

        นายศรัณย์ ผโลประการ หัวหน้าฝ่ายงานบริหารธุรกิจฟิกซ์ บรอดแบนด์ เอไอเอส เปิดเผยว่า การแข่งขันด้านราคาในธุรกิจอินเทอร์เน็ตบรอดแบนด์ปีนี้เทียบปีที่ผ่านมา “ดูดีขึ้น” มีการแข่งขันกันบนพื้นฐาน “ราคา” ที่สมเหตุสมผลขึ้น ขณะที่สถานการณ์โควิด-19 ส่งผลกระทบต่อภาพรวมตลาดพอสมควร ทั้งในแง่การทำตลาดที่ลำบากขึ้น และการลดค่าใช้จ่ายของผู้บริโภค แต่จากกระแส “เวิร์กฟรอมโฮม” ผลักดันให้ความต้องการในการใช้งานเพิ่มขึ้นมาก

        นายศรัณย์ เชื่อว่าฐานลูกค้าเอไอเอสไฟเบอร์ในปีนี้จะโตไม่น้อยไปกว่าปีที่ผ่านมาที่เพิ่มจาก 7 แสนราย เป็น 1 ล้านราย หรือเพิ่มขึ้น 3 แสนรายโดย ณ ไตรมาสแรก/2563 มีฐานลูกค้า 1.1 ล้านราย มีส่วนแบ่งตลาด 11% โตต่อเนื่อง แต่คงต้องบอกว่าโควิด-19 ส่งผลทั้งในแง่บวกและลบ แง่บวกคือลูกค้าต้องการติดบรอดแบนด์อินเทอร์เน็ตเพิ่ม แต่ในแง่ลบคนส่วนใหญ่หันมาประหยัดค่าใช้จ่าย แม้จะมีความต้องการจึงเลือกบริการที่ราคาไม่แพง
        """

    paragraph = test5
    print(inference_cut_sentence(paragraph, model_loaded, stoi, stoi_pos, max_context_length=5))



# %%
