from __future__ import annotations
import numpy as numpy
from rdkit.Chem import ChemicalFeatures
from rdkit import Geometry
import rdkit.RDLogger
__all__: list[str] = ['ChemicalFeatures', 'ExplicitPharmacophore', 'Geometry', 'Pharmacophore', 'logger', 'numpy']
class ExplicitPharmacophore:
    """
    this is a pharmacophore with explicit point locations and radii
      
    """
    def __init__(self, feats = None, radii = None):
        ...
    def __str__(self):
        ...
    def _initializeFeats(self, feats, radii):
        ...
    def getFeature(self, i):
        ...
    def getFeatures(self):
        ...
    def getRadii(self):
        ...
    def getRadius(self, i):
        ...
    def initFromFile(self, inF):
        ...
    def initFromLines(self, lines):
        ...
    def initFromString(self, text):
        ...
    def setRadius(self, i, rad):
        ...
class Pharmacophore:
    def __init__(self, feats, initMats = True):
        ...
    def __str__(self):
        ...
    def _checkBounds(self, i, j):
        """
        raises ValueError on failure 
        """
    def _initializeFeats(self, feats):
        ...
    def _initializeMatrices(self):
        ...
    def getFeature(self, i):
        ...
    def getFeatures(self):
        ...
    def getLowerBound(self, i, j):
        ...
    def getLowerBound2D(self, i, j):
        ...
    def getUpperBound(self, i, j):
        ...
    def getUpperBound2D(self, i, j):
        ...
    def setLowerBound(self, i, j, val, checkBounds = False):
        ...
    def setLowerBound2D(self, i, j, val, checkBounds = False):
        ...
    def setUpperBound(self, i, j, val, checkBounds = False):
        ...
    def setUpperBound2D(self, i, j, val, checkBounds = False):
        ...
logger: rdkit.RDLogger.logger  # value = <rdkit.RDLogger.logger object>
