/// Build script using 'built' crate to generate build info.

fn main() {
    #[cfg(feature = "build_info")]
    {
        println!("cargo:rerun-if-changed=build.rs");
        extern crate built;
        use std::env;
        use std::path::Path;

        // We must specify the workspace root as the source
        let py_polars_dir = env::var("CARGO_MANIFEST_DIR").unwrap();
        let src = Path::new(&py_polars_dir).parent().unwrap();

        let out_dir = &env::var("OUT_DIR").unwrap();
        let dst = Path::new(&out_dir).join("built.rs");

        let mut opts = built::Options::default();
        opts.set_dependencies(true).set_compiler(true).set_env(true);

        built::write_built_file_with_opts(&opts, src, &dst)
            .expect("Failed to acquire build-time information");
    }
}
