"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeploymentTierStage = exports.ContextLoadingStage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const context_1 = require("./context");
const tier_1 = require("./tier");
/**
 * A Stage that can load context values from a JSON file.
 */
class ContextLoadingStage extends aws_cdk_lib_1.Stage {
    /**
     * Creates a new ContextLoadingStage.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id, { ...props });
        if (props.contextFile) {
            context_1.ContextLoader.loadContext(props.contextFile, this.node);
        }
    }
}
exports.ContextLoadingStage = ContextLoadingStage;
_a = JSII_RTTI_SYMBOL_1;
ContextLoadingStage[_a] = { fqn: "shady-island.ContextLoadingStage", version: "0.1.4" };
/**
 * A Stage whose stacks are part of a single deployment tier.
 */
class DeploymentTierStage extends ContextLoadingStage {
    /**
     * Creates a new DeploymentTierStage.
     *
     * @param scope - The scope in which to define this construct.
     * @param id - The scoped construct ID.
     * @param props - Initialization properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            stageName: props.stageName || props.tier.label,
        });
        const { tier, addTag = true } = props;
        this.tier = tier;
        tier.assignTo(this);
        if (addTag) {
            aws_cdk_lib_1.Aspects.of(this).add(new tier_1.TierTagger(tier));
        }
    }
    /**
     * Whether this stage is considered a production deployment.
     */
    get inProduction() {
        return tier_1.Tier.PRODUCTION.matches(this.tier);
    }
}
exports.DeploymentTierStage = DeploymentTierStage;
_b = JSII_RTTI_SYMBOL_1;
DeploymentTierStage[_b] = { fqn: "shady-island.DeploymentTierStage", version: "0.1.4" };
//# sourceMappingURL=data:application/json;base64,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