"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const yaml = require("yaml");
const component_builder_1 = require("./component_builder");
const component_synchronizer_1 = require("./component_synchronizer");
const index_1 = require("./index");
const utils = require("./utils");
/**
 * @stability stable
 */
class PipelineBuilder {
    /**
     * @stability stable
     */
    constructor(config) {
        /**
         * @stability stable
         */
        this.cacheDir = 'component_cache';
        this.config = config;
    }
    /**
     * @stability stable
     */
    async create(stack, pipelineConfigDir) {
        // Get all YAMLs from the pipelineConfigDir
        const pipelineConfigs = fs.readdirSync(pipelineConfigDir)
            .filter(c => c.endsWith('.yaml'))
            .map(f => ({
            name: utils.pascalize(f.substring(0, f.lastIndexOf('.'))),
            fileContent: fs.readFileSync(path.join(pipelineConfigDir, f), 'utf-8'),
        }));
        let pipelineYamls = pipelineConfigs.map(c => ({
            name: c.name,
            ...yaml.parse(c.fileContent),
        }));
        // Get all component dependencies
        const allComponentDeps = pipelineYamls
            .filter(y => y.component_dependencies && y.component_dependencies.length > 0)
            .map(y => y.component_dependencies.map((d) => ({ platform: y.parent_image, ...d })))
            .reduce((acc, val) => acc.concat(val), []);
        // Get all git component dependencies
        const allGitComponentDeps = allComponentDeps
            .filter((c) => c.type == 'git');
        const synchronizer = new component_synchronizer_1.ComponentSynchronizer();
        await synchronizer.synchronize(allGitComponentDeps);
        let componentBuilder = new component_builder_1.ComponentBuilder(stack, allComponentDeps);
        let pipelines = pipelineYamls
            .filter(c => c.pipeline && c.component_dependencies)
            .map(c => new index_1.AmiPipelineLib(stack, c.name, c.pipeline, c.component_dependencies, componentBuilder, {
            channel: this.config.SLACK_CHANNEL,
            slackWebhookUrl: this.config.SLACK_WEBHOOK_URL,
            username: this.config.SLACK_USERNAME,
        }));
        return pipelines;
    }
}
exports.PipelineBuilder = PipelineBuilder;
_a = JSII_RTTI_SYMBOL_1;
PipelineBuilder[_a] = { fqn: "halloumi-ami-pipelines.PipelineBuilder", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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