"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFile = exports.readFileAsync = exports.readdirAsync = exports.pascalize = void 0;
const fs = require("fs");
function pascalize(input) {
    return input.replace(/([a-zA-Z])([a-zA-Z]*)/g, function (_g0, g1, g2) { return g1.toUpperCase() + g2.toLowerCase(); })
        .replace(/[^a-zA-Z0-9]/g, '');
}
exports.pascalize = pascalize;
function readdirAsync(dirname) {
    return new Promise(function (resolve, reject) {
        fs.readdir(dirname, function (err, filenames) {
            if (err) {
                reject(err);
            }
            else {
                resolve(filenames);
            }
        });
    });
}
exports.readdirAsync = readdirAsync;
;
// make Promise version of fs.readFile()
function readFileAsync(filename, enc) {
    return new Promise(function (resolve, reject) {
        fs.readFile(filename, enc, function (err, data) {
            if (err) {
                reject(err);
            }
            else {
                resolve(data);
            }
        });
    });
}
exports.readFileAsync = readFileAsync;
;
// utility function, return Promise
async function getFile(filename) {
    return readFileAsync(filename, 'utf8');
}
exports.getFile = getFile;
//# sourceMappingURL=data:application/json;base64,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