import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
 *
 * @experimental
 */
export declare class Amplifybackend extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to clone an existing Amplify Admin backend environment into a new Amplify Admin backend enviroment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-clone.html#CloneBackend
     *
     * @experimental
     */
    toCloneBackend(): this;
    /**
     * (experimental) Grants permission to create a new Amplify Admin backend environment by Amplify appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html#CreateBackend
     *
     * @experimental
     */
    toCreateBackend(): this;
    /**
     * (experimental) Grants permission to create an API for an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html#CreateBackendAPI
     *
     * @experimental
     */
    toCreateBackendAPI(): this;
    /**
     * (experimental) Grants permission to create an auth resource for an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html#CreateBackendAuth
     *
     * @experimental
     */
    toCreateBackendAuth(): this;
    /**
     * (experimental) Grants permission to create a new Amplify Admin backend config by Amplify appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html#CreateBackendConfig
     *
     * @experimental
     */
    toCreateBackendConfig(): this;
    /**
     * (experimental) Grants permission to create an Amplify Admin challenge token by appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge.html#CreateToken
     *
     * @experimental
     */
    toCreateToken(): this;
    /**
     * (experimental) Grants permission to delete an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-environments-backendenvironmentname-remove.html#DeleteBackend
     *
     * @experimental
     */
    toDeleteBackend(): this;
    /**
     * (experimental) Grants permission to delete an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-remove.html#DeleteBackendAPI
     *
     * @experimental
     */
    toDeleteBackendAPI(): this;
    /**
     * (experimental) Grants permission to delete an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-remove.html#DeleteBackendAuth
     *
     * @experimental
     */
    toDeleteBackendAuth(): this;
    /**
     * (experimental) Grants permission to delete an Amplify Admin challenge token by appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid-remove.html#DeleteToken
     *
     * @experimental
     */
    toDeleteToken(): this;
    /**
     * (experimental) Grants permission to generate models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-generatemodels.html#GenerateBackendAPIModels
     *
     * @experimental
     */
    toGenerateBackendAPIModels(): this;
    /**
     * (experimental) Grants permission to retrieve an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-details.html#GetBackend
     *
     * @experimental
     */
    toGetBackend(): this;
    /**
     * (experimental) Grants permission to retrieve an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html#GetBackendAPI
     *
     * @experimental
     */
    toGetBackendAPI(): this;
    /**
     * (experimental) Grants permission to retrieve models for an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-getmodels.html#GetBackendAPIModels
     *
     * @experimental
     */
    toGetBackendAPIModels(): this;
    /**
     * (experimental) Grants permission to retrieve an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname-details.html#GetBackendAuth
     *
     * @experimental
     */
    toGetBackendAuth(): this;
    /**
     * (experimental) Grants permission to retrieve a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#GetBackendJob
     *
     * @experimental
     */
    toGetBackendJob(): this;
    /**
     * (experimental) Grants permission to retrieve an Amplify Admin challenge token by appId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-challenge-sessionid.html#GetToken
     *
     * @experimental
     */
    toGetToken(): this;
    /**
     * (experimental) Grants permission to import an existing auth resource of an Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#ImportBackendAuth
     *
     * @experimental
     */
    toImportBackendAuth(): this;
    /**
     * (experimental) Grants permission to retrieve the jobs of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html#ListBackendJobs
     *
     * @experimental
     */
    toListBackendJobs(): this;
    /**
     * (experimental) Grants permission to delete all existing Amplify Admin backend environments by appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-remove.html#RemoveAllBackends
     *
     * @experimental
     */
    toRemoveAllBackends(): this;
    /**
     * (experimental) Grants permission to delete an Amplify Admin backend config by Amplify appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-remove.html#RemoveBackendConfig
     *
     * @experimental
     */
    toRemoveBackendConfig(): this;
    /**
     * (experimental) Grants permission to update an API of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname.html#UpdateBackendAPI
     *
     * @experimental
     */
    toUpdateBackendAPI(): this;
    /**
     * (experimental) Grants permission to update an auth resource of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth-backendenvironmentname.html#UpdateBackendAuth
     *
     * @experimental
     */
    toUpdateBackendAuth(): this;
    /**
     * (experimental) Grants permission to update an Amplify Admin backend config by Amplify appId.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config-update.html#UpdateBackendConfig
     *
     * @experimental
     */
    toUpdateBackendConfig(): this;
    /**
     * (experimental) Grants permission to update a job of an existing Amplify Admin backend environment by appId and backendEnvironmentName.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname-jobid.html#UpdateBackendJob
     *
     * @experimental
     */
    toUpdateBackendJob(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type backend to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onBackend(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type environment to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api-backendenvironmentname-details.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onEnvironment(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type api to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-api.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onApi(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type auth to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-auth.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAuth(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type job to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-job-backendenvironmentname.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onJob(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type config to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-config.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onConfig(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type token to the statement.
     *
     * https://docs.aws.amazon.com/amplify-admin-ui/latest/APIReference/backend-appid-token.html
     *
     * @param appId - Identifier for the appId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onToken(appId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [amplifybackend](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsamplifyadmin.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
