import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [devicefarm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdevicefarm.html).
 *
 * @experimental
 */
export declare class Devicefarm extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create a device pool within a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateDevicePool.html
     *
     * @experimental
     */
    toCreateDevicePool(): this;
    /**
     * (experimental) Grants permission to create a device instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateInstanceProfile.html
     *
     * @experimental
     */
    toCreateInstanceProfile(): this;
    /**
     * (experimental) Grants permission to create a network profile within a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateNetworkProfile.html
     *
     * @experimental
     */
    toCreateNetworkProfile(): this;
    /**
     * (experimental) Grants permission to create a project for mobile testing.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateProject.html
     *
     * @experimental
     */
    toCreateProject(): this;
    /**
     * (experimental) Grants permission to start a remote access session to a device instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateRemoteAccessSession.html
     *
     * @experimental
     */
    toCreateRemoteAccessSession(): this;
    /**
     * (experimental) Grants permission to create a project for desktop testing.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateTestGridProject.html
     *
     * @experimental
     */
    toCreateTestGridProject(): this;
    /**
     * (experimental) Grants permission to generate a new pre-signed url used to access our test grid service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateTestGridUrl.html
     *
     * @experimental
     */
    toCreateTestGridUrl(): this;
    /**
     * (experimental) Grants permission to upload a new file or app within a project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html
     *
     * @experimental
     */
    toCreateUpload(): this;
    /**
     * (experimental) Grants permission to create an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateVPCEConfiguration.html
     *
     * @experimental
     */
    toCreateVPCEConfiguration(): this;
    /**
     * (experimental) Grants permission to delete a user-generated device pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteDevicePool.html
     *
     * @experimental
     */
    toDeleteDevicePool(): this;
    /**
     * (experimental) Grants permission to delete a user-generated instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteInstanceProfile.html
     *
     * @experimental
     */
    toDeleteInstanceProfile(): this;
    /**
     * (experimental) Grants permission to delete a user-generated network profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/DeleteNetworkProfile.html
     *
     * @experimental
     */
    toDeleteNetworkProfile(): this;
    /**
     * (experimental) Grants permission to delete a mobile testing project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteProject.html
     *
     * @experimental
     */
    toDeleteProject(): this;
    /**
     * (experimental) Grants permission to delete a completed remote access session and its results.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteRemoteAccessSession.html
     *
     * @experimental
     */
    toDeleteRemoteAccessSession(): this;
    /**
     * (experimental) Grants permission to delete a run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteRun.html
     *
     * @experimental
     */
    toDeleteRun(): this;
    /**
     * (experimental) Grants permission to delete a desktop testing project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteTestGridProject.html
     *
     * @experimental
     */
    toDeleteTestGridProject(): this;
    /**
     * (experimental) Grants permission to delete a user-uploaded file.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteUpload.html
     *
     * @experimental
     */
    toDeleteUpload(): this;
    /**
     * (experimental) Grants permission to delete an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeleteVPCEConfiguration.html
     *
     * @experimental
     */
    toDeleteVPCEConfiguration(): this;
    /**
     * (experimental) Grants permission to retrieve the number of unmetered iOS and/or unmetered Android devices purchased by the account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetAccountSettings.html
     *
     * @experimental
     */
    toGetAccountSettings(): this;
    /**
     * (experimental) Grants permission to retrieve the information of a unique device type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevice.html
     *
     * @experimental
     */
    toGetDevice(): this;
    /**
     * (experimental) Grants permission to retireve the information of a device instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDeviceInstance.html
     *
     * @experimental
     */
    toGetDeviceInstance(): this;
    /**
     * (experimental) Grants permission to retireve the information of a device pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevicePool.html
     *
     * @experimental
     */
    toGetDevicePool(): this;
    /**
     * (experimental) Grants permission to retrieve information about the compatibility of a test and/or app with a device pool.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetDevicePoolCompatibility.html
     *
     * @experimental
     */
    toGetDevicePoolCompatibility(): this;
    /**
     * (experimental) Grants permission to retireve the information of an instance profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetInstanceProfile.html
     *
     * @experimental
     */
    toGetInstanceProfile(): this;
    /**
     * (experimental) Grants permission to retireve the information of a job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetJob.html
     *
     * @experimental
     */
    toGetJob(): this;
    /**
     * (experimental) Grants permission to retireve the information of a network profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetNetworkProfile.html
     *
     * @experimental
     */
    toGetNetworkProfile(): this;
    /**
     * (experimental) Grants permission to retrieve the current status and future status of all offerings purchased by an AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetOfferingStatus.html
     *
     * @experimental
     */
    toGetOfferingStatus(): this;
    /**
     * (experimental) Grants permission to retrieve information about a mobile testing project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetProject.html
     *
     * @experimental
     */
    toGetProject(): this;
    /**
     * (experimental) Grants permission to retireve the link to a currently running remote access session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetRemoteAccessSession.html
     *
     * @experimental
     */
    toGetRemoteAccessSession(): this;
    /**
     * (experimental) Grants permission to retireve the information of a run.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetRun.html
     *
     * @experimental
     */
    toGetRun(): this;
    /**
     * (experimental) Grants permission to retireve the information of a testing suite.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetSuite.html
     *
     * @experimental
     */
    toGetSuite(): this;
    /**
     * (experimental) Grants permission to retireve the information of a test case.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTest.html
     *
     * @experimental
     */
    toGetTest(): this;
    /**
     * (experimental) Grants permission to retrieve information about a desktop testing project.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTestGridProject.html
     *
     * @experimental
     */
    toGetTestGridProject(): this;
    /**
     * (experimental) Grants permission to retireve the information of a test grid session.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetTestGridSession.html
     *
     * @experimental
     */
    toGetTestGridSession(): this;
    /**
     * (experimental) Grants permission to retireve the information of an uploaded file.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetUpload.html
     *
     * @experimental
     */
    toGetUpload(): this;
    /**
     * (experimental) Grants permission to retireve the information of an Amazon Virtual Private Cloud (VPC) endpoint configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_GetVPCEConfiguration.html
     *
     * @experimental
     */
    toGetVPCEConfiguration(): this;
    /**
     * (experimental) Grants permission to install an application to a device in a remote access session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_InstallToRemoteAccessSession.html
     *
     * @experimental
     */
    toInstallToRemoteAccessSession(): this;
    /**
     * (experimental) Grants permission to list the artifacts in a project.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListArtifacts.html
     *
     * @experimental
     */
    toListArtifacts(): this;
    /**
     * (experimental) Grants permission to list the information of device instances.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDeviceInstances.html
     *
     * @experimental
     */
    toListDeviceInstances(): this;
    /**
     * (experimental) Grants permission to list the information of device pools.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDevicePools.html
     *
     * @experimental
     */
    toListDevicePools(): this;
    /**
     * (experimental) Grants permission to list the information of unique device types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListDevices.html
     *
     * @experimental
     */
    toListDevices(): this;
    /**
     * (experimental) Grants permission to list the information of device instance profiles.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListInstanceProfiles.html
     *
     * @experimental
     */
    toListInstanceProfiles(): this;
    /**
     * (experimental) Grants permission to list the information of jobs within a run.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListJobs.html
     *
     * @experimental
     */
    toListJobs(): this;
    /**
     * (experimental) Grants permission to list the information of network profiles within a project.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListNetworkProfiles.html
     *
     * @experimental
     */
    toListNetworkProfiles(): this;
    /**
     * (experimental) Grants permission to list the offering promotions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferingPromotions.html
     *
     * @experimental
     */
    toListOfferingPromotions(): this;
    /**
     * (experimental) Grants permission to list all of the historical purchases, renewals, and system renewal transactions for an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferingTransactions.html
     *
     * @experimental
     */
    toListOfferingTransactions(): this;
    /**
     * (experimental) Grants permission to list the products or offerings that the user can manage through the API.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListOfferings.html
     *
     * @experimental
     */
    toListOfferings(): this;
    /**
     * (experimental) Grants permission to list the information of mobile testing projects for an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListProjects.html
     *
     * @experimental
     */
    toListProjects(): this;
    /**
     * (experimental) Grants permission to list the information of currently running remote access sessions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListRemoteAccessSessions.html
     *
     * @experimental
     */
    toListRemoteAccessSessions(): this;
    /**
     * (experimental) Grants permission to list the information of runs within a project.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListRuns.html
     *
     * @experimental
     */
    toListRuns(): this;
    /**
     * (experimental) Grants permission to list the information of samples within a project.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListSamples.html
     *
     * @experimental
     */
    toListSamples(): this;
    /**
     * (experimental) Grants permission to list the information of testing suites within a job.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListSuites.html
     *
     * @experimental
     */
    toListSuites(): this;
    /**
     * (experimental) Grants permission to list the tags of a resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list the information of desktop testing projects for an AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridProjects.html
     *
     * @experimental
     */
    toListTestGridProjects(): this;
    /**
     * (experimental) Grants permission to list the session actions performed during a test grid session.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessionActions.html
     *
     * @experimental
     */
    toListTestGridSessionActions(): this;
    /**
     * (experimental) Grants permission to list the artifacts generated by a test grid session.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessionArtifacts.html
     *
     * @experimental
     */
    toListTestGridSessionArtifacts(): this;
    /**
     * (experimental) Grants permission to list the sessions within a test grid project.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTestGridSessions.html
     *
     * @experimental
     */
    toListTestGridSessions(): this;
    /**
     * (experimental) Grants permission to list the information of tests within a testing suite.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListTests.html
     *
     * @experimental
     */
    toListTests(): this;
    /**
     * (experimental) Grants permission to list the information of unique problems within a run.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListUniqueProblems.html
     *
     * @experimental
     */
    toListUniqueProblems(): this;
    /**
     * (experimental) Grants permission to list the information of uploads within a project.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListUploads.html
     *
     * @experimental
     */
    toListUploads(): this;
    /**
     * (experimental) Grants permission to list the information of Amazon Virtual Private Cloud (VPC) endpoint configurations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ListVPCEConfigurations.html
     *
     * @experimental
     */
    toListVPCEConfigurations(): this;
    /**
     * (experimental) Grants permission to purchase offerings for an AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_PurchaseOffering.html
     *
     * @experimental
     */
    toPurchaseOffering(): this;
    /**
     * (experimental) Grants permission to set the quantity of devices to renew for an offering.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_RenewOffering.html
     *
     * @experimental
     */
    toRenewOffering(): this;
    /**
     * (experimental) Grants permission to schedule a run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_ScheduleRun.html
     *
     * @experimental
     */
    toScheduleRun(): this;
    /**
     * (experimental) Grants permission to terminate a running job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopJob.html
     *
     * @experimental
     */
    toStopJob(): this;
    /**
     * (experimental) Grants permission to terminate a running remote access session.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopRemoteAccessSession.html
     *
     * @experimental
     */
    toStopRemoteAccessSession(): this;
    /**
     * (experimental) Grants permission to terminate a running test run.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_StopRun.html
     *
     * @experimental
     */
    toStopRun(): this;
    /**
     * (experimental) Grants permission to add tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to modify an existing device instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateDeviceInstance.html
     *
     * @experimental
     */
    toUpdateDeviceInstance(): this;
    /**
     * (experimental) Grants permission to modify an existing device pool.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateDevicePool.html
     *
     * @experimental
     */
    toUpdateDevicePool(): this;
    /**
     * (experimental) Grants permission to modify an existing instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateInstanceProfile.html
     *
     * @experimental
     */
    toUpdateInstanceProfile(): this;
    /**
     * (experimental) Grants permission to modify an existing network profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateNetworkProfile.html
     *
     * @experimental
     */
    toUpdateNetworkProfile(): this;
    /**
     * (experimental) Grants permission to modify an existing mobile testing project.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateProject.html
     *
     * @experimental
     */
    toUpdateProject(): this;
    /**
     * (experimental) Grants permission to modify an existing desktop testing project.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:CreateNetworkInterface
     * - ec2:DescribeSecurityGroups
     * - ec2:DescribeSubnets
     * - ec2:DescribeVpcs
     * - iam:CreateServiceLinkedRole
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateTestGridProject.html
     *
     * @experimental
     */
    toUpdateTestGridProject(): this;
    /**
     * (experimental) Grants permission to modify an existing upload.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateUpload.html
     *
     * @experimental
     */
    toUpdateUpload(): this;
    /**
     * (experimental) Grants permission to modify an existing Amazon Virtual Private Cloud (VPC) endpoint configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_UpdateVPCEConfiguration.html
     *
     * @experimental
     */
    toUpdateVPCEConfiguration(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type project to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Project.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onProject(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type run to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Run.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRun(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type job to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Job.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type suite to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Suite.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSuite(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type test to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Test.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTest(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type upload to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Upload.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onUpload(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type artifact to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Artifact.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onArtifact(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type sample to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Sample.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSample(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type networkprofile to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_NetworkProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onNetworkprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deviceinstance to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DeviceInstance.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeviceinstance(resourceId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type session to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_RemoteAccessSession.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onSession(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type devicepool to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_DevicePool.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDevicepool(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type device to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_Device.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDevice(resourceId: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type instanceprofile to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_InstanceProfile.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onInstanceprofile(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpceconfiguration to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_VPCEConfiguration.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVpceconfiguration(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type testgrid-project to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TestGridProject.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTestgridProject(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type testgrid-session to the statement.
     *
     * https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_TestGridSession.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTestgridSession(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [devicefarm](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdevicefarm.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
