import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [config](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconfig.html).
 *
 * @experimental
 */
export declare class Config extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to return the current configuration items for resources that are present in your AWS Config aggregator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_BatchGetAggregateResourceConfig.html
     *
     * @experimental
     */
    toBatchGetAggregateResourceConfig(): this;
    /**
     * (experimental) Grants permission to return the current configuration for one or more requested resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_BatchGetResourceConfig.html
     *
     * @experimental
     */
    toBatchGetResourceConfig(): this;
    /**
     * (experimental) Grants permission to delete the authorization granted to the specified configuration aggregator account in a specified region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteAggregationAuthorization.html
     *
     * @experimental
     */
    toDeleteAggregationAuthorization(): this;
    /**
     * (experimental) Grants permission to delete the specified AWS Config rule and all of its evaluation results.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigRule.html
     *
     * @experimental
     */
    toDeleteConfigRule(): this;
    /**
     * (experimental) Grants permission to delete the specified configuration aggregator and the aggregated data associated with the aggregator.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationAggregator.html
     *
     * @experimental
     */
    toDeleteConfigurationAggregator(): this;
    /**
     * (experimental) Grants permission to delete the configuration recorder.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html
     *
     * @experimental
     */
    toDeleteConfigurationRecorder(): this;
    /**
     * (experimental) Grants permission to delete the specified conformance pack and all the AWS Config rules and all evaluation results within that conformance pack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConformancePack.html
     *
     * @experimental
     */
    toDeleteConformancePack(): this;
    /**
     * (experimental) Grants permission to delete the delivery channel.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html
     *
     * @experimental
     */
    toDeleteDeliveryChannel(): this;
    /**
     * (experimental) Grants permission to delete the evaluation results for the specified Config rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteEvaluationResults.html
     *
     * @experimental
     */
    toDeleteEvaluationResults(): this;
    /**
     * (experimental) Grants permission to delete the specified organization config rule and all of its evaluation results from all member accounts in that organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteOrganizationConfigRule.html
     *
     * @experimental
     */
    toDeleteOrganizationConfigRule(): this;
    /**
     * (experimental) Grants permission to delete the specified organization conformance pack and all of its evaluation results from all member accounts in that organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteOrganizationConformancePack.html
     *
     * @experimental
     */
    toDeleteOrganizationConformancePack(): this;
    /**
     * (experimental) Grants permission to delete pending authorization requests for a specified aggregator account in a specified region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeletePendingAggregationRequest.html
     *
     * @experimental
     */
    toDeletePendingAggregationRequest(): this;
    /**
     * (experimental) Grants permission to delete the remediation configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRemediationConfiguration.html
     *
     * @experimental
     */
    toDeleteRemediationConfiguration(): this;
    /**
     * (experimental) Grants permission to delete one or more remediation exceptions for specific resource keys for a specific AWS Config Rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRemediationExceptions.html
     *
     * @experimental
     */
    toDeleteRemediationExceptions(): this;
    /**
     * (experimental) Grants permission to record the configuration state for a custom resource that has been deleted.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteResourceConfig.html
     *
     * @experimental
     */
    toDeleteResourceConfig(): this;
    /**
     * (experimental) Grants permission to delete the retention configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteRetentionConfiguration.html
     *
     * @experimental
     */
    toDeleteRetentionConfiguration(): this;
    /**
     * (experimental) Grants permission to delete the stored query for an AWS account in an AWS Region.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteStoredQuery.html
     *
     * @experimental
     */
    toDeleteStoredQuery(): this;
    /**
     * (experimental) Grants permission to schedule delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DeliverConfigSnapshot.html
     *
     * @experimental
     */
    toDeliverConfigSnapshot(): this;
    /**
     * (experimental) Grants permission to return a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregateComplianceByConfigRules.html
     *
     * @experimental
     */
    toDescribeAggregateComplianceByConfigRules(): this;
    /**
     * (experimental) Grants permission to return a list of compliant and noncompliant conformance packs along with count of compliant, non-compliant and total rules within each conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregateComplianceByConformancePacks.html
     *
     * @experimental
     */
    toDescribeAggregateComplianceByConformancePacks(): this;
    /**
     * (experimental) Grants permission to return a list of authorizations granted to various aggregator accounts and regions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeAggregationAuthorizations.html
     *
     * @experimental
     */
    toDescribeAggregationAuthorizations(): this;
    /**
     * (experimental) Grants permission to indicate whether the specified AWS Config rules are compliant.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeComplianceByConfigRule.html
     *
     * @experimental
     */
    toDescribeComplianceByConfigRule(): this;
    /**
     * (experimental) Grants permission to indicate whether the specified AWS resources are compliant.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeComplianceByResource.html
     *
     * @experimental
     */
    toDescribeComplianceByResource(): this;
    /**
     * (experimental) Grants permission to return status information for each of your AWS managed Config rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigRuleEvaluationStatus.html
     *
     * @experimental
     */
    toDescribeConfigRuleEvaluationStatus(): this;
    /**
     * (experimental) Grants permission to return details about your AWS Config rules.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigRules.html
     *
     * @experimental
     */
    toDescribeConfigRules(): this;
    /**
     * (experimental) Grants permission to return status information for sources within an aggregator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationAggregatorSourcesStatus.html
     *
     * @experimental
     */
    toDescribeConfigurationAggregatorSourcesStatus(): this;
    /**
     * (experimental) Grants permission to return the details of one or more configuration aggregators.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationAggregators.html
     *
     * @experimental
     */
    toDescribeConfigurationAggregators(): this;
    /**
     * (experimental) Grants permission to return the current status of the specified configuration recorder.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html
     *
     * @experimental
     */
    toDescribeConfigurationRecorderStatus(): this;
    /**
     * (experimental) Grants permission to return the names of one or more specified configuration recorders.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html
     *
     * @experimental
     */
    toDescribeConfigurationRecorders(): this;
    /**
     * (experimental) Grants permission to return compliance information for each rule in that conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePackCompliance.html
     *
     * @experimental
     */
    toDescribeConformancePackCompliance(): this;
    /**
     * (experimental) Grants permission to provide one or more conformance packs deployment status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePackStatus.html
     *
     * @experimental
     */
    toDescribeConformancePackStatus(): this;
    /**
     * (experimental) Grants permission to return a list of one or more conformance packs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConformancePacks.html
     *
     * @experimental
     */
    toDescribeConformancePacks(): this;
    /**
     * (experimental) Grants permission to return the current status of the specified delivery channel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeDeliveryChannelStatus.html
     *
     * @experimental
     */
    toDescribeDeliveryChannelStatus(): this;
    /**
     * (experimental) Grants permission to return details about the specified delivery channel.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeDeliveryChannels.html
     *
     * @experimental
     */
    toDescribeDeliveryChannels(): this;
    /**
     * (experimental) Grants permission to provide organization config rule deployment status for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConfigRuleStatuses.html
     *
     * @experimental
     */
    toDescribeOrganizationConfigRuleStatuses(): this;
    /**
     * (experimental) Grants permission to return a list of organization config rules.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConfigRules.html
     *
     * @experimental
     */
    toDescribeOrganizationConfigRules(): this;
    /**
     * (experimental) Grants permission to provide organization conformance pack deployment status for an organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConformancePackStatuses.html
     *
     * @experimental
     */
    toDescribeOrganizationConformancePackStatuses(): this;
    /**
     * (experimental) Grants permission to return a list of organization conformance packs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeOrganizationConformancePacks.html
     *
     * @experimental
     */
    toDescribeOrganizationConformancePacks(): this;
    /**
     * (experimental) Grants permission to return a list of all pending aggregation requests.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribePendingAggregationRequests.html
     *
     * @experimental
     */
    toDescribePendingAggregationRequests(): this;
    /**
     * (experimental) Grants permission to return the details of one or more remediation configurations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationConfigurations.html
     *
     * @experimental
     */
    toDescribeRemediationConfigurations(): this;
    /**
     * (experimental) Grants permission to return the details of one or more remediation exceptions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationExceptions.html
     *
     * @experimental
     */
    toDescribeRemediationExceptions(): this;
    /**
     * (experimental) Grants permission to provide a detailed view of a Remediation Execution for a set of resources including state, timestamps and any error messages for steps that have failed.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRemediationExecutionStatus.html
     *
     * @experimental
     */
    toDescribeRemediationExecutionStatus(): this;
    /**
     * (experimental) Grants permission to return the details of one or more retention configurations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeRetentionConfigurations.html
     *
     * @experimental
     */
    toDescribeRetentionConfigurations(): this;
    /**
     * (experimental) Grants permission to return the evaluation results for the specified AWS Config rule for a specific resource in a rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateComplianceDetailsByConfigRule.html
     *
     * @experimental
     */
    toGetAggregateComplianceDetailsByConfigRule(): this;
    /**
     * (experimental) Grants permission to return the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateConfigRuleComplianceSummary.html
     *
     * @experimental
     */
    toGetAggregateConfigRuleComplianceSummary(): this;
    /**
     * (experimental) Grants permission to return the number of compliant and noncompliant conformance packs for one or more accounts and regions in an aggregator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateConformancePackComplianceSummary.html
     *
     * @experimental
     */
    toGetAggregateConformancePackComplianceSummary(): this;
    /**
     * (experimental) Grants permission to return the resource counts across accounts and regions that are present in your AWS Config aggregator.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateDiscoveredResourceCounts.html
     *
     * @experimental
     */
    toGetAggregateDiscoveredResourceCounts(): this;
    /**
     * (experimental) Grants permission to return configuration item that is aggregated for your specific resource in a specific source account and region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetAggregateResourceConfig.html
     *
     * @experimental
     */
    toGetAggregateResourceConfig(): this;
    /**
     * (experimental) Grants permission to return the evaluation results for the specified AWS Config rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByConfigRule.html
     *
     * @experimental
     */
    toGetComplianceDetailsByConfigRule(): this;
    /**
     * (experimental) Grants permission to return the evaluation results for the specified AWS resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceDetailsByResource.html
     *
     * @experimental
     */
    toGetComplianceDetailsByResource(): this;
    /**
     * (experimental) Grants permission to return the number of AWS Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceSummaryByConfigRule.html
     *
     * @experimental
     */
    toGetComplianceSummaryByConfigRule(): this;
    /**
     * (experimental) Grants permission to return the number of resources that are compliant and the number that are noncompliant.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetComplianceSummaryByResourceType.html
     *
     * @experimental
     */
    toGetComplianceSummaryByResourceType(): this;
    /**
     * (experimental) Grants permission to return compliance details of a conformance pack for all AWS resources that are monitered by conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetConformancePackComplianceDetails.html
     *
     * @experimental
     */
    toGetConformancePackComplianceDetails(): this;
    /**
     * (experimental) Grants permission to provide compliance summary for one or more conformance packs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetConformancePackComplianceSummary.html
     *
     * @experimental
     */
    toGetConformancePackComplianceSummary(): this;
    /**
     * (experimental) Grants permission to return the resource types, the number of each resource type, and the total number of resources that AWS Config is recording in this region for your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetDiscoveredResourceCounts.html
     *
     * @experimental
     */
    toGetDiscoveredResourceCounts(): this;
    /**
     * (experimental) Grants permission to return detailed status for each member account within an organization for a given organization config rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetOrganizationConfigRuleDetailedStatus.html
     *
     * @experimental
     */
    toGetOrganizationConfigRuleDetailedStatus(): this;
    /**
     * (experimental) Grants permission to return detailed status for each member account within an organization for a given organization conformance pack.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetOrganizationConformancePackDetailedStatus.html
     *
     * @experimental
     */
    toGetOrganizationConformancePackDetailedStatus(): this;
    /**
     * (experimental) Grants permission to return a list of configuration items for the specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html
     *
     * @experimental
     */
    toGetResourceConfigHistory(): this;
    /**
     * (experimental) Grants permission to return the details of a specific stored query.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_GetStoredQuery.html
     *
     * @experimental
     */
    toGetStoredQuery(): this;
    /**
     * (experimental) Grants permission to accept a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListAggregateDiscoveredResources.html
     *
     * @experimental
     */
    toListAggregateDiscoveredResources(): this;
    /**
     * (experimental) Grants permission to accept a resource type and returns a list of resource identifiers for the resources of that type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListDiscoveredResources.html
     *
     * @experimental
     */
    toListDiscoveredResources(): this;
    /**
     * (experimental) Grants permission to list the stored queries for an AWS account in an AWS Region.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListStoredQueries.html
     *
     * @experimental
     */
    toListStoredQueries(): this;
    /**
     * (experimental) Grants permission to list the tags for AWS Config resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to authorize the aggregator account and region to collect data from the source account and region.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutAggregationAuthorization.html
     *
     * @experimental
     */
    toPutAggregationAuthorization(): this;
    /**
     * (experimental) Grants permission to add or update an AWS Config rule for evaluating whether your AWS resources comply with your desired configurations.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html
     *
     * @experimental
     */
    toPutConfigRule(): this;
    /**
     * (experimental) Grants permission to create and update the configuration aggregator with the selected source accounts and regions.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationAggregator.html
     *
     * @experimental
     */
    toPutConfigurationAggregator(): this;
    /**
     * (experimental) Grants permission to create a new configuration recorder to record the selected resource configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html
     *
     * @experimental
     */
    toPutConfigurationRecorder(): this;
    /**
     * (experimental) Grants permission to create or update a conformance pack.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html
     *
     * @experimental
     */
    toPutConformancePack(): this;
    /**
     * (experimental) Grants permission to create a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutDeliveryChannel.html
     *
     * @experimental
     */
    toPutDeliveryChannel(): this;
    /**
     * (experimental) Grants permission to be used by an AWS Lambda function to deliver evaluation results to AWS Config.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutEvaluations.html
     *
     * @experimental
     */
    toPutEvaluations(): this;
    /**
     * (experimental) Grants permission to deliver evaluation result to AWS Config.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutExternalEvaluation.html
     *
     * @experimental
     */
    toPutExternalEvaluation(): this;
    /**
     * (experimental) Grants permission to add or update organization config rule for your entire organization evaluating whether your AWS resources comply with your desired configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html
     *
     * @experimental
     */
    toPutOrganizationConfigRule(): this;
    /**
     * (experimental) Grants permission to add or update organization conformance pack for your entire organization evaluating whether your AWS resources comply with your desired configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html
     *
     * @experimental
     */
    toPutOrganizationConformancePack(): this;
    /**
     * (experimental) Grants permission to add or update the remediation configuration with a specific AWS Config rule with the selected target or action.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRemediationConfigurations.html
     *
     * @experimental
     */
    toPutRemediationConfigurations(): this;
    /**
     * (experimental) Grants permission to add or update remediation exceptions for specific resources for a specific AWS Config rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRemediationExceptions.html
     *
     * @experimental
     */
    toPutRemediationExceptions(): this;
    /**
     * (experimental) Grants permission to record the configuration state for the resource provided in the request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutResourceConfig.html
     *
     * @experimental
     */
    toPutResourceConfig(): this;
    /**
     * (experimental) Grants permission to create and update the retention configuration with details about retention period (number of days) that AWS Config stores your historical information.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutRetentionConfiguration.html
     *
     * @experimental
     */
    toPutRetentionConfiguration(): this;
    /**
     * (experimental) Grants permission to save a new query or updates an existing saved query.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html
     *
     * @experimental
     */
    toPutStoredQuery(): this;
    /**
     * (experimental) Grants permission to accept a structured query language (SQL) SELECT command and an aggregator to query configuration state of AWS resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_SelectAggregateResourceConfig.html
     *
     * @experimental
     */
    toSelectAggregateResourceConfig(): this;
    /**
     * (experimental) Grants permission to accept a structured query language (SQL) SELECT command, performs the corresponding search, and returns resource configurations matching the properties.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_SelectResourceConfig.html
     *
     * @experimental
     */
    toSelectResourceConfig(): this;
    /**
     * (experimental) Grants permission to evaluate your resources against the specified Config rules.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigRulesEvaluation.html
     *
     * @experimental
     */
    toStartConfigRulesEvaluation(): this;
    /**
     * (experimental) Grants permission to start recording configurations of the AWS resources you have selected to record in your AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html
     *
     * @experimental
     */
    toStartConfigurationRecorder(): this;
    /**
     * (experimental) Grants permission to run an on-demand remediation for the specified AWS Config rules against the last known remediation configuration.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StartRemediationExecution.html
     *
     * @experimental
     */
    toStartRemediationExecution(): this;
    /**
     * (experimental) Grants permission to stop recording configurations of the AWS resources you have selected to record in your AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html
     *
     * @experimental
     */
    toStopConfigurationRecorder(): this;
    /**
     * (experimental) Grants permission to associate the specified tags to a resource with the specified resourceArn.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to delete specified tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type AggregationAuthorization to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_AggregationAuthorization.html
     *
     * @param aggregatorAccount - Identifier for the aggregatorAccount.
     * @param aggregatorRegion - Identifier for the aggregatorRegion.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onAggregationAuthorization(aggregatorAccount: string, aggregatorRegion: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ConfigurationAggregator to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigurationAggregator.html
     *
     * @param aggregatorId - Identifier for the aggregatorId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConfigurationAggregator(aggregatorId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ConfigRule to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigRule.html
     *
     * @param configRuleId - Identifier for the configRuleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConfigRule(configRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type ConformancePack to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_ConformancePack.html
     *
     * @param conformancePackName - Identifier for the conformancePackName.
     * @param conformancePackId - Identifier for the conformancePackId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConformancePack(conformancePackName: string, conformancePackId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type OrganizationConfigRule to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_OrganizationConfigRule.html
     *
     * @param organizationConfigRuleId - Identifier for the organizationConfigRuleId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onOrganizationConfigRule(organizationConfigRuleId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type OrganizationConformancePack to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_OrganizationConformancePack.html
     *
     * @param organizationConformancePackId - Identifier for the organizationConformancePackId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onOrganizationConformancePack(organizationConformancePackId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type RemediationConfiguration to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_RemediationConfiguration.html
     *
     * @param remediationConfigurationId - Identifier for the remediationConfigurationId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRemediationConfiguration(remediationConfigurationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type StoredQuery to the statement.
     *
     * https://docs.aws.amazon.com/config/latest/APIReference/API_StoredQuery.html
     *
     * @param storedQueryName - Identifier for the storedQueryName.
     * @param storedQueryId - Identifier for the storedQueryId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onStoredQuery(storedQueryName: string, storedQueryId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [config](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconfig.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
