"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controltower = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @experimental
 */
class Controltower extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'controltower';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateManagedAccount",
                "DeregisterManagedAccount",
                "DeregisterOrganizationalUnit",
                "DisableGuardrail",
                "EnableGuardrail",
                "ManageOrganizationalUnit",
                "SetupLandingZone",
                "UpdateAccountFactoryConfig"
            ],
            "Read": [
                "DescribeAccountFactoryConfig",
                "DescribeCoreService",
                "DescribeGuardrail",
                "DescribeGuardrailForTarget",
                "DescribeManagedAccount",
                "DescribeManagedOrganizationalUnit",
                "DescribeSingleSignOn",
                "GetAvailableUpdates",
                "GetGuardrailComplianceStatus",
                "GetHomeRegion",
                "GetLandingZoneStatus"
            ],
            "List": [
                "ListDirectoryGroups",
                "ListEnabledGuardrails",
                "ListGuardrailViolations",
                "ListGuardrails",
                "ListGuardrailsForTarget",
                "ListManagedAccounts",
                "ListManagedAccountsForGuardrail",
                "ListManagedAccountsForParent",
                "ListManagedOrganizationalUnits",
                "ListManagedOrganizationalUnitsForGuardrail"
            ]
        };
    }
    /**
     * (experimental) Grants permission to create an account managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toCreateManagedAccount() {
        return this.to('CreateManagedAccount');
    }
    /**
     * (experimental) Grants permission to deregister an account created through the account factory from AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toDeregisterManagedAccount() {
        return this.to('DeregisterManagedAccount');
    }
    /**
     * (experimental) Grants permission to deregister an organizational unit from AWS Control Tower management.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toDeregisterOrganizationalUnit() {
        return this.to('DeregisterOrganizationalUnit');
    }
    /**
     * (experimental) Grants permission to describe the current account factory configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toDescribeAccountFactoryConfig() {
        return this.to('DescribeAccountFactoryConfig');
    }
    /**
     * (experimental) Grants permission to describe resources managed by core accounts in AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     *
     * @experimental
     */
    toDescribeCoreService() {
        return this.to('DescribeCoreService');
    }
    /**
     * (experimental) Grants permission to describe a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toDescribeGuardrail() {
        return this.to('DescribeGuardrail');
    }
    /**
     * (experimental) Grants permission to describe a guardrail for a organizational unit.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toDescribeGuardrailForTarget() {
        return this.to('DescribeGuardrailForTarget');
    }
    /**
     * (experimental) Grants permission to describe an account created through account factory.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toDescribeManagedAccount() {
        return this.to('DescribeManagedAccount');
    }
    /**
     * (experimental) Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toDescribeManagedOrganizationalUnit() {
        return this.to('DescribeManagedOrganizationalUnit');
    }
    /**
     * (experimental) Grants permission to describe the current AWS Control Tower SSO configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     *
     * @experimental
     */
    toDescribeSingleSignOn() {
        return this.to('DescribeSingleSignOn');
    }
    /**
     * (experimental) Grants permission to disable a guardrail from an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     *
     * @experimental
     */
    toDisableGuardrail() {
        return this.to('DisableGuardrail');
    }
    /**
     * (experimental) Grants permission to enable a guardrail to an organizational unit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     *
     * @experimental
     */
    toEnableGuardrail() {
        return this.to('EnableGuardrail');
    }
    /**
     * (experimental) Grants permission to list available updates for the current AWS Control Tower deployment.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     *
     * @experimental
     */
    toGetAvailableUpdates() {
        return this.to('GetAvailableUpdates');
    }
    /**
     * (experimental) Grants permission to get the current compliance status of a guardrail.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toGetGuardrailComplianceStatus() {
        return this.to('GetGuardrailComplianceStatus');
    }
    /**
     * (experimental) Grants permission to get the home region of the AWS Control Tower setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     *
     * @experimental
     */
    toGetHomeRegion() {
        return this.to('GetHomeRegion');
    }
    /**
     * (experimental) Grants permission to get the current status of the landing zone setup.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     *
     * @experimental
     */
    toGetLandingZoneStatus() {
        return this.to('GetLandingZoneStatus');
    }
    /**
     * (experimental) Grants permission to list the current directory groups available through SSO.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     *
     * @experimental
     */
    toListDirectoryGroups() {
        return this.to('ListDirectoryGroups');
    }
    /**
     * (experimental) Grants permission to list currently enabled guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListEnabledGuardrails() {
        return this.to('ListEnabledGuardrails');
    }
    /**
     * (experimental) Grants permission to list existing guardrail violations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListGuardrailViolations() {
        return this.to('ListGuardrailViolations');
    }
    /**
     * (experimental) Grants permission to list all available guardrails.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * (experimental) Grants permission to list guardrails and their current state for a organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     *
     * @experimental
     */
    toListGuardrailsForTarget() {
        return this.to('ListGuardrailsForTarget');
    }
    /**
     * (experimental) Grants permission to list accounts managed through AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * (experimental) Grants permission to list managed accounts with a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toListManagedAccountsForGuardrail() {
        return this.to('ListManagedAccountsForGuardrail');
    }
    /**
     * (experimental) Grants permission to list managed accounts under an organizational unit.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toListManagedAccountsForParent() {
        return this.to('ListManagedAccountsForParent');
    }
    /**
     * (experimental) Grants permission to list organizational units managed by AWS Control Tower.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toListManagedOrganizationalUnits() {
        return this.to('ListManagedOrganizationalUnits');
    }
    /**
     * (experimental) Grants permission to list managed organizational units that have a specified guardrail applied.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toListManagedOrganizationalUnitsForGuardrail() {
        return this.to('ListManagedOrganizationalUnitsForGuardrail');
    }
    /**
     * (experimental) Grants permission to set up an organizational unit to be managed by AWS Control Tower.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     *
     * @experimental
     */
    toManageOrganizationalUnit() {
        return this.to('ManageOrganizationalUnit');
    }
    /**
     * (experimental) Grants permission to set up or update AWS Control Tower landing zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     *
     * @experimental
     */
    toSetupLandingZone() {
        return this.to('SetupLandingZone');
    }
    /**
     * (experimental) Grants permission to update the account factory configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     *
     * @experimental
     */
    toUpdateAccountFactoryConfig() {
        return this.to('UpdateAccountFactoryConfig');
    }
}
exports.Controltower = Controltower;
_a = JSII_RTTI_SYMBOL_1;
Controltower[_a] = { fqn: "cdk-iam-floyd.Controltower", version: "0.218.0" };
//# sourceMappingURL=data:application/json;base64,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