"""update key to worker

Revision ID: 9bb6f1128279
Revises: 25ed0f563bdc
Create Date: 2023-12-19 10:22:34.899234

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '9bb6f1128279'
down_revision: Union[str, None] = '25ed0f563bdc'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('rosemary_tasks', 'worker')
    op.add_column('rosemary_tasks', sa.Column('worker', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'rosemary_tasks', 'rosemary_worker', ['worker'], ['id'])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'rosemary_tasks', type_='foreignkey')
    op.drop_column('rosemary_tasks', 'worker')
    op.add_column('rosemary_tasks', sa.Column('worker', sa.UUID(), nullable=True))
    # ### end Alembic commands ###
