# coding: utf-8

# flake8: noqa

"""
    API Reference: Billing

      # Introduction  Welcome to the reference for the Zuora Billing REST API!  To learn about the common use cases of Zuora Billing REST APIs, check out the [API Guides](https://www.zuora.com/developer/api-guides/).  In addition to Zuora API Reference; Billing, we also provide API references for other Zuora products:    * [API Reference: Collect](https://www.zuora.com/developer/collect-api/)   * [API Reference: Revenue](https://www.zuora.com/developer/revpro-api/)      The Zuora REST API provides a broad set of operations and resources that:    * Enable Web Storefront integration from your website.   * Support self-service subscriber sign-ups and account management.   * Process revenue schedules through custom revenue rule models.   * Enable manipulation of most objects in the Zuora Billing Object Model.  Want to share your opinion on how our API works for you? <a href=\"https://community.zuora.com/t5/Developers/API-Feedback-Form/gpm-p/21399\" target=\"_blank\">Tell us how you feel </a>about using our API and what we can do to make it better.  ## Access to the API  If you have a Zuora tenant, you can access the Zuora REST API via one of the following endpoints:  | Tenant              | Base URL for REST Endpoints | |-------------------------|-------------------------| |US Production | https://rest.zuora.com   | |US API Sandbox    | https://rest.apisandbox.zuora.com| |US Performance Test | https://rest.pt1.zuora.com | |US Production Copy | Submit a request at <a href=\"http://support.zuora.com/\" target=\"_blank\">Zuora Global Support</a> to enable the Zuora REST API in your tenant and obtain the base URL for REST endpoints. See [REST endpoint base URL of Production Copy (Service) Environment for existing and new customers](https://community.zuora.com/t5/API/REST-endpoint-base-URL-of-Production-Copy-Service-Environment/td-p/29611) for more information. | |US Cloud Production |  https://rest.na.zuora.com | |US Cloud API Sandbox |  https://rest.sandbox.na.zuora.com | |US Central Sandbox |  https://rest.test.zuora.com |     |EU Production | https://rest.eu.zuora.com | |EU API Sandbox | https://rest.sandbox.eu.zuora.com | |EU Central Sandbox |  https://rest.test.eu.zuora.com |  The Production endpoint provides access to your live user data. Sandbox tenants are a good place to test code without affecting real-world data. If you would like Zuora to provision a Sandbox tenant for you, contact your Zuora representative for assistance.   If you do not have a Zuora tenant, go to <a href=\"https://www.zuora.com/resource/zuora-test-drive\" target=\"_blank\">https://www.zuora.com/resource/zuora-test-drive</a> and sign up for a Production Test Drive tenant. The tenant comes with seed data, including a sample product catalog.  # API Changelog You can find the <a href=\"https://community.zuora.com/t5/Developers/API-Changelog/gpm-p/18092\" target=\"_blank\">Changelog</a> of the API Reference: Billing in the Zuora Community.  # Authentication  ## OAuth v2.0  Zuora recommends that you use OAuth v2.0 to authenticate to the Zuora REST API. Currently, OAuth is not available in every environment. See [Zuora Testing Environments](https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/D_Zuora_Environments) for more information.  Zuora recommends you to create a dedicated API user with API write access on a tenant when authenticating via OAuth, and then create an OAuth client for this user. See <a href=\"https://knowledgecenter.zuora.com/CF_Users_and_Administrators/A_Administrator_Settings/Manage_Users/Create_an_API_User\" target=\"_blank\">Create an API User</a> for how to do this. By creating a dedicated API user, you can control permissions of the API user without affecting other non-API users.  If a user is deactivated, all of the user's OAuth clients will be automatically deactivated.  Authenticating via OAuth requires the following steps: 1. Create a Client 2. Generate a Token 3. Make Authenticated Requests  ### Create a Client  You must first [create an OAuth client](https://knowledgecenter.zuora.com/CF_Users_and_Administrators/A_Administrator_Settings/Manage_Users#Create_an_OAuth_Client_for_a_User) in the Zuora UI. To do this, you must be an administrator of your Zuora tenant. This is a one-time operation. You will be provided with a Client ID and a Client Secret. Please note this information down, as it will be required for the next step.  **Note:** The OAuth client will be owned by a Zuora user account. If you want to perform PUT, POST, or DELETE operations using the OAuth client, the owner of the OAuth client must have a Platform role that includes the \"API Write Access\" permission.  ### Generate a Token  After creating a client, you must make a call to obtain a bearer token using the [Generate an OAuth token](https://www.zuora.com/developer/api-reference/#operation/createToken) operation. This operation requires the following parameters: - `client_id` - the Client ID displayed when you created the OAuth client in the previous step - `client_secret` - the Client Secret displayed when you created the OAuth client in the previous step - `grant_type` - must be set to `client_credentials`  **Note**: The Client ID and Client Secret mentioned above were displayed when you created the OAuth Client in the prior step. The [Generate an OAuth token](https://www.zuora.com/developer/api-reference/#operation/createToken) response specifies how long the bearer token is valid for. You should reuse the bearer token until it is expired. When the token is expired, call [Generate an OAuth token](https://www.zuora.com/developer/api-reference/#operation/createToken) again to generate a new one.  ### Make Authenticated Requests  To authenticate subsequent API requests, you must provide a valid bearer token in an HTTP header:  `Authorization: Bearer {bearer_token}`  If you have [Zuora Multi-entity](https://www.zuora.com/developer/api-reference/#tag/Entities) enabled, you need to set an additional header to specify the ID of the entity that you want to access. You can use the `scope` field in the [Generate an OAuth token](https://www.zuora.com/developer/api-reference/#operation/createToken) response to determine whether you need to specify an entity ID.  If the `scope` field contains more than one entity ID, you must specify the ID of the entity that you want to access. For example, if the `scope` field contains `entity.1a2b7a37-3e7d-4cb3-b0e2-883de9e766cc` and `entity.c92ed977-510c-4c48-9b51-8d5e848671e9`, specify one of the following headers: - `Zuora-Entity-Ids: 1a2b7a37-3e7d-4cb3-b0e2-883de9e766cc` - `Zuora-Entity-Ids: c92ed977-510c-4c48-9b51-8d5e848671e9`  **Note**: For a limited period of time, Zuora will accept the `entityId` header as an alternative to the `Zuora-Entity-Ids` header. If you choose to set the `entityId` header, you must remove all \"-\" characters from the entity ID in the `scope` field.  If the `scope` field contains a single entity ID, you do not need to specify an entity ID.  ## Other Supported Authentication Schemes  Zuora continues to support the following additional legacy means of authentication:    * Use username and password. Include authentication with each request in the header:         * `apiAccessKeyId`      * `apiSecretAccessKey`          Zuora recommends that you create an API user specifically for making API calls. See <a href=\"https://knowledgecenter.zuora.com/CF_Users_and_Administrators/A_Administrator_Settings/Manage_Users/Create_an_API_User\" target=\"_blank\">Create an API User</a> for more information.      * Use an authorization cookie. The cookie authorizes the user to make calls to the REST API for the duration specified in  **Administration > Security Policies > Session timeout**. The cookie expiration time is reset with this duration after every call to the REST API. To obtain a cookie, call the [Connections](https://www.zuora.com/developer/api-reference/#tag/Connections) resource with the following API user information:         *   ID         *   Password        * For CORS-enabled APIs only: Include a 'single-use' token in the request header, which re-authenticates the user with each request. See below for more details.  ### Entity Id and Entity Name  The `entityId` and `entityName` parameters are only used for [Zuora Multi-entity](https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/Multi-entity \"Zuora Multi-entity\"). These are the legacy parameters that Zuora will only continue to support for a period of time. Zuora recommends you to use the `Zuora-Entity-Ids` parameter instead.   The  `entityId` and `entityName` parameters specify the Id and the [name of the entity](https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/Multi-entity/B_Introduction_to_Entity_and_Entity_Hierarchy#Name_and_Display_Name \"Introduction to Entity and Entity Hierarchy\") that you want to access, respectively. Note that you must have permission to access the entity.   You can specify either the `entityId` or `entityName` parameter in the authentication to access and view an entity.    * If both `entityId` and `entityName` are specified in the authentication, an error occurs.    * If neither `entityId` nor `entityName` is specified in the authentication, you will log in to the entity in which your user account is created.      To get the entity Id and entity name, you can use the GET Entities REST call. For more information, see [API User Authentication](https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/Multi-entity/A_Overview_of_Multi-entity#API_User_Authentication \"API User Authentication\").      ### Token Authentication for CORS-Enabled APIs      The CORS mechanism enables REST API calls to Zuora to be made directly from your customer's browser, with all credit card and security information transmitted directly to Zuora. This minimizes your PCI compliance burden, allows you to implement advanced validation on your payment forms, and  makes your payment forms look just like any other part of your website.    For security reasons, instead of using cookies, an API request via CORS uses **tokens** for authentication.  The token method of authentication is only designed for use with requests that must originate from your customer's browser; **it should  not be considered a replacement to the existing cookie authentication** mechanism.  See [Zuora CORS REST](https://knowledgecenter.zuora.com/DC_Developers/C_REST_API/Zuora_CORS_REST \"Zuora CORS REST\") for details on how CORS works and how you can begin to implement customer calls to the Zuora REST APIs. See  [HMAC Signatures](https://www.zuora.com/developer/api-reference/#operation/POSTHMACSignature \"HMAC Signatures\") for details on the HMAC method that returns the authentication token.  # Requests and Responses  ## Request IDs  As a general rule, when asked to supply a \"key\" for an account or subscription (accountKey, account-key, subscriptionKey, subscription-key), you can provide either the actual ID or  the number of the entity.  ## HTTP Request Body  Most of the parameters and data accompanying your requests will be contained in the body of the HTTP request.   The Zuora REST API accepts JSON in the HTTP request body. No other data format (e.g., XML) is supported.  ### Data Type  ([Actions](https://www.zuora.com/developer/api-reference/#tag/Actions) and CRUD operations only) We recommend that you do not specify the decimal values with quotation marks, commas, and spaces. Use characters of `+-0-9.eE`, for example, `5`, `1.9`, `-8.469`, and `7.7e2`. Also, Zuora does not convert currencies for decimal values.  ## Testing a Request  Use a third party client, such as [curl](https://curl.haxx.se \"curl\"), [Postman](https://www.getpostman.com \"Postman\"), or [Advanced REST Client](https://advancedrestclient.com \"Advanced REST Client\"), to test the Zuora REST API.  You can test the Zuora REST API from the Zuora API Sandbox or Production tenants. If connecting to Production, bear in mind that you are working with your live production data, not sample data or test data.  ## Testing with Credit Cards  Sooner or later it will probably be necessary to test some transactions that involve credit cards. For suggestions on how to handle this, see [Going Live With Your Payment Gateway](https://knowledgecenter.zuora.com/CB_Billing/M_Payment_Gateways/C_Managing_Payment_Gateways/B_Going_Live_Payment_Gateways#Testing_with_Credit_Cards \"C_Zuora_User_Guides/A_Billing_and_Payments/M_Payment_Gateways/C_Managing_Payment_Gateways/B_Going_Live_Payment_Gateways#Testing_with_Credit_Cards\" ).  ## Concurrent Request Limits  Zuora enforces tenant-level concurrent request limits. See <a href=\"https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/Policies/Concurrent_Request_Limits\" target=\"_blank\">Concurrent Request Limits</a> for more information.  ## Timeout Limit  If a request does not complete within 120 seconds, the request times out and Zuora returns a Gateway Timeout error.   # Error Handling  If a request to Zuora Billing REST API with an endpoint starting with `/v1` (except [Actions](https://www.zuora.com/developer/api-reference/#tag/Actions) and CRUD operations) fails, the response will contain an eight-digit error code with a corresponding error message to indicate the details of the error.  The following code snippet is a sample error response that contains an error code and message pair:  ```  {    \"success\": false,    \"processId\": \"CBCFED6580B4E076\",    \"reasons\":  [      {       \"code\": 53100320,       \"message\": \"'termType' value should be one of: TERMED, EVERGREEN\"      }     ]  } ``` The `success` field indicates whether the API request has succeeded. The `processId` field is a Zuora internal ID that you can provide to Zuora Global Support for troubleshooting purposes.  The `reasons` field contains the actual error code and message pair. The error code begins with `5` or `6` means that you encountered a certain issue that is specific to a REST API resource in Zuora Billing. For example, `53100320` indicates that an invalid value is specified for the `termType` field of the `subscription` object.  The error code beginning with `9` usually indicates that an authentication-related issue occurred, and it can also indicate other unexpected errors depending on different cases. For example, `90000011` indicates that an invalid credential is provided in the request header.   When troubleshooting the error, you can divide the error code into two components: REST API resource code and error category code. See the following Zuora error code sample:  <a href=\"https://assets.zuora.com/zuora-documentation/ZuoraErrorCode.jpeg\" target=\"_blank\"><img src=\"https://assets.zuora.com/zuora-documentation/ZuoraErrorCode.jpeg\" alt=\"Zuora Error Code Sample\"></a>   **Note:** Zuora determines resource codes based on the request payload. Therefore, if GET and DELETE requests that do not contain payloads fail, you will get `500000` as the resource code, which indicates an unknown object and an unknown field.  The error category code of these requests is valid and follows the rules described in the [Error Category Code](https://www.zuora.com/developer/api-reference/#section/Error-Handling/Error-Category-Code) section.  In such case, you can refer to the returned error message to troubleshoot.   ## REST API Resource Code  The 6-digit resource code indicates the REST API resource, typically a field of a Zuora object, on which the issue occurs. In the preceding example, `531003` refers to the `termType` field of the `subscription` object.   The value range for all REST API resource codes is from `500000` to `679999`. See [Resource Codes](https://knowledgecenter.zuora.com/Central_Platform/API/AA_REST_API/Resource_Codes) in the Knowledge Center for a full list of resource codes.  ## Error Category Code  The 2-digit error category code identifies the type of error, for example, resource not found or missing required field.   The following table describes all error categories and the corresponding resolution:  | Code    | Error category              | Description    | Resolution    | |:--------|:--------|:--------|:--------| | 10      | Permission or access denied | The request cannot be processed because a certain tenant or user permission is missing. | Check the missing tenant or user permission in the response message and contact [Zuora Global Support](https://support.zuora.com) for enablement. | | 11      | Authentication failed       | Authentication fails due to invalid API authentication credentials. | Ensure that a valid API credential is specified. | | 20      | Invalid format or value     | The request cannot be processed due to an invalid field format or value. | Check the invalid field in the error message, and ensure that the format and value of all fields you passed in are valid. | | 21      | Unknown field in request    | The request cannot be processed because an unknown field exists in the request body. | Check the unknown field name in the response message, and ensure that you do not include any unknown field in the request body. | | 22      | Missing required field      | The request cannot be processed because a required field in the request body is missing. | Check the missing field name in the response message, and ensure that you include all required fields in the request body. | | 30      | Rule restriction            | The request cannot be processed due to the violation of a Zuora business rule. | Check the response message and ensure that the API request meets the specified business rules. | | 40      | Not found                   | The specified resource cannot be found. | Check the response message and ensure that the specified resource exists in your Zuora tenant. | | 45      | Unsupported request         | The requested endpoint does not support the specified HTTP method. | Check your request and ensure that the endpoint and method matches. | | 50      | Locking contention          | This request cannot be processed because the objects this request is trying to modify are being modified by another API request, UI operation, or batch job process. | <p>Resubmit the request first to have another try.</p> <p>If this error still occurs, contact [Zuora Global Support](https://support.zuora.com) with the returned `Zuora-Request-Id` value in the response header for assistance.</p> | | 60      | Internal error              | The server encounters an internal error. | Contact [Zuora Global Support](https://support.zuora.com) with the returned `Zuora-Request-Id` value in the response header for assistance. | | 70      | Request exceeded limit      | The total number of concurrent requests exceeds the limit allowed by the system. | <p>Resubmit the request after the number of seconds specified by the `Retry-After` value in the response header.</p> <p>Check [Concurrent request limits](https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/Policies/Concurrent_Request_Limits) for details about Zuora’s concurrent request limit policy.</p> | | 90      | Malformed request           | The request cannot be processed due to JSON syntax errors. | Check the syntax error in the JSON request body and ensure that the request is in the correct JSON format. | | 99      | Integration error           | The server encounters an error when communicating with an external system, for example, payment gateway, tax engine provider. | Check the response message and take action accordingly. |   # Pagination  When retrieving information (using GET methods), the optional `pageSize` query parameter sets the maximum number of rows to return in a response. The maximum is `40`; larger values are treated as `40`. If this value is empty or invalid, `pageSize` typically defaults to `10`.  The default value for the maximum number of rows retrieved can be overridden at the method level.  If more rows are available, the response will include a `nextPage` element, which contains a URL for requesting the next page.  If this value is not provided, no more rows are available. No \"previous page\" element is explicitly provided; to support backward paging, use the previous call.  ## Array Size  For data items that are not paginated, the REST API supports arrays of up to 300 rows.  Thus, for instance, repeated pagination can retrieve thousands of customer accounts, but within any account an array of no more than 300 rate plans is returned.  # API Versions  The Zuora REST API are version controlled. Versioning ensures that Zuora REST API changes are backward compatible. Zuora uses a major and minor version nomenclature to manage changes. By specifying a version in a REST request, you can get expected responses regardless of future changes to the API.  ## Major Version  The major version number of the REST API appears in the REST URL. Currently, Zuora only supports the **v1** major version. For example, `POST https://rest.zuora.com/v1/subscriptions`.  ## Minor Version  Zuora uses minor versions for the REST API to control small changes. For example, a field in a REST method is deprecated and a new field is used to replace it.   Some fields in the REST methods are supported as of minor versions. If a field is not noted with a minor version, this field is available for all minor versions. If a field is noted with a minor version, this field is in version control. You must specify the supported minor version in the request header to process without an error.   If a field is in version control, it is either with a minimum minor version or a maximum minor version, or both of them. You can only use this field with the minor version between the minimum and the maximum minor versions. For example, the `invoiceCollect` field in the POST Subscription method is in version control and its maximum minor version is 189.0. You can only use this field with the minor version 189.0 or earlier.  If you specify a version number in the request header that is not supported, Zuora will use the minimum minor version of the REST API. In our REST API documentation, if a field or feature requires a minor version number, we note that in the field description.  You only need to specify the version number when you use the fields require a minor version. To specify the minor version, set the `zuora-version` parameter to the minor version number in the request header for the request call. For example, the `collect` field is in 196.0 minor version. If you want to use this field for the POST Subscription method, set the  `zuora-version` parameter to `196.0` in the request header. The `zuora-version` parameter is case sensitive.  For all the REST API fields, by default, if the minor version is not specified in the request header, Zuora will use the minimum minor version of the REST API to avoid breaking your integration.   ### Minor Version History  The supported minor versions are not serial. This section documents the changes made to each Zuora REST API minor version.  The following table lists the supported versions and the fields that have a Zuora REST API minor version.  | Fields         | Minor Version      | REST Methods    | Description | |:--------|:--------|:--------|:--------| | invoiceCollect | 189.0 and earlier  | [Create Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_Subscription \"Create Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\"); [Renew Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_RenewSubscription \"Renew Subscription\"); [Cancel Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_CancelSubscription \"Cancel Subscription\"); [Suspend Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_SuspendSubscription \"Suspend Subscription\"); [Resume Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_ResumeSubscription \"Resume Subscription\"); [Create Account](https://www.zuora.com/developer/api-reference/#operation/POST_Account \"Create Account\")|Generates an invoice and collects a payment for a subscription. | | collect        | 196.0 and later    | [Create Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_Subscription \"Create Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\"); [Renew Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_RenewSubscription \"Renew Subscription\"); [Cancel Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_CancelSubscription \"Cancel Subscription\"); [Suspend Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_SuspendSubscription \"Suspend Subscription\"); [Resume Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_ResumeSubscription \"Resume Subscription\"); [Create Account](https://www.zuora.com/developer/api-reference/#operation/POST_Account \"Create Account\")|Collects an automatic payment for a subscription. | | invoice | 196.0 and 207.0| [Create Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_Subscription \"Create Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\"); [Renew Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_RenewSubscription \"Renew Subscription\"); [Cancel Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_CancelSubscription \"Cancel Subscription\"); [Suspend Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_SuspendSubscription \"Suspend Subscription\"); [Resume Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_ResumeSubscription \"Resume Subscription\"); [Create Account](https://www.zuora.com/developer/api-reference/#operation/POST_Account \"Create Account\")|Generates an invoice for a subscription. | | invoiceTargetDate | 196.0 and earlier  | [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\") |Date through which charges are calculated on the invoice, as `yyyy-mm-dd`. | | invoiceTargetDate | 207.0 and earlier  | [Create Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_Subscription \"Create Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\"); [Renew Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_RenewSubscription \"Renew Subscription\"); [Cancel Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_CancelSubscription \"Cancel Subscription\"); [Suspend Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_SuspendSubscription \"Suspend Subscription\"); [Resume Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_ResumeSubscription \"Resume Subscription\"); [Create Account](https://www.zuora.com/developer/api-reference/#operation/POST_Account \"Create Account\")|Date through which charges are calculated on the invoice, as `yyyy-mm-dd`. | | targetDate | 207.0 and later | [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\") |Date through which charges are calculated on the invoice, as `yyyy-mm-dd`. | | targetDate | 211.0 and later | [Create Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_Subscription \"Create Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\"); [Renew Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_RenewSubscription \"Renew Subscription\"); [Cancel Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_CancelSubscription \"Cancel Subscription\"); [Suspend Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_SuspendSubscription \"Suspend Subscription\"); [Resume Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_ResumeSubscription \"Resume Subscription\"); [Create Account](https://www.zuora.com/developer/api-reference/#operation/POST_Account \"Create Account\")|Date through which charges are calculated on the invoice, as `yyyy-mm-dd`. | | includeExisting DraftInvoiceItems | 196.0 and earlier| [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\") | Specifies whether to include draft invoice items in subscription previews. Specify it to be `true` (default) to include draft invoice items in the preview result. Specify it to be `false` to excludes draft invoice items in the preview result. | | includeExisting DraftDocItems | 207.0 and later  | [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\") | Specifies whether to include draft invoice items in subscription previews. Specify it to be `true` (default) to include draft invoice items in the preview result. Specify it to be `false` to excludes draft invoice items in the preview result. | | previewType | 196.0 and earlier| [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\") | The type of preview you will receive. The possible values are `InvoiceItem`(default), `ChargeMetrics`, and `InvoiceItemChargeMetrics`. | | previewType | 207.0 and later  | [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\") | The type of preview you will receive. The possible values are `LegalDoc`(default), `ChargeMetrics`, and `LegalDocChargeMetrics`. | | runBilling  | 211.0 and later  | [Create Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_Subscription \"Create Subscription\"); [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\"); [Renew Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_RenewSubscription \"Renew Subscription\"); [Cancel Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_CancelSubscription \"Cancel Subscription\"); [Suspend Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_SuspendSubscription \"Suspend Subscription\"); [Resume Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_ResumeSubscription \"Resume Subscription\"); [Create Account](https://www.zuora.com/developer/api-reference/#operation/POST_Account \"Create Account\")|Generates an invoice or credit memo for a subscription. **Note:** Credit memos are only available if you have the Invoice Settlement feature enabled. | | invoiceDate | 214.0 and earlier  | [Invoice and Collect](https://www.zuora.com/developer/api-reference/#operation/POST_TransactionInvoicePayment \"Invoice and Collect\") |Date that should appear on the invoice being generated, as `yyyy-mm-dd`. | | invoiceTargetDate | 214.0 and earlier  | [Invoice and Collect](https://www.zuora.com/developer/api-reference/#operation/POST_TransactionInvoicePayment \"Invoice and Collect\") |Date through which to calculate charges on this account if an invoice is generated, as `yyyy-mm-dd`. | | documentDate | 215.0 and later | [Invoice and Collect](https://www.zuora.com/developer/api-reference/#operation/POST_TransactionInvoicePayment \"Invoice and Collect\") |Date that should appear on the invoice and credit memo being generated, as `yyyy-mm-dd`. | | targetDate | 215.0 and later | [Invoice and Collect](https://www.zuora.com/developer/api-reference/#operation/POST_TransactionInvoicePayment \"Invoice and Collect\") |Date through which to calculate charges on this account if an invoice or a credit memo is generated, as `yyyy-mm-dd`. | | memoItemAmount | 223.0 and earlier | [Create credit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromPrpc \"Create credit memo from charge\"); [Create debit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromPrpc \"Create debit memo from charge\") | Amount of the memo item. | | amount | 224.0 and later | [Create credit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromPrpc \"Create credit memo from charge\"); [Create debit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromPrpc \"Create debit memo from charge\") | Amount of the memo item. | | subscriptionNumbers | 222.4 and earlier | [Create order](https://www.zuora.com/developer/api-reference/#operation/POST_Order \"Create order\") | Container for the subscription numbers of the subscriptions in an order. | | subscriptions | 223.0 and later | [Create order](https://www.zuora.com/developer/api-reference/#operation/POST_Order \"Create order\") | Container for the subscription numbers and statuses in an order. | | creditTaxItems | 238.0 and earlier | [Get credit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItems \"Get credit memo items\"); [Get credit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItem \"Get credit memo item\") | Container for the taxation items of the credit memo item. | | taxItems | 238.0 and earlier | [Get debit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItems \"Get debit memo items\"); [Get debit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItem \"Get debit memo item\") | Container for the taxation items of the debit memo item. | | taxationItems | 239.0 and later | [Get credit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItems \"Get credit memo items\"); [Get credit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItem \"Get credit memo item\"); [Get debit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItems \"Get debit memo items\"); [Get debit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItem \"Get debit memo item\") | Container for the taxation items of the memo item. | | chargeId | 256.0 and earlier | [Create credit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromPrpc \"Create credit memo from charge\"); [Create debit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromPrpc \"Create debit memo from charge\") | ID of the product rate plan charge that the memo is created from. | | productRatePlanChargeId | 257.0 and later | [Create credit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromPrpc \"Create credit memo from charge\"); [Create debit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromPrpc \"Create debit memo from charge\") | ID of the product rate plan charge that the memo is created from. | | comment | 256.0 and earlier | [Create credit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromPrpc \"Create credit memo from charge\"); [Create debit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromPrpc \"Create debit memo from charge\"); [Create credit memo from invoice](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromInvoice \"Create credit memo from invoice\"); [Create debit memo from invoice](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromInvoice \"Create debit memo from invoice\"); [Get credit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItems \"Get credit memo items\"); [Get credit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItem \"Get credit memo item\"); [Get debit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItems \"Get debit memo items\"); [Get debit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItem \"Get debit memo item\") | Comments about the product rate plan charge, invoice item, or memo item. | | description | 257.0 and later | [Create credit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromPrpc \"Create credit memo from charge\"); [Create debit memo from charge](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromPrpc \"Create debit memo from charge\"); [Create credit memo from invoice](https://www.zuora.com/developer/api-reference/#operation/POST_CreditMemoFromInvoice \"Create credit memo from invoice\"); [Create debit memo from invoice](https://www.zuora.com/developer/api-reference/#operation/POST_DebitMemoFromInvoice \"Create debit memo from invoice\"); [Get credit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItems \"Get credit memo items\"); [Get credit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_CreditMemoItem \"Get credit memo item\"); [Get debit memo items](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItems \"Get debit memo items\"); [Get debit memo item](https://www.zuora.com/developer/api-reference/#operation/GET_DebitMemoItem \"Get debit memo item\") | Description of the the product rate plan charge, invoice item, or memo item. |   #### Version 207.0 and Later  The response structure of the [Preview Subscription](https://www.zuora.com/developer/api-reference/#operation/POST_SubscriptionPreview \"Preview Subscription\") and [Update Subscription](https://www.zuora.com/developer/api-reference/#operation/PUT_Subscription \"Update Subscription\") methods are changed. The following invoice related response fields are moved to the invoice container:    * amount   * amountWithoutTax   * taxAmount   * invoiceItems   * targetDate   * chargeMetrics  # Zuora Billing Object Model  The following diagram is a high-level view of how key business objects are related to one another within Zuora Billing.  Click the diagram to open it in a new tab and zoom in. For more information about the different sections of the diagram, see <a href=\"https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/A_Zuora_Billing_business_object_model\" target=\"_blank\">Zuora Billing business object model</a>.  <a href=\"https://assets.zuora.com/zuora-documentation/Zuora_Billing_object_model_Sep2020.png\" target=\"_blank\"><img src=\"https://assets.zuora.com/zuora-documentation/Zuora_Billing_object_model_Sep2020.png\" alt=\"Zuora Billing object model diagram\"></a>  This diagram is intended to provide a conceptual understanding; it does not illustrate a specific way to integrate with Zuora.  The diagram includes the Orders feature and the Invoice Settlement feature. If your organization does not use either of these features, see <a href=\"https://knowledgecenter.zuora.com/BB_Introducing_Z_Business/B_Zuora_Billing_business_object_model_prior_to_Orders_and_Invoice_Settlement\" target=\"_blank\">Zuora Billing business object model prior to Orders and Invoice Settlement</a> for an alternative diagram.  ## API Names  You can use the [Describe object](https://www.zuora.com/developer/api-reference/#operation/GET_Describe) operation to list the fields of each Zuora object that is available in your tenant. When you call the operation, you must specify the API name of the Zuora object.  The following table provides the API name of each Zuora object:  | Object                                        | API Name                                   | |-----------------------------------------------|--------------------------------------------| | Account                                       | `Account`                                  | | Accounting Code                               | `AccountingCode`                           | | Accounting Period                             | `AccountingPeriod`                         | | Amendment                                     | `Amendment`                                | | Application Group                             | `ApplicationGroup`                         | | Billing Run                                   | <p>`BillingRun` - API name used  in the [Describe object](https://www.zuora.com/developer/api-reference/#operation/GET_Describe) operation, Export ZOQL queries, and Data Query.</p> <p>`BillRun` - API name used in the [Actions](https://www.zuora.com/developer/api-reference/#tag/Actions). See the CRUD oprations of [Bill Run](https://www.zuora.com/developer/api-reference/#tag/Bill-Run) for more information about the `BillRun` object. `BillingRun` and `BillRun` have different fields. | | Contact                                       | `Contact`                                  | | Contact Snapshot                              | `ContactSnapshot`                          | | Credit Balance Adjustment                     | `CreditBalanceAdjustment`                  | | Credit Memo                                   | `CreditMemo`                               | | Credit Memo Application                       | `CreditMemoApplication`                    | | Credit Memo Application Item                  | `CreditMemoApplicationItem`                | | Credit Memo Item                              | `CreditMemoItem`                           | | Credit Memo Part                              | `CreditMemoPart`                           | | Credit Memo Part Item                         | `CreditMemoPartItem`                       | | Credit Taxation Item                          | `CreditTaxationItem`                       | | Custom Exchange Rate                          | `FXCustomRate`                             | | Debit Memo                                    | `DebitMemo`                                | | Debit Memo Item                               | `DebitMemoItem`                            | | Debit Taxation Item                           | `DebitTaxationItem`                        | | Discount Applied Metrics                      | `DiscountAppliedMetrics`                   | | Entity                                        | `Tenant`                                   | | Feature                                       | `Feature`                                  | | Gateway Reconciliation Event                  | `PaymentGatewayReconciliationEventLog`     | | Gateway Reconciliation Job                    | `PaymentReconciliationJob`                 | | Gateway Reconciliation Log                    | `PaymentReconciliationLog`                 | | Invoice                                       | `Invoice`                                  | | Invoice Adjustment                            | `InvoiceAdjustment`                        | | Invoice Item                                  | `InvoiceItem`                              | | Invoice Item Adjustment                       | `InvoiceItemAdjustment`                    | | Invoice Payment                               | `InvoicePayment`                           | | Journal Entry                                 | `JournalEntry`                             | | Journal Entry Item                            | `JournalEntryItem`                         | | Journal Run                                   | `JournalRun`                               | | Order                                         | `Order`                                    | | Order Action                                  | `OrderAction`                              | | Order ELP                                     | `OrderElp`                                 | | Order Item                                    | `OrderItem`                                | | Order MRR                                     | `OrderMrr`                                 | | Order Quantity                                | `OrderQuantity`                            | | Order TCB                                     | `OrderTcb`                                 | | Order TCV                                     | `OrderTcv`                                 | | Payment                                       | `Payment`                                  | | Payment Application                           | `PaymentApplication`                       | | Payment Application Item                      | `PaymentApplicationItem`                   | | Payment Method                                | `PaymentMethod`                            | | Payment Method Snapshot                       | `PaymentMethodSnapshot`                    | | Payment Method Transaction Log                | `PaymentMethodTransactionLog`              | | Payment Method Update                         | `UpdaterDetail`                            | | Payment Part                                  | `PaymentPart`                              | | Payment Part Item                             | `PaymentPartItem`                          | | Payment Run                                   | `PaymentRun`                               | | Payment Transaction Log                       | `PaymentTransactionLog`                    | | Processed Usage                               | `ProcessedUsage`                           | | Product                                       | `Product`                                  | | Product Feature                               | `ProductFeature`                           | | Product Rate Plan                             | `ProductRatePlan`                          | | Product Rate Plan Charge                      | `ProductRatePlanCharge`                    | | Product Rate Plan Charge Tier                 | `ProductRatePlanChargeTier`                | | Rate Plan                                     | `RatePlan`                                 | | Rate Plan Charge                              | `RatePlanCharge`                           | | Rate Plan Charge Tier                         | `RatePlanChargeTier`                       | | Refund                                        | `Refund`                                   | | Refund Application                            | `RefundApplication`                        | | Refund Application Item                       | `RefundApplicationItem`                    | | Refund Invoice Payment                        | `RefundInvoicePayment`                     | | Refund Part                                   | `RefundPart`                               | | Refund Part Item                              | `RefundPartItem`                           | | Refund Transaction Log                        | `RefundTransactionLog`                     | | Revenue Charge Summary                        | `RevenueChargeSummary`                     | | Revenue Charge Summary Item                   | `RevenueChargeSummaryItem`                 | | Revenue Event                                 | `RevenueEvent`                             | | Revenue Event Credit Memo Item                | `RevenueEventCreditMemoItem`               | | Revenue Event Debit Memo Item                 | `RevenueEventDebitMemoItem`                | | Revenue Event Invoice Item                    | `RevenueEventInvoiceItem`                  | | Revenue Event Invoice Item Adjustment         | `RevenueEventInvoiceItemAdjustment`        | | Revenue Event Item                            | `RevenueEventItem`                         | | Revenue Event Item Credit Memo Item           | `RevenueEventItemCreditMemoItem`           | | Revenue Event Item Debit Memo Item            | `RevenueEventItemDebitMemoItem`            | | Revenue Event Item Invoice Item               | `RevenueEventItemInvoiceItem`              | | Revenue Event Item Invoice Item Adjustment    | `RevenueEventItemInvoiceItemAdjustment`    | | Revenue Event Type                            | `RevenueEventType`                         | | Revenue Schedule                              | `RevenueSchedule`                          | | Revenue Schedule Credit Memo Item             | `RevenueScheduleCreditMemoItem`            | | Revenue Schedule Debit Memo Item              | `RevenueScheduleDebitMemoItem`             | | Revenue Schedule Invoice Item                 | `RevenueScheduleInvoiceItem`               | | Revenue Schedule Invoice Item Adjustment      | `RevenueScheduleInvoiceItemAdjustment`     | | Revenue Schedule Item                         | `RevenueScheduleItem`                      | | Revenue Schedule Item Credit Memo Item        | `RevenueScheduleItemCreditMemoItem`        | | Revenue Schedule Item Debit Memo Item         | `RevenueScheduleItemDebitMemoItem`         | | Revenue Schedule Item Invoice Item            | `RevenueScheduleItemInvoiceItem`           | | Revenue Schedule Item Invoice Item Adjustment | `RevenueScheduleItemInvoiceItemAdjustment` | | Subscription                                  | `Subscription`                             | | Subscription Product Feature                  | `SubscriptionProductFeature`               | | Taxable Item Snapshot                         | `TaxableItemSnapshot`                      | | Taxation Item                                 | `TaxationItem`                             | | Updater Batch                                 | `UpdaterBatch`                             | | Usage                                         | `Usage`                                    |   # noqa: E501

    OpenAPI spec version: 2021-02-09
    Contact: docs@zuora.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import apis into sdk package
from swagger_client.api.accounting_codes_api import AccountingCodesApi
from swagger_client.api.accounting_periods_api import AccountingPeriodsApi
from swagger_client.api.accounts_api import AccountsApi
from swagger_client.api.actions_api import ActionsApi
from swagger_client.api.amendments_api import AmendmentsApi
from swagger_client.api.attachments_api import AttachmentsApi
from swagger_client.api.bill_run_api import BillRunApi
from swagger_client.api.billing_documents_api import BillingDocumentsApi
from swagger_client.api.billing_preview_run_api import BillingPreviewRunApi
from swagger_client.api.catalog_api import CatalogApi
from swagger_client.api.charge_metrics_api import ChargeMetricsApi
from swagger_client.api.charge_revenue_summaries_api import ChargeRevenueSummariesApi
from swagger_client.api.communication_profiles_api import CommunicationProfilesApi
from swagger_client.api.connections_api import ConnectionsApi
from swagger_client.api.contacts_api import ContactsApi
from swagger_client.api.credit_balance_adjustments_api import CreditBalanceAdjustmentsApi
from swagger_client.api.credit_memos_api import CreditMemosApi
from swagger_client.api.custom_exchange_rates_api import CustomExchangeRatesApi
from swagger_client.api.custom_object_definitions_api import CustomObjectDefinitionsApi
from swagger_client.api.custom_object_records_api import CustomObjectRecordsApi
from swagger_client.api.data_queries_api import DataQueriesApi
from swagger_client.api.debit_memos_api import DebitMemosApi
from swagger_client.api.describe_api import DescribeApi
from swagger_client.api.document_properties_api import DocumentPropertiesApi
from swagger_client.api.entities_api import EntitiesApi
from swagger_client.api.entity_connections_api import EntityConnectionsApi
from swagger_client.api.event_triggers_api import EventTriggersApi
from swagger_client.api.exports_api import ExportsApi
from swagger_client.api.features_api import FeaturesApi
from swagger_client.api.get_files_api import GetFilesApi
from swagger_client.api.hmac_signatures_api import HMACSignaturesApi
from swagger_client.api.hosted_pages_api import HostedPagesApi
from swagger_client.api.imports_api import ImportsApi
from swagger_client.api.invoice_adjustments_api import InvoiceAdjustmentsApi
from swagger_client.api.invoice_item_adjustments_api import InvoiceItemAdjustmentsApi
from swagger_client.api.invoice_items_api import InvoiceItemsApi
from swagger_client.api.invoice_payments_api import InvoicePaymentsApi
from swagger_client.api.invoice_split_items_api import InvoiceSplitItemsApi
from swagger_client.api.invoice_splits_api import InvoiceSplitsApi
from swagger_client.api.invoices_api import InvoicesApi
from swagger_client.api.journal_runs_api import JournalRunsApi
from swagger_client.api.mass_updater_api import MassUpdaterApi
from swagger_client.api.notifications_api import NotificationsApi
from swagger_client.api.o_auth_api import OAuthApi
from swagger_client.api.operations_api import OperationsApi
from swagger_client.api.orders_api import OrdersApi
from swagger_client.api.payment_gateway_reconciliation_api import PaymentGatewayReconciliationApi
from swagger_client.api.payment_gateways_api import PaymentGatewaysApi
from swagger_client.api.payment_method_snapshots_api import PaymentMethodSnapshotsApi
from swagger_client.api.payment_method_transaction_logs_api import PaymentMethodTransactionLogsApi
from swagger_client.api.payment_methods_api import PaymentMethodsApi
from swagger_client.api.payment_runs_api import PaymentRunsApi
from swagger_client.api.payment_transaction_logs_api import PaymentTransactionLogsApi
from swagger_client.api.payments_api import PaymentsApi
from swagger_client.api.product_features_api import ProductFeaturesApi
from swagger_client.api.product_rate_plan_charge_tiers_api import ProductRatePlanChargeTiersApi
from swagger_client.api.product_rate_plan_charges_api import ProductRatePlanChargesApi
from swagger_client.api.product_rate_plans_api import ProductRatePlansApi
from swagger_client.api.products_api import ProductsApi
from swagger_client.api.quotes_document_api import QuotesDocumentApi
from swagger_client.api.rsa_signatures_api import RSASignaturesApi
from swagger_client.api.ramps_api import RampsApi
from swagger_client.api.rate_plan_charge_tiers_api import RatePlanChargeTiersApi
from swagger_client.api.rate_plan_charges_api import RatePlanChargesApi
from swagger_client.api.rate_plans_api import RatePlansApi
from swagger_client.api.refund_invoice_payments_api import RefundInvoicePaymentsApi
from swagger_client.api.refund_transaction_logs_api import RefundTransactionLogsApi
from swagger_client.api.refunds_api import RefundsApi
from swagger_client.api.revenue_events_api import RevenueEventsApi
from swagger_client.api.revenue_items_api import RevenueItemsApi
from swagger_client.api.revenue_rules_api import RevenueRulesApi
from swagger_client.api.revenue_schedules_api import RevenueSchedulesApi
from swagger_client.api.sequence_sets_api import SequenceSetsApi
from swagger_client.api.settings_api import SettingsApi
from swagger_client.api.subscription_product_features_api import SubscriptionProductFeaturesApi
from swagger_client.api.subscriptions_api import SubscriptionsApi
from swagger_client.api.summary_journal_entries_api import SummaryJournalEntriesApi
from swagger_client.api.taxation_items_api import TaxationItemsApi
from swagger_client.api.transactions_api import TransactionsApi
from swagger_client.api.unit_of_measure_api import UnitOfMeasureApi
from swagger_client.api.usage_api import UsageApi
from swagger_client.api.users_api import UsersApi
from swagger_client.api.workflows_api import WorkflowsApi
from swagger_client.api.zuora_revenue_integration_api import ZuoraRevenueIntegrationApi

# import ApiClient
from swagger_client.api_client import ApiClient
from swagger_client.configuration import Configuration
# import models into sdk package
from swagger_client.models.account import Account
from swagger_client.models.account_credit_card_holder import AccountCreditCardHolder
from swagger_client.models.account_object_custom_fields import AccountObjectCustomFields
from swagger_client.models.account_object_ns_fields import AccountObjectNSFields
from swagger_client.models.accounting_code_object_custom_fields import AccountingCodeObjectCustomFields
from swagger_client.models.accounting_period_object_custom_fields import AccountingPeriodObjectCustomFields
from swagger_client.models.action_amend_credit_memo import ActionAmendCreditMemo
from swagger_client.models.action_amend_credit_memo_data import ActionAmendCreditMemoData
from swagger_client.models.action_amend_credit_memo_item import ActionAmendCreditMemoItem
from swagger_client.models.action_amend_invoice_data import ActionAmendInvoiceData
from swagger_client.models.action_amend_invoice_item import ActionAmendInvoiceItem
from swagger_client.models.action_amend_subscription_product_feature import ActionAmendSubscriptionProductFeature
from swagger_client.models.action_subscribe_credit_memo import ActionSubscribeCreditMemo
from swagger_client.models.action_subscribe_credit_memo_data import ActionSubscribeCreditMemoData
from swagger_client.models.action_subscribe_credit_memo_item import ActionSubscribeCreditMemoItem
from swagger_client.models.action_subscribe_invoice_data import ActionSubscribeInvoiceData
from swagger_client.models.action_subscribe_invoice_item import ActionSubscribeInvoiceItem
from swagger_client.models.actions_error_response import ActionsErrorResponse
from swagger_client.models.amend_request import AmendRequest
from swagger_client.models.amend_request_amend_options import AmendRequestAmendOptions
from swagger_client.models.amend_request_preview_options import AmendRequestPreviewOptions
from swagger_client.models.amend_result import AmendResult
from swagger_client.models.amendment import Amendment
from swagger_client.models.amendment_object_custom_fields import AmendmentObjectCustomFields
from swagger_client.models.amendment_rate_plan_charge_data import AmendmentRatePlanChargeData
from swagger_client.models.amendment_rate_plan_charge_data_rate_plan_charge import AmendmentRatePlanChargeDataRatePlanCharge
from swagger_client.models.amendment_rate_plan_charge_tier import AmendmentRatePlanChargeTier
from swagger_client.models.amendment_rate_plan_data import AmendmentRatePlanData
from swagger_client.models.apply_credit_memo_type import ApplyCreditMemoType
from swagger_client.models.apply_payment_type import ApplyPaymentType
from swagger_client.models.bad_request_response import BadRequestResponse
from swagger_client.models.bad_request_response_errors import BadRequestResponseErrors
from swagger_client.models.batch_debit_memo_type import BatchDebitMemoType
from swagger_client.models.batch_invoice_type import BatchInvoiceType
from swagger_client.models.bill_to_contact import BillToContact
from swagger_client.models.bill_to_contact_post_order import BillToContactPostOrder
from swagger_client.models.billing_document_query_response_element_type import BillingDocumentQueryResponseElementType
from swagger_client.models.billing_options import BillingOptions
from swagger_client.models.billing_preview_result import BillingPreviewResult
from swagger_client.models.billing_update import BillingUpdate
from swagger_client.models.body_in_setting_value_reponse import BodyInSettingValueReponse
from swagger_client.models.body_in_setting_value_request import BodyInSettingValueRequest
from swagger_client.models.callout_auth import CalloutAuth
from swagger_client.models.callout_merge_fields import CalloutMergeFields
from swagger_client.models.cancel_subscription import CancelSubscription
from swagger_client.models.charge_metrics_data import ChargeMetricsData
from swagger_client.models.charge_metrics_discount_allocation_detail_response import ChargeMetricsDiscountAllocationDetailResponse
from swagger_client.models.charge_metrics_response import ChargeMetricsResponse
from swagger_client.models.charge_model_configuration_type import ChargeModelConfigurationType
from swagger_client.models.charge_model_data_override import ChargeModelDataOverride
from swagger_client.models.charge_model_data_override_charge_model_configuration import ChargeModelDataOverrideChargeModelConfiguration
from swagger_client.models.charge_override import ChargeOverride
from swagger_client.models.charge_override_billing import ChargeOverrideBilling
from swagger_client.models.charge_override_for_evergreen import ChargeOverrideForEvergreen
from swagger_client.models.charge_override_pricing import ChargeOverridePricing
from swagger_client.models.charge_preview_metrics import ChargePreviewMetrics
from swagger_client.models.charge_preview_metrics_cmrr import ChargePreviewMetricsCmrr
from swagger_client.models.charge_preview_metrics_tax import ChargePreviewMetricsTax
from swagger_client.models.charge_preview_metrics_tcb import ChargePreviewMetricsTcb
from swagger_client.models.charge_preview_metrics_tcv import ChargePreviewMetricsTcv
from swagger_client.models.charge_tier import ChargeTier
from swagger_client.models.charge_update import ChargeUpdate
from swagger_client.models.charge_update_for_evergreen import ChargeUpdateForEvergreen
from swagger_client.models.children_setting_value_request import ChildrenSettingValueRequest
from swagger_client.models.common_error_response import CommonErrorResponse
from swagger_client.models.common_reasons_error_response import CommonReasonsErrorResponse
from swagger_client.models.common_reasons_error_response_reasons import CommonReasonsErrorResponseReasons
from swagger_client.models.common_response_type import CommonResponseType
from swagger_client.models.common_response_type_reasons import CommonResponseTypeReasons
from swagger_client.models.contact import Contact
from swagger_client.models.contact_object_custom_fields import ContactObjectCustomFields
from swagger_client.models.create_entity_response_type import CreateEntityResponseType
from swagger_client.models.create_entity_type import CreateEntityType
from swagger_client.models.create_order_charge_override import CreateOrderChargeOverride
from swagger_client.models.create_order_charge_update import CreateOrderChargeUpdate
from swagger_client.models.create_order_create_subscription import CreateOrderCreateSubscription
from swagger_client.models.create_order_create_subscription_new_subscription_owner_account import CreateOrderCreateSubscriptionNewSubscriptionOwnerAccount
from swagger_client.models.create_order_create_subscription_terms import CreateOrderCreateSubscriptionTerms
from swagger_client.models.create_order_create_subscription_terms_initial_term import CreateOrderCreateSubscriptionTermsInitialTerm
from swagger_client.models.create_order_order_action import CreateOrderOrderAction
from swagger_client.models.create_order_pricing_update import CreateOrderPricingUpdate
from swagger_client.models.create_order_rate_plan_override import CreateOrderRatePlanOverride
from swagger_client.models.create_order_rate_plan_update import CreateOrderRatePlanUpdate
from swagger_client.models.create_order_resume import CreateOrderResume
from swagger_client.models.create_order_suspend import CreateOrderSuspend
from swagger_client.models.create_order_terms_and_conditions import CreateOrderTermsAndConditions
from swagger_client.models.create_order_trigger_params import CreateOrderTriggerParams
from swagger_client.models.create_order_update_product_trigger_params import CreateOrderUpdateProductTriggerParams
from swagger_client.models.create_pm_pay_pal_ec_pay_pal_native_ec import CreatePMPayPalECPayPalNativeEC
from swagger_client.models.create_payment_method_ach import CreatePaymentMethodACH
from swagger_client.models.create_payment_method_bank_transfer import CreatePaymentMethodBankTransfer
from swagger_client.models.create_payment_method_bank_transfer_account_holder_info import CreatePaymentMethodBankTransferAccountHolderInfo
from swagger_client.models.create_payment_method_cardholder_info import CreatePaymentMethodCardholderInfo
from swagger_client.models.create_payment_method_common import CreatePaymentMethodCommon
from swagger_client.models.create_payment_method_credit_card import CreatePaymentMethodCreditCard
from swagger_client.models.create_payment_method_pay_pal_adaptive import CreatePaymentMethodPayPalAdaptive
from swagger_client.models.create_payment_type import CreatePaymentType
from swagger_client.models.create_payment_type_finance_information import CreatePaymentTypeFinanceInformation
from swagger_client.models.create_payment_type_gateway_options import CreatePaymentTypeGatewayOptions
from swagger_client.models.create_stored_credential_profile_request import CreateStoredCredentialProfileRequest
from swagger_client.models.create_subscription import CreateSubscription
from swagger_client.models.create_subscription_for_evergreen import CreateSubscriptionForEvergreen
from swagger_client.models.create_subscription_for_evergreen_new_subscription_owner_account import CreateSubscriptionForEvergreenNewSubscriptionOwnerAccount
from swagger_client.models.create_subscription_new_subscription_owner_account import CreateSubscriptionNewSubscriptionOwnerAccount
from swagger_client.models.create_subscription_terms import CreateSubscriptionTerms
from swagger_client.models.credit_balance_adjustment_object_custom_fields import CreditBalanceAdjustmentObjectCustomFields
from swagger_client.models.credit_balance_adjustment_object_ns_fields import CreditBalanceAdjustmentObjectNSFields
from swagger_client.models.credit_card import CreditCard
from swagger_client.models.credit_memo_apply_debit_memo_item_request_type import CreditMemoApplyDebitMemoItemRequestType
from swagger_client.models.credit_memo_apply_debit_memo_request_type import CreditMemoApplyDebitMemoRequestType
from swagger_client.models.credit_memo_apply_invoice_item_request_type import CreditMemoApplyInvoiceItemRequestType
from swagger_client.models.credit_memo_apply_invoice_request_type import CreditMemoApplyInvoiceRequestType
from swagger_client.models.credit_memo_entity_prefix import CreditMemoEntityPrefix
from swagger_client.models.credit_memo_from_charge_detail_type import CreditMemoFromChargeDetailType
from swagger_client.models.credit_memo_from_charge_detail_type_finance_information import CreditMemoFromChargeDetailTypeFinanceInformation
from swagger_client.models.credit_memo_from_charge_type import CreditMemoFromChargeType
from swagger_client.models.credit_memo_from_invoice_type import CreditMemoFromInvoiceType
from swagger_client.models.credit_memo_item_from_invoice_item_type import CreditMemoItemFromInvoiceItemType
from swagger_client.models.credit_memo_item_from_invoice_item_type_finance_information import CreditMemoItemFromInvoiceItemTypeFinanceInformation
from swagger_client.models.credit_memo_item_from_write_off_invoice import CreditMemoItemFromWriteOffInvoice
from swagger_client.models.credit_memo_item_object_custom_fields import CreditMemoItemObjectCustomFields
from swagger_client.models.credit_memo_object_custom_fields import CreditMemoObjectCustomFields
from swagger_client.models.credit_memo_object_ns_fields import CreditMemoObjectNSFields
from swagger_client.models.credit_memo_response_type import CreditMemoResponseType
from swagger_client.models.credit_memo_result import CreditMemoResult
from swagger_client.models.credit_memo_result_credit_memo import CreditMemoResultCreditMemo
from swagger_client.models.credit_memo_tax_item_from_invoice_tax_item_type import CreditMemoTaxItemFromInvoiceTaxItemType
from swagger_client.models.credit_memo_tax_item_from_invoice_tax_item_type_finance_information import CreditMemoTaxItemFromInvoiceTaxItemTypeFinanceInformation
from swagger_client.models.credit_memo_unapply_debit_memo_item_request_type import CreditMemoUnapplyDebitMemoItemRequestType
from swagger_client.models.credit_memo_unapply_debit_memo_request_type import CreditMemoUnapplyDebitMemoRequestType
from swagger_client.models.credit_memo_unapply_invoice_item_request_type import CreditMemoUnapplyInvoiceItemRequestType
from swagger_client.models.credit_memo_unapply_invoice_request_type import CreditMemoUnapplyInvoiceRequestType
from swagger_client.models.credit_taxation_item_object_custom_fields import CreditTaxationItemObjectCustomFields
from swagger_client.models.custom_object_all_fields_definition import CustomObjectAllFieldsDefinition
from swagger_client.models.custom_object_all_fields_definition_created_by_id import CustomObjectAllFieldsDefinitionCreatedById
from swagger_client.models.custom_object_all_fields_definition_created_date import CustomObjectAllFieldsDefinitionCreatedDate
from swagger_client.models.custom_object_all_fields_definition_id import CustomObjectAllFieldsDefinitionId
from swagger_client.models.custom_object_all_fields_definition_updated_by_id import CustomObjectAllFieldsDefinitionUpdatedById
from swagger_client.models.custom_object_all_fields_definition_updated_date import CustomObjectAllFieldsDefinitionUpdatedDate
from swagger_client.models.custom_object_custom_field_definition import CustomObjectCustomFieldDefinition
from swagger_client.models.custom_object_custom_field_definition_update import CustomObjectCustomFieldDefinitionUpdate
from swagger_client.models.custom_object_custom_fields_definition import CustomObjectCustomFieldsDefinition
from swagger_client.models.custom_object_definition import CustomObjectDefinition
from swagger_client.models.custom_object_definition_schema import CustomObjectDefinitionSchema
from swagger_client.models.custom_object_definition_schema_relationships import CustomObjectDefinitionSchemaRelationships
from swagger_client.models.custom_object_definition_update_action_request import CustomObjectDefinitionUpdateActionRequest
from swagger_client.models.custom_object_definition_update_action_request_relationship import CustomObjectDefinitionUpdateActionRequestRelationship
from swagger_client.models.custom_object_definition_update_action_response import CustomObjectDefinitionUpdateActionResponse
from swagger_client.models.custom_object_definitions import CustomObjectDefinitions
from swagger_client.models.custom_object_record_batch_action import CustomObjectRecordBatchAction
from swagger_client.models.custom_object_record_batch_request import CustomObjectRecordBatchRequest
from swagger_client.models.custom_object_record_batch_update_mapping import CustomObjectRecordBatchUpdateMapping
from swagger_client.models.custom_object_record_with_all_fields import CustomObjectRecordWithAllFields
from swagger_client.models.custom_object_record_with_only_custom_fields import CustomObjectRecordWithOnlyCustomFields
from swagger_client.models.custom_object_records_error_response import CustomObjectRecordsErrorResponse
from swagger_client.models.custom_object_records_throttled_response import CustomObjectRecordsThrottledResponse
from swagger_client.models.custom_object_records_with_error import CustomObjectRecordsWithError
from swagger_client.models.custom_objects_namespace import CustomObjectsNamespace
from swagger_client.models.delet_entity_response_type import DELETEntityResponseType
from swagger_client.models.data_access_control_field import DataAccessControlField
from swagger_client.models.data_query_error_response import DataQueryErrorResponse
from swagger_client.models.data_query_job import DataQueryJob
from swagger_client.models.data_query_job_cancelled import DataQueryJobCancelled
from swagger_client.models.data_query_job_common import DataQueryJobCommon
from swagger_client.models.debit_memo_collect_request import DebitMemoCollectRequest
from swagger_client.models.debit_memo_collect_request_payment import DebitMemoCollectRequestPayment
from swagger_client.models.debit_memo_collect_response import DebitMemoCollectResponse
from swagger_client.models.debit_memo_collect_response_applied_credit_memos import DebitMemoCollectResponseAppliedCreditMemos
from swagger_client.models.debit_memo_collect_response_applied_payments import DebitMemoCollectResponseAppliedPayments
from swagger_client.models.debit_memo_collect_response_debit_memo import DebitMemoCollectResponseDebitMemo
from swagger_client.models.debit_memo_collect_response_processed_payment import DebitMemoCollectResponseProcessedPayment
from swagger_client.models.debit_memo_entity_prefix import DebitMemoEntityPrefix
from swagger_client.models.debit_memo_from_charge_detail_type import DebitMemoFromChargeDetailType
from swagger_client.models.debit_memo_from_charge_detail_type_finance_information import DebitMemoFromChargeDetailTypeFinanceInformation
from swagger_client.models.debit_memo_from_charge_type import DebitMemoFromChargeType
from swagger_client.models.debit_memo_from_invoice_type import DebitMemoFromInvoiceType
from swagger_client.models.debit_memo_item_from_invoice_item_type import DebitMemoItemFromInvoiceItemType
from swagger_client.models.debit_memo_item_from_invoice_item_type_finance_information import DebitMemoItemFromInvoiceItemTypeFinanceInformation
from swagger_client.models.debit_memo_item_object_custom_fields import DebitMemoItemObjectCustomFields
from swagger_client.models.debit_memo_object_custom_fields import DebitMemoObjectCustomFields
from swagger_client.models.debit_memo_object_ns_fields import DebitMemoObjectNSFields
from swagger_client.models.debit_memo_tax_item_from_invoice_tax_item_type import DebitMemoTaxItemFromInvoiceTaxItemType
from swagger_client.models.debit_memo_tax_item_from_invoice_tax_item_type_finance_information import DebitMemoTaxItemFromInvoiceTaxItemTypeFinanceInformation
from swagger_client.models.debit_taxation_item_object_custom_fields import DebitTaxationItemObjectCustomFields
from swagger_client.models.delete_data_query_job_response import DeleteDataQueryJobResponse
from swagger_client.models.delete_result import DeleteResult
from swagger_client.models.delete_workflow_error import DeleteWorkflowError
from swagger_client.models.delete_workflow_success import DeleteWorkflowSuccess
from swagger_client.models.discount_pricing_override import DiscountPricingOverride
from swagger_client.models.discount_pricing_update import DiscountPricingUpdate
from swagger_client.models.electronic_payment_options import ElectronicPaymentOptions
from swagger_client.models.end_conditions import EndConditions
from swagger_client.models.error401 import Error401
from swagger_client.models.error_response import ErrorResponse
from swagger_client.models.error_response401_record import ErrorResponse401Record
from swagger_client.models.error_response_reasons import ErrorResponseReasons
from swagger_client.models.event_revenue_item_type import EventRevenueItemType
from swagger_client.models.event_trigger import EventTrigger
from swagger_client.models.event_type import EventType
from swagger_client.models.execute_result import ExecuteResult
from swagger_client.models.external_payment_options import ExternalPaymentOptions
from swagger_client.models.feature_object_custom_fields import FeatureObjectCustomFields
from swagger_client.models.fields_additional_properties import FieldsAdditionalProperties
from swagger_client.models.fields_additional_properties_for_post_definition import FieldsAdditionalPropertiesForPostDefinition
from swagger_client.models.filter_rule_parameter_definition import FilterRuleParameterDefinition
from swagger_client.models.filter_rule_parameter_definitions import FilterRuleParameterDefinitions
from swagger_client.models.filter_rule_parameter_values import FilterRuleParameterValues
from swagger_client.models.finance_information import FinanceInformation
from swagger_client.models.geta_payment_gatway_response import GETAPaymentGatwayResponse
from swagger_client.models.getar_payment_type import GETARPaymentType
from swagger_client.models.getar_payment_type_finance_information import GETARPaymentTypeFinanceInformation
from swagger_client.models.getar_payment_typewith_success import GETARPaymentTypewithSuccess
from swagger_client.models.get_account_summary_invoice_type import GETAccountSummaryInvoiceType
from swagger_client.models.get_account_summary_payment_invoice_type import GETAccountSummaryPaymentInvoiceType
from swagger_client.models.get_account_summary_payment_type import GETAccountSummaryPaymentType
from swagger_client.models.get_account_summary_subscription_rate_plan_type import GETAccountSummarySubscriptionRatePlanType
from swagger_client.models.get_account_summary_subscription_type import GETAccountSummarySubscriptionType
from swagger_client.models.get_account_summary_type import GETAccountSummaryType
from swagger_client.models.get_account_summary_type_basic_info import GETAccountSummaryTypeBasicInfo
from swagger_client.models.get_account_summary_type_basic_info_default_payment_method import GETAccountSummaryTypeBasicInfoDefaultPaymentMethod
from swagger_client.models.get_account_summary_type_bill_to_contact import GETAccountSummaryTypeBillToContact
from swagger_client.models.get_account_summary_type_sold_to_contact import GETAccountSummaryTypeSoldToContact
from swagger_client.models.get_account_summary_type_tax_info import GETAccountSummaryTypeTaxInfo
from swagger_client.models.get_account_summary_usage_type import GETAccountSummaryUsageType
from swagger_client.models.get_account_type import GETAccountType
from swagger_client.models.get_account_type_basic_info import GETAccountTypeBasicInfo
from swagger_client.models.get_account_type_bill_to_contact import GETAccountTypeBillToContact
from swagger_client.models.get_account_type_billing_and_payment import GETAccountTypeBillingAndPayment
from swagger_client.models.get_account_type_metrics import GETAccountTypeMetrics
from swagger_client.models.get_account_type_sold_to_contact import GETAccountTypeSoldToContact
from swagger_client.models.get_accounting_code_item_type import GETAccountingCodeItemType
from swagger_client.models.get_accounting_code_item_without_success_type import GETAccountingCodeItemWithoutSuccessType
from swagger_client.models.get_accounting_codes_type import GETAccountingCodesType
from swagger_client.models.get_accounting_period_type import GETAccountingPeriodType
from swagger_client.models.get_accounting_period_type_file_ids import GETAccountingPeriodTypeFileIds
from swagger_client.models.get_accounting_period_without_success_type import GETAccountingPeriodWithoutSuccessType
from swagger_client.models.get_accounting_periods_type import GETAccountingPeriodsType
from swagger_client.models.get_all_custom_object_definitions_in_namespace_response import GETAllCustomObjectDefinitionsInNamespaceResponse
from swagger_client.models.get_amendment_type import GETAmendmentType
from swagger_client.models.get_attachment_response_type import GETAttachmentResponseType
from swagger_client.models.get_attachment_response_without_success_type import GETAttachmentResponseWithoutSuccessType
from swagger_client.models.get_attachments_response_type import GETAttachmentsResponseType
from swagger_client.models.get_billing_document_files_deletion_job_response import GETBillingDocumentFilesDeletionJobResponse
from swagger_client.models.get_billing_documents_response_type import GETBillingDocumentsResponseType
from swagger_client.models.getcm_tax_item_type import GETCMTaxItemType
from swagger_client.models.getcm_tax_item_type_finance_information import GETCMTaxItemTypeFinanceInformation
from swagger_client.models.getcm_tax_item_type_new import GETCMTaxItemTypeNew
from swagger_client.models.get_callout_history_vo_type import GETCalloutHistoryVOType
from swagger_client.models.get_callout_history_v_os_type import GETCalloutHistoryVOsType
from swagger_client.models.get_catalog_type import GETCatalogType
from swagger_client.models.get_charge_rs_detail_type import GETChargeRSDetailType
from swagger_client.models.get_credit_memo_collection_type import GETCreditMemoCollectionType
from swagger_client.models.get_credit_memo_item_part_type import GETCreditMemoItemPartType
from swagger_client.models.get_credit_memo_item_part_typewith_success import GETCreditMemoItemPartTypewithSuccess
from swagger_client.models.get_credit_memo_item_parts_collection_type import GETCreditMemoItemPartsCollectionType
from swagger_client.models.get_credit_memo_item_type import GETCreditMemoItemType
from swagger_client.models.get_credit_memo_item_type_finance_information import GETCreditMemoItemTypeFinanceInformation
from swagger_client.models.get_credit_memo_item_type_taxation_items import GETCreditMemoItemTypeTaxationItems
from swagger_client.models.get_credit_memo_item_typewith_success import GETCreditMemoItemTypewithSuccess
from swagger_client.models.get_credit_memo_item_typewith_success_finance_information import GETCreditMemoItemTypewithSuccessFinanceInformation
from swagger_client.models.get_credit_memo_items_list_type import GETCreditMemoItemsListType
from swagger_client.models.get_credit_memo_part_type import GETCreditMemoPartType
from swagger_client.models.get_credit_memo_part_typewith_success import GETCreditMemoPartTypewithSuccess
from swagger_client.models.get_credit_memo_parts_collection_type import GETCreditMemoPartsCollectionType
from swagger_client.models.get_credit_memo_type import GETCreditMemoType
from swagger_client.models.get_credit_memo_typewith_success import GETCreditMemoTypewithSuccess
from swagger_client.models.get_custom_exchange_rates_data_type import GETCustomExchangeRatesDataType
from swagger_client.models.get_custom_exchange_rates_type import GETCustomExchangeRatesType
from swagger_client.models.getdm_tax_item_type import GETDMTaxItemType
from swagger_client.models.getdm_tax_item_type_finance_information import GETDMTaxItemTypeFinanceInformation
from swagger_client.models.getdm_tax_item_type_new import GETDMTaxItemTypeNew
from swagger_client.models.get_debit_memo_collection_type import GETDebitMemoCollectionType
from swagger_client.models.get_debit_memo_item_collection_type import GETDebitMemoItemCollectionType
from swagger_client.models.get_debit_memo_item_type import GETDebitMemoItemType
from swagger_client.models.get_debit_memo_item_type_finance_information import GETDebitMemoItemTypeFinanceInformation
from swagger_client.models.get_debit_memo_item_type_taxation_items import GETDebitMemoItemTypeTaxationItems
from swagger_client.models.get_debit_memo_item_typewith_success import GETDebitMemoItemTypewithSuccess
from swagger_client.models.get_debit_memo_item_typewith_success_taxation_items import GETDebitMemoItemTypewithSuccessTaxationItems
from swagger_client.models.get_debit_memo_type import GETDebitMemoType
from swagger_client.models.get_debit_memo_typewith_success import GETDebitMemoTypewithSuccess
from swagger_client.models.get_discount_apply_details_type import GETDiscountApplyDetailsType
from swagger_client.models.get_document_properties_response_type import GETDocumentPropertiesResponseType
from swagger_client.models.get_email_history_vo_type import GETEmailHistoryVOType
from swagger_client.models.get_email_history_v_os_type import GETEmailHistoryVOsType
from swagger_client.models.get_entities_response_type import GETEntitiesResponseType
from swagger_client.models.get_entities_response_type_with_id import GETEntitiesResponseTypeWithId
from swagger_client.models.get_entities_type import GETEntitiesType
from swagger_client.models.get_entities_user_accessible_response_type import GETEntitiesUserAccessibleResponseType
from swagger_client.models.get_entity_connections_array_items_type import GETEntityConnectionsArrayItemsType
from swagger_client.models.get_entity_connections_response_type import GETEntityConnectionsResponseType
from swagger_client.models.get_invoice_file_wrapper import GETInvoiceFileWrapper
from swagger_client.models.get_invoice_files_response import GETInvoiceFilesResponse
from swagger_client.models.get_invoice_items_response import GETInvoiceItemsResponse
from swagger_client.models.get_invoice_tax_item_type import GETInvoiceTaxItemType
from swagger_client.models.get_invoice_taxation_items_response import GETInvoiceTaxationItemsResponse
from swagger_client.models.get_invoice_type import GETInvoiceType
from swagger_client.models.get_journal_entries_in_journal_run_type import GETJournalEntriesInJournalRunType
from swagger_client.models.get_journal_entry_detail_type import GETJournalEntryDetailType
from swagger_client.models.get_journal_entry_detail_type_without_success import GETJournalEntryDetailTypeWithoutSuccess
from swagger_client.models.get_journal_entry_item_type import GETJournalEntryItemType
from swagger_client.models.get_journal_entry_segment_type import GETJournalEntrySegmentType
from swagger_client.models.get_journal_run_transaction_type import GETJournalRunTransactionType
from swagger_client.models.get_journal_run_type import GETJournalRunType
from swagger_client.models.get_mass_update_type import GETMassUpdateType
from swagger_client.models.getpm_account_holder_info import GETPMAccountHolderInfo
from swagger_client.models.get_paid_invoices_type import GETPaidInvoicesType
from swagger_client.models.get_payment_gatways_response import GETPaymentGatwaysResponse
from swagger_client.models.get_payment_item_part_collection_type import GETPaymentItemPartCollectionType
from swagger_client.models.get_payment_item_part_type import GETPaymentItemPartType
from swagger_client.models.get_payment_item_part_typewith_success import GETPaymentItemPartTypewithSuccess
from swagger_client.models.get_payment_method_response import GETPaymentMethodResponse
from swagger_client.models.get_payment_method_response_ach import GETPaymentMethodResponseACH
from swagger_client.models.get_payment_method_response_bank_transfer import GETPaymentMethodResponseBankTransfer
from swagger_client.models.get_payment_method_response_credit_card import GETPaymentMethodResponseCreditCard
from swagger_client.models.get_payment_method_response_pay_pal import GETPaymentMethodResponsePayPal
from swagger_client.models.get_payment_method_type import GETPaymentMethodType
from swagger_client.models.get_payment_method_type_card_holder_info import GETPaymentMethodTypeCardHolderInfo
from swagger_client.models.get_payment_methods_type import GETPaymentMethodsType
from swagger_client.models.get_payment_part_type import GETPaymentPartType
from swagger_client.models.get_payment_part_typewith_success import GETPaymentPartTypewithSuccess
from swagger_client.models.get_payment_parts_collection_type import GETPaymentPartsCollectionType
from swagger_client.models.get_payment_run_collection_type import GETPaymentRunCollectionType
from swagger_client.models.get_payment_run_summary_response import GETPaymentRunSummaryResponse
from swagger_client.models.get_payment_run_summary_total_values import GETPaymentRunSummaryTotalValues
from swagger_client.models.get_payment_run_type import GETPaymentRunType
from swagger_client.models.get_payment_type import GETPaymentType
from swagger_client.models.get_payments_type import GETPaymentsType
from swagger_client.models.get_product_discount_apply_details_type import GETProductDiscountApplyDetailsType
from swagger_client.models.get_product_rate_plan_charge_pricing_tier_type import GETProductRatePlanChargePricingTierType
from swagger_client.models.get_product_rate_plan_charge_pricing_type import GETProductRatePlanChargePricingType
from swagger_client.models.get_product_rate_plan_charge_type import GETProductRatePlanChargeType
from swagger_client.models.get_product_rate_plan_type import GETProductRatePlanType
from swagger_client.models.get_product_rate_plans_response import GETProductRatePlansResponse
from swagger_client.models.get_product_type import GETProductType
from swagger_client.models.get_public_email_template_response import GETPublicEmailTemplateResponse
from swagger_client.models.get_public_notification_definition_response import GETPublicNotificationDefinitionResponse
from swagger_client.models.get_public_notification_definition_response_callout import GETPublicNotificationDefinitionResponseCallout
from swagger_client.models.get_public_notification_definition_response_filter_rule import GETPublicNotificationDefinitionResponseFilterRule
from swagger_client.models.getrs_detail_for_product_charge_type import GETRSDetailForProductChargeType
from swagger_client.models.getrs_detail_type import GETRSDetailType
from swagger_client.models.getrs_detail_without_success_type import GETRSDetailWithoutSuccessType
from swagger_client.models.getrs_details_by_charge_type import GETRSDetailsByChargeType
from swagger_client.models.getrs_details_by_product_charge_type import GETRSDetailsByProductChargeType
from swagger_client.models.get_ramp_by_ramp_number_response_type import GETRampByRampNumberResponseType
from swagger_client.models.get_ramp_metrics_by_order_number_response_type import GETRampMetricsByOrderNumberResponseType
from swagger_client.models.get_ramp_metrics_by_ramp_number_response_type import GETRampMetricsByRampNumberResponseType
from swagger_client.models.get_ramp_metrics_by_subscription_key_response_type import GETRampMetricsBySubscriptionKeyResponseType
from swagger_client.models.get_ramps_by_subscription_key_response_type import GETRampsBySubscriptionKeyResponseType
from swagger_client.models.get_refund_collection_type import GETRefundCollectionType
from swagger_client.models.get_refund_credit_memo_type import GETRefundCreditMemoType
from swagger_client.models.get_refund_credit_memo_type_finance_information import GETRefundCreditMemoTypeFinanceInformation
from swagger_client.models.get_refund_item_part_collection_type import GETRefundItemPartCollectionType
from swagger_client.models.get_refund_item_part_type import GETRefundItemPartType
from swagger_client.models.get_refund_item_part_typewith_success import GETRefundItemPartTypewithSuccess
from swagger_client.models.get_refund_part_collection_type import GETRefundPartCollectionType
from swagger_client.models.get_refund_payment_type import GETRefundPaymentType
from swagger_client.models.get_refund_type import GETRefundType
from swagger_client.models.get_refund_typewith_success import GETRefundTypewithSuccess
from swagger_client.models.get_revenue_event_detail_type import GETRevenueEventDetailType
from swagger_client.models.get_revenue_event_detail_without_success_type import GETRevenueEventDetailWithoutSuccessType
from swagger_client.models.get_revenue_event_details_type import GETRevenueEventDetailsType
from swagger_client.models.get_revenue_item_type import GETRevenueItemType
from swagger_client.models.get_revenue_item_type_response import GETRevenueItemTypeResponse
from swagger_client.models.get_revenue_items_type import GETRevenueItemsType
from swagger_client.models.get_revenue_recognition_rule_association_type import GETRevenueRecognitionRuleAssociationType
from swagger_client.models.get_revenue_start_date_setting_type import GETRevenueStartDateSettingType
from swagger_client.models.get_rs_revenue_item_type import GETRsRevenueItemType
from swagger_client.models.get_rs_revenue_items_type import GETRsRevenueItemsType
from swagger_client.models.get_sequence_set_response import GETSequenceSetResponse
from swagger_client.models.get_sequence_sets_response import GETSequenceSetsResponse
from swagger_client.models.get_subscription_product_feature_type import GETSubscriptionProductFeatureType
from swagger_client.models.get_subscription_rate_plan_charges_type import GETSubscriptionRatePlanChargesType
from swagger_client.models.get_subscription_rate_plan_type import GETSubscriptionRatePlanType
from swagger_client.models.get_subscription_type import GETSubscriptionType
from swagger_client.models.get_subscription_type_with_success import GETSubscriptionTypeWithSuccess
from swagger_client.models.get_subscription_wrapper import GETSubscriptionWrapper
from swagger_client.models.get_taxation_item_list_type import GETTaxationItemListType
from swagger_client.models.get_taxation_item_type import GETTaxationItemType
from swagger_client.models.get_taxation_item_typewith_success import GETTaxationItemTypewithSuccess
from swagger_client.models.get_taxation_items_of_credit_memo_item_type import GETTaxationItemsOfCreditMemoItemType
from swagger_client.models.get_taxation_items_of_debit_memo_item_type import GETTaxationItemsOfDebitMemoItemType
from swagger_client.models.get_tier_type import GETTierType
from swagger_client.models.get_usage_type import GETUsageType
from swagger_client.models.get_usage_wrapper import GETUsageWrapper
from swagger_client.models.gateway_option import GatewayOption
from swagger_client.models.generate_billing_document_response_type import GenerateBillingDocumentResponseType
from swagger_client.models.get_all_orders_response_type import GetAllOrdersResponseType
from swagger_client.models.get_billing_preview_run_response import GetBillingPreviewRunResponse
from swagger_client.models.get_custom_objects_all_namespaces_response import GetCustomObjectsAllNamespacesResponse
from swagger_client.models.get_data_query_job_response import GetDataQueryJobResponse
from swagger_client.models.get_data_query_jobs_response import GetDataQueryJobsResponse
from swagger_client.models.get_debit_memo_application_part_collection_type import GetDebitMemoApplicationPartCollectionType
from swagger_client.models.get_debit_memo_application_part_type import GetDebitMemoApplicationPartType
from swagger_client.models.get_hosted_page_type import GetHostedPageType
from swagger_client.models.get_hosted_pages_type import GetHostedPagesType
from swagger_client.models.get_invoice_application_part_collection_type import GetInvoiceApplicationPartCollectionType
from swagger_client.models.get_invoice_application_part_type import GetInvoiceApplicationPartType
from swagger_client.models.get_order_response import GetOrderResponse
from swagger_client.models.get_order_response_for_evergreen import GetOrderResponseForEvergreen
from swagger_client.models.get_order_resume import GetOrderResume
from swagger_client.models.get_order_suspend import GetOrderSuspend
from swagger_client.models.get_orders_response import GetOrdersResponse
from swagger_client.models.get_product_feature_type import GetProductFeatureType
from swagger_client.models.get_stored_credential_profiles_response import GetStoredCredentialProfilesResponse
from swagger_client.models.get_stored_credential_profiles_response_profiles import GetStoredCredentialProfilesResponseProfiles
from swagger_client.models.get_subscription_term_info_response_type import GetSubscriptionTermInfoResponseType
from swagger_client.models.get_workflow_response import GetWorkflowResponse
from swagger_client.models.get_workflow_response_tasks import GetWorkflowResponseTasks
from swagger_client.models.get_workflows_response import GetWorkflowsResponse
from swagger_client.models.get_workflows_response_pagination import GetWorkflowsResponsePagination
from swagger_client.models.initial_term import InitialTerm
from swagger_client.models.inline_response200 import InlineResponse200
from swagger_client.models.inline_response2001 import InlineResponse2001
from swagger_client.models.inline_response2002 import InlineResponse2002
from swagger_client.models.inline_response2003 import InlineResponse2003
from swagger_client.models.inline_response2004 import InlineResponse2004
from swagger_client.models.inline_response2005 import InlineResponse2005
from swagger_client.models.inline_response202 import InlineResponse202
from swagger_client.models.inline_response2021 import InlineResponse2021
from swagger_client.models.inline_response400 import InlineResponse400
from swagger_client.models.inline_response406 import InlineResponse406
from swagger_client.models.invoice import Invoice
from swagger_client.models.invoice_adjustment_object_custom_fields import InvoiceAdjustmentObjectCustomFields
from swagger_client.models.invoice_data_invoice import InvoiceDataInvoice
from swagger_client.models.invoice_entity_prefix import InvoiceEntityPrefix
from swagger_client.models.invoice_file import InvoiceFile
from swagger_client.models.invoice_item import InvoiceItem
from swagger_client.models.invoice_item_adjustment_object_custom_fields import InvoiceItemAdjustmentObjectCustomFields
from swagger_client.models.invoice_item_adjustment_object_ns_fields import InvoiceItemAdjustmentObjectNSFields
from swagger_client.models.invoice_item_object_custom_fields import InvoiceItemObjectCustomFields
from swagger_client.models.invoice_item_object_ns_fields import InvoiceItemObjectNSFields
from swagger_client.models.invoice_item_preview_result import InvoiceItemPreviewResult
from swagger_client.models.invoice_item_preview_result_additional_info import InvoiceItemPreviewResultAdditionalInfo
from swagger_client.models.invoice_item_taxation_items import InvoiceItemTaxationItems
from swagger_client.models.invoice_object_custom_fields import InvoiceObjectCustomFields
from swagger_client.models.invoice_object_ns_fields import InvoiceObjectNSFields
from swagger_client.models.invoice_payment import InvoicePayment
from swagger_client.models.invoice_payment_data import InvoicePaymentData
from swagger_client.models.invoice_processing_options import InvoiceProcessingOptions
from swagger_client.models.invoice_response_type import InvoiceResponseType
from swagger_client.models.job_result import JobResult
from swagger_client.models.job_result_subscriptions import JobResultSubscriptions
from swagger_client.models.journal_entry_item_object_custom_fields import JournalEntryItemObjectCustomFields
from swagger_client.models.journal_entry_object_custom_fields import JournalEntryObjectCustomFields
from swagger_client.models.last_term import LastTerm
from swagger_client.models.linkage import Linkage
from swagger_client.models.list_all_settings_response import ListAllSettingsResponse
from swagger_client.models.list_of_exchange_rates import ListOfExchangeRates
from swagger_client.models.migration_update_custom_object_definitions_request import MigrationUpdateCustomObjectDefinitionsRequest
from swagger_client.models.migration_update_custom_object_definitions_response import MigrationUpdateCustomObjectDefinitionsResponse
from swagger_client.models.modified_stored_credential_profile_response import ModifiedStoredCredentialProfileResponse
from swagger_client.models.new_charge_metrics import NewChargeMetrics
from swagger_client.models.notifications_history_deletion_task_response import NotificationsHistoryDeletionTaskResponse
from swagger_client.models.one_time_flat_fee_pricing_override import OneTimeFlatFeePricingOverride
from swagger_client.models.one_time_per_unit_pricing_override import OneTimePerUnitPricingOverride
from swagger_client.models.one_time_tiered_pricing_override import OneTimeTieredPricingOverride
from swagger_client.models.one_time_volume_pricing_override import OneTimeVolumePricingOverride
from swagger_client.models.order import Order
from swagger_client.models.order_action import OrderAction
from swagger_client.models.order_action_for_evergreen import OrderActionForEvergreen
from swagger_client.models.order_action_object_custom_fields import OrderActionObjectCustomFields
from swagger_client.models.order_for_evergreen import OrderForEvergreen
from swagger_client.models.order_for_evergreen_subscriptions import OrderForEvergreenSubscriptions
from swagger_client.models.order_item import OrderItem
from swagger_client.models.order_metric import OrderMetric
from swagger_client.models.order_metrics_for_evergreen import OrderMetricsForEvergreen
from swagger_client.models.order_object_custom_fields import OrderObjectCustomFields
from swagger_client.models.order_ramp_interval_metrics import OrderRampIntervalMetrics
from swagger_client.models.order_ramp_metrics import OrderRampMetrics
from swagger_client.models.order_subscriptions import OrderSubscriptions
from swagger_client.models.owner_transfer import OwnerTransfer
from swagger_client.models.post_account_response_type import POSTAccountResponseType
from swagger_client.models.post_account_type import POSTAccountType
from swagger_client.models.post_account_type_bill_to_contact import POSTAccountTypeBillToContact
from swagger_client.models.post_account_type_credit_card import POSTAccountTypeCreditCard
from swagger_client.models.post_account_type_credit_card_card_holder_info import POSTAccountTypeCreditCardCardHolderInfo
from swagger_client.models.post_account_type_payment_method import POSTAccountTypePaymentMethod
from swagger_client.models.post_account_type_sold_to_contact import POSTAccountTypeSoldToContact
from swagger_client.models.post_account_type_subscription import POSTAccountTypeSubscription
from swagger_client.models.post_account_type_tax_info import POSTAccountTypeTaxInfo
from swagger_client.models.post_accounting_code_response_type import POSTAccountingCodeResponseType
from swagger_client.models.post_accounting_code_type import POSTAccountingCodeType
from swagger_client.models.post_accounting_period_response_type import POSTAccountingPeriodResponseType
from swagger_client.models.post_accounting_period_type import POSTAccountingPeriodType
from swagger_client.models.post_attachment_response_type import POSTAttachmentResponseType
from swagger_client.models.post_authorize_response import POSTAuthorizeResponse
from swagger_client.models.post_billing_document_files_deletion_job_request import POSTBillingDocumentFilesDeletionJobRequest
from swagger_client.models.post_billing_document_files_deletion_job_response import POSTBillingDocumentFilesDeletionJobResponse
from swagger_client.models.post_billing_preview_credit_memo_item import POSTBillingPreviewCreditMemoItem
from swagger_client.models.post_billing_preview_invoice_item import POSTBillingPreviewInvoiceItem
from swagger_client.models.post_catalog_type import POSTCatalogType
from swagger_client.models.post_decrypt_response_type import POSTDecryptResponseType
from swagger_client.models.post_decryption_type import POSTDecryptionType
from swagger_client.models.post_delay_authorize_capture import POSTDelayAuthorizeCapture
from swagger_client.models.post_distribution_item_type import POSTDistributionItemType
from swagger_client.models.post_document_properties_type import POSTDocumentPropertiesType
from swagger_client.models.post_email_billing_docfrom_bill_run_type import POSTEmailBillingDocfromBillRunType
from swagger_client.models.post_entity_connections_response_type import POSTEntityConnectionsResponseType
from swagger_client.models.post_entity_connections_type import POSTEntityConnectionsType
from swagger_client.models.posthmac_signature_response_type import POSTHMACSignatureResponseType
from swagger_client.models.posthmac_signature_type import POSTHMACSignatureType
from swagger_client.models.post_invoice_collect_credit_memos_type import POSTInvoiceCollectCreditMemosType
from swagger_client.models.post_invoice_collect_invoices_type import POSTInvoiceCollectInvoicesType
from swagger_client.models.post_invoice_collect_response_type import POSTInvoiceCollectResponseType
from swagger_client.models.post_invoice_collect_type import POSTInvoiceCollectType
from swagger_client.models.post_journal_entry_item_type import POSTJournalEntryItemType
from swagger_client.models.post_journal_entry_response_type import POSTJournalEntryResponseType
from swagger_client.models.post_journal_entry_segment_type import POSTJournalEntrySegmentType
from swagger_client.models.post_journal_entry_type import POSTJournalEntryType
from swagger_client.models.post_journal_run_response_type import POSTJournalRunResponseType
from swagger_client.models.post_journal_run_transaction_type import POSTJournalRunTransactionType
from swagger_client.models.post_journal_run_type import POSTJournalRunType
from swagger_client.models.post_mass_update_response_type import POSTMassUpdateResponseType
from swagger_client.models.post_memo_pdf_response import POSTMemoPdfResponse
from swagger_client.models.post_order_preview_request_type import POSTOrderPreviewRequestType
from swagger_client.models.post_order_preview_request_type_subscriptions import POSTOrderPreviewRequestTypeSubscriptions
from swagger_client.models.post_order_request_type import POSTOrderRequestType
from swagger_client.models.post_order_request_type_subscriptions import POSTOrderRequestTypeSubscriptions
from swagger_client.models.postpm_mandate_info import POSTPMMandateInfo
from swagger_client.models.post_payment_method_decryption import POSTPaymentMethodDecryption
from swagger_client.models.post_payment_method_decryption_card_holder_info import POSTPaymentMethodDecryptionCardHolderInfo
from swagger_client.models.post_payment_method_request import POSTPaymentMethodRequest
from swagger_client.models.post_payment_method_response import POSTPaymentMethodResponse
from swagger_client.models.post_payment_method_response_decryption import POSTPaymentMethodResponseDecryption
from swagger_client.models.post_payment_method_response_reasons import POSTPaymentMethodResponseReasons
from swagger_client.models.post_payment_method_response_type import POSTPaymentMethodResponseType
from swagger_client.models.post_payment_method_type import POSTPaymentMethodType
from swagger_client.models.post_payment_method_type_gateway_options import POSTPaymentMethodTypeGatewayOptions
from swagger_client.models.post_payment_run_request import POSTPaymentRunRequest
from swagger_client.models.post_public_email_template_request import POSTPublicEmailTemplateRequest
from swagger_client.models.post_public_notification_definition_request import POSTPublicNotificationDefinitionRequest
from swagger_client.models.post_public_notification_definition_request_callout import POSTPublicNotificationDefinitionRequestCallout
from swagger_client.models.post_public_notification_definition_request_filter_rule import POSTPublicNotificationDefinitionRequestFilterRule
from swagger_client.models.post_quote_doc_response_type import POSTQuoteDocResponseType
from swagger_client.models.post_quote_doc_type import POSTQuoteDocType
from swagger_client.models.postrsa_signature_response_type import POSTRSASignatureResponseType
from swagger_client.models.postrsa_signature_type import POSTRSASignatureType
from swagger_client.models.post_reject_payment_request import POSTRejectPaymentRequest
from swagger_client.models.post_reject_payment_response import POSTRejectPaymentResponse
from swagger_client.models.post_reject_payment_response_finance_information import POSTRejectPaymentResponseFinanceInformation
from swagger_client.models.post_revenue_schedule_by_charge_response_type import POSTRevenueScheduleByChargeResponseType
from swagger_client.models.post_revenue_schedule_by_charge_type import POSTRevenueScheduleByChargeType
from swagger_client.models.post_revenue_schedule_by_charge_type_revenue_event import POSTRevenueScheduleByChargeTypeRevenueEvent
from swagger_client.models.post_revenue_schedule_by_date_range_type import POSTRevenueScheduleByDateRangeType
from swagger_client.models.post_revenue_schedule_by_date_range_type_revenue_event import POSTRevenueScheduleByDateRangeTypeRevenueEvent
from swagger_client.models.post_revenue_schedule_by_transaction_ratably_cm_type import POSTRevenueScheduleByTransactionRatablyCMType
from swagger_client.models.post_revenue_schedule_by_transaction_ratably_dm_type import POSTRevenueScheduleByTransactionRatablyDMType
from swagger_client.models.post_revenue_schedule_by_transaction_ratably_type_revenue_event import POSTRevenueScheduleByTransactionRatablyTypeRevenueEvent
from swagger_client.models.post_revenue_schedule_by_transaction_response_type import POSTRevenueScheduleByTransactionResponseType
from swagger_client.models.post_revenue_schedule_by_transaction_type import POSTRevenueScheduleByTransactionType
from swagger_client.models.post_revenue_schedule_by_transaction_type_revenue_event import POSTRevenueScheduleByTransactionTypeRevenueEvent
from swagger_client.models.post_reverse_payment_request import POSTReversePaymentRequest
from swagger_client.models.post_reverse_payment_response import POSTReversePaymentResponse
from swagger_client.models.post_sc_create_type import POSTScCreateType
from swagger_client.models.post_sequence_set_request import POSTSequenceSetRequest
from swagger_client.models.post_sequence_sets_request import POSTSequenceSetsRequest
from swagger_client.models.post_sequence_sets_response import POSTSequenceSetsResponse
from swagger_client.models.post_settle_payment_request import POSTSettlePaymentRequest
from swagger_client.models.post_settle_payment_response import POSTSettlePaymentResponse
from swagger_client.models.post_srp_create_type import POSTSrpCreateType
from swagger_client.models.post_subscription_cancellation_response_type import POSTSubscriptionCancellationResponseType
from swagger_client.models.post_subscription_cancellation_type import POSTSubscriptionCancellationType
from swagger_client.models.post_subscription_preview_credit_memo_items_type import POSTSubscriptionPreviewCreditMemoItemsType
from swagger_client.models.post_subscription_preview_invoice_items_type import POSTSubscriptionPreviewInvoiceItemsType
from swagger_client.models.post_subscription_preview_response_type import POSTSubscriptionPreviewResponseType
from swagger_client.models.post_subscription_preview_response_type_charge_metrics import POSTSubscriptionPreviewResponseTypeChargeMetrics
from swagger_client.models.post_subscription_preview_response_type_credit_memo import POSTSubscriptionPreviewResponseTypeCreditMemo
from swagger_client.models.post_subscription_preview_type import POSTSubscriptionPreviewType
from swagger_client.models.post_subscription_preview_type_preview_account_info import POSTSubscriptionPreviewTypePreviewAccountInfo
from swagger_client.models.post_subscription_preview_type_preview_account_info_bill_to_contact import POSTSubscriptionPreviewTypePreviewAccountInfoBillToContact
from swagger_client.models.post_subscription_response_type import POSTSubscriptionResponseType
from swagger_client.models.post_subscription_type import POSTSubscriptionType
from swagger_client.models.post_taxation_item_for_cm_type import POSTTaxationItemForCMType
from swagger_client.models.post_taxation_item_for_cm_type_finance_information import POSTTaxationItemForCMTypeFinanceInformation
from swagger_client.models.post_taxation_item_for_dm_type import POSTTaxationItemForDMType
from swagger_client.models.post_taxation_item_for_dm_type_finance_information import POSTTaxationItemForDMTypeFinanceInformation
from swagger_client.models.post_taxation_item_list_for_cm_type import POSTTaxationItemListForCMType
from swagger_client.models.post_taxation_item_list_for_dm_type import POSTTaxationItemListForDMType
from swagger_client.models.post_tier_type import POSTTierType
from swagger_client.models.post_upload_file_response import POSTUploadFileResponse
from swagger_client.models.post_usage_response_type import POSTUsageResponseType
from swagger_client.models.post_void_authorize import POSTVoidAuthorize
from swagger_client.models.post_void_authorize_response import POSTVoidAuthorizeResponse
from swagger_client.models.put_accept_user_access_response_type import PUTAcceptUserAccessResponseType
from swagger_client.models.put_account_type import PUTAccountType
from swagger_client.models.put_account_type_bill_to_contact import PUTAccountTypeBillToContact
from swagger_client.models.put_account_type_sold_to_contact import PUTAccountTypeSoldToContact
from swagger_client.models.put_accounting_code_type import PUTAccountingCodeType
from swagger_client.models.put_accounting_period_type import PUTAccountingPeriodType
from swagger_client.models.put_allocate_manually_type import PUTAllocateManuallyType
from swagger_client.models.put_attachment_type import PUTAttachmentType
from swagger_client.models.put_basic_summary_journal_entry_type import PUTBasicSummaryJournalEntryType
from swagger_client.models.put_batch_debit_memos_request import PUTBatchDebitMemosRequest
from swagger_client.models.put_credit_memo_item_type import PUTCreditMemoItemType
from swagger_client.models.put_credit_memo_type import PUTCreditMemoType
from swagger_client.models.put_debit_memo_item_type import PUTDebitMemoItemType
from swagger_client.models.put_debit_memo_type import PUTDebitMemoType
from swagger_client.models.put_deny_user_access_response_type import PUTDenyUserAccessResponseType
from swagger_client.models.put_document_properties_type import PUTDocumentPropertiesType
from swagger_client.models.put_entity_connections_accept_response_type import PUTEntityConnectionsAcceptResponseType
from swagger_client.models.put_entity_connections_deny_response_type import PUTEntityConnectionsDenyResponseType
from swagger_client.models.put_entity_connections_disconnect_response_type import PUTEntityConnectionsDisconnectResponseType
from swagger_client.models.put_event_ri_detail_type import PUTEventRIDetailType
from swagger_client.models.put_journal_entry_item_type import PUTJournalEntryItemType
from swagger_client.models.put_order_action_trigger_dates_request_type import PUTOrderActionTriggerDatesRequestType
from swagger_client.models.put_order_action_trigger_dates_request_type_charges import PUTOrderActionTriggerDatesRequestTypeCharges
from swagger_client.models.put_order_action_trigger_dates_request_type_order_actions import PUTOrderActionTriggerDatesRequestTypeOrderActions
from swagger_client.models.put_order_action_trigger_dates_request_type_subscriptions import PUTOrderActionTriggerDatesRequestTypeSubscriptions
from swagger_client.models.put_order_action_trigger_dates_request_type_trigger_dates import PUTOrderActionTriggerDatesRequestTypeTriggerDates
from swagger_client.models.put_order_patch_request_type import PUTOrderPatchRequestType
from swagger_client.models.put_order_patch_request_type_order_actions import PUTOrderPatchRequestTypeOrderActions
from swagger_client.models.put_order_patch_request_type_subscriptions import PUTOrderPatchRequestTypeSubscriptions
from swagger_client.models.put_order_trigger_dates_response_type import PUTOrderTriggerDatesResponseType
from swagger_client.models.put_order_trigger_dates_response_type_subscriptions import PUTOrderTriggerDatesResponseTypeSubscriptions
from swagger_client.models.putpm_account_holder_info import PUTPMAccountHolderInfo
from swagger_client.models.putpm_credit_card_info import PUTPMCreditCardInfo
from swagger_client.models.put_payment_method_request import PUTPaymentMethodRequest
from swagger_client.models.put_payment_method_response import PUTPaymentMethodResponse
from swagger_client.models.put_payment_method_response_type import PUTPaymentMethodResponseType
from swagger_client.models.put_payment_method_type import PUTPaymentMethodType
from swagger_client.models.put_payment_run_request import PUTPaymentRunRequest
from swagger_client.models.put_public_callout_options_request import PUTPublicCalloutOptionsRequest
from swagger_client.models.put_public_email_template_request import PUTPublicEmailTemplateRequest
from swagger_client.models.put_public_notification_definition_request import PUTPublicNotificationDefinitionRequest
from swagger_client.models.put_public_notification_definition_request_callout import PUTPublicNotificationDefinitionRequestCallout
from swagger_client.models.put_public_notification_definition_request_filter_rule import PUTPublicNotificationDefinitionRequestFilterRule
from swagger_client.models.putrs_basic_info_type import PUTRSBasicInfoType
from swagger_client.models.putrs_term_type import PUTRSTermType
from swagger_client.models.put_refund_type import PUTRefundType
from swagger_client.models.put_refund_type_finance_information import PUTRefundTypeFinanceInformation
from swagger_client.models.put_renew_subscription_response_type import PUTRenewSubscriptionResponseType
from swagger_client.models.put_renew_subscription_type import PUTRenewSubscriptionType
from swagger_client.models.put_revenue_schedule_response_type import PUTRevenueScheduleResponseType
from swagger_client.models.put_revpro_acc_code_response import PUTRevproAccCodeResponse
from swagger_client.models.put_sc_add_type import PUTScAddType
from swagger_client.models.put_sc_update_type import PUTScUpdateType
from swagger_client.models.put_schedule_ri_detail_type import PUTScheduleRIDetailType
from swagger_client.models.put_send_user_access_request_response_type import PUTSendUserAccessRequestResponseType
from swagger_client.models.put_send_user_access_request_type import PUTSendUserAccessRequestType
from swagger_client.models.put_sequence_set_request import PUTSequenceSetRequest
from swagger_client.models.put_sequence_set_response import PUTSequenceSetResponse
from swagger_client.models.put_specific_date_allocation_type import PUTSpecificDateAllocationType
from swagger_client.models.put_srp_add_type import PUTSrpAddType
from swagger_client.models.put_srp_remove_type import PUTSrpRemoveType
from swagger_client.models.put_srp_update_type import PUTSrpUpdateType
from swagger_client.models.put_subscription_patch_request_type import PUTSubscriptionPatchRequestType
from swagger_client.models.put_subscription_patch_request_type_charges import PUTSubscriptionPatchRequestTypeCharges
from swagger_client.models.put_subscription_patch_request_type_rate_plans import PUTSubscriptionPatchRequestTypeRatePlans
from swagger_client.models.put_subscription_preview_invoice_items_type import PUTSubscriptionPreviewInvoiceItemsType
from swagger_client.models.put_subscription_response_type import PUTSubscriptionResponseType
from swagger_client.models.put_subscription_response_type_charge_metrics import PUTSubscriptionResponseTypeChargeMetrics
from swagger_client.models.put_subscription_response_type_credit_memo import PUTSubscriptionResponseTypeCreditMemo
from swagger_client.models.put_subscription_resume_response_type import PUTSubscriptionResumeResponseType
from swagger_client.models.put_subscription_resume_type import PUTSubscriptionResumeType
from swagger_client.models.put_subscription_suspend_response_type import PUTSubscriptionSuspendResponseType
from swagger_client.models.put_subscription_suspend_type import PUTSubscriptionSuspendType
from swagger_client.models.put_subscription_type import PUTSubscriptionType
from swagger_client.models.put_taxation_item_type import PUTTaxationItemType
from swagger_client.models.put_verify_payment_method_response_type import PUTVerifyPaymentMethodResponseType
from swagger_client.models.put_verify_payment_method_type import PUTVerifyPaymentMethodType
from swagger_client.models.put_write_off_invoice_request import PUTWriteOffInvoiceRequest
from swagger_client.models.put_write_off_invoice_response import PUTWriteOffInvoiceResponse
from swagger_client.models.put_write_off_invoice_response_credit_memo import PUTWriteOffInvoiceResponseCreditMemo
from swagger_client.models.payment_collection_response_type import PaymentCollectionResponseType
from swagger_client.models.payment_debit_memo_application_apply_request_type import PaymentDebitMemoApplicationApplyRequestType
from swagger_client.models.payment_debit_memo_application_create_request_type import PaymentDebitMemoApplicationCreateRequestType
from swagger_client.models.payment_debit_memo_application_item_apply_request_type import PaymentDebitMemoApplicationItemApplyRequestType
from swagger_client.models.payment_debit_memo_application_item_create_request_type import PaymentDebitMemoApplicationItemCreateRequestType
from swagger_client.models.payment_debit_memo_application_item_unapply_request_type import PaymentDebitMemoApplicationItemUnapplyRequestType
from swagger_client.models.payment_debit_memo_application_unapply_request_type import PaymentDebitMemoApplicationUnapplyRequestType
from swagger_client.models.payment_entity_prefix import PaymentEntityPrefix
from swagger_client.models.payment_invoice_application_apply_request_type import PaymentInvoiceApplicationApplyRequestType
from swagger_client.models.payment_invoice_application_create_request_type import PaymentInvoiceApplicationCreateRequestType
from swagger_client.models.payment_invoice_application_item_apply_request_type import PaymentInvoiceApplicationItemApplyRequestType
from swagger_client.models.payment_invoice_application_item_create_request_type import PaymentInvoiceApplicationItemCreateRequestType
from swagger_client.models.payment_invoice_application_item_unapply_request_type import PaymentInvoiceApplicationItemUnapplyRequestType
from swagger_client.models.payment_invoice_application_unapply_request_type import PaymentInvoiceApplicationUnapplyRequestType
from swagger_client.models.payment_method import PaymentMethod
from swagger_client.models.payment_method_object_custom_fields import PaymentMethodObjectCustomFields
from swagger_client.models.payment_object_custom_fields import PaymentObjectCustomFields
from swagger_client.models.payment_object_ns_fields import PaymentObjectNSFields
from swagger_client.models.post_billing_preview_param import PostBillingPreviewParam
from swagger_client.models.post_billing_preview_run_param import PostBillingPreviewRunParam
from swagger_client.models.post_credit_memo_email_request_type import PostCreditMemoEmailRequestType
from swagger_client.models.post_custom_object_definition_field_definition_request import PostCustomObjectDefinitionFieldDefinitionRequest
from swagger_client.models.post_custom_object_definition_fields_definition_request import PostCustomObjectDefinitionFieldsDefinitionRequest
from swagger_client.models.post_custom_object_definition_request import PostCustomObjectDefinitionRequest
from swagger_client.models.post_custom_object_definition_request_relationships import PostCustomObjectDefinitionRequestRelationships
from swagger_client.models.post_custom_object_records_request import PostCustomObjectRecordsRequest
from swagger_client.models.post_custom_object_records_response import PostCustomObjectRecordsResponse
from swagger_client.models.post_debit_memo_email_type import PostDebitMemoEmailType
from swagger_client.models.post_event_trigger_request import PostEventTriggerRequest
from swagger_client.models.post_generate_billing_document_type import PostGenerateBillingDocumentType
from swagger_client.models.post_invoice_email_request_type import PostInvoiceEmailRequestType
from swagger_client.models.post_non_ref_refund_type import PostNonRefRefundType
from swagger_client.models.post_non_ref_refund_type_finance_information import PostNonRefRefundTypeFinanceInformation
from swagger_client.models.post_order_preview_response_type import PostOrderPreviewResponseType
from swagger_client.models.post_order_response_type import PostOrderResponseType
from swagger_client.models.post_order_response_type_ramps import PostOrderResponseTypeRamps
from swagger_client.models.post_order_response_type_subscriptions import PostOrderResponseTypeSubscriptions
from swagger_client.models.post_refund_type import PostRefundType
from swagger_client.models.post_refund_type_finance_information import PostRefundTypeFinanceInformation
from swagger_client.models.preview_account_info import PreviewAccountInfo
from swagger_client.models.preview_contact_info import PreviewContactInfo
from swagger_client.models.preview_options import PreviewOptions
from swagger_client.models.preview_order_charge_override import PreviewOrderChargeOverride
from swagger_client.models.preview_order_charge_update import PreviewOrderChargeUpdate
from swagger_client.models.preview_order_create_subscription import PreviewOrderCreateSubscription
from swagger_client.models.preview_order_create_subscription_new_subscription_owner_account import PreviewOrderCreateSubscriptionNewSubscriptionOwnerAccount
from swagger_client.models.preview_order_order_action import PreviewOrderOrderAction
from swagger_client.models.preview_order_pricing_update import PreviewOrderPricingUpdate
from swagger_client.models.preview_order_rate_plan_override import PreviewOrderRatePlanOverride
from swagger_client.models.preview_order_rate_plan_update import PreviewOrderRatePlanUpdate
from swagger_client.models.preview_order_trigger_params import PreviewOrderTriggerParams
from swagger_client.models.preview_result import PreviewResult
from swagger_client.models.preview_result_charge_metrics import PreviewResultChargeMetrics
from swagger_client.models.preview_result_credit_memos import PreviewResultCreditMemos
from swagger_client.models.preview_result_invoices import PreviewResultInvoices
from swagger_client.models.preview_result_order_actions import PreviewResultOrderActions
from swagger_client.models.preview_result_order_metrics import PreviewResultOrderMetrics
from swagger_client.models.price_change_params import PriceChangeParams
from swagger_client.models.pricing_update import PricingUpdate
from swagger_client.models.pricing_update_for_evergreen import PricingUpdateForEvergreen
from swagger_client.models.processing_options import ProcessingOptions
from swagger_client.models.processing_options_electronic_payment_options import ProcessingOptionsElectronicPaymentOptions
from swagger_client.models.product_feature_object_custom_fields import ProductFeatureObjectCustomFields
from swagger_client.models.product_object_custom_fields import ProductObjectCustomFields
from swagger_client.models.product_object_ns_fields import ProductObjectNSFields
from swagger_client.models.product_rate_plan_charge_object_custom_fields import ProductRatePlanChargeObjectCustomFields
from swagger_client.models.product_rate_plan_charge_object_ns_fields import ProductRatePlanChargeObjectNSFields
from swagger_client.models.product_rate_plan_object_custom_fields import ProductRatePlanObjectCustomFields
from swagger_client.models.product_rate_plan_object_ns_fields import ProductRatePlanObjectNSFields
from swagger_client.models.provision_entity_response_type import ProvisionEntityResponseType
from swagger_client.models.proxy_actionamend_request import ProxyActionamendRequest
from swagger_client.models.proxy_actionamend_response import ProxyActionamendResponse
from swagger_client.models.proxy_actioncreate_request import ProxyActioncreateRequest
from swagger_client.models.proxy_actiondelete_request import ProxyActiondeleteRequest
from swagger_client.models.proxy_actionexecute_request import ProxyActionexecuteRequest
from swagger_client.models.proxy_actiongenerate_request import ProxyActiongenerateRequest
from swagger_client.models.proxy_actionquery_more_request import ProxyActionqueryMoreRequest
from swagger_client.models.proxy_actionquery_more_response import ProxyActionqueryMoreResponse
from swagger_client.models.proxy_actionquery_request import ProxyActionqueryRequest
from swagger_client.models.proxy_actionquery_request_conf import ProxyActionqueryRequestConf
from swagger_client.models.proxy_actionquery_response import ProxyActionqueryResponse
from swagger_client.models.proxy_actionsubscribe_request import ProxyActionsubscribeRequest
from swagger_client.models.proxy_actionupdate_request import ProxyActionupdateRequest
from swagger_client.models.proxy_bad_request_response import ProxyBadRequestResponse
from swagger_client.models.proxy_bad_request_response_errors import ProxyBadRequestResponseErrors
from swagger_client.models.proxy_create_account import ProxyCreateAccount
from swagger_client.models.proxy_create_bill_run import ProxyCreateBillRun
from swagger_client.models.proxy_create_contact import ProxyCreateContact
from swagger_client.models.proxy_create_credit_balance_adjustment import ProxyCreateCreditBalanceAdjustment
from swagger_client.models.proxy_create_export import ProxyCreateExport
from swagger_client.models.proxy_create_feature import ProxyCreateFeature
from swagger_client.models.proxy_create_invoice_adjustment import ProxyCreateInvoiceAdjustment
from swagger_client.models.proxy_create_invoice_payment import ProxyCreateInvoicePayment
from swagger_client.models.proxy_create_or_modify_product_rate_plan_charge_charge_model_configuration import ProxyCreateOrModifyProductRatePlanChargeChargeModelConfiguration
from swagger_client.models.proxy_create_or_modify_product_rate_plan_charge_charge_model_configuration_item import ProxyCreateOrModifyProductRatePlanChargeChargeModelConfigurationItem
from swagger_client.models.proxy_create_or_modify_product_rate_plan_charge_tier_data import ProxyCreateOrModifyProductRatePlanChargeTierData
from swagger_client.models.proxy_create_or_modify_product_rate_plan_charge_tier_data_product_rate_plan_charge_tier import ProxyCreateOrModifyProductRatePlanChargeTierDataProductRatePlanChargeTier
from swagger_client.models.proxy_create_or_modify_response import ProxyCreateOrModifyResponse
from swagger_client.models.proxy_create_payment import ProxyCreatePayment
from swagger_client.models.proxy_create_payment_gateway_option_data import ProxyCreatePaymentGatewayOptionData
from swagger_client.models.proxy_create_payment_method import ProxyCreatePaymentMethod
from swagger_client.models.proxy_create_product import ProxyCreateProduct
from swagger_client.models.proxy_create_product_rate_plan import ProxyCreateProductRatePlan
from swagger_client.models.proxy_create_product_rate_plan_charge import ProxyCreateProductRatePlanCharge
from swagger_client.models.proxy_create_refund import ProxyCreateRefund
from swagger_client.models.proxy_create_refund_refund_invoice_payment_data import ProxyCreateRefundRefundInvoicePaymentData
from swagger_client.models.proxy_create_taxation_item import ProxyCreateTaxationItem
from swagger_client.models.proxy_create_unit_of_measure import ProxyCreateUnitOfMeasure
from swagger_client.models.proxy_create_usage import ProxyCreateUsage
from swagger_client.models.proxy_delete_response import ProxyDeleteResponse
from swagger_client.models.proxy_get_account import ProxyGetAccount
from swagger_client.models.proxy_get_amendment import ProxyGetAmendment
from swagger_client.models.proxy_get_bill_run import ProxyGetBillRun
from swagger_client.models.proxy_get_communication_profile import ProxyGetCommunicationProfile
from swagger_client.models.proxy_get_contact import ProxyGetContact
from swagger_client.models.proxy_get_credit_balance_adjustment import ProxyGetCreditBalanceAdjustment
from swagger_client.models.proxy_get_export import ProxyGetExport
from swagger_client.models.proxy_get_feature import ProxyGetFeature
from swagger_client.models.proxy_get_import import ProxyGetImport
from swagger_client.models.proxy_get_invoice import ProxyGetInvoice
from swagger_client.models.proxy_get_invoice_adjustment import ProxyGetInvoiceAdjustment
from swagger_client.models.proxy_get_invoice_item import ProxyGetInvoiceItem
from swagger_client.models.proxy_get_invoice_item_adjustment import ProxyGetInvoiceItemAdjustment
from swagger_client.models.proxy_get_invoice_payment import ProxyGetInvoicePayment
from swagger_client.models.proxy_get_invoice_split import ProxyGetInvoiceSplit
from swagger_client.models.proxy_get_invoice_split_item import ProxyGetInvoiceSplitItem
from swagger_client.models.proxy_get_payment import ProxyGetPayment
from swagger_client.models.proxy_get_payment_method import ProxyGetPaymentMethod
from swagger_client.models.proxy_get_payment_method_snapshot import ProxyGetPaymentMethodSnapshot
from swagger_client.models.proxy_get_payment_method_transaction_log import ProxyGetPaymentMethodTransactionLog
from swagger_client.models.proxy_get_payment_transaction_log import ProxyGetPaymentTransactionLog
from swagger_client.models.proxy_get_product import ProxyGetProduct
from swagger_client.models.proxy_get_product_feature import ProxyGetProductFeature
from swagger_client.models.proxy_get_product_rate_plan import ProxyGetProductRatePlan
from swagger_client.models.proxy_get_product_rate_plan_charge import ProxyGetProductRatePlanCharge
from swagger_client.models.proxy_get_product_rate_plan_charge_tier import ProxyGetProductRatePlanChargeTier
from swagger_client.models.proxy_get_rate_plan import ProxyGetRatePlan
from swagger_client.models.proxy_get_rate_plan_charge import ProxyGetRatePlanCharge
from swagger_client.models.proxy_get_rate_plan_charge_tier import ProxyGetRatePlanChargeTier
from swagger_client.models.proxy_get_refund import ProxyGetRefund
from swagger_client.models.proxy_get_refund_invoice_payment import ProxyGetRefundInvoicePayment
from swagger_client.models.proxy_get_refund_transaction_log import ProxyGetRefundTransactionLog
from swagger_client.models.proxy_get_subscription import ProxyGetSubscription
from swagger_client.models.proxy_get_subscription_product_feature import ProxyGetSubscriptionProductFeature
from swagger_client.models.proxy_get_taxation_item import ProxyGetTaxationItem
from swagger_client.models.proxy_get_unit_of_measure import ProxyGetUnitOfMeasure
from swagger_client.models.proxy_get_usage import ProxyGetUsage
from swagger_client.models.proxy_modify_account import ProxyModifyAccount
from swagger_client.models.proxy_modify_amendment import ProxyModifyAmendment
from swagger_client.models.proxy_modify_bill_run import ProxyModifyBillRun
from swagger_client.models.proxy_modify_contact import ProxyModifyContact
from swagger_client.models.proxy_modify_credit_balance_adjustment import ProxyModifyCreditBalanceAdjustment
from swagger_client.models.proxy_modify_feature import ProxyModifyFeature
from swagger_client.models.proxy_modify_invoice import ProxyModifyInvoice
from swagger_client.models.proxy_modify_invoice_adjustment import ProxyModifyInvoiceAdjustment
from swagger_client.models.proxy_modify_invoice_payment import ProxyModifyInvoicePayment
from swagger_client.models.proxy_modify_payment import ProxyModifyPayment
from swagger_client.models.proxy_modify_payment_method import ProxyModifyPaymentMethod
from swagger_client.models.proxy_modify_product import ProxyModifyProduct
from swagger_client.models.proxy_modify_product_rate_plan import ProxyModifyProductRatePlan
from swagger_client.models.proxy_modify_product_rate_plan_charge import ProxyModifyProductRatePlanCharge
from swagger_client.models.proxy_modify_product_rate_plan_charge_tier import ProxyModifyProductRatePlanChargeTier
from swagger_client.models.proxy_modify_rate_plan_charge import ProxyModifyRatePlanCharge
from swagger_client.models.proxy_modify_refund import ProxyModifyRefund
from swagger_client.models.proxy_modify_subscription import ProxyModifySubscription
from swagger_client.models.proxy_modify_taxation_item import ProxyModifyTaxationItem
from swagger_client.models.proxy_modify_unit_of_measure import ProxyModifyUnitOfMeasure
from swagger_client.models.proxy_modify_usage import ProxyModifyUsage
from swagger_client.models.proxy_no_data_response import ProxyNoDataResponse
from swagger_client.models.proxy_post_import import ProxyPostImport
from swagger_client.models.proxy_unauthorized_response import ProxyUnauthorizedResponse
from swagger_client.models.put_batch_invoice_type import PutBatchInvoiceType
from swagger_client.models.put_credit_memo_tax_item_type import PutCreditMemoTaxItemType
from swagger_client.models.put_credit_memo_tax_item_type_finance_information import PutCreditMemoTaxItemTypeFinanceInformation
from swagger_client.models.put_debit_memo_tax_item_type import PutDebitMemoTaxItemType
from swagger_client.models.put_debit_memo_tax_item_type_finance_information import PutDebitMemoTaxItemTypeFinanceInformation
from swagger_client.models.put_event_trigger_request import PutEventTriggerRequest
from swagger_client.models.put_event_trigger_request_event_type import PutEventTriggerRequestEventType
from swagger_client.models.put_invoice_response_type import PutInvoiceResponseType
from swagger_client.models.put_invoice_type import PutInvoiceType
from swagger_client.models.put_reverse_invoice_response_type import PutReverseInvoiceResponseType
from swagger_client.models.put_reverse_invoice_response_type_credit_memo import PutReverseInvoiceResponseTypeCreditMemo
from swagger_client.models.put_reverse_invoice_type import PutReverseInvoiceType
from swagger_client.models.put_tasks_request import PutTasksRequest
from swagger_client.models.query_custom_object_records_response import QueryCustomObjectRecordsResponse
from swagger_client.models.quote_object_fields import QuoteObjectFields
from swagger_client.models.ramp_charge_request import RampChargeRequest
from swagger_client.models.ramp_charge_response import RampChargeResponse
from swagger_client.models.ramp_interval_charge_delta_metrics import RampIntervalChargeDeltaMetrics
from swagger_client.models.ramp_interval_charge_delta_metrics_delta_mrr import RampIntervalChargeDeltaMetricsDeltaMrr
from swagger_client.models.ramp_interval_charge_delta_metrics_delta_quantity import RampIntervalChargeDeltaMetricsDeltaQuantity
from swagger_client.models.ramp_interval_charge_metrics import RampIntervalChargeMetrics
from swagger_client.models.ramp_interval_charge_metrics_mrr import RampIntervalChargeMetricsMrr
from swagger_client.models.ramp_interval_metrics import RampIntervalMetrics
from swagger_client.models.ramp_interval_request import RampIntervalRequest
from swagger_client.models.ramp_interval_response import RampIntervalResponse
from swagger_client.models.ramp_metrics import RampMetrics
from swagger_client.models.ramp_request import RampRequest
from swagger_client.models.ramp_response import RampResponse
from swagger_client.models.rate_plan import RatePlan
from swagger_client.models.rate_plan_charge_data import RatePlanChargeData
from swagger_client.models.rate_plan_charge_data_in_rate_plan_data import RatePlanChargeDataInRatePlanData
from swagger_client.models.rate_plan_charge_data_in_rate_plan_data_rate_plan_charge import RatePlanChargeDataInRatePlanDataRatePlanCharge
from swagger_client.models.rate_plan_charge_data_rate_plan_charge import RatePlanChargeDataRatePlanCharge
from swagger_client.models.rate_plan_charge_object_custom_fields import RatePlanChargeObjectCustomFields
from swagger_client.models.rate_plan_charge_tier import RatePlanChargeTier
from swagger_client.models.rate_plan_data import RatePlanData
from swagger_client.models.rate_plan_data_rate_plan import RatePlanDataRatePlan
from swagger_client.models.rate_plan_data_subscription_product_feature_list import RatePlanDataSubscriptionProductFeatureList
from swagger_client.models.rate_plan_object_custom_fields import RatePlanObjectCustomFields
from swagger_client.models.rate_plan_override import RatePlanOverride
from swagger_client.models.rate_plan_override_for_evergreen import RatePlanOverrideForEvergreen
from swagger_client.models.rate_plan_update import RatePlanUpdate
from swagger_client.models.rate_plan_update_for_evergreen import RatePlanUpdateForEvergreen
from swagger_client.models.recurring_flat_fee_pricing_override import RecurringFlatFeePricingOverride
from swagger_client.models.recurring_flat_fee_pricing_update import RecurringFlatFeePricingUpdate
from swagger_client.models.recurring_per_unit_pricing_override import RecurringPerUnitPricingOverride
from swagger_client.models.recurring_per_unit_pricing_update import RecurringPerUnitPricingUpdate
from swagger_client.models.recurring_tiered_pricing_override import RecurringTieredPricingOverride
from swagger_client.models.recurring_tiered_pricing_update import RecurringTieredPricingUpdate
from swagger_client.models.recurring_volume_pricing_override import RecurringVolumePricingOverride
from swagger_client.models.recurring_volume_pricing_update import RecurringVolumePricingUpdate
from swagger_client.models.refund_credit_memo_item_type import RefundCreditMemoItemType
from swagger_client.models.refund_entity_prefix import RefundEntityPrefix
from swagger_client.models.refund_invoice_payment import RefundInvoicePayment
from swagger_client.models.refund_object_custom_fields import RefundObjectCustomFields
from swagger_client.models.refund_object_ns_fields import RefundObjectNSFields
from swagger_client.models.refund_part_response_type import RefundPartResponseType
from swagger_client.models.refund_part_response_typewith_success import RefundPartResponseTypewithSuccess
from swagger_client.models.remove_product import RemoveProduct
from swagger_client.models.renewal_term import RenewalTerm
from swagger_client.models.request import Request
from swagger_client.models.revenue_event_item_object_custom_fields import RevenueEventItemObjectCustomFields
from swagger_client.models.revenue_event_object_custom_fields import RevenueEventObjectCustomFields
from swagger_client.models.revenue_schedule_item_object_custom_fields import RevenueScheduleItemObjectCustomFields
from swagger_client.models.revenue_schedule_item_type import RevenueScheduleItemType
from swagger_client.models.revenue_schedule_object_custom_fields import RevenueScheduleObjectCustomFields
from swagger_client.models.revpro_accounting_codes import RevproAccountingCodes
from swagger_client.models.save_result import SaveResult
from swagger_client.models.setting_item_http_operation import SettingItemHttpOperation
from swagger_client.models.setting_item_http_request_parameter import SettingItemHttpRequestParameter
from swagger_client.models.setting_item_with_operations_information import SettingItemWithOperationsInformation
from swagger_client.models.setting_value_request import SettingValueRequest
from swagger_client.models.setting_value_response import SettingValueResponse
from swagger_client.models.setting_value_response_wrapper import SettingValueResponseWrapper
from swagger_client.models.settings_batch_request import SettingsBatchRequest
from swagger_client.models.settings_batch_response import SettingsBatchResponse
from swagger_client.models.sold_to_contact import SoldToContact
from swagger_client.models.sold_to_contact_post_order import SoldToContactPostOrder
from swagger_client.models.submit_data_query_request import SubmitDataQueryRequest
from swagger_client.models.submit_data_query_request_output import SubmitDataQueryRequestOutput
from swagger_client.models.submit_data_query_response import SubmitDataQueryResponse
from swagger_client.models.subscribe_request import SubscribeRequest
from swagger_client.models.subscribe_request_account import SubscribeRequestAccount
from swagger_client.models.subscribe_request_bill_to_contact import SubscribeRequestBillToContact
from swagger_client.models.subscribe_request_payment_method import SubscribeRequestPaymentMethod
from swagger_client.models.subscribe_request_payment_method_gateway_option_data import SubscribeRequestPaymentMethodGatewayOptionData
from swagger_client.models.subscribe_request_preview_options import SubscribeRequestPreviewOptions
from swagger_client.models.subscribe_request_sold_to_contact import SubscribeRequestSoldToContact
from swagger_client.models.subscribe_request_subscribe_options import SubscribeRequestSubscribeOptions
from swagger_client.models.subscribe_request_subscribe_options_electronic_payment_options import SubscribeRequestSubscribeOptionsElectronicPaymentOptions
from swagger_client.models.subscribe_request_subscribe_options_external_payment_options import SubscribeRequestSubscribeOptionsExternalPaymentOptions
from swagger_client.models.subscribe_request_subscribe_options_subscribe_invoice_processing_options import SubscribeRequestSubscribeOptionsSubscribeInvoiceProcessingOptions
from swagger_client.models.subscribe_request_subscription_data import SubscribeRequestSubscriptionData
from swagger_client.models.subscribe_request_subscription_data_subscription import SubscribeRequestSubscriptionDataSubscription
from swagger_client.models.subscribe_result import SubscribeResult
from swagger_client.models.subscribe_result_charge_metrics_data import SubscribeResultChargeMetricsData
from swagger_client.models.subscribe_result_invoice_result import SubscribeResultInvoiceResult
from swagger_client.models.subscribe_result_invoice_result_invoice import SubscribeResultInvoiceResultInvoice
from swagger_client.models.subscription_object_custom_fields import SubscriptionObjectCustomFields
from swagger_client.models.subscription_object_ns_fields import SubscriptionObjectNSFields
from swagger_client.models.subscription_object_qt_fields import SubscriptionObjectQTFields
from swagger_client.models.subscription_product_feature import SubscriptionProductFeature
from swagger_client.models.subscription_product_feature_list import SubscriptionProductFeatureList
from swagger_client.models.subscription_product_feature_object_custom_fields import SubscriptionProductFeatureObjectCustomFields
from swagger_client.models.task import Task
from swagger_client.models.tasks_response import TasksResponse
from swagger_client.models.tasks_response_pagination import TasksResponsePagination
from swagger_client.models.tax_info import TaxInfo
from swagger_client.models.taxation_item_object_custom_fields import TaxationItemObjectCustomFields
from swagger_client.models.term import Term
from swagger_client.models.terms_and_conditions import TermsAndConditions
from swagger_client.models.time_sliced_elp_net_metrics import TimeSlicedElpNetMetrics
from swagger_client.models.time_sliced_metrics import TimeSlicedMetrics
from swagger_client.models.time_sliced_metrics_for_evergreen import TimeSlicedMetricsForEvergreen
from swagger_client.models.time_sliced_net_metrics import TimeSlicedNetMetrics
from swagger_client.models.time_sliced_net_metrics_for_evergreen import TimeSlicedNetMetricsForEvergreen
from swagger_client.models.time_sliced_tcb_net_metrics import TimeSlicedTcbNetMetrics
from swagger_client.models.time_sliced_tcb_net_metrics_for_evergreen import TimeSlicedTcbNetMetricsForEvergreen
from swagger_client.models.token_response import TokenResponse
from swagger_client.models.transfer_payment_type import TransferPaymentType
from swagger_client.models.trigger_date import TriggerDate
from swagger_client.models.trigger_params import TriggerParams
from swagger_client.models.unapply_credit_memo_type import UnapplyCreditMemoType
from swagger_client.models.unapply_payment_type import UnapplyPaymentType
from swagger_client.models.update_custom_object_cusotm_field import UpdateCustomObjectCusotmField
from swagger_client.models.update_entity_response_type import UpdateEntityResponseType
from swagger_client.models.update_entity_type import UpdateEntityType
from swagger_client.models.update_payment_type import UpdatePaymentType
from swagger_client.models.update_task import UpdateTask
from swagger_client.models.usage import Usage
from swagger_client.models.usage_flat_fee_pricing_override import UsageFlatFeePricingOverride
from swagger_client.models.usage_flat_fee_pricing_update import UsageFlatFeePricingUpdate
from swagger_client.models.usage_object_custom_fields import UsageObjectCustomFields
from swagger_client.models.usage_overage_pricing_override import UsageOveragePricingOverride
from swagger_client.models.usage_overage_pricing_update import UsageOveragePricingUpdate
from swagger_client.models.usage_per_unit_pricing_override import UsagePerUnitPricingOverride
from swagger_client.models.usage_per_unit_pricing_update import UsagePerUnitPricingUpdate
from swagger_client.models.usage_tiered_pricing_override import UsageTieredPricingOverride
from swagger_client.models.usage_tiered_pricing_update import UsageTieredPricingUpdate
from swagger_client.models.usage_tiered_with_overage_pricing_override import UsageTieredWithOveragePricingOverride
from swagger_client.models.usage_tiered_with_overage_pricing_update import UsageTieredWithOveragePricingUpdate
from swagger_client.models.usage_values import UsageValues
from swagger_client.models.usage_volume_pricing_override import UsageVolumePricingOverride
from swagger_client.models.usage_volume_pricing_update import UsageVolumePricingUpdate
from swagger_client.models.usages_response import UsagesResponse
from swagger_client.models.workflow import Workflow
from swagger_client.models.workflow_error import WorkflowError
from swagger_client.models.workflow_instance import WorkflowInstance
from swagger_client.models.z_object import ZObject
from swagger_client.models.z_object_update import ZObjectUpdate
