"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        const compatibleRuntimes = (_b = props.compatibleRuntimes) !== null && _b !== void 0 ? _b : [lambda.Runtime.PYTHON_3_7];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime to use for bundling or PYTHON_3_7
        const runtime = (_c = compatibleRuntimes[0]) !== null && _c !== void 0 ? _c : lambda.Runtime.PYTHON_3_7;
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.bundle({
                entry,
                runtime,
                outputPathSuffix: 'python',
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python.PythonLayerVersion", version: "1.95.2" };
//# sourceMappingURL=data:application/json;base64,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