from divinegift.cipher import decrypt_str, get_cipher, encrypt_str

cipher_key = b'rKKvXPL7OefUAfscsduYOWdtHHC1V0Mo0n5VgLR19tE='

console_template = b'gAAAAABcc7dme0updua4UQ9yQ5mNUF6f2m0RRqjTq-XoBE0RhLSJr22elU3rvTxzmXf0ytCKarUFbxBlZVvBlLt8ebUt9OYStzmPpXO_titLgRof329O-FA_GjwV_lF7ju1cvRQ-tp0-4aX0Sk1IeOfVrSzEsqVrZFSncLuSbU1ZRt6aPvW8GUdNoZo9flUC7_N2O-43fi4cfPPvu85JXq4OXIgQ6C4Mwd0sUiIcYRewlo7MJP4DujRVn4Mjed5fzp5GAYTdjpdndg3CVcv9aJmM3Aq9eqQhLT__tGC6gI_C1bYTQ0yNveelgUmytbJinN5EhMGIxnKxZbbvajRwVW6xuak5otFBglfyhciu7LosjWF-PJ4uAwK0_pJClBwx3C9Eg_flkh-bmkBY-RbXGbhLzVJdJXpPY_n6G3Ozy2A5CceYEf3AR5WmQhMy7_ofEXt1eFIfBvZgWB7SPJx_IdgptQxkOsai4T1GkcXjkJ3Qb-WmW10mKZhu_7YH3RlF7ZKmDy836kdCht8W2AOofZ72-fgZyXUkpqCVkTP2Sf8a1oyw0wsDtRJgoHQOV09s7RtYJBBBicstLtr7OUGl-1hNZasAUtLp7lgiGkye34TyBxScBTURG2kUNDHEFL6QSVlVnBbZxQk_7WH7I9oNwBypCQAwUjO5E_AeqGbIFcy6NTNo_Z1jop-dDMqHPhQytD4fGZdhRUL7xMvPSMh0gKRjm-wqUgef3Lr5kRGCL4ntOvY__sy1NK__xjuiYta3wiRnczwSAOJ9L9seTmDiX7wlbPFdbpJUkccjxywZNZvLVyu8BrIG1BG1IdspmFTlxtyYz4b9_ZYrFPq5zxlC3yOTDF7_j4YymRAkxl0hIj3egd0vA2zk0Ox9pqiSfRkzSoEbb6kRz6biz130366fVwURwAqOj-au6zwvssRz-tBk7up-n51qYw5iABfv6LI3aVczeAx94O28pPJCCU8ZUrX6mivdMTkHe1_yaMNrExfObocZykBEO0tfHg0Qn120JdPO2X1QHXwresmoJmpjsfInYu-Dfn85VwUzlsvMDNpjknGBxgzo42LFByr7d5aMVsb-Z-N-3wR5XCoWsTvC79uMcx334d3ndj8EmZAoTvudmQ7eTfGz1SfPXhsVpq3xtlVksptVITW-Yjv5aFHbU_1q-cb5yk1V3g9KIcRWsUG6x-luWV6YQCmsy_PPwuD_SLtbTtOJL1l8qevHmcgg3J9gdJBQ9AkEW_6gpuinObURaNhUCo4GkEhUwIf8Vwn-t6L9YWg_tIg2Y0VQuJA4GzU4XPYs9dVDCmk_C0z1G0wJ1kybq35P_-XQPQ3PPlmxW-7RGFffUNbEw2InAE8uPkmax2-gotZANizSU3e5f2t_JECklcLo7fZCwD1zOSaruRQBF9onOdmSss4hp3AU_t3_OsY-zBKjtO3PlCkzbBT-ZqIuHvJIQkYOkZ9x9O63i8LUmlBK_lwCpztgTtO37wEwNBRbBIToxk08GkHJZu-oG_E65aGaexI3eGMl-Flxnb6JQqVnR87Ru0u3agTq-cWDcfjAhcxFgqgQo2IUf-8lVSnoAEErBsh2b5DTbcvzOxRx07YlFbAI2MqQRUY_IvHZ6zAg6npsbODSDcWmzId0XUVnMDv4OAMmILO-5nhRh1ekCcRrH8BBfycw8YuEKdWTDdPGsRvDJqxm9rmidLkQ2kjFi2KOLn4pOSorFsNFtdiPL_ThCi9yaJ3IDZCZWxOziJUrEJFPRbR0w_W6lWDphsFrfGrb5-ExDiNGzWXtiVoRg1K4qrdRL6kdXVJNwP0YdOs-HyqmpuheZFiiZDlkmbPWRX4oSWilghNMALYtZWrxxXa4BrNNXiWGkl2i1Vd681VZGYaziCwn8FCb8j6r4HycZdJEmcO0hwuKOi3WmvThUGWskcj44s7umBnGQf20IMeYezCjILt1h7_-JBS4YhSjK1wqiwQ1iN5o7-yLzdqm6niw6j1AuVVN7HRNvziTDDm1Db3Gnmo8Ck4fy_EDCnTw_ZNVgnmvpr--O17XCsLDXMJAC64bw0eyW4LHaFhU_IZOW2Vx4oRoOiWRMrxonQ791Blt4UWiGqzR4WQg_gePP4dFjEWCLmFpQwtLCQJiCpsfj6geEA=='
gui_template = b'gAAAAABcc7gmma_Yb6WFUpFArh0PIh_Kgkk-VGDURE7HRlIp81CwZZVBvozjzyFilBJfSM97lu9f3Ouxs1K06BH710g-W3O-HwehrTvTVGvdPloYKqGsI8wWkvdx7vBP0e-KL1dy1Ld_RuXcR0nrxb57dMIKbgc5EWkLHV82Zal1zapjPdwO0nJYKsmRzIomeDR6JrGvZ3ZOZuD7mxXAWxs9QOSfu7ovDYXpd4Zg1AB9MUrWxVLIn0DmYYb0NrCifS122HgGjyPEqMsPzI2X8bxCp0eD-JCczponz3z1_IT8j7jROLVsSFnFhYjwZmOd7bqoUhZ2_hgRpGFouQlLfgjxvFe62OClMNbkp3mkIiaQNhuTR9lWYyNjOQxtdF6hi8pBix5AvjuH5as4lyzlhHke7nsCrQDba8JGowKNeQxgoqWwDlXwWdHkKyCDSFCUbuFnzLUuq8HnV0t_MoHMtAesIE2lB7kOWdmpMhqwAZYfCX49QOyGm0tSPG1EZAoL3p3ozIlboxKd4aP3pVFJQoi4YIcEWImRQ1dfksYmoE87qvQzSwL6tT2hw_lQ03gOqIKAEP58SiYzTJlMoau5M1qXY1wlgLkmsyP_ql7lOn6PlbkJKcAuSm4XHFdlt5vdUjBipIdJfR0o9OxboIzdnp8QKp_zBmKjrp5hq3Maia-pUZLomnzPxo9_R3waP9ARZNT5kSD4hHM6MkM61cqfEn8ev9hPKsikmjDRdGjPnVVVunHmtMj9P6M5TsXD5-sO7ymFaT_pxul3GuxKZGKSrVGF1ceNWmZtUezvlpjUxYx6-TdjbMgHBWWlpNWi9Ffb2_7L8UwBxBs91BiESBnsYvh9WhnD4czwu8DWoNlPRyEVJuaOWVyZjergqywZTbooXXnLIb_PKwtLfyaaQRxBTiDPuIKWnqZgGaZlXlVNwuo5eYBxuZP059cNBRQxe2oJRzCZ94vIvCBhevwuN7Cdgay8ZviU91cByvPFu8OIQ-Ht2QH9MWc0Zdx8uXh9N9KGUKf_9FaAGSlfNiJBxhh4TmhgnhE9lbLBlSG5u7NyB67AHLzIk6b_EH7KcJjvQT7ZQ2DxLT8sRI7BomDanAbRY7lfZCtC1eC0EMJLMe8troNj4T0C37_PPRLl88QmF7BZwezHi-MeVxnqvTxUJQ2Fa0lmQqwM4DqUr8g9rjQ9WBIJ5mOvLbRPxn_M3xaBaGhH7UKLRSW5hStxZ5eBH1tiD2Xbge_iG_bFPS7O8Onfj5S88XwAHhQOSxBMcbKbIRtgXA9p8GROghvlZClnH0WAWr5YkJ9JJEo_BWofG7dxkdl6Rf_-cuygMFY0dCfSF6HWi6kS4iCgqIjsnUxqax-wS07HV3G6U9Lanq6KVsioaNZvD8OtIHDF42fpjpmHSdH1qu1wRZEYASkZsfe8GtqcW6WvPrMOHVtwTlswF9m64Ua4I22Qch-2UuGXqTL5GZYG53FzLrnziQ24nAmHsmNEpNB-0nXElRDzGfqwHbRDeuM0VatWWQDfJ5KHY_U6_i86XrQspTsz_5W6ozMvjxSs4FrodL8EJ1P7GE2tYLW-bRpmF4w1uFBhHWaRSbuY-blXLVqEzpHRw5JQ_iMF7BSymstldLW18P9e4huOoO9fGNpUwyT38c3LJh6Ffq4NcoIwQK-8RuSEzlGCIi3n84rBSR4M9k-Bvxc9FlPchx8Ya-va-4dHy_EarIIT8i3qnmlAs-Y7OL5SX7q59mixDBOgRjCEWuTQNW8YC4bP29gXFyLbhb76vQs-Oi2o9NyLsKmm5HOPuVtxEDzthBEE4_w9K3GmelDsfEliAG2E4F2uw8S4SprEuxeZRN3sPcX9NiqkdFH5i0lnLpXXx5N3Cqnt5kBk6LWmquRTgVV2DpOUJSU2jzSe21Ez-WhrsNqJeOeqK1HIxYrANSynlOUmmwhOHDii1PsoTTWhMvkn1cLL9PadbB0KjS_RudAIMPCbScWviPRoSMnQnRnYlcYi0FbxDymArj3EN394SHEd0eYHrzVvCYTQ5AtqyTmfQW8z0jNIUiFwARxoBNTkxR5Nn26-22ZL615umNIEA0yKXFRYYj39SGaspuZ_toHu1-kKj0P9-Eh_w9gqI2DZymraD3ADFvFP7rO7e7YMqNHQxVIq_jiRiMiUCBOVfptx_lllEKXCObsk0fx8zj6NCwvf5JGCiwXi5tUTClcMPb9gjcSyLF2wFId7yFb5F5VBz3pD_J3M_LS9m3h_NvMOEbBXHwYPgjyxLHSxTe92v9U2Cbyz5YdFrU0ad1RtVR9S2Tnyw3WX-O4abqBm1wd3tZRPqPHiHCke7Fd07BgpBdiY7LTBl-8lIZNTlAIhca1qVVtI93Y1aTg3nkUBasj9HBj3r60d8GKwZaMCDs05pLlU30jqhVVXhlqPGE87lY1T7ONAl2vDfQDyTRevUD1bB52TMgs_1y5c_v95ODRgZ90VAYQyYPJ9lSAmS2YsW8WatH-T07pbskqgFUvSgOJLKtzSh3ZTL3izeztgZv6fZZKcP1CgW8Fh5sJgX8YcQI91wVE23NSFMbPgtD6I36YFi6a8wX91Of_R7K1165om32djMZvq3rIu4rbr6O8tktVbVJTLAcRTbSNLnkIksrVUlXl4F1A0vkSPLrvuBTZ_yHClcOK3ytYSZbONlgbDXBJwVIw-MKBCXABDSC0oKgvDNCvC5KbTnmslpTA0vZjgI_RgoSRwsb5mY4FlCcccmXY57xzak3_ZpjtjLGtquamIC0Zvd_bHIaYsPtVUnHo4fpnrKJDDsUsJKSPcDipNoUdObXhwfKb3Br8mMSozBzJS1noj0huVRzQiRQaMYyTWPJ6qxO7_5gAnujzrpFxmWCieA4lR_u90Va642RFdFBH-2qlIDdSN9l4cfz7sR-NI2f8kL52xCjhEYPe2Nl00VWwUuLly_CTOWtut3qTukVJSTs-h07UeQHAyE5Hnnndefo_g3XzGLAhjblPK2NERSC5zeXIHnMfXoDYuEHr_V2qdyd9k8p1NZxfjPYVu8aTgPq9NmFXWHj_-EWrync460hDCpreBmZ6rcrCGnZrNzBMSRDqLbAvbl58dcWJLNiwfz7LWg5l0BkAIhLga0INdEP32rIOARNZVQOCNCE963CDKVOd0ewYLO1hHPukLJrruqASFhWkfYobzktOtTLSSZBtYRU2sDZ4oqcq8QUSertAtdl44VchQpo_sy0AfZ9MPg9VVvuObWKc6-lq04LGOYwh7fl0jAaOr_fWEuZh_i7kzFNFsMRXOi7Zvw0hLkJ30mQ5gnpZKp2Txl2qYj7CoH02GKkbeoaH6JQkDz1X_YT0z8y6qrWsYQcWWPCt4zYIXSOK0Yv28PuNfOWrnXMb0SWExBHKK5eCPwRi1fR_HpMu7udPvajCs9IfJE6bm8mYlaX8OGxVSAFfzoi0bTvhY7gup8P_pa5buEUE9AP477shoyg-bhx3zVHMGV7Rr3SJn1L0cBcGci5-GGXSAUSgXVLdq11mu5Tfeplm6LSb3LZNVv87OnaVU9ZFUpI-2ePsH0_-6UeNWE1Z79YCA_vuCg5TIMnip7O71rykxU5NdONqPpVybvWoa98vMcRLzwafbKYzX9t9Bj63TRPrIlkQ8jp09BObL_ZHbtkREjmw0R4V4uPxHAtB7nY9SwA-sF3pdrLr9MoLPlFkIkghjhK-ZqaW8Rn-TvTiab0ygserx5hqAgxMzVT008DnXKAEYXjMixLwWdCOpJgq8cQMQYH1DB7rFMFvuypLNjPG56wo6L-yL8tFGBB0CmzH5nfisvBioGQ=='
config_template = b'gAAAAABcam4IXxB5tsuLAWqnXGH4PQT0tEg8aU_gusJvhR5xEh56Aim_jjtcXmTz2EBJSM8_RPp_nAJvxEf4baDMtzTsBY95VLY-a6MMTRGSUlVOE4nsD5cgp95iXC6MNRYEGNFxYswTI_O8JZyYfF1bEaVz8ISlLlwFCCSHWqnC3MURYWISTXQ8-GXJAR5FDzPHP0A3nvPcP3b3kY8EPPZIW639cUdHNmQv6tr9zPKE3du5Wfe1tV3aEKIgtSVhwfHmI55ZrQ-cQ7Yrkxh740Y3T17CjYWSARSr9R3iA-YK1L1bKq6MgD8bgIP1Lg6tl9BZ1yyjZk3OZtSJmsbuzup_7RxjYY3fY1wKBDydM3GOL3MrE8nwZ3dehRiZzdQNFaJb0S-eK8qPw25NItQYXA4RPLrBJepU6PyuRCQNx5MReKODp1vWs_Wze7l8LhARMnfrBeYFA5vbfLqCXrdYqcDmOuRNV8uIhuLB5jREBsL9lToTuAuCjia1j9UejZejm4v3YNoztffu'
email_config_template = b'gAAAAABcam4qHlH4MHm2hjQV_XOgRFBTluMpHfiFmdXqGHBEUejBqBzB76elHTgZ2X1NT9ZCQMbk9w9XAJ7ZQEMA6SiX1Px-NMezp7F4HMI31Bia2-sPV5WtlCNJBsUaM8e0q4jMLqklBRy1-_nAkUxE4DVYjWVUvOTPcU1szIWWxFVFzjrS1Wpb8KZXR_vsYXDylTxrv5uwlMscCc_RrFANL3K8L-swbfVramykFcvnYhQHbgsqN_n7_MtQ8mfBpwTz6iNoCIC9'


def create_file(filename, text):
    cipher = get_cipher(cipher_key)
    with open(filename, 'w') as f:
        f.write(decrypt_str(text, cipher))


def create_console(filename='main.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, console_template)


def create_gui(filename='main_gui.py'):
    if not filename.endswith('.py'):
        filename += '.py'
    create_file(filename, gui_template)


def create_config(filename='settings.conf'):
    create_file(filename, config_template)


def add_email_config(filename='settings.conf'):
    try:
        with open(filename, 'r') as f:
            text = f.read()
        text += ',\n'
    except:
        text = ''
    cipher = get_cipher(cipher_key)
    text += decrypt_str(email_config_template, cipher)
    config_with_email_template = encrypt_str(text, cipher, get_str=False)
    create_file(filename, config_with_email_template)


if __name__ == '__main__':
    pass
