# Generated by Django 4.0.7 on 2022-08-08 11:01

# Django
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (("basic_access", "Can access this app"),),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Webhook",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the channel this webhook posts to",
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "url",
                    models.CharField(
                        help_text="URL of this webhook, e.g. https://discord.com/api/webhooks/123456/abcdef",
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="You can add notes about this webhook here if you want",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Whether this webhook is active or not",
                    ),
                ),
                (
                    "restricted_to_group",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Restrict ping rights to the following group(s) ...",
                        related_name="discord_announcement_webhook_required_groups",
                        to="auth.group",
                    ),
                ),
            ],
            options={
                "verbose_name": "Webhook",
                "verbose_name_plural": "Webhooks",
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="PingTarget",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "discord_id",
                    models.CharField(
                        blank=True,
                        help_text="ID of the Discord role to ping",
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="You can add notes about this configuration here if you want",
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Whether this ping target is enabled or not",
                    ),
                ),
                (
                    "name",
                    models.OneToOneField(
                        help_text="Name of the Discord role to ping. (Note: This must be an Auth group that is synced to Discord.)",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="discord_announcement_pingtarget",
                        to="auth.group",
                    ),
                ),
                (
                    "restricted_to_group",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Restrict ping rights to the following group(s) ...",
                        related_name="discord_announcement_pingtarget_required_groups",
                        to="auth.group",
                    ),
                ),
            ],
            options={
                "verbose_name": "Discord Ping Target",
                "verbose_name_plural": "Discord Ping Targets",
                "default_permissions": (),
            },
        ),
    ]
