from typing import List, Tuple, Dict
from .ChipQubit import ChipQubit
from .ChipCoupler import ChipCoupler

class ChipError:
    H : int
    W : int
    qubits : List[ChipQubit]
    n_available_qubits : int
    couplers : List[ChipCoupler]
    n_available_couplers : int

    xy_crosstalk : List[List[float]]
    error_arr : List[List[List[float]]]
    alpha_list : List[float]
    mu_list : List[float]
    detune_list : List[float]

    def __init__(self) -> None: ...

    def qubit_name_idx(self, i : int, j : int) -> int: ...
    def qubit_idx(self, i : int, j : int) -> int: ...
    def check_available_pair(self, i : int, j : int) -> bool: ...
    def get_neighbors(self, i : int, j : int) -> List[Tuple[int, int]]: ...
    def get_neighbors_distance_sqrt2(self, i : int, j : int) -> List[Tuple[int, int]]: ...
    def get_neighbors_distance_2(self, i : int, j : int) -> List[Tuple[int, int]]: ...
    def get_distance(self, q1 : int, q2 : int) -> int: ...

    def from_qubits_to_coupler_idx(self, q1 : int, q2 : int) -> int: ...
    def from_qubit_pos_to_coupler_idx(self, q1 : Tuple[int, int], q2 : Tuple[int, int]) -> int: ...
    def from_coupler_idx_to_qubits(self, coupler_idx : int) -> Tuple[int, int]: ...
    def get_neighbor_couplers(self, coupler_id : int) -> List[int]: ...

    def load_file(self, qubit_data_filename : str, 
                  xy_crosstalk_sim_filename : str) -> None: ...

    def initialize_all_qubits(self) -> None: ...
    def list_all_unallocated_qubits(self) -> List[Tuple[int, int]]: ...
    def list_all_allocated_qubits(self) -> List[Tuple[int, int]]: ...
    def assign_qubit_frequencies(self, frequencies : List[float]) -> None : ...
    def assign_qubit_frequencies_full(self, frequencies : List[float]) -> None : ...
    def assign_qubit_frequencies_with_ranges(self, ranges : List[float]) -> None : ...
    def assign_qubit_frequencies_by_idx_dict(self, frequency_dict : Dict[int, float]) -> None : ...
    def assign_qubit_frequencies_by_pair_dict(self, frequency_dict : Dict[Tuple[int, int], float]) -> None : ...
    def list_qubit_freq_ranges(self) -> List[Tuple[float, float]]: ...
    
    def initialize_all_couplers(self) -> None: ...
    def list_all_unallocated_couplers(self) -> List[int]: ...
    def list_all_allocated_couplers(self) -> List[int]: ...
    def assign_coupler_frequencies(self, frequencies : List[float]) -> None: ...
    def assign_coupler_frequencies_by_idx_dict(self, frequency_dict : Dict[int, float]) -> None : ...
    def assign_coupler_frequencies_by_pair_dict(self, frequency_dict : Dict[Tuple[Tuple[int, int], Tuple[int, int]], float]) -> None : ...
    

