# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionResult',
    'GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionItemResult',
    'GetAssignedSubscriptionLineItemsFilterResult',
    'GetAssignedSubscriptionPromotionResult',
    'GetAssignedSubscriptionSkusResult',
    'GetAssignedSubscriptionsAssignedSubscriptionCollectionResult',
    'GetAssignedSubscriptionsAssignedSubscriptionCollectionItemResult',
    'GetAssignedSubscriptionsAssignedSubscriptionCollectionItemPromotionResult',
    'GetAssignedSubscriptionsAssignedSubscriptionCollectionItemSkusResult',
    'GetAssignedSubscriptionsFilterResult',
    'GetDomainGovernancesDomainGovernanceCollectionResult',
    'GetDomainGovernancesDomainGovernanceCollectionItemResult',
    'GetDomainGovernancesFilterResult',
    'GetDomainsDomainCollectionResult',
    'GetDomainsDomainCollectionItemResult',
    'GetDomainsFilterResult',
    'GetLinksFilterResult',
    'GetLinksLinkCollectionResult',
    'GetLinksLinkCollectionItemResult',
    'GetOrganizationTenanciesFilterResult',
    'GetOrganizationTenanciesOrganizationTenancyCollectionResult',
    'GetOrganizationTenanciesOrganizationTenancyCollectionItemResult',
    'GetOrganizationsFilterResult',
    'GetOrganizationsOrganizationCollectionResult',
    'GetOrganizationsOrganizationCollectionItemResult',
    'GetRecipientInvitationsFilterResult',
    'GetRecipientInvitationsRecipientInvitationCollectionResult',
    'GetRecipientInvitationsRecipientInvitationCollectionItemResult',
    'GetSenderInvitationsFilterResult',
    'GetSenderInvitationsSenderInvitationCollectionResult',
    'GetSenderInvitationsSenderInvitationCollectionItemResult',
    'GetSubscriptionAvailableRegionsAvailableRegionCollectionResult',
    'GetSubscriptionAvailableRegionsAvailableRegionCollectionItemResult',
    'GetSubscriptionAvailableRegionsFilterResult',
    'GetSubscriptionLineItemsFilterResult',
    'GetSubscriptionLineItemsSubscriptionLineItemCollectionResult',
    'GetSubscriptionLineItemsSubscriptionLineItemCollectionItemResult',
    'GetSubscriptionMappingsFilterResult',
    'GetSubscriptionMappingsSubscriptionMappingCollectionResult',
    'GetSubscriptionMappingsSubscriptionMappingCollectionItemResult',
    'GetSubscriptionPromotionResult',
    'GetSubscriptionSkusResult',
    'GetSubscriptionsFilterResult',
    'GetSubscriptionsSubscriptionCollectionResult',
    'GetSubscriptionsSubscriptionCollectionItemResult',
    'GetSubscriptionsSubscriptionCollectionItemPromotionResult',
    'GetSubscriptionsSubscriptionCollectionItemSkusResult',
]

@pulumi.output_type
class GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionItemResult']):
        """
        :param Sequence['GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionItemArgs'] items: Array containing line item summaries in an assigned subscription.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionItemResult']:
        """
        Array containing line item summaries in an assigned subscription.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAssignedSubscriptionLineItemsAssignedSubscriptionLineItemCollectionItemResult(dict):
    def __init__(__self__, *,
                 billing_model: str,
                 id: str,
                 product_code: str,
                 quantity: float,
                 system_tags: Mapping[str, str],
                 time_ended: str,
                 time_started: str):
        """
        :param str billing_model: Billing model supported by the associated line item.
        :param str id: Subscription line item identifier.
        :param str product_code: Product code.
        :param float quantity: Product number.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_ended: The time the subscription item and associated products should end. An RFC 3339 formatted date and time string.
        :param str time_started: The time the subscription item and associated products should start. An RFC 3339 formatted date and time string.
        """
        pulumi.set(__self__, "billing_model", billing_model)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="billingModel")
    def billing_model(self) -> str:
        """
        Billing model supported by the associated line item.
        """
        return pulumi.get(self, "billing_model")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Subscription line item identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        """
        Product code.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter
    def quantity(self) -> float:
        """
        Product number.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The time the subscription item and associated products should end. An RFC 3339 formatted date and time string.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The time the subscription item and associated products should start. An RFC 3339 formatted date and time string.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetAssignedSubscriptionLineItemsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAssignedSubscriptionPromotionResult(dict):
    def __init__(__self__, *,
                 amount: float,
                 currency_unit: str,
                 duration: int,
                 duration_unit: str,
                 is_intent_to_pay: bool,
                 status: str,
                 time_expired: str,
                 time_started: str):
        """
        :param float amount: If a subscription is present, indicates the total amount of promotional subscription credits.
        :param str currency_unit: Currency unit associated with the promotion.
        :param int duration: Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        :param str duration_unit: Unit for the duration.
        :param bool is_intent_to_pay: Speficies whether or not the customer intends to pay after the promotion has expired.
        :param str status: If a subscription is present, indicates the current status of the subscription promotion.
        :param str time_expired: Date and time when the promotion ends.
        :param str time_started: Date and time when the promotion starts.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "currency_unit", currency_unit)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_expired", time_expired)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter
    def amount(self) -> float:
        """
        If a subscription is present, indicates the total amount of promotional subscription credits.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="currencyUnit")
    def currency_unit(self) -> str:
        """
        Currency unit associated with the promotion.
        """
        return pulumi.get(self, "currency_unit")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> str:
        """
        Unit for the duration.
        """
        return pulumi.get(self, "duration_unit")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> bool:
        """
        Speficies whether or not the customer intends to pay after the promotion has expired.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        If a subscription is present, indicates the current status of the subscription promotion.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeExpired")
    def time_expired(self) -> str:
        """
        Date and time when the promotion ends.
        """
        return pulumi.get(self, "time_expired")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Date and time when the promotion starts.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetAssignedSubscriptionSkusResult(dict):
    def __init__(__self__, *,
                 description: str,
                 end_date: str,
                 gsi_order_line_id: str,
                 is_additional_instance: bool,
                 is_base_service_component: bool,
                 license_part_description: str,
                 metric_name: str,
                 quantity: int,
                 sku: str,
                 start_date: str):
        """
        :param str description: Description of the stock units.
        :param str end_date: Date and time when the SKU ended.
        :param str gsi_order_line_id: Sales order line identifier.
        :param bool is_additional_instance: Specifies if an additional test instance can be provisioned by the SaaS application.
        :param bool is_base_service_component: Specifies if the SKU is considered as a parent or child.
        :param str license_part_description: Description of the covered product belonging to this SKU.
        :param str metric_name: Base metric for billing the service.
        :param int quantity: Quantity of the stock units.
        :param str sku: Stock Keeping Unit (SKU) ID.
        :param str start_date: Subscription start time.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "gsi_order_line_id", gsi_order_line_id)
        pulumi.set(__self__, "is_additional_instance", is_additional_instance)
        pulumi.set(__self__, "is_base_service_component", is_base_service_component)
        pulumi.set(__self__, "license_part_description", license_part_description)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "start_date", start_date)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the stock units.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="gsiOrderLineId")
    def gsi_order_line_id(self) -> str:
        """
        Sales order line identifier.
        """
        return pulumi.get(self, "gsi_order_line_id")

    @property
    @pulumi.getter(name="isAdditionalInstance")
    def is_additional_instance(self) -> bool:
        """
        Specifies if an additional test instance can be provisioned by the SaaS application.
        """
        return pulumi.get(self, "is_additional_instance")

    @property
    @pulumi.getter(name="isBaseServiceComponent")
    def is_base_service_component(self) -> bool:
        """
        Specifies if the SKU is considered as a parent or child.
        """
        return pulumi.get(self, "is_base_service_component")

    @property
    @pulumi.getter(name="licensePartDescription")
    def license_part_description(self) -> str:
        """
        Description of the covered product belonging to this SKU.
        """
        return pulumi.get(self, "license_part_description")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Base metric for billing the service.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        Quantity of the stock units.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        Stock Keeping Unit (SKU) ID.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class GetAssignedSubscriptionsAssignedSubscriptionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetAssignedSubscriptionsAssignedSubscriptionCollectionItemResult(dict):
    def __init__(__self__, *,
                 classic_subscription_id: str,
                 cloud_amount_currency: str,
                 compartment_id: str,
                 csi_number: str,
                 currency_code: str,
                 customer_country_code: str,
                 defined_tags: Mapping[str, str],
                 end_date: str,
                 entity_version: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_classic_subscription: bool,
                 is_government_subscription: bool,
                 managed_by: str,
                 order_ids: Sequence[str],
                 program_type: str,
                 promotions: Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionItemPromotionResult'],
                 purchase_entitlement_id: str,
                 region_assignment: str,
                 service_name: str,
                 skuses: Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionItemSkusResult'],
                 start_date: str,
                 state: str,
                 subscription_number: str,
                 subscription_tier: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str classic_subscription_id: Subscription ID.
        :param str cloud_amount_currency: The currency code for the customer associated with the subscription.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str csi_number: Customer service identifier for the customer associated with the subscription.
        :param str currency_code: Currency code. For example USD, MXN.
        :param str customer_country_code: The country code for the customer associated with the subscription.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str end_date: Date and time when the SKU ended.
        :param str entity_version: The version of the subscription entity.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subscription.
        :param bool is_classic_subscription: Specifies whether or not the subscription is legacy.
        :param bool is_government_subscription: Specifies whether or not the subscription is a government subscription.
        :param str managed_by: Service or component which is used to provision and manage the subscription.
        :param Sequence[str] order_ids: List of subscription order OCIDs that contributed to this subscription.
        :param str program_type: Specifies any program that is associated with the subscription.
        :param Sequence['GetAssignedSubscriptionsAssignedSubscriptionCollectionItemPromotionArgs'] promotions: List of promotions related to the subscription.
        :param str purchase_entitlement_id: Purchase entitlement ID associated with the subscription.
        :param str region_assignment: Region for the subscription.
        :param str service_name: The type of subscription, such as 'UCM', 'SAAS', 'ERP', 'CRM'.
        :param Sequence['GetAssignedSubscriptionsAssignedSubscriptionCollectionItemSkusArgs'] skuses: List of SKUs linked to the subscription.
        :param str start_date: Subscription start time.
        :param str state: Lifecycle state of the subscription.
        :param str subscription_number: Unique Oracle Cloud Subscriptions identifier that is immutable on creation.
        :param str subscription_tier: Tier for the subscription, whether a free promotion subscription or a paid subscription.
        :param str time_created: The date and time of creation, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param str time_updated: The date and time of update, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "classic_subscription_id", classic_subscription_id)
        pulumi.set(__self__, "cloud_amount_currency", cloud_amount_currency)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "csi_number", csi_number)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "customer_country_code", customer_country_code)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "entity_version", entity_version)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_classic_subscription", is_classic_subscription)
        pulumi.set(__self__, "is_government_subscription", is_government_subscription)
        pulumi.set(__self__, "managed_by", managed_by)
        pulumi.set(__self__, "order_ids", order_ids)
        pulumi.set(__self__, "program_type", program_type)
        pulumi.set(__self__, "promotions", promotions)
        pulumi.set(__self__, "purchase_entitlement_id", purchase_entitlement_id)
        pulumi.set(__self__, "region_assignment", region_assignment)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "skuses", skuses)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription_number", subscription_number)
        pulumi.set(__self__, "subscription_tier", subscription_tier)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="classicSubscriptionId")
    def classic_subscription_id(self) -> str:
        """
        Subscription ID.
        """
        return pulumi.get(self, "classic_subscription_id")

    @property
    @pulumi.getter(name="cloudAmountCurrency")
    def cloud_amount_currency(self) -> str:
        """
        The currency code for the customer associated with the subscription.
        """
        return pulumi.get(self, "cloud_amount_currency")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> str:
        """
        Customer service identifier for the customer associated with the subscription.
        """
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code. For example USD, MXN.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="customerCountryCode")
    def customer_country_code(self) -> str:
        """
        The country code for the customer associated with the subscription.
        """
        return pulumi.get(self, "customer_country_code")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="entityVersion")
    def entity_version(self) -> str:
        """
        The version of the subscription entity.
        """
        return pulumi.get(self, "entity_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isClassicSubscription")
    def is_classic_subscription(self) -> bool:
        """
        Specifies whether or not the subscription is legacy.
        """
        return pulumi.get(self, "is_classic_subscription")

    @property
    @pulumi.getter(name="isGovernmentSubscription")
    def is_government_subscription(self) -> bool:
        """
        Specifies whether or not the subscription is a government subscription.
        """
        return pulumi.get(self, "is_government_subscription")

    @property
    @pulumi.getter(name="managedBy")
    def managed_by(self) -> str:
        """
        Service or component which is used to provision and manage the subscription.
        """
        return pulumi.get(self, "managed_by")

    @property
    @pulumi.getter(name="orderIds")
    def order_ids(self) -> Sequence[str]:
        """
        List of subscription order OCIDs that contributed to this subscription.
        """
        return pulumi.get(self, "order_ids")

    @property
    @pulumi.getter(name="programType")
    def program_type(self) -> str:
        """
        Specifies any program that is associated with the subscription.
        """
        return pulumi.get(self, "program_type")

    @property
    @pulumi.getter
    def promotions(self) -> Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionItemPromotionResult']:
        """
        List of promotions related to the subscription.
        """
        return pulumi.get(self, "promotions")

    @property
    @pulumi.getter(name="purchaseEntitlementId")
    def purchase_entitlement_id(self) -> str:
        """
        Purchase entitlement ID associated with the subscription.
        """
        return pulumi.get(self, "purchase_entitlement_id")

    @property
    @pulumi.getter(name="regionAssignment")
    def region_assignment(self) -> str:
        """
        Region for the subscription.
        """
        return pulumi.get(self, "region_assignment")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The type of subscription, such as 'UCM', 'SAAS', 'ERP', 'CRM'.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetAssignedSubscriptionsAssignedSubscriptionCollectionItemSkusResult']:
        """
        List of SKUs linked to the subscription.
        """
        return pulumi.get(self, "skuses")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the subscription.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionNumber")
    def subscription_number(self) -> str:
        """
        Unique Oracle Cloud Subscriptions identifier that is immutable on creation.
        """
        return pulumi.get(self, "subscription_number")

    @property
    @pulumi.getter(name="subscriptionTier")
    def subscription_tier(self) -> str:
        """
        Tier for the subscription, whether a free promotion subscription or a paid subscription.
        """
        return pulumi.get(self, "subscription_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time of creation, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time of update, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAssignedSubscriptionsAssignedSubscriptionCollectionItemPromotionResult(dict):
    def __init__(__self__, *,
                 amount: float,
                 currency_unit: str,
                 duration: int,
                 duration_unit: str,
                 is_intent_to_pay: bool,
                 status: str,
                 time_expired: str,
                 time_started: str):
        """
        :param float amount: If a subscription is present, indicates the total amount of promotional subscription credits.
        :param str currency_unit: Currency unit associated with the promotion.
        :param int duration: Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        :param str duration_unit: Unit for the duration.
        :param bool is_intent_to_pay: Speficies whether or not the customer intends to pay after the promotion has expired.
        :param str status: If a subscription is present, indicates the current status of the subscription promotion.
        :param str time_expired: Date and time when the promotion ends.
        :param str time_started: Date and time when the promotion starts.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "currency_unit", currency_unit)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_expired", time_expired)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter
    def amount(self) -> float:
        """
        If a subscription is present, indicates the total amount of promotional subscription credits.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="currencyUnit")
    def currency_unit(self) -> str:
        """
        Currency unit associated with the promotion.
        """
        return pulumi.get(self, "currency_unit")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> str:
        """
        Unit for the duration.
        """
        return pulumi.get(self, "duration_unit")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> bool:
        """
        Speficies whether or not the customer intends to pay after the promotion has expired.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        If a subscription is present, indicates the current status of the subscription promotion.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeExpired")
    def time_expired(self) -> str:
        """
        Date and time when the promotion ends.
        """
        return pulumi.get(self, "time_expired")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Date and time when the promotion starts.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetAssignedSubscriptionsAssignedSubscriptionCollectionItemSkusResult(dict):
    def __init__(__self__, *,
                 description: str,
                 end_date: str,
                 gsi_order_line_id: str,
                 is_additional_instance: bool,
                 is_base_service_component: bool,
                 license_part_description: str,
                 metric_name: str,
                 quantity: int,
                 sku: str,
                 start_date: str):
        """
        :param str description: Description of the stock units.
        :param str end_date: Date and time when the SKU ended.
        :param str gsi_order_line_id: Sales order line identifier.
        :param bool is_additional_instance: Specifies if an additional test instance can be provisioned by the SaaS application.
        :param bool is_base_service_component: Specifies if the SKU is considered as a parent or child.
        :param str license_part_description: Description of the covered product belonging to this SKU.
        :param str metric_name: Base metric for billing the service.
        :param int quantity: Quantity of the stock units.
        :param str sku: Stock Keeping Unit (SKU) ID.
        :param str start_date: Subscription start time.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "gsi_order_line_id", gsi_order_line_id)
        pulumi.set(__self__, "is_additional_instance", is_additional_instance)
        pulumi.set(__self__, "is_base_service_component", is_base_service_component)
        pulumi.set(__self__, "license_part_description", license_part_description)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "start_date", start_date)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the stock units.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="gsiOrderLineId")
    def gsi_order_line_id(self) -> str:
        """
        Sales order line identifier.
        """
        return pulumi.get(self, "gsi_order_line_id")

    @property
    @pulumi.getter(name="isAdditionalInstance")
    def is_additional_instance(self) -> bool:
        """
        Specifies if an additional test instance can be provisioned by the SaaS application.
        """
        return pulumi.get(self, "is_additional_instance")

    @property
    @pulumi.getter(name="isBaseServiceComponent")
    def is_base_service_component(self) -> bool:
        """
        Specifies if the SKU is considered as a parent or child.
        """
        return pulumi.get(self, "is_base_service_component")

    @property
    @pulumi.getter(name="licensePartDescription")
    def license_part_description(self) -> str:
        """
        Description of the covered product belonging to this SKU.
        """
        return pulumi.get(self, "license_part_description")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Base metric for billing the service.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        Quantity of the stock units.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        Stock Keeping Unit (SKU) ID.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class GetAssignedSubscriptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDomainGovernancesDomainGovernanceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDomainGovernancesDomainGovernanceCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDomainGovernancesDomainGovernanceCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDomainGovernancesDomainGovernanceCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 domain_id: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_governance_enabled: bool,
                 ons_subscription_id: str,
                 ons_topic_id: str,
                 owner_id: str,
                 state: str,
                 subscription_email: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str domain_id: The domain OCID.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the domain governance entity.
        :param bool is_governance_enabled: Indicates whether governance is enabled for this domain.
        :param str ons_subscription_id: The ONS subscription associated with this domain governance entity.
        :param str ons_topic_id: The ONS topic associated with this domain governance entity.
        :param str owner_id: The OCID of the tenancy that owns this domain governance entity.
        :param str state: The lifecycle state of the resource.
        :param str subscription_email: Email address to be used to notify the user, and that the ONS subscription will be created with.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Date-time when this domain governance was created. An RFC 3339-formatted date and time string.
        :param str time_updated: Date-time when this domain governance was last updated. An RFC 3339-formatted date and time string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "domain_id", domain_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_governance_enabled", is_governance_enabled)
        pulumi.set(__self__, "ons_subscription_id", ons_subscription_id)
        pulumi.set(__self__, "ons_topic_id", ons_topic_id)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription_email", subscription_email)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        The domain OCID.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the domain governance entity.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isGovernanceEnabled")
    def is_governance_enabled(self) -> bool:
        """
        Indicates whether governance is enabled for this domain.
        """
        return pulumi.get(self, "is_governance_enabled")

    @property
    @pulumi.getter(name="onsSubscriptionId")
    def ons_subscription_id(self) -> str:
        """
        The ONS subscription associated with this domain governance entity.
        """
        return pulumi.get(self, "ons_subscription_id")

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> str:
        """
        The ONS topic associated with this domain governance entity.
        """
        return pulumi.get(self, "ons_topic_id")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        """
        The OCID of the tenancy that owns this domain governance entity.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionEmail")
    def subscription_email(self) -> str:
        """
        Email address to be used to notify the user, and that the ONS subscription will be created with.
        """
        return pulumi.get(self, "subscription_email")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date-time when this domain governance was created. An RFC 3339-formatted date and time string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date-time when this domain governance was last updated. An RFC 3339-formatted date and time string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDomainGovernancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that exactly match the name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that exactly match the name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDomainsDomainCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDomainsDomainCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDomainsDomainCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDomainsDomainCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 domain_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_governance_enabled: bool,
                 owner_id: str,
                 state: str,
                 status: str,
                 subscription_email: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str,
                 txt_record: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str domain_name: The domain name.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of the domain.
        :param str owner_id: The OCID of the tenancy that has started the registration process for this domain.
        :param str state: The lifecycle state of the resource.
        :param str status: The status of the domain.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Date-time when this domain was created. An RFC 3339-formatted date and time string.
        :param str time_updated: Date-time when this domain was last updated. An RFC 3339-formatted date and time string.
        :param str txt_record: The code that the owner of the domain will need to add as a TXT record to their domain.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_governance_enabled", is_governance_enabled)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscription_email", subscription_email)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "txt_record", txt_record)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the domain.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isGovernanceEnabled")
    def is_governance_enabled(self) -> bool:
        return pulumi.get(self, "is_governance_enabled")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        """
        The OCID of the tenancy that has started the registration process for this domain.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the domain.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionEmail")
    def subscription_email(self) -> str:
        return pulumi.get(self, "subscription_email")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date-time when this domain was created. An RFC 3339-formatted date and time string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date-time when this domain was last updated. An RFC 3339-formatted date and time string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="txtRecord")
    def txt_record(self) -> str:
        """
        The code that the owner of the domain will need to add as a TXT record to their domain.
        """
        return pulumi.get(self, "txt_record")


@pulumi.output_type
class GetDomainsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that exactly match the name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that exactly match the name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLinksFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLinksLinkCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetLinksLinkCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetLinksLinkCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetLinksLinkCollectionItemResult(dict):
    def __init__(__self__, *,
                 child_tenancy_id: str,
                 id: str,
                 parent_tenancy_id: str,
                 state: str,
                 time_created: str,
                 time_terminated: str,
                 time_updated: str):
        """
        :param str child_tenancy_id: The ID of the child tenancy this link is associated with.
        :param str id: OCID of the link.
        :param str parent_tenancy_id: The ID of the parent tenancy this link is associated with.
        :param str state: The lifecycle state of the resource.
        :param str time_created: Date-time when this link was created.
        :param str time_terminated: Date-time when this link was terminated.
        :param str time_updated: Date-time when this link was last updated.
        """
        pulumi.set(__self__, "child_tenancy_id", child_tenancy_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parent_tenancy_id", parent_tenancy_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_terminated", time_terminated)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="childTenancyId")
    def child_tenancy_id(self) -> str:
        """
        The ID of the child tenancy this link is associated with.
        """
        return pulumi.get(self, "child_tenancy_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the link.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentTenancyId")
    def parent_tenancy_id(self) -> str:
        """
        The ID of the parent tenancy this link is associated with.
        """
        return pulumi.get(self, "parent_tenancy_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date-time when this link was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> str:
        """
        Date-time when this link was terminated.
        """
        return pulumi.get(self, "time_terminated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date-time when this link was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetOrganizationTenanciesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the tenancy.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the tenancy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOrganizationTenanciesOrganizationTenancyCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOrganizationTenanciesOrganizationTenancyCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOrganizationTenanciesOrganizationTenancyCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOrganizationTenanciesOrganizationTenancyCollectionItemResult(dict):
    def __init__(__self__, *,
                 governance_status: str,
                 is_approved_for_transfer: bool,
                 name: str,
                 role: str,
                 state: str,
                 tenancy_id: str,
                 time_joined: str,
                 time_left: str):
        """
        :param str governance_status: The governance status of the tenancy.
        :param bool is_approved_for_transfer: Parameter to indicate the tenancy is approved for transfer to another organization.
        :param str name: Name of the tenancy.
        :param str role: Role of the organization tenancy.
        :param str state: Lifecycle state of the organization tenancy.
        :param str tenancy_id: OCID of the tenancy.
        :param str time_joined: Date and time when the tenancy joined the organization.
        :param str time_left: Date and time when the tenancy left the organization.
        """
        pulumi.set(__self__, "governance_status", governance_status)
        pulumi.set(__self__, "is_approved_for_transfer", is_approved_for_transfer)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tenancy_id", tenancy_id)
        pulumi.set(__self__, "time_joined", time_joined)
        pulumi.set(__self__, "time_left", time_left)

    @property
    @pulumi.getter(name="governanceStatus")
    def governance_status(self) -> str:
        """
        The governance status of the tenancy.
        """
        return pulumi.get(self, "governance_status")

    @property
    @pulumi.getter(name="isApprovedForTransfer")
    def is_approved_for_transfer(self) -> bool:
        """
        Parameter to indicate the tenancy is approved for transfer to another organization.
        """
        return pulumi.get(self, "is_approved_for_transfer")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the tenancy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role of the organization tenancy.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the organization tenancy.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        OCID of the tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeJoined")
    def time_joined(self) -> str:
        """
        Date and time when the tenancy joined the organization.
        """
        return pulumi.get(self, "time_joined")

    @property
    @pulumi.getter(name="timeLeft")
    def time_left(self) -> str:
        """
        Date and time when the tenancy left the organization.
        """
        return pulumi.get(self, "time_left")


@pulumi.output_type
class GetOrganizationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOrganizationsOrganizationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOrganizationsOrganizationCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOrganizationsOrganizationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOrganizationsOrganizationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 default_ucm_subscription_id: str,
                 display_name: str,
                 id: str,
                 parent_name: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str default_ucm_subscription_id: OCID of the default Universal Credits Model subscription. Any tenancy joining the organization will automatically get assigned this subscription, if a subscription is not explictly assigned.
        :param str display_name: A display name for the organization. Avoid entering confidential information.
        :param str id: OCID of the organization.
        :param str parent_name: The name of the tenancy that is the organization parent.
        :param str state: Lifecycle state of the organization.
        :param str time_created: Date and time when the organization was created.
        :param str time_updated: Date and time when the organization was last updated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "default_ucm_subscription_id", default_ucm_subscription_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "parent_name", parent_name)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultUcmSubscriptionId")
    def default_ucm_subscription_id(self) -> str:
        """
        OCID of the default Universal Credits Model subscription. Any tenancy joining the organization will automatically get assigned this subscription, if a subscription is not explictly assigned.
        """
        return pulumi.get(self, "default_ucm_subscription_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A display name for the organization. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the organization.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="parentName")
    def parent_name(self) -> str:
        """
        The name of the tenancy that is the organization parent.
        """
        return pulumi.get(self, "parent_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the organization.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time when the organization was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date and time when the organization was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetRecipientInvitationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRecipientInvitationsRecipientInvitationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRecipientInvitationsRecipientInvitationCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRecipientInvitationsRecipientInvitationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRecipientInvitationsRecipientInvitationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 recipient_email_address: str,
                 sender_invitation_id: str,
                 sender_tenancy_id: str,
                 state: str,
                 status: str,
                 subjects: Sequence[str],
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A user-created name to describe the invitation. Avoid entering confidential information.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: OCID of the recipient invitation.
        :param str recipient_email_address: Email address of the recipient.
        :param str sender_invitation_id: OCID of the corresponding sender invitation.
        :param str sender_tenancy_id: The tenancy that sent the invitation.
        :param str state: The lifecycle state of the resource.
        :param str status: The status of the recipient invitation.
        :param Sequence[str] subjects: The list of subjects the invitation contains.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Date and time when the recipient invitation was created.
        :param str time_updated: Date and time when the recipient invitation was last updated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "recipient_email_address", recipient_email_address)
        pulumi.set(__self__, "sender_invitation_id", sender_invitation_id)
        pulumi.set(__self__, "sender_tenancy_id", sender_tenancy_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subjects", subjects)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-created name to describe the invitation. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the recipient invitation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recipientEmailAddress")
    def recipient_email_address(self) -> str:
        """
        Email address of the recipient.
        """
        return pulumi.get(self, "recipient_email_address")

    @property
    @pulumi.getter(name="senderInvitationId")
    def sender_invitation_id(self) -> str:
        """
        OCID of the corresponding sender invitation.
        """
        return pulumi.get(self, "sender_invitation_id")

    @property
    @pulumi.getter(name="senderTenancyId")
    def sender_tenancy_id(self) -> str:
        """
        The tenancy that sent the invitation.
        """
        return pulumi.get(self, "sender_tenancy_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the recipient invitation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subjects(self) -> Sequence[str]:
        """
        The list of subjects the invitation contains.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time when the recipient invitation was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date and time when the recipient invitation was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSenderInvitationsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSenderInvitationsSenderInvitationCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSenderInvitationsSenderInvitationCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSenderInvitationsSenderInvitationCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSenderInvitationsSenderInvitationCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 recipient_email_address: str,
                 recipient_invitation_id: str,
                 recipient_tenancy_id: str,
                 state: str,
                 status: str,
                 subjects: Sequence[str],
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: OCID of the sender invitation.
        :param str recipient_email_address: Email address of the recipient.
        :param str recipient_invitation_id: OCID of the corresponding recipient invitation.
        :param str recipient_tenancy_id: The tenancy that the invitation is addressed to.
        :param str state: The lifecycle state of the resource.
        :param str status: The status of the sender invitation.
        :param Sequence[str] subjects: The list of subjects the invitation contains.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Date and time when the sender invitation was created.
        :param str time_updated: Date and time when the sender invitation was last updated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "recipient_email_address", recipient_email_address)
        pulumi.set(__self__, "recipient_invitation_id", recipient_invitation_id)
        pulumi.set(__self__, "recipient_tenancy_id", recipient_tenancy_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subjects", subjects)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the sender invitation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="recipientEmailAddress")
    def recipient_email_address(self) -> str:
        """
        Email address of the recipient.
        """
        return pulumi.get(self, "recipient_email_address")

    @property
    @pulumi.getter(name="recipientInvitationId")
    def recipient_invitation_id(self) -> str:
        """
        OCID of the corresponding recipient invitation.
        """
        return pulumi.get(self, "recipient_invitation_id")

    @property
    @pulumi.getter(name="recipientTenancyId")
    def recipient_tenancy_id(self) -> str:
        """
        The tenancy that the invitation is addressed to.
        """
        return pulumi.get(self, "recipient_tenancy_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the sender invitation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subjects(self) -> Sequence[str]:
        """
        The list of subjects the invitation contains.
        """
        return pulumi.get(self, "subjects")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time when the sender invitation was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date and time when the sender invitation was last updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSubscriptionAvailableRegionsAvailableRegionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionAvailableRegionsAvailableRegionCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionAvailableRegionsAvailableRegionCollectionItemArgs'] items: Array containing available region items.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionAvailableRegionsAvailableRegionCollectionItemResult']:
        """
        Array containing available region items.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionAvailableRegionsAvailableRegionCollectionItemResult(dict):
    def __init__(__self__, *,
                 region_name: str,
                 system_tags: Mapping[str, str]):
        """
        :param str region_name: Region availability for the subscription.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        pulumi.set(__self__, "region_name", region_name)
        pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="regionName")
    def region_name(self) -> str:
        """
        Region availability for the subscription.
        """
        return pulumi.get(self, "region_name")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")


@pulumi.output_type
class GetSubscriptionAvailableRegionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionLineItemsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionLineItemsSubscriptionLineItemCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionLineItemsSubscriptionLineItemCollectionItemResult']):
        """
        :param Sequence['GetSubscriptionLineItemsSubscriptionLineItemCollectionItemArgs'] items: Array containing line item summaries in a subscription.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionLineItemsSubscriptionLineItemCollectionItemResult']:
        """
        Array containing line item summaries in a subscription.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionLineItemsSubscriptionLineItemCollectionItemResult(dict):
    def __init__(__self__, *,
                 billing_model: str,
                 id: str,
                 product_code: str,
                 quantity: float,
                 system_tags: Mapping[str, str],
                 time_ended: str,
                 time_started: str):
        """
        :param str billing_model: Billing model supported by the associated line item.
        :param str id: Subscription line item identifier.
        :param str product_code: Product code.
        :param float quantity: Product number.
        :param Mapping[str, str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_ended: The time the subscription item and associated products should end. An RFC 3339 formatted date and time string.
        :param str time_started: The time the subscription item and associated products should start. An RFC 3339 formatted date and time string.
        """
        pulumi.set(__self__, "billing_model", billing_model)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_ended", time_ended)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter(name="billingModel")
    def billing_model(self) -> str:
        """
        Billing model supported by the associated line item.
        """
        return pulumi.get(self, "billing_model")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Subscription line item identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        """
        Product code.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter
    def quantity(self) -> float:
        """
        Product number.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The time the subscription item and associated products should end. An RFC 3339 formatted date and time string.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The time the subscription item and associated products should start. An RFC 3339 formatted date and time string.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetSubscriptionMappingsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionMappingsSubscriptionMappingCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionMappingsSubscriptionMappingCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionMappingsSubscriptionMappingCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionMappingsSubscriptionMappingCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 is_explicitly_assigned: bool,
                 state: str,
                 subscription_id: str,
                 time_created: str,
                 time_terminated: str,
                 time_updated: str):
        """
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str id: OCID of the mapping between subscription and compartment identified by the tenancy.
        :param bool is_explicitly_assigned: Denotes if the subscription is explicity assigned to the root compartment or tenancy.
        :param str state: The lifecycle state of the resource.
        :param str subscription_id: OCID of the subscription.
        :param str time_created: Date-time when subscription mapping was created.
        :param str time_terminated: Date-time when subscription mapping was terminated.
        :param str time_updated: Date-time when subscription mapping was updated.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_explicitly_assigned", is_explicitly_assigned)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_terminated", time_terminated)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the mapping between subscription and compartment identified by the tenancy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isExplicitlyAssigned")
    def is_explicitly_assigned(self) -> bool:
        """
        Denotes if the subscription is explicity assigned to the root compartment or tenancy.
        """
        return pulumi.get(self, "is_explicitly_assigned")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        OCID of the subscription.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date-time when subscription mapping was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> str:
        """
        Date-time when subscription mapping was terminated.
        """
        return pulumi.get(self, "time_terminated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date-time when subscription mapping was updated.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSubscriptionPromotionResult(dict):
    def __init__(__self__, *,
                 amount: float,
                 currency_unit: str,
                 duration: int,
                 duration_unit: str,
                 is_intent_to_pay: bool,
                 status: str,
                 time_expired: str,
                 time_started: str):
        """
        :param float amount: If a subscription is present, indicates the total amount of promotional subscription credits.
        :param str currency_unit: Currency unit associated with the promotion.
        :param int duration: Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        :param str duration_unit: Unit for the duration.
        :param bool is_intent_to_pay: Speficies whether or not the customer intends to pay after the promotion has expired.
        :param str status: If a subscription is present, indicates the current status of the subscription promotion.
        :param str time_expired: Date and time when the promotion ends.
        :param str time_started: Date and time when the promotion starts.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "currency_unit", currency_unit)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_expired", time_expired)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter
    def amount(self) -> float:
        """
        If a subscription is present, indicates the total amount of promotional subscription credits.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="currencyUnit")
    def currency_unit(self) -> str:
        """
        Currency unit associated with the promotion.
        """
        return pulumi.get(self, "currency_unit")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> str:
        """
        Unit for the duration.
        """
        return pulumi.get(self, "duration_unit")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> bool:
        """
        Speficies whether or not the customer intends to pay after the promotion has expired.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        If a subscription is present, indicates the current status of the subscription promotion.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeExpired")
    def time_expired(self) -> str:
        """
        Date and time when the promotion ends.
        """
        return pulumi.get(self, "time_expired")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Date and time when the promotion starts.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetSubscriptionSkusResult(dict):
    def __init__(__self__, *,
                 description: str,
                 end_date: str,
                 gsi_order_line_id: str,
                 is_additional_instance: bool,
                 is_base_service_component: bool,
                 license_part_description: str,
                 metric_name: str,
                 quantity: int,
                 sku: str,
                 start_date: str):
        """
        :param str description: Description of the stock units.
        :param str end_date: Date and time when the SKU ended.
        :param str gsi_order_line_id: Sales order line identifier.
        :param bool is_additional_instance: Specifies if an additional test instance can be provisioned by the SaaS application.
        :param bool is_base_service_component: Specifies if the SKU is considered as a parent or child.
        :param str license_part_description: Description of the covered product belonging to this SKU.
        :param str metric_name: Base metric for billing the service.
        :param int quantity: Quantity of the stock units.
        :param str sku: Stock Keeping Unit (SKU) ID.
        :param str start_date: Subscription start time.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "gsi_order_line_id", gsi_order_line_id)
        pulumi.set(__self__, "is_additional_instance", is_additional_instance)
        pulumi.set(__self__, "is_base_service_component", is_base_service_component)
        pulumi.set(__self__, "license_part_description", license_part_description)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "start_date", start_date)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the stock units.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="gsiOrderLineId")
    def gsi_order_line_id(self) -> str:
        """
        Sales order line identifier.
        """
        return pulumi.get(self, "gsi_order_line_id")

    @property
    @pulumi.getter(name="isAdditionalInstance")
    def is_additional_instance(self) -> bool:
        """
        Specifies if an additional test instance can be provisioned by the SaaS application.
        """
        return pulumi.get(self, "is_additional_instance")

    @property
    @pulumi.getter(name="isBaseServiceComponent")
    def is_base_service_component(self) -> bool:
        """
        Specifies if the SKU is considered as a parent or child.
        """
        return pulumi.get(self, "is_base_service_component")

    @property
    @pulumi.getter(name="licensePartDescription")
    def license_part_description(self) -> str:
        """
        Description of the covered product belonging to this SKU.
        """
        return pulumi.get(self, "license_part_description")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Base metric for billing the service.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        Quantity of the stock units.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        Stock Keeping Unit (SKU) ID.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class GetSubscriptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemResult(dict):
    def __init__(__self__, *,
                 classic_subscription_id: str,
                 cloud_amount_currency: str,
                 compartment_id: str,
                 csi_number: str,
                 currency_code: str,
                 customer_country_code: str,
                 defined_tags: Mapping[str, str],
                 end_date: str,
                 entity_version: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_classic_subscription: bool,
                 is_government_subscription: bool,
                 payment_model: str,
                 program_type: str,
                 promotions: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPromotionResult'],
                 purchase_entitlement_id: str,
                 region_assignment: str,
                 service_name: str,
                 skuses: Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSkusResult'],
                 start_date: str,
                 state: str,
                 subscription_number: str,
                 subscription_tier: str,
                 time_created: str,
                 time_updated: str):
        """
        :param str classic_subscription_id: Classic subscription ID.
        :param str cloud_amount_currency: The currency code for the customer associated with the subscription.
        :param str compartment_id: The ID of the compartment in which to list resources.
        :param str csi_number: Customer service identifier for the customer associated with the subscription.
        :param str currency_code: Currency code. For example USD, MXN.
        :param str customer_country_code: The country code for the customer associated with the subscription.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str end_date: Date and time when the SKU ended.
        :param str entity_version: The version of the subscription entity.
        :param Mapping[str, str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subscription.
        :param bool is_classic_subscription: Specifies whether or not the subscription is from classic systems.
        :param bool is_government_subscription: Specifies whether or not the subscription is a government subscription.
        :param str payment_model: The pay model of the subscription, such as 'Pay as you go' or 'Monthly'.
        :param str program_type: Specifies any program that is associated with the subscription.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemPromotionArgs'] promotions: List of promotions related to the subscription.
        :param str purchase_entitlement_id: Purchase entitlement ID associated with the subscription.
        :param str region_assignment: Region for the subscription.
        :param str service_name: The type of subscription, such as 'UCM', 'SAAS', 'ERP', 'CRM'.
        :param Sequence['GetSubscriptionsSubscriptionCollectionItemSkusArgs'] skuses: List of SKUs linked to this subscription.
        :param str start_date: Subscription start time.
        :param str state: Lifecycle state of the subscription.
        :param str subscription_number: Unique Oracle Cloud Subscriptions identifier that is immutable on creation.
        :param str subscription_tier: Tier for the subscription, whether a free promotion subscription or a paid subscription.
        :param str time_created: The date and time of creation, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        :param str time_updated: The date and time of update, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        pulumi.set(__self__, "classic_subscription_id", classic_subscription_id)
        pulumi.set(__self__, "cloud_amount_currency", cloud_amount_currency)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "csi_number", csi_number)
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "customer_country_code", customer_country_code)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "entity_version", entity_version)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_classic_subscription", is_classic_subscription)
        pulumi.set(__self__, "is_government_subscription", is_government_subscription)
        pulumi.set(__self__, "payment_model", payment_model)
        pulumi.set(__self__, "program_type", program_type)
        pulumi.set(__self__, "promotions", promotions)
        pulumi.set(__self__, "purchase_entitlement_id", purchase_entitlement_id)
        pulumi.set(__self__, "region_assignment", region_assignment)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "skuses", skuses)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscription_number", subscription_number)
        pulumi.set(__self__, "subscription_tier", subscription_tier)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="classicSubscriptionId")
    def classic_subscription_id(self) -> str:
        """
        Classic subscription ID.
        """
        return pulumi.get(self, "classic_subscription_id")

    @property
    @pulumi.getter(name="cloudAmountCurrency")
    def cloud_amount_currency(self) -> str:
        """
        The currency code for the customer associated with the subscription.
        """
        return pulumi.get(self, "cloud_amount_currency")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="csiNumber")
    def csi_number(self) -> str:
        """
        Customer service identifier for the customer associated with the subscription.
        """
        return pulumi.get(self, "csi_number")

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        Currency code. For example USD, MXN.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter(name="customerCountryCode")
    def customer_country_code(self) -> str:
        """
        The country code for the customer associated with the subscription.
        """
        return pulumi.get(self, "customer_country_code")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="entityVersion")
    def entity_version(self) -> str:
        """
        The version of the subscription entity.
        """
        return pulumi.get(self, "entity_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) of the subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isClassicSubscription")
    def is_classic_subscription(self) -> bool:
        """
        Specifies whether or not the subscription is from classic systems.
        """
        return pulumi.get(self, "is_classic_subscription")

    @property
    @pulumi.getter(name="isGovernmentSubscription")
    def is_government_subscription(self) -> bool:
        """
        Specifies whether or not the subscription is a government subscription.
        """
        return pulumi.get(self, "is_government_subscription")

    @property
    @pulumi.getter(name="paymentModel")
    def payment_model(self) -> str:
        """
        The pay model of the subscription, such as 'Pay as you go' or 'Monthly'.
        """
        return pulumi.get(self, "payment_model")

    @property
    @pulumi.getter(name="programType")
    def program_type(self) -> str:
        """
        Specifies any program that is associated with the subscription.
        """
        return pulumi.get(self, "program_type")

    @property
    @pulumi.getter
    def promotions(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemPromotionResult']:
        """
        List of promotions related to the subscription.
        """
        return pulumi.get(self, "promotions")

    @property
    @pulumi.getter(name="purchaseEntitlementId")
    def purchase_entitlement_id(self) -> str:
        """
        Purchase entitlement ID associated with the subscription.
        """
        return pulumi.get(self, "purchase_entitlement_id")

    @property
    @pulumi.getter(name="regionAssignment")
    def region_assignment(self) -> str:
        """
        Region for the subscription.
        """
        return pulumi.get(self, "region_assignment")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The type of subscription, such as 'UCM', 'SAAS', 'ERP', 'CRM'.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def skuses(self) -> Sequence['outputs.GetSubscriptionsSubscriptionCollectionItemSkusResult']:
        """
        List of SKUs linked to this subscription.
        """
        return pulumi.get(self, "skuses")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the subscription.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionNumber")
    def subscription_number(self) -> str:
        """
        Unique Oracle Cloud Subscriptions identifier that is immutable on creation.
        """
        return pulumi.get(self, "subscription_number")

    @property
    @pulumi.getter(name="subscriptionTier")
    def subscription_tier(self) -> str:
        """
        Tier for the subscription, whether a free promotion subscription or a paid subscription.
        """
        return pulumi.get(self, "subscription_tier")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time of creation, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time of update, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 14.29.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemPromotionResult(dict):
    def __init__(__self__, *,
                 amount: float,
                 currency_unit: str,
                 duration: int,
                 duration_unit: str,
                 is_intent_to_pay: bool,
                 status: str,
                 time_expired: str,
                 time_started: str):
        """
        :param float amount: If a subscription is present, indicates the total amount of promotional subscription credits.
        :param str currency_unit: Currency unit associated with the promotion.
        :param int duration: Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        :param str duration_unit: Unit for the duration.
        :param bool is_intent_to_pay: Speficies whether or not the customer intends to pay after the promotion has expired.
        :param str status: If a subscription is present, indicates the current status of the subscription promotion.
        :param str time_expired: Date and time when the promotion ends.
        :param str time_started: Date and time when the promotion starts.
        """
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "currency_unit", currency_unit)
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "duration_unit", duration_unit)
        pulumi.set(__self__, "is_intent_to_pay", is_intent_to_pay)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_expired", time_expired)
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter
    def amount(self) -> float:
        """
        If a subscription is present, indicates the total amount of promotional subscription credits.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="currencyUnit")
    def currency_unit(self) -> str:
        """
        Currency unit associated with the promotion.
        """
        return pulumi.get(self, "currency_unit")

    @property
    @pulumi.getter
    def duration(self) -> int:
        """
        Specifies how long the promotion related to the subscription, if any, is valid in duration units.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationUnit")
    def duration_unit(self) -> str:
        """
        Unit for the duration.
        """
        return pulumi.get(self, "duration_unit")

    @property
    @pulumi.getter(name="isIntentToPay")
    def is_intent_to_pay(self) -> bool:
        """
        Speficies whether or not the customer intends to pay after the promotion has expired.
        """
        return pulumi.get(self, "is_intent_to_pay")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        If a subscription is present, indicates the current status of the subscription promotion.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeExpired")
    def time_expired(self) -> str:
        """
        Date and time when the promotion ends.
        """
        return pulumi.get(self, "time_expired")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        Date and time when the promotion starts.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetSubscriptionsSubscriptionCollectionItemSkusResult(dict):
    def __init__(__self__, *,
                 description: str,
                 end_date: str,
                 gsi_order_line_id: str,
                 is_additional_instance: bool,
                 is_base_service_component: bool,
                 license_part_description: str,
                 metric_name: str,
                 quantity: int,
                 sku: str,
                 start_date: str):
        """
        :param str description: Description of the stock units.
        :param str end_date: Date and time when the SKU ended.
        :param str gsi_order_line_id: Sales order line identifier.
        :param bool is_additional_instance: Specifies if an additional test instance can be provisioned by the SaaS application.
        :param bool is_base_service_component: Specifies if the SKU is considered as a parent or child.
        :param str license_part_description: Description of the covered product belonging to this SKU.
        :param str metric_name: Base metric for billing the service.
        :param int quantity: Quantity of the stock units.
        :param str sku: Stock Keeping Unit (SKU) ID.
        :param str start_date: Subscription start time.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "gsi_order_line_id", gsi_order_line_id)
        pulumi.set(__self__, "is_additional_instance", is_additional_instance)
        pulumi.set(__self__, "is_base_service_component", is_base_service_component)
        pulumi.set(__self__, "license_part_description", license_part_description)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "start_date", start_date)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the stock units.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> str:
        """
        Date and time when the SKU ended.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="gsiOrderLineId")
    def gsi_order_line_id(self) -> str:
        """
        Sales order line identifier.
        """
        return pulumi.get(self, "gsi_order_line_id")

    @property
    @pulumi.getter(name="isAdditionalInstance")
    def is_additional_instance(self) -> bool:
        """
        Specifies if an additional test instance can be provisioned by the SaaS application.
        """
        return pulumi.get(self, "is_additional_instance")

    @property
    @pulumi.getter(name="isBaseServiceComponent")
    def is_base_service_component(self) -> bool:
        """
        Specifies if the SKU is considered as a parent or child.
        """
        return pulumi.get(self, "is_base_service_component")

    @property
    @pulumi.getter(name="licensePartDescription")
    def license_part_description(self) -> str:
        """
        Description of the covered product belonging to this SKU.
        """
        return pulumi.get(self, "license_part_description")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        Base metric for billing the service.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def quantity(self) -> int:
        """
        Quantity of the stock units.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        Stock Keeping Unit (SKU) ID.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> str:
        """
        Subscription start time.
        """
        return pulumi.get(self, "start_date")


