# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubscriptionRewardResult',
    'AwaitableGetSubscriptionRewardResult',
    'get_subscription_reward',
    'get_subscription_reward_output',
]

@pulumi.output_type
class GetSubscriptionRewardResult:
    """
    A collection of values returned by getSubscriptionReward.
    """
    def __init__(__self__, id=None, items=None, subscription_id=None, summaries=None, tenancy_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if summaries and not isinstance(summaries, list):
            raise TypeError("Expected argument 'summaries' to be a list")
        pulumi.set(__self__, "summaries", summaries)
        if tenancy_id and not isinstance(tenancy_id, str):
            raise TypeError("Expected argument 'tenancy_id' to be a str")
        pulumi.set(__self__, "tenancy_id", tenancy_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSubscriptionRewardItemResult']:
        """
        The monthly summary of rewards.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> str:
        """
        The entitlement ID from MQS, which is the same as the subcription ID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def summaries(self) -> Sequence['outputs.GetSubscriptionRewardSummaryResult']:
        """
        The overall monthly reward summary.
        """
        return pulumi.get(self, "summaries")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> str:
        """
        The OCID of the target tenancy.
        """
        return pulumi.get(self, "tenancy_id")


class AwaitableGetSubscriptionRewardResult(GetSubscriptionRewardResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionRewardResult(
            id=self.id,
            items=self.items,
            subscription_id=self.subscription_id,
            summaries=self.summaries,
            tenancy_id=self.tenancy_id)


def get_subscription_reward(subscription_id: Optional[str] = None,
                            tenancy_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionRewardResult:
    """
    This data source provides details about a specific Subscription Reward resource in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the list of rewards for a subscription ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_reward = oci.UsageProxy.get_subscription_reward(subscription_id=test_subscription["id"],
        tenancy_id=test_tenancy["id"])
    ```


    :param str subscription_id: The subscription ID for which rewards information is requested for.
    :param str tenancy_id: The OCID of the tenancy.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:UsageProxy/getSubscriptionReward:getSubscriptionReward', __args__, opts=opts, typ=GetSubscriptionRewardResult).value

    return AwaitableGetSubscriptionRewardResult(
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        summaries=pulumi.get(__ret__, 'summaries'),
        tenancy_id=pulumi.get(__ret__, 'tenancy_id'))
def get_subscription_reward_output(subscription_id: Optional[pulumi.Input[str]] = None,
                                   tenancy_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionRewardResult]:
    """
    This data source provides details about a specific Subscription Reward resource in Oracle Cloud Infrastructure Usage Proxy service.

    Returns the list of rewards for a subscription ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_subscription_reward = oci.UsageProxy.get_subscription_reward(subscription_id=test_subscription["id"],
        tenancy_id=test_tenancy["id"])
    ```


    :param str subscription_id: The subscription ID for which rewards information is requested for.
    :param str tenancy_id: The OCID of the tenancy.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    __args__['tenancyId'] = tenancy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:UsageProxy/getSubscriptionReward:getSubscriptionReward', __args__, opts=opts, typ=GetSubscriptionRewardResult)
    return __ret__.apply(lambda __response__: GetSubscriptionRewardResult(
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        summaries=pulumi.get(__response__, 'summaries'),
        tenancy_id=pulumi.get(__response__, 'tenancy_id')))
