import enum

from .bindings import lib

__all__ = (
    "FILE_ATTRIBUTE",
    "CREATE_FILE_CREATE_OPTIONS",
)


class FILE_ATTRIBUTE(enum.IntEnum):
    """
    NT File attributes
    see https://docs.microsoft.com/en-us/dotnet/api/system.io.fileattributes
    """

    FILE_ATTRIBUTE_ARCHIVE = 0x20
    FILE_ATTRIBUTE_COMPRESSED = 0x800
    FILE_ATTRIBUTE_DEVICE = 0x40
    FILE_ATTRIBUTE_DIRECTORY = 0x10
    FILE_ATTRIBUTE_ENCRYPTED = 0x4000
    FILE_ATTRIBUTE_HIDDEN = 0x2
    FILE_ATTRIBUTE_INTEGRITY_STREAM = 0x8000
    FILE_ATTRIBUTE_NORMAL = 0x80
    FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 0x2000
    FILE_ATTRIBUTE_NO_SCRUB_DATA = 0x20000
    FILE_ATTRIBUTE_OFFLINE = 0x1000
    FILE_ATTRIBUTE_READONLY = 0x1
    FILE_ATTRIBUTE_RECALL_ON_DATA_ACCESS = 0x400000
    FILE_ATTRIBUTE_RECALL_ON_OPEN = 0x40000
    FILE_ATTRIBUTE_REPARSE_POINT = 0x400
    FILE_ATTRIBUTE_SPARSE_FILE = 0x200
    FILE_ATTRIBUTE_SYSTEM = 0x4
    FILE_ATTRIBUTE_TEMPORARY = 0x100
    FILE_ATTRIBUTE_VIRTUAL = 0x10000

    INVALID_FILE_ATTRIBUTES = lib.WFSPY_FILE_ATTRIBUTE_INVALID_FILE_ATTRIBUTES


class CREATE_FILE_CREATE_OPTIONS(enum.IntEnum):
    """
    `NtCreateFile`'s CreateOptions flags
    see https://docs.microsoft.com/en-us/windows/desktop/api/winternl/nf-winternl-ntcreatefile
    """

    FILE_DIRECTORY_FILE = lib.WFSPY_FILE_DIRECTORY_FILE
    FILE_NON_DIRECTORY_FILE = lib.WFSPY_FILE_NON_DIRECTORY_FILE
    FILE_WRITE_THROUGH = lib.WFSPY_FILE_WRITE_THROUGH
    FILE_SEQUENTIAL_ONLY = lib.WFSPY_FILE_SEQUENTIAL_ONLY
    FILE_RANDOM_ACCESS = lib.WFSPY_FILE_RANDOM_ACCESS
    FILE_NO_INTERMEDIATE_BUFFERING = lib.WFSPY_FILE_NO_INTERMEDIATE_BUFFERING
    FILE_SYNCHRONOUS_IO_ALERT = lib.WFSPY_FILE_SYNCHRONOUS_IO_ALERT
    FILE_SYNCHRONOUS_IO_NONALERT = lib.WFSPY_FILE_SYNCHRONOUS_IO_NONALERT
    FILE_CREATE_TREE_CONNECTION = lib.WFSPY_FILE_CREATE_TREE_CONNECTION
    FILE_NO_EA_KNOWLEDGE = lib.WFSPY_FILE_NO_EA_KNOWLEDGE
    FILE_OPEN_REPARSE_POINT = lib.WFSPY_FILE_OPEN_REPARSE_POINT
    FILE_DELETE_ON_CLOSE = lib.WFSPY_FILE_DELETE_ON_CLOSE
    FILE_OPEN_BY_FILE_ID = lib.WFSPY_FILE_OPEN_BY_FILE_ID
    FILE_OPEN_FOR_BACKUP_INTENT = lib.WFSPY_FILE_OPEN_FOR_BACKUP_INTENT
    FILE_RESERVE_OPFILTER = lib.WFSPY_FILE_RESERVE_OPFILTER
    FILE_OPEN_REQUIRING_OPLOCK = lib.WFSPY_FILE_OPEN_REQUIRING_OPLOCK
    FILE_COMPLETE_IF_OPLOCKED = lib.WFSPY_FILE_COMPLETE_IF_OPLOCKED
