"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .balance_transfer_category import BalanceTransferCategory
from .entity_balance_transfer_party import (
    EntityBalanceTransferParty,
    EntityBalanceTransferPartyTypedDict,
)
from mollie.types import BaseModel
from typing import Any, Dict, Optional
from typing_extensions import NotRequired, TypedDict


class EntityBalanceTransferTypedDict(TypedDict):
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    source: EntityBalanceTransferPartyTypedDict
    r"""A party involved in the balance transfer, either the sender or the receiver."""
    destination: EntityBalanceTransferPartyTypedDict
    r"""A party involved in the balance transfer, either the sender or the receiver."""
    description: str
    r"""The transfer description for initiating party."""
    category: NotRequired[BalanceTransferCategory]
    r"""The type of the transfer. Different fees may apply to different types of transfers."""
    metadata: NotRequired[Dict[str, Any]]
    r"""A JSON object that you can attach to a balance transfer.
    This can be useful for storing additional information about the transfer in a structured format. Maximum size is approximately 1KB.
    """
    testmode: NotRequired[bool]
    r"""Whether to create the entity in test mode or live mode.

    You can enable test mode by setting `testmode` to `true`.
    """


class EntityBalanceTransfer(BaseModel):
    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    source: EntityBalanceTransferParty
    r"""A party involved in the balance transfer, either the sender or the receiver."""

    destination: EntityBalanceTransferParty
    r"""A party involved in the balance transfer, either the sender or the receiver."""

    description: str
    r"""The transfer description for initiating party."""

    category: Optional[BalanceTransferCategory] = None
    r"""The type of the transfer. Different fees may apply to different types of transfers."""

    metadata: Optional[Dict[str, Any]] = None
    r"""A JSON object that you can attach to a balance transfer.
    This can be useful for storing additional information about the transfer in a structured format. Maximum size is approximately 1KB.
    """

    testmode: Optional[bool] = None
    r"""Whether to create the entity in test mode or live mode.

    You can enable test mode by setting `testmode` to `true`.
    """
