"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ProfileRequestTypedDict(TypedDict):
    name: str
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: str
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """
    email: str
    r"""The email address associated with the profile's trade name or brand."""
    phone: str
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[str]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[List[str]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    business_category: NotRequired[str]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """


class ProfileRequest(BaseModel):
    name: str
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: str
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are
    allowed.
    """

    email: str
    r"""The email address associated with the profile's trade name or brand."""

    phone: str
    r"""The phone number associated with the profile's trade name or brand."""

    description: Optional[str] = None
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        Optional[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = None
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    business_category: Annotated[
        Optional[str], pydantic.Field(alias="businessCategory")
    ] = None
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types#business-category) for all possible options.
    """
