# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/dataset.ipynb (unless otherwise specified).

__all__ = ['PhotoTourRevisited', 'read_interest_file']

# Cell
import os
import numpy as np
from PIL import Image
from typing import Any, Callable, List, Optional, Tuple, Union

import torch
import torchvision
from torchvision.datasets import PhotoTour
from torchvision.datasets.phototour import read_image_file, read_info_file


from torchvision.datasets.utils import download_url

class PhotoTourRevisited(torchvision.datasets.PhotoTour):
    """`Learning Local Image Descriptors Data <http://phototour.cs.washington.edu/patches/default.htm>`_ Dataset
    with for new evaluation protocol.
    Args:
        root (string): Root directory where images are.
        name (string): Name of the dataset to load.
        transform (callable, optional): A function/transform that  takes in an PIL image
            and returns a transformed version.
        download (bool, optional): If true, downloads the dataset from the internet and
            puts it in root directory. If dataset is already downloaded, it is not
            downloaded again.
    """
    img_info_files = 'interest.txt'
    def __init__(
            self, root: str, name: str,
            transform: Optional[Callable] = None, download: bool = False) -> None:
        super(PhotoTourRevisited, self).__init__(root, name, False, transform, download)
        # load the serialized data
        self.data, self.labels, self.img_idxs = torch.load(self.data_file)

    def __getitem__(self, index: int) -> Union[torch.Tensor, Tuple[Any, Any, torch.Tensor]]:
        """
        Args:
            index (int): Index
        Returns:
            tuple: (patch, label, img_idx)
        """
        data = self.data[index]
        if self.transform is not None:
            data = self.transform(data)
        if self.train:
            return data
        return data, self.labels[index], self.img_idxs[index]

    def __len__(self) -> int:
        return self.lens[self.name]

    def download(self) -> None:
        if self._check_datafile_exists():
            print('# Found cached data {}'.format(self.data_file))
            return

        if not self._check_downloaded():
            # download files
            url = self.urls[self.name][0]
            filename = self.urls[self.name][1]
            md5 = self.urls[self.name][2]
            fpath = os.path.join(self.root, filename)

            download_url(url, self.root, filename, md5)

            print('# Extracting data {}\n'.format(self.data_down))

            import zipfile
            with zipfile.ZipFile(fpath, 'r') as z:
                z.extractall(self.data_dir)

            os.unlink(fpath)

        # process and save as torch files
        print('# Caching data {}'.format(self.data_file))

        dataset = (
            read_image_file(self.data_dir, self.image_ext, self.lens[self.name]),
            read_info_file(self.data_dir, self.info_file),
            read_interest_file(self.data_dir, self.img_info_files)
        )

        with open(self.data_file, 'wb') as f:
            torch.save(dataset, f)

    def extra_repr(self) -> str:
        return "Split: Test"


def read_interest_file(data_dir: str, info_file: str) -> torch.Tensor:
    """Return a Tensor containing the list of image ids
       Read the file and keep only the ID of the image point.
    """
    img_idxs = []
    with open(os.path.join(data_dir, info_file), 'r') as f:
        img_idxs = [int(line.split()[0]) for line in f]
    return torch.LongTensor(img_idxs)

