# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/extraction.ipynb (unless otherwise specified).

__all__ = ['extract_pytorchinput_descriptors', 'extract_numpyinput_descriptors']

# Cell
import numpy as np
import torch
import torchvision as tv
import os
from fastprogress.fastprogress import progress_bar
from .dataset import PhotoTourRevisited
from typing import Dict

def extract_pytorchinput_descriptors(model: torch.nn.Module,
                                desc_name: str,
                                subset: str,
                                path_to_save_dataset:str = './dataset/',
                                path_to_save_descriptors: str = './descriptors/',
                                patch_size: int = 32, device: torch.device = torch.device('cpu'))-> Dict:
    '''Function, which extracts descriptors and labels required for evaluation'''
    allowed_datasets = ['liberty', 'notredame', 'yosemite']
    if subset not in allowed_datasets:
        raise ValueError(f'subset {subset} should be one of {allowed_datasets}')
    BS = 256
    transform = tv.transforms.Compose([
                tv.transforms.ToPILImage(),
                tv.transforms.Resize(patch_size),
                tv.transforms.ToTensor()])
    kwargs = {} if device is torch.device('cpu') else {'num_workers': 4, 'pin_memory': True}

    ds_loader = torch.utils.data.DataLoader(
             PhotoTourRevisited(root=path_to_save_dataset,
                     name=subset,
                     download=True,
                     transform=transform),
                        batch_size=BS,
                        shuffle=False, drop_last = False, **kwargs)
    num_patches = len(ds_loader.dataset)
    if not os.path.isdir(path_to_save_descriptors):
        os.makedirs(path_to_save_descriptors)
    DESC_NAME = f'{desc_name}_{patch_size}px_{subset}'
    desc_fname = f'{path_to_save_descriptors}/{DESC_NAME}.npy'
    labels_fname = f'{path_to_save_descriptors}/{DESC_NAME}_labels.npy'
    img_labels_fname = f'{path_to_save_descriptors}/{DESC_NAME}_imglabels.npy'
    if os.path.isfile(desc_fname):
        print (f"{desc_fname} already exists, loading")
        descriptors = np.load(desc_fname)
        labels = np.load(labels_fname)
        img_labels = np.load(img_labels_fname)
        assert len(descriptors) == len(labels)
        assert len(descriptors) == len(img_labels)
        return {"descriptors": descriptors,
               "labels": labels,
               "img_idxs": img_labels}
    labels, img_labels =  np.zeros((num_patches)), np.zeros((num_patches))
    descriptors = None
    with torch.no_grad():
        count = 0
        model = model.to(device)
        model.eval()
        for patch, label, img_label in progress_bar(ds_loader):
            desc = model(patch.to(device))
            bs = len(patch)
            if descriptors is None:
                dim = desc.size(1)
                descriptors = np.zeros((num_patches,dim))
            descriptors[count:count+bs] = desc.cpu().detach().numpy()
            labels[count:count+bs] = label
            img_labels[count:count+bs] = img_label
            count+=bs
    np.save(desc_fname, descriptors)
    np.save(labels_fname, labels)
    np.save(img_labels_fname, img_labels)
    return {"descriptors": descriptors,
               "labels": labels,
               "img_idxs": img_labels}

# Cell
def extract_numpyinput_descriptors(model,
                                desc_name: str,
                                subset: str,
                                path_to_save_dataset:str = './dataset/',
                                path_to_save_descriptors: str = './descriptors/',
                                patch_size: int = 32)-> Dict:
    '''Function, which extracts descriptors and labels required for evaluation'''
    allowed_datasets = ['liberty', 'notredame', 'yosemite']
    if subset not in allowed_datasets:
        raise ValueError(f'subset {subset} should be one of {allowed_datasets}')
    BS = 1
    transform = tv.transforms.Compose([
                tv.transforms.ToPILImage(),
                tv.transforms.Resize(patch_size),
                tv.transforms.ToTensor()])
    ds_loader = torch.utils.data.DataLoader(
             PhotoTourRevisited(root=path_to_save_dataset,
                     name=subset,
                     download=True,
                     transform=transform),
                        batch_size=BS,
                        shuffle=False, drop_last = False)
    num_patches = len(ds_loader.dataset)
    if not os.path.isdir(path_to_save_descriptors):
        os.makedirs(path_to_save_descriptors)
    DESC_NAME = f'{desc_name}_{patch_size}px_{subset}'
    desc_fname = f'{path_to_save_descriptors}/{DESC_NAME}.npy'
    labels_fname = f'{path_to_save_descriptors}/{DESC_NAME}_labels.npy'
    img_labels_fname = f'{path_to_save_descriptors}/{DESC_NAME}_imglabels.npy'
    if os.path.isfile(desc_fname):
        print (f"{desc_fname} already exists, loading")
        descriptors = np.load(desc_fname)
        labels = np.load(labels_fname)
        img_labels = np.load(img_labels_fname)
        assert len(descriptors) == len(labels)
        assert len(descriptors) == len(img_labels)
        return {"descriptors": descriptors,
               "labels": labels,
               "img_idxs": img_labels}
    labels, img_labels =  np.zeros((num_patches)), np.zeros((num_patches))
    descriptors = None
    count = 0
    for patch, label, img_label in progress_bar(ds_loader):
        desc = model(patch.detach().cpu().view(patch_size, patch_size).numpy())
        if descriptors is None:
            if len(desc.shape) == 1:
                dim = desc.shape[0]
            else:
                dim = desc.shape[1]
            descriptors = np.zeros((num_patches,dim))
        descriptors[count:count+BS] = desc.reshape(BS, dim)
        labels[count:count+BS] = label
        img_labels[count:count+BS] = img_label
        count+=BS
    np.save(desc_fname, descriptors)
    np.save(labels_fname, labels)
    np.save(img_labels_fname, img_labels)
    return {"descriptors": descriptors,
               "labels": labels,
               "img_idxs": img_labels}