# This Python file uses the following encoding: utf-8
#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:LGPL$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## GNU Lesser General Public License Usage
## Alternatively, this file may be used under the terms of the GNU Lesser
## General Public License version 3 as published by the Free Software
## Foundation and appearing in the file LICENSE.LGPL3 included in the
## packaging of this file. Please review the following information to
## ensure the GNU Lesser General Public License version 3 requirements
## will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
##
## GNU General Public License Usage
## Alternatively, this file may be used under the terms of the GNU
## General Public License version 2.0 or (at your option) the GNU General
## Public license version 3 or any later version approved by the KDE Free
## Qt Foundation. The licenses are as published by the Free Software
## Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
## included in the packaging of this file. Please review the following
## information to ensure the GNU General Public License requirements will
## be met: https://www.gnu.org/licenses/gpl-2.0.html and
## https://www.gnu.org/licenses/gpl-3.0.html.
##
## $QT_END_LICENSE$
##
#############################################################################

"""
This file contains the exact signatures for all functions in module
PySide6.QtQml, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtQml`

from shiboken6 import Shiboken

import typing
from typing import Any, Callable, Dict, List, Optional, Tuple, Union

import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtQml


class ListProperty(PySide6.QtCore.Property):

    def __init__(self, type:type, append:Callable, at:Optional[Callable]=..., clear:Optional[Callable]=..., count:Optional[Callable]=...) -> None: ...


class QJSEngine(PySide6.QtCore.QObject):
    AllExtensions            : QJSEngine.Extension = ... # -0x1
    TranslationExtension     : QJSEngine.Extension = ... # 0x1
    ConsoleExtension         : QJSEngine.Extension = ... # 0x2
    GarbageCollectionExtension: QJSEngine.Extension = ... # 0x4
    CppOwnership             : QJSEngine.ObjectOwnership = ... # 0x0
    JavaScriptOwnership      : QJSEngine.ObjectOwnership = ... # 0x1

    class Extension(Shiboken.Enum):
        AllExtensions            : QJSEngine.Extension = ... # -0x1
        TranslationExtension     : QJSEngine.Extension = ... # 0x1
        ConsoleExtension         : QJSEngine.Extension = ... # 0x2
        GarbageCollectionExtension: QJSEngine.Extension = ... # 0x4


    class Extensions(object):

    class ObjectOwnership(Shiboken.Enum):
        CppOwnership             : QJSEngine.ObjectOwnership = ... # 0x0
        JavaScriptOwnership      : QJSEngine.ObjectOwnership = ... # 0x1


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide6.QtCore.QObject) -> None: ...

    def catchError(self) -> PySide6.QtQml.QJSValue: ...
    def collectGarbage(self) -> None: ...
    def evaluate(self, program:str, fileName:str=..., lineNumber:int=...) -> Tuple[PySide6.QtQml.QJSValue, List]: ...
    def globalObject(self) -> PySide6.QtQml.QJSValue: ...
    def hasError(self) -> bool: ...
    def importModule(self, fileName:str) -> PySide6.QtQml.QJSValue: ...
    def installExtensions(self, extensions:PySide6.QtQml.QJSEngine.Extensions, object:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]=...) -> None: ...
    def isInterrupted(self) -> bool: ...
    def newArray(self, length:int=...) -> PySide6.QtQml.QJSValue: ...
    def newErrorObject(self, errorType:PySide6.QtQml.QJSValue.ErrorType, message:str=...) -> PySide6.QtQml.QJSValue: ...
    def newObject(self) -> PySide6.QtQml.QJSValue: ...
    def newQMetaObject(self, metaObject:PySide6.QtCore.QMetaObject) -> PySide6.QtQml.QJSValue: ...
    def newQObject(self, object:PySide6.QtCore.QObject) -> PySide6.QtQml.QJSValue: ...
    @staticmethod
    def objectOwnership(arg__1:PySide6.QtCore.QObject) -> PySide6.QtQml.QJSEngine.ObjectOwnership: ...
    def setInterrupted(self, interrupted:bool) -> None: ...
    @staticmethod
    def setObjectOwnership(arg__1:PySide6.QtCore.QObject, arg__2:PySide6.QtQml.QJSEngine.ObjectOwnership) -> None: ...
    def setUiLanguage(self, language:str) -> None: ...
    @typing.overload
    def throwError(self, error:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> None: ...
    @typing.overload
    def throwError(self, errorType:PySide6.QtQml.QJSValue.ErrorType, message:str=...) -> None: ...
    @typing.overload
    def throwError(self, message:str) -> None: ...
    def toScriptValue(self, arg__1:Any) -> PySide6.QtQml.QJSValue: ...
    def uiLanguage(self) -> str: ...


class QJSValue(Shiboken.Object):
    NoError                  : QJSValue.ErrorType = ... # 0x0
    GenericError             : QJSValue.ErrorType = ... # 0x1
    EvalError                : QJSValue.ErrorType = ... # 0x2
    RangeError               : QJSValue.ErrorType = ... # 0x3
    ReferenceError           : QJSValue.ErrorType = ... # 0x4
    SyntaxError              : QJSValue.ErrorType = ... # 0x5
    TypeError                : QJSValue.ErrorType = ... # 0x6
    URIError                 : QJSValue.ErrorType = ... # 0x7
    ConvertJSObjects         : QJSValue.ObjectConversionBehavior = ... # 0x0
    RetainJSObjects          : QJSValue.ObjectConversionBehavior = ... # 0x1
    NullValue                : QJSValue.SpecialValue = ... # 0x0
    UndefinedValue           : QJSValue.SpecialValue = ... # 0x1

    class ErrorType(Shiboken.Enum):
        NoError                  : QJSValue.ErrorType = ... # 0x0
        GenericError             : QJSValue.ErrorType = ... # 0x1
        EvalError                : QJSValue.ErrorType = ... # 0x2
        RangeError               : QJSValue.ErrorType = ... # 0x3
        ReferenceError           : QJSValue.ErrorType = ... # 0x4
        SyntaxError              : QJSValue.ErrorType = ... # 0x5
        TypeError                : QJSValue.ErrorType = ... # 0x6
        URIError                 : QJSValue.ErrorType = ... # 0x7


    class ObjectConversionBehavior(Shiboken.Enum):
        ConvertJSObjects         : QJSValue.ObjectConversionBehavior = ... # 0x0
        RetainJSObjects          : QJSValue.ObjectConversionBehavior = ... # 0x1


    class SpecialValue(Shiboken.Enum):
        NullValue                : QJSValue.SpecialValue = ... # 0x0
        UndefinedValue           : QJSValue.SpecialValue = ... # 0x1


    @typing.overload
    def __init__(self, other:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> None: ...
    @typing.overload
    def __init__(self, str:bytes) -> None: ...
    @typing.overload
    def __init__(self, value:PySide6.QtQml.QJSValue.SpecialValue=...) -> None: ...
    @typing.overload
    def __init__(self, value:str) -> None: ...
    @typing.overload
    def __init__(self, value:bool) -> None: ...
    @typing.overload
    def __init__(self, value:float) -> None: ...
    @typing.overload
    def __init__(self, value:int) -> None: ...
    @typing.overload
    def __init__(self, value:int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1:PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1:PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def call(self, args:Sequence[PySide6.QtQml.QJSValue]=...) -> PySide6.QtQml.QJSValue: ...
    def callAsConstructor(self, args:Sequence[PySide6.QtQml.QJSValue]=...) -> PySide6.QtQml.QJSValue: ...
    def callWithInstance(self, instance:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int], args:Sequence[PySide6.QtQml.QJSValue]=...) -> PySide6.QtQml.QJSValue: ...
    def deleteProperty(self, name:str) -> bool: ...
    def equals(self, other:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> bool: ...
    def errorType(self) -> PySide6.QtQml.QJSValue.ErrorType: ...
    def hasOwnProperty(self, name:str) -> bool: ...
    def hasProperty(self, name:str) -> bool: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isCallable(self) -> bool: ...
    def isDate(self) -> bool: ...
    def isError(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isNumber(self) -> bool: ...
    def isObject(self) -> bool: ...
    def isQMetaObject(self) -> bool: ...
    def isQObject(self) -> bool: ...
    def isRegExp(self) -> bool: ...
    def isString(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isVariant(self) -> bool: ...
    @typing.overload
    def property(self, arrayIndex:int) -> PySide6.QtQml.QJSValue: ...
    @typing.overload
    def property(self, name:str) -> PySide6.QtQml.QJSValue: ...
    def prototype(self) -> PySide6.QtQml.QJSValue: ...
    @typing.overload
    def setProperty(self, arrayIndex:int, value:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> None: ...
    @typing.overload
    def setProperty(self, name:str, value:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> None: ...
    def setPrototype(self, prototype:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> None: ...
    def strictlyEquals(self, other:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> bool: ...
    def toBool(self) -> bool: ...
    def toDateTime(self) -> PySide6.QtCore.QDateTime: ...
    def toInt(self) -> int: ...
    def toNumber(self) -> float: ...
    def toQMetaObject(self) -> PySide6.QtCore.QMetaObject: ...
    def toQObject(self) -> PySide6.QtCore.QObject: ...
    def toString(self) -> str: ...
    def toUInt(self) -> int: ...
    @typing.overload
    def toVariant(self) -> Any: ...
    @typing.overload
    def toVariant(self, behavior:PySide6.QtQml.QJSValue.ObjectConversionBehavior) -> Any: ...


class QJSValueIterator(Shiboken.Object):

    def __init__(self, value:Union[PySide6.QtQml.QJSValue, PySide6.QtQml.QJSValue.SpecialValue, str, bytes, float, int]) -> None: ...

    def hasNext(self) -> bool: ...
    def name(self) -> str: ...
    def next(self) -> bool: ...
    def value(self) -> PySide6.QtQml.QJSValue: ...


class QQmlAbstractUrlInterceptor(Shiboken.Object):
    QmlFile                  : QQmlAbstractUrlInterceptor.DataType = ... # 0x0
    JavaScriptFile           : QQmlAbstractUrlInterceptor.DataType = ... # 0x1
    QmldirFile               : QQmlAbstractUrlInterceptor.DataType = ... # 0x2
    UrlString                : QQmlAbstractUrlInterceptor.DataType = ... # 0x1000

    class DataType(Shiboken.Enum):
        QmlFile                  : QQmlAbstractUrlInterceptor.DataType = ... # 0x0
        JavaScriptFile           : QQmlAbstractUrlInterceptor.DataType = ... # 0x1
        QmldirFile               : QQmlAbstractUrlInterceptor.DataType = ... # 0x2
        UrlString                : QQmlAbstractUrlInterceptor.DataType = ... # 0x1000


    def __init__(self) -> None: ...

    def intercept(self, path:Union[PySide6.QtCore.QUrl, str], type:PySide6.QtQml.QQmlAbstractUrlInterceptor.DataType) -> PySide6.QtCore.QUrl: ...


class QQmlApplicationEngine(PySide6.QtQml.QQmlEngine):

    @typing.overload
    def __init__(self, filePath:str, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, url:Union[PySide6.QtCore.QUrl, str], parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    @typing.overload
    def load(self, filePath:str) -> None: ...
    @typing.overload
    def load(self, url:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def loadData(self, data:Union[PySide6.QtCore.QByteArray, bytes], url:Union[PySide6.QtCore.QUrl, str]=...) -> None: ...
    def rootObjects(self) -> List[PySide6.QtCore.QObject]: ...
    def setExtraFileSelectors(self, extraFileSelectors:Sequence[str]) -> None: ...
    def setInitialProperties(self, initialProperties:Dict[str, Any]) -> None: ...


class QQmlComponent(PySide6.QtCore.QObject):
    PreferSynchronous        : QQmlComponent.CompilationMode = ... # 0x0
    Asynchronous             : QQmlComponent.CompilationMode = ... # 0x1
    Null                     : QQmlComponent.Status = ... # 0x0
    Ready                    : QQmlComponent.Status = ... # 0x1
    Loading                  : QQmlComponent.Status = ... # 0x2
    Error                    : QQmlComponent.Status = ... # 0x3

    class CompilationMode(Shiboken.Enum):
        PreferSynchronous        : QQmlComponent.CompilationMode = ... # 0x0
        Asynchronous             : QQmlComponent.CompilationMode = ... # 0x1


    class Status(Shiboken.Enum):
        Null                     : QQmlComponent.Status = ... # 0x0
        Ready                    : QQmlComponent.Status = ... # 0x1
        Loading                  : QQmlComponent.Status = ... # 0x2
        Error                    : QQmlComponent.Status = ... # 0x3


    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, fileName:str, mode:PySide6.QtQml.QQmlComponent.CompilationMode, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, fileName:str, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, url:Union[PySide6.QtCore.QUrl, str], mode:PySide6.QtQml.QQmlComponent.CompilationMode, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, url:Union[PySide6.QtCore.QUrl, str], parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def beginCreate(self, arg__1:PySide6.QtQml.QQmlContext) -> PySide6.QtCore.QObject: ...
    def completeCreate(self) -> None: ...
    @typing.overload
    def create(self, arg__1:PySide6.QtQml.QQmlIncubator, context:Optional[PySide6.QtQml.QQmlContext]=..., forContext:Optional[PySide6.QtQml.QQmlContext]=...) -> None: ...
    @typing.overload
    def create(self, context:Optional[PySide6.QtQml.QQmlContext]=...) -> PySide6.QtCore.QObject: ...
    def createWithInitialProperties(self, initialProperties:Dict[str, Any], context:Optional[PySide6.QtQml.QQmlContext]=...) -> PySide6.QtCore.QObject: ...
    def creationContext(self) -> PySide6.QtQml.QQmlContext: ...
    def engine(self) -> PySide6.QtQml.QQmlEngine: ...
    def errorString(self) -> str: ...
    def errors(self) -> List[PySide6.QtQml.QQmlError]: ...
    def isError(self) -> bool: ...
    def isLoading(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isReady(self) -> bool: ...
    @typing.overload
    def loadUrl(self, url:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    @typing.overload
    def loadUrl(self, url:Union[PySide6.QtCore.QUrl, str], mode:PySide6.QtQml.QQmlComponent.CompilationMode) -> None: ...
    def progress(self) -> float: ...
    def setData(self, arg__1:Union[PySide6.QtCore.QByteArray, bytes], baseUrl:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def setInitialProperties(self, component:PySide6.QtCore.QObject, properties:Dict[str, Any]) -> None: ...
    def status(self) -> PySide6.QtQml.QQmlComponent.Status: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QQmlContext(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self, parent:PySide6.QtQml.QQmlContext, objParent:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, parent:PySide6.QtQml.QQmlEngine, objParent:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def baseUrl(self) -> PySide6.QtCore.QUrl: ...
    def contextObject(self) -> PySide6.QtCore.QObject: ...
    def contextProperty(self, arg__1:str) -> Any: ...
    def engine(self) -> PySide6.QtQml.QQmlEngine: ...
    def importedScript(self, name:str) -> PySide6.QtQml.QJSValue: ...
    def isValid(self) -> bool: ...
    def nameForObject(self, arg__1:PySide6.QtCore.QObject) -> str: ...
    def parentContext(self) -> PySide6.QtQml.QQmlContext: ...
    def resolvedUrl(self, arg__1:Union[PySide6.QtCore.QUrl, str]) -> PySide6.QtCore.QUrl: ...
    def setBaseUrl(self, arg__1:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def setContextObject(self, arg__1:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def setContextProperty(self, arg__1:str, arg__2:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def setContextProperty(self, arg__1:str, arg__2:Any) -> None: ...


class QQmlDebuggingEnabler(Shiboken.Object):
    DoNotWaitForClient       : QQmlDebuggingEnabler.StartMode = ... # 0x0
    WaitForClient            : QQmlDebuggingEnabler.StartMode = ... # 0x1

    class StartMode(Shiboken.Enum):
        DoNotWaitForClient       : QQmlDebuggingEnabler.StartMode = ... # 0x0
        WaitForClient            : QQmlDebuggingEnabler.StartMode = ... # 0x1


    def __init__(self, printWarning:bool=...) -> None: ...

    @staticmethod
    def connectToLocalDebugger(socketFileName:str, mode:PySide6.QtQml.QQmlDebuggingEnabler.StartMode=...) -> bool: ...
    @staticmethod
    def debuggerServices() -> List[str]: ...
    @staticmethod
    def inspectorServices() -> List[str]: ...
    @staticmethod
    def nativeDebuggerServices() -> List[str]: ...
    @staticmethod
    def profilerServices() -> List[str]: ...
    @staticmethod
    def setServices(services:Sequence[str]) -> None: ...
    @staticmethod
    def startDebugConnector(pluginName:str, configuration:Dict[str, Any]=...) -> bool: ...
    @staticmethod
    def startTcpDebugServer(port:int, mode:PySide6.QtQml.QQmlDebuggingEnabler.StartMode=..., hostName:str=...) -> bool: ...


class QQmlEngine(PySide6.QtQml.QJSEngine):

    def __init__(self, p:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def addImageProvider(self, id:str, arg__2:PySide6.QtQml.QQmlImageProviderBase) -> None: ...
    def addImportPath(self, dir:str) -> None: ...
    def addNamedBundle(self, arg__1:str, arg__2:str) -> bool: ...
    def addPluginPath(self, dir:str) -> None: ...
    def addUrlInterceptor(self, urlInterceptor:PySide6.QtQml.QQmlAbstractUrlInterceptor) -> None: ...
    def baseUrl(self) -> PySide6.QtCore.QUrl: ...
    def captureProperty(self, object:PySide6.QtCore.QObject, property:PySide6.QtCore.QMetaProperty) -> None: ...
    def clearComponentCache(self) -> None: ...
    @staticmethod
    def contextForObject(arg__1:PySide6.QtCore.QObject) -> PySide6.QtQml.QQmlContext: ...
    def event(self, arg__1:PySide6.QtCore.QEvent) -> bool: ...
    def imageProvider(self, id:str) -> PySide6.QtQml.QQmlImageProviderBase: ...
    def importPathList(self) -> List[str]: ...
    def importPlugin(self, filePath:str, uri:str, errors:Sequence[PySide6.QtQml.QQmlError]) -> bool: ...
    def incubationController(self) -> PySide6.QtQml.QQmlIncubationController: ...
    def interceptUrl(self, url:Union[PySide6.QtCore.QUrl, str], type:PySide6.QtQml.QQmlAbstractUrlInterceptor.DataType) -> PySide6.QtCore.QUrl: ...
    def networkAccessManager(self) -> PySide6.QtNetwork.QNetworkAccessManager: ...
    def networkAccessManagerFactory(self) -> PySide6.QtQml.QQmlNetworkAccessManagerFactory: ...
    def offlineStorageDatabaseFilePath(self, databaseName:str) -> str: ...
    def offlineStoragePath(self) -> str: ...
    def outputWarningsToStandardError(self) -> bool: ...
    def pluginPathList(self) -> List[str]: ...
    def removeImageProvider(self, id:str) -> None: ...
    def removeUrlInterceptor(self, urlInterceptor:PySide6.QtQml.QQmlAbstractUrlInterceptor) -> None: ...
    def retranslate(self) -> None: ...
    def rootContext(self) -> PySide6.QtQml.QQmlContext: ...
    def setBaseUrl(self, arg__1:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    @staticmethod
    def setContextForObject(arg__1:PySide6.QtCore.QObject, arg__2:PySide6.QtQml.QQmlContext) -> None: ...
    def setImportPathList(self, paths:Sequence[str]) -> None: ...
    def setIncubationController(self, arg__1:PySide6.QtQml.QQmlIncubationController) -> None: ...
    def setNetworkAccessManagerFactory(self, arg__1:PySide6.QtQml.QQmlNetworkAccessManagerFactory) -> None: ...
    def setOfflineStoragePath(self, dir:str) -> None: ...
    def setOutputWarningsToStandardError(self, arg__1:bool) -> None: ...
    def setPluginPathList(self, paths:Sequence[str]) -> None: ...
    def setUrlInterceptor(self, urlInterceptor:PySide6.QtQml.QQmlAbstractUrlInterceptor) -> None: ...
    def trimComponentCache(self) -> None: ...
    def urlInterceptor(self) -> PySide6.QtQml.QQmlAbstractUrlInterceptor: ...


class QQmlError(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlError) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def column(self) -> int: ...
    def description(self) -> str: ...
    def isValid(self) -> bool: ...
    def line(self) -> int: ...
    def messageType(self) -> PySide6.QtCore.QtMsgType: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def setColumn(self, arg__1:int) -> None: ...
    def setDescription(self, arg__1:str) -> None: ...
    def setLine(self, arg__1:int) -> None: ...
    def setMessageType(self, messageType:PySide6.QtCore.QtMsgType) -> None: ...
    def setObject(self, arg__1:PySide6.QtCore.QObject) -> None: ...
    def setUrl(self, arg__1:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def toString(self) -> str: ...
    def url(self) -> PySide6.QtCore.QUrl: ...


class QQmlExpression(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlContext, arg__2:PySide6.QtCore.QObject, arg__3:str, arg__4:Optional[PySide6.QtCore.QObject]=...) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlScriptString, arg__2:Optional[PySide6.QtQml.QQmlContext]=..., arg__3:Optional[PySide6.QtCore.QObject]=..., arg__4:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def clearError(self) -> None: ...
    def columnNumber(self) -> int: ...
    def context(self) -> PySide6.QtQml.QQmlContext: ...
    def engine(self) -> PySide6.QtQml.QQmlEngine: ...
    def error(self) -> PySide6.QtQml.QQmlError: ...
    def evaluate(self) -> Tuple[Any, bool]: ...
    def expression(self) -> str: ...
    def hasError(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def notifyOnValueChanged(self) -> bool: ...
    def scopeObject(self) -> PySide6.QtCore.QObject: ...
    def setExpression(self, arg__1:str) -> None: ...
    def setNotifyOnValueChanged(self, arg__1:bool) -> None: ...
    def setSourceLocation(self, fileName:str, line:int, column:int=...) -> None: ...
    def sourceFile(self) -> str: ...


class QQmlExtensionInterface(PySide6.QtQml.QQmlTypesExtensionInterface):

    def __init__(self) -> None: ...

    def initializeEngine(self, engine:PySide6.QtQml.QQmlEngine, uri:bytes) -> None: ...


class QQmlExtensionPlugin(PySide6.QtCore.QObject, PySide6.QtQml.QQmlExtensionInterface):

    def __init__(self, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def baseUrl(self) -> PySide6.QtCore.QUrl: ...
    def initializeEngine(self, engine:PySide6.QtQml.QQmlEngine, uri:bytes) -> None: ...
    def registerTypes(self, uri:bytes) -> None: ...
    def unregisterTypes(self) -> None: ...


class QQmlFile(Shiboken.Object):
    Null                     : QQmlFile.Status = ... # 0x0
    Ready                    : QQmlFile.Status = ... # 0x1
    Error                    : QQmlFile.Status = ... # 0x2
    Loading                  : QQmlFile.Status = ... # 0x3

    class Status(Shiboken.Enum):
        Null                     : QQmlFile.Status = ... # 0x0
        Ready                    : QQmlFile.Status = ... # 0x1
        Error                    : QQmlFile.Status = ... # 0x2
        Loading                  : QQmlFile.Status = ... # 0x3


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, arg__2:str) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlEngine, arg__2:Union[PySide6.QtCore.QUrl, str]) -> None: ...

    @typing.overload
    def clear(self) -> None: ...
    @typing.overload
    def clear(self, arg__1:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def connectDownloadProgress(self, arg__1:PySide6.QtCore.QObject, arg__2:bytes) -> bool: ...
    @typing.overload
    def connectDownloadProgress(self, arg__1:PySide6.QtCore.QObject, arg__2:int) -> bool: ...
    @typing.overload
    def connectFinished(self, arg__1:PySide6.QtCore.QObject, arg__2:bytes) -> bool: ...
    @typing.overload
    def connectFinished(self, arg__1:PySide6.QtCore.QObject, arg__2:int) -> bool: ...
    def data(self) -> bytes: ...
    def dataByteArray(self) -> PySide6.QtCore.QByteArray: ...
    def error(self) -> str: ...
    def isError(self) -> bool: ...
    def isLoading(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isLocalFile(url:str) -> bool: ...
    @typing.overload
    @staticmethod
    def isLocalFile(url:Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    def isNull(self) -> bool: ...
    def isReady(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isSynchronous(url:str) -> bool: ...
    @typing.overload
    @staticmethod
    def isSynchronous(url:Union[PySide6.QtCore.QUrl, str]) -> bool: ...
    @typing.overload
    def load(self, arg__1:PySide6.QtQml.QQmlEngine, arg__2:str) -> None: ...
    @typing.overload
    def load(self, arg__1:PySide6.QtQml.QQmlEngine, arg__2:Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def size(self) -> int: ...
    def status(self) -> PySide6.QtQml.QQmlFile.Status: ...
    def url(self) -> PySide6.QtCore.QUrl: ...
    @typing.overload
    @staticmethod
    def urlToLocalFileOrQrc(arg__1:str) -> str: ...
    @typing.overload
    @staticmethod
    def urlToLocalFileOrQrc(arg__1:Union[PySide6.QtCore.QUrl, str]) -> str: ...


class QQmlFileSelector(PySide6.QtCore.QObject):

    def __init__(self, engine:PySide6.QtQml.QQmlEngine, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    @staticmethod
    def get(arg__1:PySide6.QtQml.QQmlEngine) -> PySide6.QtQml.QQmlFileSelector: ...
    def selector(self) -> PySide6.QtCore.QFileSelector: ...
    def setExtraSelectors(self, strings:Sequence[str]) -> None: ...
    def setSelector(self, selector:PySide6.QtCore.QFileSelector) -> None: ...


class QQmlImageProviderBase(PySide6.QtCore.QObject):
    ForceAsynchronousImageLoading: QQmlImageProviderBase.Flag = ... # 0x1
    Invalid                  : QQmlImageProviderBase.ImageType = ... # 0x0
    Image                    : QQmlImageProviderBase.ImageType = ... # 0x1
    Pixmap                   : QQmlImageProviderBase.ImageType = ... # 0x2
    Texture                  : QQmlImageProviderBase.ImageType = ... # 0x3
    ImageResponse            : QQmlImageProviderBase.ImageType = ... # 0x4

    class Flag(Shiboken.Enum):
        ForceAsynchronousImageLoading: QQmlImageProviderBase.Flag = ... # 0x1


    class Flags(object):

    class ImageType(Shiboken.Enum):
        Invalid                  : QQmlImageProviderBase.ImageType = ... # 0x0
        Image                    : QQmlImageProviderBase.ImageType = ... # 0x1
        Pixmap                   : QQmlImageProviderBase.ImageType = ... # 0x2
        Texture                  : QQmlImageProviderBase.ImageType = ... # 0x3
        ImageResponse            : QQmlImageProviderBase.ImageType = ... # 0x4


    def flags(self) -> PySide6.QtQml.QQmlImageProviderBase.Flags: ...
    def imageType(self) -> PySide6.QtQml.QQmlImageProviderBase.ImageType: ...


class QQmlIncubationController(Shiboken.Object):

    def __init__(self) -> None: ...

    def engine(self) -> PySide6.QtQml.QQmlEngine: ...
    def incubateFor(self, msecs:int) -> None: ...
    def incubateWhile(self, msecs:int=...) -> bool: ...
    def incubatingObjectCount(self) -> int: ...
    def incubatingObjectCountChanged(self, arg__1:int) -> None: ...


class QQmlIncubator(Shiboken.Object):
    Asynchronous             : QQmlIncubator.IncubationMode = ... # 0x0
    AsynchronousIfNested     : QQmlIncubator.IncubationMode = ... # 0x1
    Synchronous              : QQmlIncubator.IncubationMode = ... # 0x2
    Null                     : QQmlIncubator.Status = ... # 0x0
    Ready                    : QQmlIncubator.Status = ... # 0x1
    Loading                  : QQmlIncubator.Status = ... # 0x2
    Error                    : QQmlIncubator.Status = ... # 0x3

    class IncubationMode(Shiboken.Enum):
        Asynchronous             : QQmlIncubator.IncubationMode = ... # 0x0
        AsynchronousIfNested     : QQmlIncubator.IncubationMode = ... # 0x1
        Synchronous              : QQmlIncubator.IncubationMode = ... # 0x2


    class Status(Shiboken.Enum):
        Null                     : QQmlIncubator.Status = ... # 0x0
        Ready                    : QQmlIncubator.Status = ... # 0x1
        Loading                  : QQmlIncubator.Status = ... # 0x2
        Error                    : QQmlIncubator.Status = ... # 0x3


    def __init__(self, arg__1:PySide6.QtQml.QQmlIncubator.IncubationMode=...) -> None: ...

    def clear(self) -> None: ...
    def errors(self) -> List[PySide6.QtQml.QQmlError]: ...
    def forceCompletion(self) -> None: ...
    def incubationMode(self) -> PySide6.QtQml.QQmlIncubator.IncubationMode: ...
    def isError(self) -> bool: ...
    def isLoading(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isReady(self) -> bool: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def setInitialProperties(self, initialProperties:Dict[str, Any]) -> None: ...
    def setInitialState(self, arg__1:PySide6.QtCore.QObject) -> None: ...
    def status(self) -> PySide6.QtQml.QQmlIncubator.Status: ...
    def statusChanged(self, arg__1:PySide6.QtQml.QQmlIncubator.Status) -> None: ...


class QQmlListReference(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject, property:bytes, arg__3:Optional[PySide6.QtQml.QQmlEngine]=...) -> None: ...
    @typing.overload
    def __init__(self, arg__1:Union[PySide6.QtQml.QQmlListReference, Any]) -> None: ...
    @typing.overload
    def __init__(self, variant:Any, engine:Optional[PySide6.QtQml.QQmlEngine]=...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def append(self, arg__1:PySide6.QtCore.QObject) -> bool: ...
    def at(self, arg__1:int) -> PySide6.QtCore.QObject: ...
    def canAppend(self) -> bool: ...
    def canAt(self) -> bool: ...
    def canClear(self) -> bool: ...
    def canCount(self) -> bool: ...
    def canRemoveLast(self) -> bool: ...
    def canReplace(self) -> bool: ...
    def clear(self) -> bool: ...
    def count(self) -> int: ...
    def isManipulable(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isValid(self) -> bool: ...
    def listElementType(self) -> PySide6.QtCore.QMetaObject: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def removeLast(self) -> bool: ...
    def replace(self, arg__1:int, arg__2:PySide6.QtCore.QObject) -> bool: ...


class QQmlModuleImportSpecialVersions(Shiboken.Enum):
    QQmlModuleImportAuto     : QQmlModuleImportSpecialVersions = ... # -0x2
    QQmlModuleImportLatest   : QQmlModuleImportSpecialVersions = ... # -0x1
    QQmlModuleImportModuleAny: QQmlModuleImportSpecialVersions = ... # -0x1


class QQmlNetworkAccessManagerFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    def create(self, parent:PySide6.QtCore.QObject) -> PySide6.QtNetwork.QNetworkAccessManager: ...


class QQmlParserStatus(Shiboken.Object):

    def __init__(self) -> None: ...

    def classBegin(self) -> None: ...
    def componentComplete(self) -> None: ...


class QQmlProperty(Shiboken.Object):
    InvalidCategory          : QQmlProperty.PropertyTypeCategory = ... # 0x0
    List                     : QQmlProperty.PropertyTypeCategory = ... # 0x1
    Object                   : QQmlProperty.PropertyTypeCategory = ... # 0x2
    Normal                   : QQmlProperty.PropertyTypeCategory = ... # 0x3
    Invalid                  : QQmlProperty.Type = ... # 0x0
    Property                 : QQmlProperty.Type = ... # 0x1
    SignalProperty           : QQmlProperty.Type = ... # 0x2

    class PropertyTypeCategory(Shiboken.Enum):
        InvalidCategory          : QQmlProperty.PropertyTypeCategory = ... # 0x0
        List                     : QQmlProperty.PropertyTypeCategory = ... # 0x1
        Object                   : QQmlProperty.PropertyTypeCategory = ... # 0x2
        Normal                   : QQmlProperty.PropertyTypeCategory = ... # 0x3


    class Type(Shiboken.Enum):
        Invalid                  : QQmlProperty.Type = ... # 0x0
        Property                 : QQmlProperty.Type = ... # 0x1
        SignalProperty           : QQmlProperty.Type = ... # 0x2


    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject, arg__2:PySide6.QtQml.QQmlContext) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject, arg__2:PySide6.QtQml.QQmlEngine) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject, arg__2:str) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:PySide6.QtQml.QQmlContext) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:PySide6.QtQml.QQmlEngine) -> None: ...
    @typing.overload
    def __init__(self, arg__1:Union[PySide6.QtQml.QQmlProperty, PySide6.QtCore.QObject]) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @typing.overload
    def connectNotifySignal(self, dest:PySide6.QtCore.QObject, method:int) -> bool: ...
    @typing.overload
    def connectNotifySignal(self, dest:PySide6.QtCore.QObject, slot:bytes) -> bool: ...
    def hasNotifySignal(self) -> bool: ...
    def index(self) -> int: ...
    def isDesignable(self) -> bool: ...
    def isProperty(self) -> bool: ...
    def isResettable(self) -> bool: ...
    def isSignalProperty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def method(self) -> PySide6.QtCore.QMetaMethod: ...
    def name(self) -> str: ...
    def needsNotifySignal(self) -> bool: ...
    def object(self) -> PySide6.QtCore.QObject: ...
    def property(self) -> PySide6.QtCore.QMetaProperty: ...
    def propertyMetaType(self) -> PySide6.QtCore.QMetaType: ...
    def propertyType(self) -> int: ...
    def propertyTypeCategory(self) -> PySide6.QtQml.QQmlProperty.PropertyTypeCategory: ...
    def propertyTypeName(self) -> bytes: ...
    @typing.overload
    @staticmethod
    def read(arg__1:PySide6.QtCore.QObject, arg__2:str) -> Any: ...
    @typing.overload
    @staticmethod
    def read(arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:PySide6.QtQml.QQmlContext) -> Any: ...
    @typing.overload
    @staticmethod
    def read(arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:PySide6.QtQml.QQmlEngine) -> Any: ...
    @typing.overload
    def read(self) -> Any: ...
    def reset(self) -> bool: ...
    def type(self) -> PySide6.QtQml.QQmlProperty.Type: ...
    @typing.overload
    @staticmethod
    def write(arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:Any) -> bool: ...
    @typing.overload
    @staticmethod
    def write(arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:Any, arg__4:PySide6.QtQml.QQmlContext) -> bool: ...
    @typing.overload
    @staticmethod
    def write(arg__1:PySide6.QtCore.QObject, arg__2:str, arg__3:Any, arg__4:PySide6.QtQml.QQmlEngine) -> bool: ...
    @typing.overload
    def write(self, arg__1:Any) -> bool: ...


class QQmlPropertyMap(PySide6.QtCore.QObject):

    def __init__(self, parent:Optional[PySide6.QtCore.QObject]=...) -> None: ...

    def clear(self, key:str) -> None: ...
    def contains(self, key:str) -> bool: ...
    def count(self) -> int: ...
    def freeze(self) -> None: ...
    @typing.overload
    def insert(self, key:str, value:Any) -> None: ...
    @typing.overload
    def insert(self, values:Dict[str, Any]) -> None: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> List[str]: ...
    def size(self) -> int: ...
    def updateValue(self, key:str, input:Any) -> Any: ...
    def value(self, key:str) -> Any: ...


class QQmlPropertyValueSource(Shiboken.Object):

    def __init__(self) -> None: ...

    def setTarget(self, arg__1:Union[PySide6.QtQml.QQmlProperty, PySide6.QtCore.QObject]) -> None: ...


class QQmlScriptString(Shiboken.Object):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, arg__1:PySide6.QtQml.QQmlScriptString) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def booleanLiteral(self) -> Tuple[bool, bool]: ...
    def isEmpty(self) -> bool: ...
    def isNullLiteral(self) -> bool: ...
    def isUndefinedLiteral(self) -> bool: ...
    def numberLiteral(self) -> Tuple[float, bool]: ...
    def stringLiteral(self) -> str: ...


class QQmlTypesExtensionInterface(Shiboken.Object):

    def __init__(self) -> None: ...

    def registerTypes(self, uri:bytes) -> None: ...


class VolatileBool(object):
    def get(self) -> bool: ...
    def set(self, a:object) -> None: ...


def QmlElement(arg__1:object) -> object: ...
@typing.overload
def qmlRegisterSingletonType(arg__1:type, arg__2:bytes, arg__3:int, arg__4:int, arg__5:bytes) -> int: ...
@typing.overload
def qmlRegisterSingletonType(arg__1:type, arg__2:bytes, arg__3:int, arg__4:int, arg__5:bytes, arg__6:object) -> int: ...
@typing.overload
def qmlRegisterSingletonType(arg__1:bytes, arg__2:int, arg__3:int, arg__4:bytes, arg__5:object) -> int: ...
def qmlRegisterType(arg__1:type, arg__2:bytes, arg__3:int, arg__4:int, arg__5:bytes) -> int: ...
def qmlRegisterUncreatableType(arg__1:type, arg__2:bytes, arg__3:int, arg__4:int, arg__5:bytes, arg__6:bytes) -> int: ...


# eof
