KEYWORDS_C = [
    "alignas",
    "alignof",
    "auto",
    "bool",
    "break",
    "case",
    "char",
    "const",
    "constexpr",
    "continue",
    "default",
    "do",
    "double",
    "else",
    "enum",
    "extern",
    "false",
    "float",
    "for",
    "goto",
    "if",
    "inline",
    "int",
    "long",
    "nullptr",
    "register",
    "restrict",
    "return",
    "short",
    "signed",
    "sizeof",
    "static",
    "static_assert",
    "struct",
    "switch",
    "thread_local",
    "true",
    "typedef",
    "typeof",
    "typeof_unqual",
    "union",
    "unsigned",
    "void",
    "volatile",
    "while",
    "_Alignas",
    "_Alignof",
    "_Atomic",
    "_BitInt",
    "_Bool",
    "_Complex",
    "_Decimal128",
    "_Decimal32",
    "_Decimal64",
    "_Generic",
    "_Imaginary",
    "_Noreturn",
    "_Static_assert",
    "_Thread_local",
    "printf",
    "snprintf",
    "strlen",
    "strcmp",
    "strcpy",
    "strncmp",
    "max",
    "min",
]


KEYWORDS_PY = [
    "abs",
    "aiter",
    "all",
    "anext",
    "any",
    "ascii",
    "bin",
    "bool",
    "breakpoint",
    "bytearray",
    "bytes",
    "callable",
    "chr",
    "classmethod",
    "compile",
    "complex",
    "delattr",
    "dict",
    "dir",
    "divmod",
    "enumerate",
    "eval",
    "exec",
    "filter",
    "float",
    "format",
    "frozenset",
    "getattr",
    "globals",
    "hasattr",
    "hash",
    "help",
    "hex",
    "id",
    "input",
    "int",
    "isinstance",
    "issubclass",
    "iter",
    "len",
    "list",
    "locals",
    "map",
    "max",
    "memoryview",
    "min",
    "next",
    "object",
    "oct",
    "open",
    "ord",
    "pow",
    "print",
    "property",
    "range",
    "repr",
    "reversed",
    "round",
    "set",
    "setattr",
    "slice",
    "sorted",
    "staticmethod",
    "str",
    "sum",
    "super",
    "tuple",
    "type",
    "vars",
    "zip",
    "__import__",
    "ZeroDivisionError",
    "ValueError",
    "AssertionError",
    "AttributeError",
    "EOFError",
    "FloatingPointError",
    "GeneratorExit",
    "ImportError",
    "IndexError",
    "KeyError",
    "KeyboardInterrupt",
    "MemoryError",
    "NameError",
    "NotImplementedError",
    "OSError",
    "OverflowError",
    "ReferenceError",
    "RuntimeError",
    "StopIteration",
    "SyntaxError",
    "IndentationError",
    "TabError",
    "SystemError",
    "SystemExit",
    "TypeError",
    "UnboundLocalError",
    "UnicodeError",
    "UnicodeEncodeError",
    "UnicodeDecodeError",
    "UnicodeTranslateError",
    "and",
    "or",
    "if",
    "in",
    "elif",
    "else",
    "with",
    "open",
    "append",
    "update",
    "readlines",
    "startswith",
    "endswith",
    "keys",
    "values",
    "pop",
    "join",
    "strip",
]


# Keep this in alphabetical other , you b*st*rd

KEYWORDS_FTN = {
    "abs": "other",
    "aimag": "other",
    "aint": "other",
    "all": "other",
    "allocatable": "other",
    "allocate": "other",
    "allocated": "other",
    "anint": "other",
    "any": "other",
    "asin": "other",
    "assign": "other",
    "assignment": "other",
    "associate": "nesting",
    "atan": "other",
    "atan2": "other",
    "backspace": "other",
    "bind": "other",
    "bit_size": "other",
    "block": "nesting",
    "blockdata": "structure",
    "btest": "other",
    "call": "other",
    "case": "other",
    "ceiling": "other",
    "char": "other",
    "character": "other",
    "close": "other",
    "class": "other",
    "cmplx": "other",
    "common": "other",
    "conjg": "other",
    "contains": "other",
    "continue": "other",
    "cos": "other",
    "cosh": "other",
    "count": "other",
    "cshift": "other",
    "cycle": "other",
    "data": "other",
    "date_and_time": "other",
    "deallocate": "other",
    "digits": "other",
    "dim": "other",
    "dimension": "other",
    "do": "nesting",
    "dot_product": "other",
    "dprod": "other",
    "dshiftl": "other",
    "dshiftr": "other",
    "else": "other",
    "elseif": "other",
    "elsewhere": "other",
    "end": "other",
    "endfile": "other",
    "entry": "other",
    "enum": "nesting",
    "eor": "other",
    "epsilon": "other",
    "equivalence": "other",
    "erf": "other",
    "erfc": "other",
    "etime": "other",
    "exit": "other",
    "exp": "other",
    "exponent": "other",
    "extends": "other",
    "extends_type_of": "other",
    "external": "other",
    "floor": "other",
    "forall": "nesting",
    "format": "other",
    "fraction": "other",
    "function": "structure",
    "function_elemental": "structure",  # Created to simplify struct analysis
    "function_pure": "structure",  # Created to simplify struct analysis
    "function_recursive": "structure",  # Created to simplify struct analysis
    "gamma": "other",
    "go": "other",
    "goto": "other",
    "huge": "other",
    "iachar": "other",
    "iall": "other",
    "iand": "other",
    "iany": "other",
    "ibclr": "other",
    "ibits": "other",
    "ibset": "other",
    "ichar": "other",
    "idate": "other",
    "idim": "other",
    "idint": "other",
    "idnint": "other",
    "ieor": "other",
    "ierrno": "other",
    "if": "nesting",
    "ifix": "other",
    "implicit": "other",
    "index": "other",
    "inquire": "other",
    "int": "other",
    "integer": "other",
    "intent": "other",
    "interface": "structure",
    "interface_abstract": "structure",  # Created to simplify struct analysis
    "intrinsic": "other",
    "ior": "other",
    "iparity": "other",
    "irand": "other",
    "is_iostat_end": "other",
    "is_iostat_eor": "other",
    "ishft": "other",
    "ishftc": "other",
    "kind": "other",
    "lbound": "other",
    "lcm": "other",
    "len": "other",
    "len_trim": "other",
    "lge": "other",
    "lgt": "other",
    "lle": "other",
    "llt": "other",
    "log": "other",
    "log10": "other",
    "log_gamma": "other",
    "logical": "other",
    "maskl": "other",
    "maskr": "other",
    "matmul": "other",
    "max": "other",
    "maxexponent": "other",
    "maxloc": "other",
    "maxval": "other",
    "merge": "other",
    "merge_bits": "other",
    "min": "other",
    "minexponent": "other",
    "minloc": "other",
    "minval": "other",
    "mod": "other",
    "module": "structure",
    "modulo": "other",
    "namelist": "other",
    "nearest": "other",
    "norm2": "other",
    "not": "other",
    "null": "other",
    "nullify": "other",
    "nworkers": "other",
    "only": "other",
    "open": "other",
    "operator": "other",
    "optional": "other",
    "pack": "other",
    "parameter": "other",
    "parity": "other",
    "pause": "other",
    "pointer": "other",
    "popcnt": "other",
    "poppar": "other",
    "precision": "other",
    "present": "other",
    "print": "other",
    "private": "other",
    "procedure": "other",
    "product": "other",
    "program": "structure",
    "public": "other",
    "radix": "other",
    "range": "other",
    "read": "other",
    "real": "other",
    "recursive": "other",
    "repeat": "other",
    "reshape": "other",
    "result": "other",
    "return": "other",
    "rewind": "other",
    "rrspacing": "other",
    "save": "other",
    "scale": "other",
    "scan": "other",
    "select": "other",
    "select_case": "nesting",  # Created to simplify struct analysis
    "select_type": "nesting",  # Created to simplify struct analysis
    "selected_int_kind": "other",
    "selected_real_kind": "other",
    "sequence": "other",
    "set_exponent": "other",
    "shape": "other",
    "shifta": "other",
    "shiftl": "other",
    "shiftr": "other",
    "sign": "other",
    "sin": "other",
    "sinh": "other",
    "size": "other",
    "spacing": "other",
    "spread": "other",
    "sqrt": "other",
    "stop": "other",
    "storage_size": "other",
    "subroutine": "structure",
    "subroutine_elemental": "structure",  # Created to simplify struct analysis
    "subroutine_recursive": "structure",  # Created to simplify struct analysis
    "sum": "other",
    "system_clock": "other",
    "tan": "other",
    "tanh": "other",
    "target": "other",
    "then": "other",
    "this_image": "other",
    "tiny": "other",
    "to": "other",
    "trailz": "other",
    "transfer": "other",
    "transpose": "other",
    "trim": "other",
    "type": "structure",
    "type_private": "structure",  # Created to simplify struct analysis
    "type_private_abstract": "structure",  # Created to simplify struct analysis
    "type_public": "structure",  # Created to simplify struct analysis
    "type_public_abstract": "structure",  # Created to simplify struct analysis
    "ubound": "other",
    "unpack": "other",
    "use": "other",
    "verify": "other",
    "where": "nesting",
    "while": "other",
    "write": "other",
    "xor": "other",
}

STRUCTURES_FTN = [key for key, value in KEYWORDS_FTN.items() if value == "structure"]
NESTS_FTN = [key for key, value in KEYWORDS_FTN.items() if value == "nesting"]
OTHERS_FTN = [key for key, value in KEYWORDS_FTN.items() if value == "other"]

CONTROL_PTS_FTN_ACTIVE = ["if","select_case", "select_type", "where","any"]
CONTROL_PTS_FTN_PASSIVE =  ["case", "else", "elif"]
CONTROL_LOOPS_FTN =  ["do", "forall", "where","any"]
CONTROL_PTS_C_ACTIVE = ["if"]
CONTROL_PTS_C_PASSIVE = ["case", "default"]
CONTROL_LOOPS_C =  ["do"]
CONTROL_PTS_PY_ACTIVE = ["if"]
CONTROL_PTS_PY_PASSIVE = ["elif","else"]
CONTROL_LOOPS_PY =  ["for"]
