# Generated by Django 3.2.23 on 2023-12-13 18:00

from django.db import migrations, models

import alexandria.core.models
import alexandria.storages.fields


def migrate_file_references(apps, schema_editor):
    """Migrate the download_url based content access to storage backend access.

    The simple object storage's object_name was simply the file's name. Setting
    the name to the file name in the storage attribute will refer retrieve
    the same object if it still exists.
    Just make sure to point the object storage client to the right endpoint
    and bucket before accessing the file.
    """
    File = apps.get_model("alexandria_core", "File")
    for file in File.objects.iterator():
        file.content.name = alexandria.core.models.upload_file_content_to(file, None)
        file.save()


class Migration(migrations.Migration):
    dependencies = [
        ("alexandria_core", "0012_tag_uuid_schema"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="file",
            name="upload_status",
        ),
        migrations.AddField(
            model_name="file",
            name="content",
            field=alexandria.storages.fields.DynamicStorageFileField(
                default="", upload_to=alexandria.core.models.upload_file_content_to
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="file",
            name="encryption_status",
            field=models.CharField(
                blank=True,
                choices=[
                    (None, "Encryption status not set"),
                    ("none", "No at-rest enryption"),
                    ("ssec-global", "SSE-C global key encryption (AES256)"),
                    ("ssec-object", "SSE-C per object encryption (AES256)"),
                ],
                default=None,
                max_length=12,
                null=True,
            ),
        ),
        migrations.RunPython(migrate_file_references, migrations.RunPython.noop),
    ]
