"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debounce = (func, waitFor) => {
    let timeout;
    return (...args) => new Promise(resolve => {
        if (timeout) {
            clearTimeout(timeout);
        }
        timeout = setTimeout(() => resolve(func(...args)), waitFor);
    });
};
exports.default = debounce;
//# sourceMappingURL=debounce.js.map