/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.Analysis;
import fpp.compiler.analysis.Analysis$;
import fpp.compiler.analysis.Analyzer;
import fpp.compiler.analysis.ComponentAnalyzer;
import fpp.compiler.analysis.ModuleAnalyzer;
import fpp.compiler.analysis.Name;
import fpp.compiler.analysis.Symbol;
import fpp.compiler.analysis.Symbol$AbsType$;
import fpp.compiler.analysis.Symbol$Array$;
import fpp.compiler.analysis.Symbol$Enum$;
import fpp.compiler.analysis.Symbol$Struct$;
import fpp.compiler.analysis.TopologyAnalyzer;
import fpp.compiler.analysis.Type;
import fpp.compiler.analysis.Type$;
import fpp.compiler.analysis.Type$AbsType$;
import fpp.compiler.analysis.Type$AnonArray$;
import fpp.compiler.analysis.Type$AnonStruct$;
import fpp.compiler.analysis.Type$Array$;
import fpp.compiler.analysis.Type$Boolean$;
import fpp.compiler.analysis.Type$Enum$;
import fpp.compiler.analysis.Type$String$;
import fpp.compiler.analysis.Type$Struct$;
import fpp.compiler.analysis.TypeExpressionAnalyzer;
import fpp.compiler.analysis.UseAnalyzer;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.Ast$F32$;
import fpp.compiler.ast.Ast$F64$;
import fpp.compiler.ast.Ast$I16$;
import fpp.compiler.ast.Ast$I32$;
import fpp.compiler.ast.Ast$I64$;
import fpp.compiler.ast.Ast$I8$;
import fpp.compiler.ast.Ast$U16$;
import fpp.compiler.ast.Ast$U32$;
import fpp.compiler.ast.Ast$U64$;
import fpp.compiler.ast.Ast$U8$;
import fpp.compiler.ast.AstNode;
import fpp.compiler.ast.AstStateVisitor;
import fpp.compiler.ast.AstVisitor;
import fpp.compiler.ast.Locations$;
import fpp.compiler.util.Error;
import fpp.compiler.util.Location;
import fpp.compiler.util.SemanticError$InvalidSymbol$;
import fpp.compiler.util.SemanticError$InvalidType$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class CheckTypeUses$
implements AstVisitor,
AstStateVisitor,
Analyzer,
ComponentAnalyzer,
ModuleAnalyzer,
TopologyAnalyzer,
TypeExpressionAnalyzer,
UseAnalyzer,
Serializable {
    public static final CheckTypeUses$ MODULE$ = new CheckTypeUses$();

    private CheckTypeUses$() {
    }

    @Override
    public /* synthetic */ Either fpp$compiler$analysis$UseAnalyzer$$super$defComponentInstanceAnnotatedNode(Analysis a, Tuple3 node) {
        return TypeExpressionAnalyzer.defComponentInstanceAnnotatedNode$(this, a, node);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CheckTypeUses$.class);
    }

    public Either<Error, Analysis> defAbsTypeAnnotatedNode(Analysis a2, Tuple3<List<String>, AstNode<Ast.DefAbsType>, List<String>> aNode2) {
        return this.visitIfNeeded((Function2<Analysis, Tuple3, Either> & Serializable)(a, aNode) -> this.visitor$1((Analysis)a, (Tuple3)aNode), a2, aNode2);
    }

    @Override
    public Either<Error, Analysis> defArrayAnnotatedNode(Analysis a2, Tuple3<List<String>, AstNode<Ast.DefArray>, List<String>> aNode2) {
        return this.visitIfNeeded((Function2<Analysis, Tuple3, Either> & Serializable)(a, aNode) -> this.visitor$2((Analysis)a, (Tuple3)aNode), a2, aNode2);
    }

    @Override
    public Either<Error, Analysis> defEnumAnnotatedNode(Analysis a2, Tuple3<List<String>, AstNode<Ast.DefEnum>, List<String>> aNode2) {
        return this.visitIfNeeded((Function2<Analysis, Tuple3, Either> & Serializable)(a, aNode) -> this.visitor$3((Analysis)a, (Tuple3)aNode), a2, aNode2);
    }

    @Override
    public Either<Error, Analysis> defStructAnnotatedNode(Analysis a2, Tuple3<List<String>, AstNode<Ast.DefStruct>, List<String>> aNode2) {
        return this.visitIfNeeded((Function2<Analysis, Tuple3, Either> & Serializable)(a, aNode) -> this.visitor$5((Analysis)a, (Tuple3)aNode), a2, aNode2);
    }

    @Override
    public Either<Error, Analysis> exprNode(Analysis a, AstNode<Ast.Expr> node) {
        return this.default(a);
    }

    public Either<Error, Analysis> typeNameBoolNode(Analysis a, AstNode<Ast.TypeName> node) {
        AstNode<Ast.TypeName> astNode = Predef$.MODULE$.ArrowAssoc(node);
        return package$.MODULE$.Right().apply(a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, Type$Boolean$.MODULE$)));
    }

    public Either<Error, Analysis> typeNameFloatNode(Analysis a, AstNode<Ast.TypeName> node, Ast.TypeNameFloat tn) {
        Type.Float float_;
        Ast.TypeFloat typeFloat = tn.name();
        if (typeFloat instanceof Ast.F32 && Ast$F32$.MODULE$.unapply((Ast.F32)typeFloat)) {
            float_ = Type$.MODULE$.F32();
        } else if (typeFloat instanceof Ast.F64 && Ast$F64$.MODULE$.unapply((Ast.F64)typeFloat)) {
            float_ = Type$.MODULE$.F64();
        } else {
            throw new MatchError(typeFloat);
        }
        Type.Float t = float_;
        AstNode<Ast.TypeName> astNode = Predef$.MODULE$.ArrowAssoc(node);
        return package$.MODULE$.Right().apply(a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t)));
    }

    public Either<Error, Analysis> typeNameIntNode(Analysis a, AstNode<Ast.TypeName> node, Ast.TypeNameInt tn) {
        Type.PrimitiveInt primitiveInt;
        Ast.TypeInt typeInt = tn.name();
        if (typeInt instanceof Ast.I8 && Ast$I8$.MODULE$.unapply((Ast.I8)typeInt)) {
            primitiveInt = Type$.MODULE$.I8();
        } else if (typeInt instanceof Ast.I16 && Ast$I16$.MODULE$.unapply((Ast.I16)typeInt)) {
            primitiveInt = Type$.MODULE$.I16();
        } else if (typeInt instanceof Ast.I32 && Ast$I32$.MODULE$.unapply((Ast.I32)typeInt)) {
            primitiveInt = Type$.MODULE$.I32();
        } else if (typeInt instanceof Ast.I64 && Ast$I64$.MODULE$.unapply((Ast.I64)typeInt)) {
            primitiveInt = Type$.MODULE$.I64();
        } else if (typeInt instanceof Ast.U8 && Ast$U8$.MODULE$.unapply((Ast.U8)typeInt)) {
            primitiveInt = Type$.MODULE$.U8();
        } else if (typeInt instanceof Ast.U16 && Ast$U16$.MODULE$.unapply((Ast.U16)typeInt)) {
            primitiveInt = Type$.MODULE$.U16();
        } else if (typeInt instanceof Ast.U32 && Ast$U32$.MODULE$.unapply((Ast.U32)typeInt)) {
            primitiveInt = Type$.MODULE$.U32();
        } else if (typeInt instanceof Ast.U64 && Ast$U64$.MODULE$.unapply((Ast.U64)typeInt)) {
            primitiveInt = Type$.MODULE$.U64();
        } else {
            throw new MatchError(typeInt);
        }
        Type.PrimitiveInt t = primitiveInt;
        AstNode<Ast.TypeName> astNode = Predef$.MODULE$.ArrowAssoc(node);
        return package$.MODULE$.Right().apply(a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t)));
    }

    @Override
    public Either<Error, Analysis> typeNameStringNode(Analysis a, AstNode<Ast.TypeName> node, Ast.TypeNameString tn) {
        AstNode<Ast.TypeName> astNode = Predef$.MODULE$.ArrowAssoc(node);
        return package$.MODULE$.Right().apply(a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, Type$String$.MODULE$.apply(tn.size()))));
    }

    @Override
    public Either<Error, Analysis> typeUse(Analysis a, AstNode<Ast.TypeName> node, Name.Qualified use) {
        return this.visitUse(a, node);
    }

    private <T> Either<Error, Analysis> visitUse(Analysis a2, AstNode<T> node) {
        Either either;
        Symbol symbol = (Symbol)a2.useDefMap().apply(BoxesRunTime.boxToInteger(node.id()));
        Symbol symbol2 = symbol;
        if (symbol2 instanceof Symbol.AbsType) {
            Tuple3<List<String>, AstNode<Ast.DefAbsType>, List<String>> tuple3;
            Symbol.AbsType absType = Symbol$AbsType$.MODULE$.unapply((Symbol.AbsType)symbol2);
            Tuple3<List<String>, AstNode<Ast.DefAbsType>, List<String>> node2 = tuple3 = absType._1();
            either = this.defAbsTypeAnnotatedNode(a2, node2);
        } else if (symbol2 instanceof Symbol.Array) {
            Tuple3<List<String>, AstNode<Ast.DefArray>, List<String>> tuple3;
            Symbol.Array array = Symbol$Array$.MODULE$.unapply((Symbol.Array)symbol2);
            Tuple3<List<String>, AstNode<Ast.DefArray>, List<String>> node3 = tuple3 = array._1();
            either = this.defArrayAnnotatedNode(a2, node3);
        } else if (symbol2 instanceof Symbol.Enum) {
            Tuple3<List<String>, AstNode<Ast.DefEnum>, List<String>> tuple3;
            Symbol.Enum enum_ = Symbol$Enum$.MODULE$.unapply((Symbol.Enum)symbol2);
            Tuple3<List<String>, AstNode<Ast.DefEnum>, List<String>> node4 = tuple3 = enum_._1();
            either = this.defEnumAnnotatedNode(a2, node4);
        } else if (symbol2 instanceof Symbol.Struct) {
            Tuple3<List<String>, AstNode<Ast.DefStruct>, List<String>> tuple3;
            Symbol.Struct struct = Symbol$Struct$.MODULE$.unapply((Symbol.Struct)symbol2);
            Tuple3<List<String>, AstNode<Ast.DefStruct>, List<String>> node5 = tuple3 = struct._1();
            either = this.defStructAnnotatedNode(a2, node5);
        } else {
            either = package$.MODULE$.Right().apply(a2);
        }
        return either.flatMap((Function1<Analysis, Either> & Serializable)a -> {
            Right right;
            Option option = a.typeMap().get(BoxesRunTime.boxToInteger(symbol.getNodeId()));
            if (option instanceof Some) {
                Type t2 = (Type)((Some)option).value();
                right = package$.MODULE$.Right().apply(t2);
            } else if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Left().apply(SemanticError$InvalidSymbol$.MODULE$.apply(symbol.getUnqualifiedName(), Locations$.MODULE$.get(node.id()), "not a type symbol", symbol.getLoc()));
            } else {
                throw new MatchError(option);
            }
            return right.map((Function1<Type, Analysis> & Serializable)t -> {
                AstNode astNode = Predef$.MODULE$.ArrowAssoc(node);
                return a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t));
            });
        });
    }

    private <T> Either<Error, Analysis> visitIfNeeded(Function2<Analysis, Tuple3<List<String>, AstNode<T>, List<String>>, Either<Error, Analysis>> visitor, Analysis a, Tuple3<List<String>, AstNode<T>, List<String>> aNode) {
        AstNode<T> node = aNode._2();
        return !a.typeMap().contains(BoxesRunTime.boxToInteger(node.id())) ? visitor.apply(a, aNode) : package$.MODULE$.Right().apply(a);
    }

    private final Right visitor$1(Analysis a, Tuple3 aNode) {
        Type.AbsType t = Type$AbsType$.MODULE$.apply(aNode);
        AstNode node = (AstNode)aNode._2();
        AstNode astNode = Predef$.MODULE$.ArrowAssoc(node);
        return package$.MODULE$.Right().apply(a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t)));
    }

    private final Either visitor$2(Analysis a2, Tuple3 aNode) {
        return TypeExpressionAnalyzer.defArrayAnnotatedNode$(this, a2, aNode).map((Function1<Analysis, Analysis> & Serializable)a -> {
            Tuple3 tuple3 = aNode;
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            AstNode node = (AstNode)tuple3._2();
            AstNode node2 = node;
            Ast.DefArray data = (Ast.DefArray)node2.data();
            Type eltType = (Type)a.typeMap().apply(BoxesRunTime.boxToInteger(data.eltType().id()));
            Type.AnonArray anonArray = Type$AnonArray$.MODULE$.apply(None$.MODULE$, eltType);
            Type.Array t = Type$Array$.MODULE$.apply(aNode, anonArray, Type$Array$.MODULE$.$lessinit$greater$default$3(), Type$Array$.MODULE$.$lessinit$greater$default$4());
            AstNode astNode = Predef$.MODULE$.ArrowAssoc(node2);
            return a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t));
        });
    }

    private final Either visitor$4(Type.Enum t$1, Analysis a, Tuple3 aNode) {
        AstNode astNode = (AstNode)Predef$.MODULE$.ArrowAssoc(aNode._2());
        return package$.MODULE$.Right().apply(a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t$1)));
    }

    private final Either visitor$3(Analysis a2, Tuple3 aNode) {
        Tuple3 tuple3 = aNode;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AstNode node = (AstNode)tuple3._2();
        AstNode node2 = node;
        Ast.DefEnum data = (Ast.DefEnum)node2.data();
        Location loc = Locations$.MODULE$.get(node2.id());
        return TypeExpressionAnalyzer.defEnumAnnotatedNode$(this, a2, aNode).flatMap((Function1<Analysis, Either> & Serializable)a -> {
            List<Tuple3<List<String>, AstNode<Ast.DefEnumConstant>, List<String>>> list = data.constants();
            Nil$ nil$ = package$.MODULE$.Nil();
            List<Tuple3<List<String>, AstNode<Ast.DefEnumConstant>, List<String>>> list2 = list;
            return (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null) ? package$.MODULE$.Left().apply(SemanticError$InvalidType$.MODULE$.apply(loc, "enum must define at least one constant")) : package$.MODULE$.Right().apply(BoxedUnit.UNIT)).flatMap((Function1<BoxedUnit, Either> & Serializable)x$1 -> {
                Right right;
                BoxedUnit boxedUnit = x$1;
                Option<AstNode<Ast.TypeName>> option = data.typeName();
                if (option instanceof Some) {
                    AstNode typeName = (AstNode)((Some)option).value();
                    Type repType2 = (Type)a.typeMap().apply(BoxesRunTime.boxToInteger(typeName.id()));
                    Location loc = Locations$.MODULE$.get(typeName.id());
                    Type type = repType2;
                    if (type instanceof Type.PrimitiveInt) {
                        Type.PrimitiveInt t = (Type.PrimitiveInt)type;
                        right = package$.MODULE$.Right().apply(t);
                    } else {
                        right = package$.MODULE$.Left().apply(SemanticError$InvalidType$.MODULE$.apply(loc, "primitive integer type required"));
                    }
                } else if (None$.MODULE$.equals(option)) {
                    right = package$.MODULE$.Right().apply(Type$.MODULE$.I32());
                } else {
                    throw new MatchError(option);
                }
                return right.flatMap((Function1<Type.PrimitiveInt, Either> & Serializable)repType -> {
                    Type.Enum t = Type$Enum$.MODULE$.apply(aNode, (Type.PrimitiveInt)repType, Type$Enum$.MODULE$.$lessinit$greater$default$3());
                    AstNode astNode = Predef$.MODULE$.ArrowAssoc(node2);
                    Analysis a1 = a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t));
                    return this.visitList((Object)a1, data.constants(), (Function2<Analysis, Tuple3, Either> & Serializable)(T1 a, T2 aNode) -> this.visitor$4(t, (Analysis)a, (Tuple3)aNode)).map((Function1<Analysis, Analysis> & Serializable)a -> a);
                });
            });
        });
    }

    private final String getName$1(Ast.StructTypeMember member) {
        return member.name();
    }

    private final Map visitor$6(Analysis a$4, Map members, Tuple3 aNode) {
        Tuple3 tuple3 = aNode;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AstNode node = (AstNode)tuple3._2();
        AstNode node2 = node;
        Ast.StructTypeMember data = (Ast.StructTypeMember)node2.data();
        Type t = (Type)a$4.typeMap().apply(BoxesRunTime.boxToInteger(data.typeName().id()));
        String string2 = Predef$.MODULE$.ArrowAssoc(data.name());
        return (Map)members.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, t));
    }

    private final Either visitor$5(Analysis a, Tuple3 aNode) {
        Tuple3 tuple3 = aNode;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AstNode node = (AstNode)tuple3._2();
        AstNode node2 = node;
        Ast.DefStruct data = (Ast.DefStruct)node2.data();
        return Analysis$.MODULE$.checkForDuplicateStructMember((Function1<Ast.StructTypeMember, String> & Serializable)member -> this.getName$1((Ast.StructTypeMember)member), data.members().map((Function1<Tuple3, AstNode> & Serializable)_$1 -> (AstNode)_$1._2())).flatMap((Function1<BoxedUnit, Either> & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return TypeExpressionAnalyzer.defStructAnnotatedNode$(this, a, aNode).map((Function1<Analysis, Analysis> & Serializable)a -> {
                Map empty = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
                Map members2 = data.members().foldLeft(empty, (Function2<Map, Tuple3, Map> & Serializable)(members, aNode) -> this.visitor$6((Analysis)a, (Map)members, (Tuple3)aNode));
                Type.AnonStruct anonStruct = Type$AnonStruct$.MODULE$.apply(members2);
                Type.Struct t = Type$Struct$.MODULE$.apply(aNode, anonStruct, Type$Struct$.MODULE$.$lessinit$greater$default$3(), Type$Struct$.MODULE$.$lessinit$greater$default$4(), Type$Struct$.MODULE$.$lessinit$greater$default$5());
                AstNode astNode = Predef$.MODULE$.ArrowAssoc(node2);
                return a.assignType(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(astNode, t));
            });
        });
    }
}

