/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.analysis;

import fpp.compiler.analysis.Connection;
import fpp.compiler.analysis.GeneralPortNumbering$;
import fpp.compiler.analysis.MatchedPortNumbering$;
import fpp.compiler.analysis.PortInstance;
import fpp.compiler.analysis.PortInstanceIdentifier;
import fpp.compiler.analysis.Topology;
import fpp.compiler.util.Error;
import fpp.compiler.util.Location;
import fpp.compiler.util.Result$;
import fpp.compiler.util.SemanticError$DuplicateOutputConnection$;
import fpp.compiler.util.SemanticError$TooManyOutputPorts$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class ResolvePortNumbers$
implements Serializable {
    public static final ResolvePortNumbers$ MODULE$ = new ResolvePortNumbers$();

    private ResolvePortNumbers$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResolvePortNumbers$.class);
    }

    private Either<Error, BoxedUnit> checkOutputPorts(Topology t) {
        return Result$.MODULE$.foldLeft(t.outputConnectionMap().toList(), BoxedUnit.UNIT, (Function2<BoxedUnit, Tuple2, Either> & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2<BoxedUnit, Tuple2> tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 == null || (tuple2 = tuple22._2()) == null) {
                throw new MatchError(tuple22);
            }
            PortInstanceIdentifier pii = (PortInstanceIdentifier)tuple2._1();
            Set s = (Set)tuple2._2();
            return this.checkOutputSizeBounds(pii, s).flatMap((Function1<BoxedUnit, Either> & Serializable)x$12 -> {
                BoxedUnit boxedUnit = x$12;
                return this.checkDuplicateOutputConnections(s).map(x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                });
            });
        });
    }

    private Either<Error, BoxedUnit> checkDuplicateOutputConnections(Set<Connection> connections) {
        Map portNumMap = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
        return Result$.MODULE$.foldLeft(connections.toList(), portNumMap, (Function2<Map, Connection, Either> & Serializable)(m, c) -> {
            Either either;
            Option<Object> option = c.from().portNumber();
            if (option instanceof Some) {
                int portNum = BoxesRunTime.unboxToInt(((Some)option).value());
                Option option2 = m.get(BoxesRunTime.boxToInteger(portNum));
                if (option2 instanceof Some) {
                    Connection prevC = (Connection)((Some)option2).value();
                    Location loc = c.from().loc();
                    Location prevLoc = prevC.from().loc();
                    either = package$.MODULE$.Left().apply(SemanticError$DuplicateOutputConnection$.MODULE$.apply(loc, portNum, prevLoc));
                    return either;
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(portNum));
                    either = package$.MODULE$.Right().apply(m.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, c)));
                }
                return either;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                either = package$.MODULE$.Right().apply(m);
            }
            return either;
        }).map(x$1 -> {
            Map map = x$1;
        });
    }

    private Either<Error, BoxedUnit> checkOutputSizeBounds(PortInstanceIdentifier pii, Set<Connection> connections) {
        Either either;
        PortInstance pi = pii.portInstance();
        int arraySize = pi.getArraySize();
        int numPorts = connections.size();
        if (numPorts <= arraySize) {
            either = package$.MODULE$.Right().apply(BoxedUnit.UNIT);
        } else {
            Location loc = pi.getLoc();
            Location instanceLoc = pii.componentInstance().getLoc();
            either = package$.MODULE$.Left().apply(SemanticError$TooManyOutputPorts$.MODULE$.apply(loc, numPorts, arraySize, instanceLoc));
        }
        return either;
    }

    public Either<Error, Topology> resolve(Topology t) {
        return this.checkOutputPorts(t).flatMap((Function1<BoxedUnit, Either> & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return MatchedPortNumbering$.MODULE$.apply(t).flatMap((Function1<Topology, Either> & Serializable)t2 -> package$.MODULE$.Right().apply(GeneralPortNumbering$.MODULE$.apply((Topology)t2)).map((Function1<Topology, Topology> & Serializable)t -> t));
        });
    }
}

