/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import io.circe.JsonFloat$;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.math.BigDecimal;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;

public final class JsonFloat
extends JsonNumber
implements Product {
    private final float value;

    public static JsonFloat apply(float f) {
        return JsonFloat$.MODULE$.apply(f);
    }

    public static JsonFloat fromProduct(Product product) {
        return JsonFloat$.MODULE$.fromProduct(product);
    }

    public static JsonFloat unapply(JsonFloat jsonFloat) {
        return JsonFloat$.MODULE$.unapply(jsonFloat);
    }

    public JsonFloat(float value) {
        this.value = value;
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof JsonFloat;
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public String productPrefix() {
        return "JsonFloat";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return BoxesRunTime.boxToFloat(this._1());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }
        return "value";
    }

    public float value() {
        return this.value;
    }

    @Override
    public BiggerDecimal toBiggerDecimal() {
        return BiggerDecimal$.MODULE$.fromFloat(this.value());
    }

    private BigDecimal toJavaBigDecimal() {
        return new BigDecimal(Float.toString(this.value()));
    }

    @Override
    public final Option<scala.math.BigDecimal> toBigDecimal() {
        return Some$.MODULE$.apply(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(this.toJavaBigDecimal()));
    }

    @Override
    public final Option<BigInt> toBigInt() {
        BigDecimal asBigDecimal = this.toJavaBigDecimal();
        return JsonNumber$.MODULE$.bigDecimalIsWhole(asBigDecimal) ? Some$.MODULE$.apply(new BigInt(asBigDecimal.toBigInteger())) : None$.MODULE$;
    }

    @Override
    public final double toDouble() {
        return this.toJavaBigDecimal().doubleValue();
    }

    @Override
    public final float toFloat() {
        return this.value();
    }

    @Override
    public final Option<Object> toLong() {
        BigDecimal asBigDecimal = this.toJavaBigDecimal();
        return JsonNumber$.MODULE$.bigDecimalIsValidLong(asBigDecimal) ? Some$.MODULE$.apply(BoxesRunTime.boxToLong(asBigDecimal.longValue())) : None$.MODULE$;
    }

    public final String toString() {
        return Float.toString(this.value());
    }

    @Override
    public void appendToStringBuilder(StringBuilder builder) {
        builder.append(this.value());
    }

    public JsonFloat copy(float value) {
        return new JsonFloat(value);
    }

    public float copy$default$1() {
        return this.value();
    }

    public float _1() {
        return this.value();
    }
}

