/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.kernel.Eq;
import cats.kernel.Eq$;
import io.circe.BiggerDecimalJsonNumber;
import io.circe.JsonBigDecimal;
import io.circe.JsonBigDecimal$;
import io.circe.JsonBiggerDecimal$;
import io.circe.JsonDecimal$;
import io.circe.JsonDouble;
import io.circe.JsonDouble$;
import io.circe.JsonFloat;
import io.circe.JsonFloat$;
import io.circe.JsonLong;
import io.circe.JsonLong$;
import io.circe.JsonNumber;
import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import java.math.BigDecimal;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;

public final class JsonNumber$
implements Mirror.Sum,
Serializable {
    private static final BigDecimal bigDecimalMinLong;
    private static final BigDecimal bigDecimalMaxLong;
    private static final Eq eqJsonNumber;
    public static final JsonNumber$ MODULE$;

    private JsonNumber$() {
    }

    static {
        MODULE$ = new JsonNumber$();
        bigDecimalMinLong = new BigDecimal(Long.MIN_VALUE);
        bigDecimalMaxLong = new BigDecimal(Long.MAX_VALUE);
        eqJsonNumber = Eq$.MODULE$.instance((Function2<JsonNumber, JsonNumber, boolean> & Serializable)(x$1, x$2) -> {
            Tuple2<JsonNumber, JsonNumber> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) throw new MatchError(tuple2);
            JsonNumber jsonNumber = tuple2._1();
            JsonNumber jsonNumber2 = tuple2._2();
            if (jsonNumber instanceof JsonLong) {
                long l;
                JsonLong jsonLong = JsonLong$.MODULE$.unapply((JsonLong)jsonNumber);
                long x = l = jsonLong._1();
                if (jsonNumber2 instanceof JsonLong) {
                    JsonLong jsonLong2 = JsonLong$.MODULE$.unapply((JsonLong)jsonNumber2);
                    long l2 = jsonLong2._1();
                    long y = l2;
                    if (x != y) return false;
                    return true;
                }
            }
            if (jsonNumber instanceof JsonDouble) {
                double d;
                JsonDouble jsonDouble = JsonDouble$.MODULE$.unapply((JsonDouble)jsonNumber);
                double x = d = jsonDouble._1();
                if (jsonNumber2 instanceof JsonDouble) {
                    JsonDouble jsonDouble2 = JsonDouble$.MODULE$.unapply((JsonDouble)jsonNumber2);
                    double d2 = jsonDouble2._1();
                    double y = d2;
                    if (Double.compare(x, y) != 0) return false;
                    return true;
                }
            }
            if (jsonNumber instanceof JsonFloat) {
                float f;
                JsonFloat jsonFloat = JsonFloat$.MODULE$.unapply((JsonFloat)jsonNumber);
                float x = f = jsonFloat._1();
                if (jsonNumber2 instanceof JsonFloat) {
                    JsonFloat jsonFloat2 = JsonFloat$.MODULE$.unapply((JsonFloat)jsonNumber2);
                    float f2 = jsonFloat2._1();
                    float y = f2;
                    if (Float.compare(x, y) != 0) return false;
                    return true;
                }
            }
            if (jsonNumber instanceof JsonBigDecimal) {
                BigDecimal bigDecimal;
                JsonBigDecimal jsonBigDecimal = JsonBigDecimal$.MODULE$.unapply((JsonBigDecimal)jsonNumber);
                BigDecimal x = bigDecimal = jsonBigDecimal._1();
                if (jsonNumber2 instanceof JsonBigDecimal) {
                    JsonBigDecimal jsonBigDecimal2 = JsonBigDecimal$.MODULE$.unapply((JsonBigDecimal)jsonNumber2);
                    BigDecimal bigDecimal2 = jsonBigDecimal2._1();
                    BigDecimal y = bigDecimal2;
                    if (x.compareTo(y) != 0) return false;
                    return true;
                }
            }
            JsonNumber a = jsonNumber;
            JsonNumber b = jsonNumber2;
            BiggerDecimal biggerDecimal = a.toBiggerDecimal();
            BiggerDecimal biggerDecimal2 = b.toBiggerDecimal();
            if (biggerDecimal != null) {
                if (!biggerDecimal.equals(biggerDecimal2)) return false;
                return true;
            }
            if (biggerDecimal2 == null) return true;
            return false;
        });
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonNumber$.class);
    }

    public final JsonNumber fromDecimalStringUnsafe(String value) {
        return JsonDecimal$.MODULE$.apply(value);
    }

    public final JsonNumber fromIntegralStringUnsafe(String value) {
        JsonNumber jsonNumber;
        if (!BiggerDecimal$.MODULE$.integralIsValidLong(value)) {
            jsonNumber = JsonDecimal$.MODULE$.apply(value);
        } else {
            long longValue = Long.parseLong(value);
            jsonNumber = value.charAt(0) == '-' && longValue == 0L ? JsonDecimal$.MODULE$.apply(value) : JsonLong$.MODULE$.apply(longValue);
        }
        return jsonNumber;
    }

    public final Option<JsonNumber> fromString(String value) {
        BiggerDecimal result = BiggerDecimal$.MODULE$.parseBiggerDecimalUnsafe(value);
        return result == null ? None$.MODULE$ : Some$.MODULE$.apply(JsonBiggerDecimal$.MODULE$.apply(result, value));
    }

    public boolean bigDecimalIsWhole(BigDecimal value) {
        return value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    public boolean bigDecimalIsValidLong(BigDecimal value) {
        return this.bigDecimalIsWhole(value) && value.compareTo(bigDecimalMinLong) >= 0 && value.compareTo(bigDecimalMaxLong) <= 0;
    }

    public final Eq<JsonNumber> eqJsonNumber() {
        return eqJsonNumber;
    }

    public int ordinal(JsonNumber x$0) {
        int n;
        JsonNumber jsonNumber = x$0;
        if (jsonNumber instanceof BiggerDecimalJsonNumber) {
            n = 0;
        } else if (jsonNumber instanceof JsonBigDecimal) {
            n = 1;
        } else if (jsonNumber instanceof JsonLong) {
            n = 2;
        } else if (jsonNumber instanceof JsonDouble) {
            n = 3;
        } else if (jsonNumber instanceof JsonFloat) {
            n = 4;
        } else {
            throw new MatchError(jsonNumber);
        }
        return n;
    }
}

