"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketWebsiteTarget = void 0;
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use a S3 as an alias record target
 */
class BucketWebsiteTarget {
    constructor(bucket) {
        this.bucket = bucket;
    }
    bind(_record) {
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
//# sourceMappingURL=data:application/json;base64,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