"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined
     */
    static getHostedZoneId(scope) {
        var _a;
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_a = scopeStack.node.tryFindChild(mappingName)) !== null && _a !== void 0 ? _a : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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