"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target
 */
class UserPoolDomainTarget {
    constructor(domain) {
        this.domain = domain;
    }
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLDJEQUF1RDtBQUV2RDs7R0FFRztBQUNILE1BQWEsb0JBQW9CO0lBQy9CLFlBQTZCLE1BQXNCO1FBQXRCLFdBQU0sR0FBTixNQUFNLENBQWdCO0lBQ25ELENBQUM7SUFFTSxJQUFJLENBQUMsT0FBbUI7UUFDN0IsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQjtZQUN6QyxZQUFZLEVBQUUsb0NBQWdCLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDNUQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQVZELG9EQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVXNlclBvb2xEb21haW4gfSBmcm9tICdAYXdzLWNkay9hd3MtY29nbml0byc7XG5pbXBvcnQgeyBBbGlhc1JlY29yZFRhcmdldENvbmZpZywgSUFsaWFzUmVjb3JkVGFyZ2V0LCBJUmVjb3JkU2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ2xvdWRGcm9udFRhcmdldCB9IGZyb20gJy4vY2xvdWRmcm9udC10YXJnZXQnO1xuXG4vKipcbiAqIFVzZSBhIHVzZXIgcG9vbCBkb21haW4gYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgVXNlclBvb2xEb21haW5UYXJnZXQgaW1wbGVtZW50cyBJQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRvbWFpbjogVXNlclBvb2xEb21haW4pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IElSZWNvcmRTZXQpOiBBbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGRuc05hbWU6IHRoaXMuZG9tYWluLmNsb3VkRnJvbnREb21haW5OYW1lLFxuICAgICAgaG9zdGVkWm9uZUlkOiBDbG91ZEZyb250VGFyZ2V0LmdldEhvc3RlZFpvbmVJZCh0aGlzLmRvbWFpbiksXG4gICAgfTtcbiAgfVxufVxuIl19