# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/01_dialog_system.ipynb (unless otherwise specified).

__all__ = ['run_shell_installs', 'replacement_f', 'gen_faq_config_file', 'load_qa_models', 'select_squad_responses',
           'select_faq_responses', 'format_responses', 'get_responses', 'get_input', 'new_answer', 'question_response',
           'dialog_system']

# Cell
# export
from deeppavlov import configs,build_model,train_model
import json
from os import path,popen
import pandas as pd
import numpy as np
from pathlib import Path
import logging

logging.basicConfig(format='%(asctime)s %(levelname)s:%(message)s', level=logging.DEBUG, datefmt='%I:%M:%S')
logging.info("test: hola")
logging.error('test: adios')

# Cell
def run_shell_installs():
    ''' Run install commands
    '''
    command_strings = (
        ' pip install deeppavlov',
        ' python -m deeppavlov install squad',
        ' python -m deeppavlov install squad_bert',
        ' python -m deeppavlov install fasttext_avg_autofaq',
        ' python -m deeppavlov install fasttext_tfidf_autofaq',
        ' python -m deeppavlov install tfidf_autofaq',
        ' python -m deeppavlov install tfidf_logreg_autofaq ',
        ' python -m deeppavlov install tfidf_logreg_en_faq'
    )
    for command in command_strings:
        logging.debug(command)
        logging.debug(popen(command).read())


# Cell
def replacement_f(model_config,**args):
    for k,v in args.items():
        if isinstance(v,dict):
            replacement_f(model_config[k],**v)
        else:
            model_config[k] = v

def gen_faq_config_file(**args):

    #set FAQ data in config file
    model_config = json.load(open(configs.faq.tfidf_logreg_en_faq))
    if 'data_url' in model_config['dataset_reader']:
        del model_config['dataset_reader']['data_url']

    replacement_f(model_config,**args)

    json.dump(model_config, open(configs.faq.tfidf_logreg_en_faq, 'w'))

# Cell
def load_qa_models():
    qa_models = {
        'squad':
            {
                'rnet': build_model(configs.squad.squad, download=True),
                'bert': build_model(configs.squad.squad_bert, download=True)
            },
        'faq':
            {
                'tfidf':
                    train_model(configs.faq.tfidf_logreg_en_faq, download=True)
            }
    }
    return qa_models

# Cell
def select_squad_responses(
    contexts, squad_model, question, num_returned_values=1
):
    responses = contexts.context.apply(
        lambda context: squad_model([context], [question])
    ).values
    return [
        r[0][0] for r in sorted(responses, key=lambda x: -1 * x[2][0])
        [:num_returned_values]
    ]


def select_faq_responses(faq_model, question):
    return faq_model([question])[0]


def format_responses(question, responses):
    formatted_response = f'{question}:\n\n'
    for k, res in enumerate(responses):
        formatted_response += f'{k}: {res}\n'
    return formatted_response


def get_responses(
    contexts, question, qa_models, num_returned_values_per_squad_model=1
):
    responses = []
    for squad_model in qa_models['squad'].values():
        responses.extend(
            select_squad_responses(
                contexts,
                squad_model,
                question,
                num_returned_values=num_returned_values_per_squad_model
            )
        )
    for faq_model in qa_models['faq'].values():
        responses.extend(select_faq_responses(faq_model, question))
    return format_responses(question, set([r for r in responses if r.strip()]))

# Cell
def get_input(text):
    '''This redundancy is needed for testing'''
    return input(text)


def new_answer(question, data, qa_models):

    if get_input('Give a better anwser [y/n]?')[0].lower() != 'y':
        return 'no data updates..'

    if get_input('Give the answer as a context [y/n]?')[0].lower() == 'y':
        new_context = pd.DataFrame(
            {
                'topic': [get_input('Give context a title:\n')],
                'context': [get_input('Introduce the context:\n')]
            }
        )
        data['context']['df'] = data['context']['df'].append(new_context)
        data['context']['df'].to_csv(data['context']['path'])

        return 'contexts dataset updated..'
    else:
        new_faq = pd.DataFrame(
            {
                'Question': [question],
                'Answer': [get_input('Introduce the answer:\n')]
            }
        )
        data['faq']['df'] = data['faq']['df'].append(new_faq)
        data['faq']['df'].to_csv(data['faq']['path'])
        qa_models['faq']['tfidf'] = train_model(
            configs.faq.tfidf_logreg_en_faq, download=False
        )
        return 'FAQ dataset and model updated..'


def question_response(data, qa_models, num_returned_values_per_squad_model=1):
    question = get_input('Introduce question:\n')

    responses = get_responses(
        data['context']['df'], question, qa_models,
        num_returned_values_per_squad_model
    )
    return responses, new_answer(question, data, qa_models)

# Cell
def dialog_system():

    PARENT_DIR = popen('dirname $PWD').read().strip()
    CONTEXT_DATA_FILE = path.join(PARENT_DIR, 'data/context_data.csv')
    FAQ_DATA_FILE = path.join(PARENT_DIR, 'data/faq_data.csv')

    run_shell_installs()
    qa_models = load_qa_models()

    context = {'df': pd.read_csv(CONTEXT_DATA_FILE), 'path': CONTEXT_DATA_FILE}
    faq = {'df': pd.read_csv(FAQ_DATA_FILE), 'path': FAQ_DATA_FILE}

    data = {'context': context, 'faq': faq}

    while True:
        try:
            question_response(data=data, qa_models=qa_models)
        except (KeyboardInterrupt, EOFError, SystemExit):
            logging.info('Goodbye!')
            return 'Goodbye!'