import { IConstruct } from "./construct";
import { Intrinsic } from "./private/intrinsic";
import { IPostProcessor, IResolveContext } from "./resolvable";
/**
 * Given an object, converts all keys to PascalCase given they are currently in camel case.
 * @param obj The object.
 */
export declare function capitalizePropertyNames(construct: IConstruct, obj: any): any;
/**
 * Turns empty arrays/objects to undefined (after evaluating tokens).
 */
export declare function ignoreEmpty(obj: any): any;
/**
 * Returns a copy of `obj` without `undefined` (or `null`) values in maps or arrays.
 */
export declare function filterUndefined(obj: any): any;
/**
 * A Token that applies a function AFTER resolve resolution
 */
export declare class PostResolveToken extends Intrinsic implements IPostProcessor {
    private readonly processor;
    constructor(value: any, processor: (x: any) => any);
    resolve(context: IResolveContext): any;
    postProcess(o: any, _context: IResolveContext): any;
}
