"""Implementations of 'Overridable' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""

from __future__ import annotations

from enum import Enum
from typing import TypeVar

from mastapy.materials.efficiency import _294
from mastapy._internal import mixins
from mastapy._internal.python_net import python_net_import

_OVERRIDABLE = python_net_import("SMT.MastaAPI.Utility.Property", "Overridable")


__docformat__ = "restructuredtext en"
__all__ = ("Overridable_EfficiencyRatingMethod",)


Self = TypeVar("Self", bound="Overridable_EfficiencyRatingMethod")


class Overridable_EfficiencyRatingMethod(mixins.OverridableMixin, Enum):
    """Overridable_EfficiencyRatingMethod

    A specific implementation of 'Overridable' for 'EfficiencyRatingMethod' types.
    """

    __qualname__ = "EfficiencyRatingMethod"

    @classmethod
    def wrapper_type(cls) -> "_OVERRIDABLE":
        """Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _OVERRIDABLE

    @classmethod
    def wrapped_type(cls) -> "_294.EfficiencyRatingMethod":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly
        """

        return _294.EfficiencyRatingMethod

    @classmethod
    def implicit_type(cls) -> "_294.EfficiencyRatingMethod.type_()":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _294.EfficiencyRatingMethod.type_()

    @property
    def value(self: Self) -> "_294.EfficiencyRatingMethod":
        """mastapy.materials.efficiency.EfficiencyRatingMethod

        Note:
            This property is readonly.
        """
        return None

    @property
    def overridden(self: Self) -> "bool":
        """bool

        Note:
            This property is readonly.
        """
        return None

    @property
    def override_value(self: Self) -> "_294.EfficiencyRatingMethod":
        """mastapy.materials.efficiency.EfficiencyRatingMethod

        Note:
            This property is readonly.
        """
        return None

    @property
    def calculated_value(self: Self) -> "_294.EfficiencyRatingMethod":
        """mastapy.materials.efficiency.EfficiencyRatingMethod

        Note:
            This property is readonly.
        """
        return None
