"""PressureAngleTypes"""

from __future__ import annotations

from typing import TypeVar, Any
from enum import Enum

from mastapy._internal.python_net import python_net_import

_PRESSURE_ANGLE_TYPES = python_net_import(
    "SMT.MastaAPI.DetailedRigidConnectors.Splines", "PressureAngleTypes"
)


__docformat__ = "restructuredtext en"
__all__ = ("PressureAngleTypes",)


Self = TypeVar("Self", bound="PressureAngleTypes")


class PressureAngleTypes(Enum):
    """PressureAngleTypes

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls):
        return _PRESSURE_ANGLE_TYPES

    _30 = 0
    _375 = 1
    _45 = 2


def __enum_setattr(self: Self, attr: str, value: Any):
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: Self, attr: str):
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


PressureAngleTypes.__setattr__ = __enum_setattr
PressureAngleTypes.__delattr__ = __enum_delattr
