"""NonLinearDQModelGeneratorSettings"""

from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, Union, Tuple, List

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal.implicit import enum_with_selected_value, overridable
from mastapy.nodal_analysis.elmer import _169
from mastapy._internal.overridable_constructor import _unpack_overridable
from mastapy._internal import enum_with_selected_value_runtime, conversion, constructor
from mastapy import _0
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_NON_LINEAR_DQ_MODEL_GENERATOR_SETTINGS = python_net_import(
    "SMT.MastaAPI.ElectricMachines.Results", "NonLinearDQModelGeneratorSettings"
)

if TYPE_CHECKING:
    from mastapy.electric_machines.load_cases_and_analyses import _1376


__docformat__ = "restructuredtext en"
__all__ = ("NonLinearDQModelGeneratorSettings",)


Self = TypeVar("Self", bound="NonLinearDQModelGeneratorSettings")


class NonLinearDQModelGeneratorSettings(_0.APIBase):
    """NonLinearDQModelGeneratorSettings

    This is a mastapy class.
    """

    TYPE = _NON_LINEAR_DQ_MODEL_GENERATOR_SETTINGS
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_NonLinearDQModelGeneratorSettings")

    class _Cast_NonLinearDQModelGeneratorSettings:
        """Special nested class for casting NonLinearDQModelGeneratorSettings to subclasses."""

        def __init__(
            self: "NonLinearDQModelGeneratorSettings._Cast_NonLinearDQModelGeneratorSettings",
            parent: "NonLinearDQModelGeneratorSettings",
        ):
            self._parent = parent

        @property
        def non_linear_dq_model_generator_settings(
            self: "NonLinearDQModelGeneratorSettings._Cast_NonLinearDQModelGeneratorSettings",
        ) -> "NonLinearDQModelGeneratorSettings":
            return self._parent

        def __getattr__(
            self: "NonLinearDQModelGeneratorSettings._Cast_NonLinearDQModelGeneratorSettings",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "NonLinearDQModelGeneratorSettings.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def analysis_period(
        self: Self,
    ) -> "enum_with_selected_value.EnumWithSelectedValue_ElectricMachineAnalysisPeriod":
        """EnumWithSelectedValue[mastapy.nodal_analysis.elmer.ElectricMachineAnalysisPeriod]"""
        temp = self.wrapped.AnalysisPeriod

        if temp is None:
            return None

        value = (
            enum_with_selected_value.EnumWithSelectedValue_ElectricMachineAnalysisPeriod.wrapped_type()
        )
        return enum_with_selected_value_runtime.create(temp, value)

    @analysis_period.setter
    @enforce_parameter_types
    def analysis_period(self: Self, value: "_169.ElectricMachineAnalysisPeriod"):
        wrapper_type = enum_with_selected_value_runtime.ENUM_WITH_SELECTED_VALUE
        enclosed_type = (
            enum_with_selected_value.EnumWithSelectedValue_ElectricMachineAnalysisPeriod.implicit_type()
        )
        value = conversion.mp_to_pn_enum(value, enclosed_type)
        value = wrapper_type[enclosed_type](value)
        self.wrapped.AnalysisPeriod = value

    @property
    def copy_all_setups(self: Self) -> "bool":
        """bool"""
        temp = self.wrapped.CopyAllSetups

        if temp is None:
            return False

        return temp

    @copy_all_setups.setter
    @enforce_parameter_types
    def copy_all_setups(self: Self, value: "bool"):
        self.wrapped.CopyAllSetups = bool(value) if value is not None else False

    @property
    def exponent_for_ac_winding_loss_temperature_scaling(self: Self) -> "float":
        """float"""
        temp = self.wrapped.ExponentForACWindingLossTemperatureScaling

        if temp is None:
            return 0.0

        return temp

    @exponent_for_ac_winding_loss_temperature_scaling.setter
    @enforce_parameter_types
    def exponent_for_ac_winding_loss_temperature_scaling(self: Self, value: "float"):
        self.wrapped.ExponentForACWindingLossTemperatureScaling = (
            float(value) if value is not None else 0.0
        )

    @property
    def include_ac_winding_losses(self: Self) -> "bool":
        """bool"""
        temp = self.wrapped.IncludeACWindingLosses

        if temp is None:
            return False

        return temp

    @include_ac_winding_losses.setter
    @enforce_parameter_types
    def include_ac_winding_losses(self: Self, value: "bool"):
        self.wrapped.IncludeACWindingLosses = (
            bool(value) if value is not None else False
        )

    @property
    def include_efficiency(self: Self) -> "bool":
        """bool"""
        temp = self.wrapped.IncludeEfficiency

        if temp is None:
            return False

        return temp

    @include_efficiency.setter
    @enforce_parameter_types
    def include_efficiency(self: Self, value: "bool"):
        self.wrapped.IncludeEfficiency = bool(value) if value is not None else False

    @property
    def maximum_current_angle_for_map(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MaximumCurrentAngleForMap

        if temp is None:
            return 0.0

        return temp

    @maximum_current_angle_for_map.setter
    @enforce_parameter_types
    def maximum_current_angle_for_map(self: Self, value: "float"):
        self.wrapped.MaximumCurrentAngleForMap = (
            float(value) if value is not None else 0.0
        )

    @property
    def maximum_peak_line_current_magnitude_for_map(
        self: Self,
    ) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MaximumPeakLineCurrentMagnitudeForMap

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @maximum_peak_line_current_magnitude_for_map.setter
    @enforce_parameter_types
    def maximum_peak_line_current_magnitude_for_map(
        self: Self, value: "Union[float, Tuple[float, bool]]"
    ):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MaximumPeakLineCurrentMagnitudeForMap = value

    @property
    def minimum_current_angle_for_map(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumCurrentAngleForMap

        if temp is None:
            return 0.0

        return temp

    @minimum_current_angle_for_map.setter
    @enforce_parameter_types
    def minimum_current_angle_for_map(self: Self, value: "float"):
        self.wrapped.MinimumCurrentAngleForMap = (
            float(value) if value is not None else 0.0
        )

    @property
    def minimum_peak_line_current_magnitude_for_map(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MinimumPeakLineCurrentMagnitudeForMap

        if temp is None:
            return 0.0

        return temp

    @minimum_peak_line_current_magnitude_for_map.setter
    @enforce_parameter_types
    def minimum_peak_line_current_magnitude_for_map(self: Self, value: "float"):
        self.wrapped.MinimumPeakLineCurrentMagnitudeForMap = (
            float(value) if value is not None else 0.0
        )

    @property
    def non_linear_system_convergence_tolerance(self: Self) -> "float":
        """float"""
        temp = self.wrapped.NonLinearSystemConvergenceTolerance

        if temp is None:
            return 0.0

        return temp

    @non_linear_system_convergence_tolerance.setter
    @enforce_parameter_types
    def non_linear_system_convergence_tolerance(self: Self, value: "float"):
        self.wrapped.NonLinearSystemConvergenceTolerance = (
            float(value) if value is not None else 0.0
        )

    @property
    def number_of_current_angle_points(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfCurrentAnglePoints

        if temp is None:
            return 0

        return temp

    @number_of_current_angle_points.setter
    @enforce_parameter_types
    def number_of_current_angle_points(self: Self, value: "int"):
        self.wrapped.NumberOfCurrentAnglePoints = int(value) if value is not None else 0

    @property
    def number_of_current_magnitude_points(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfCurrentMagnitudePoints

        if temp is None:
            return 0

        return temp

    @number_of_current_magnitude_points.setter
    @enforce_parameter_types
    def number_of_current_magnitude_points(self: Self, value: "int"):
        self.wrapped.NumberOfCurrentMagnitudePoints = (
            int(value) if value is not None else 0
        )

    @property
    def number_of_initial_transient_steps(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfInitialTransientSteps

        if temp is None:
            return 0

        return temp

    @number_of_initial_transient_steps.setter
    @enforce_parameter_types
    def number_of_initial_transient_steps(self: Self, value: "int"):
        self.wrapped.NumberOfInitialTransientSteps = (
            int(value) if value is not None else 0
        )

    @property
    def number_of_time_steps_for_analysis_period(self: Self) -> "int":
        """int"""
        temp = self.wrapped.NumberOfTimeStepsForAnalysisPeriod

        if temp is None:
            return 0

        return temp

    @number_of_time_steps_for_analysis_period.setter
    @enforce_parameter_types
    def number_of_time_steps_for_analysis_period(self: Self, value: "int"):
        self.wrapped.NumberOfTimeStepsForAnalysisPeriod = (
            int(value) if value is not None else 0
        )

    @property
    def reference_speed(self: Self) -> "float":
        """float"""
        temp = self.wrapped.ReferenceSpeed

        if temp is None:
            return 0.0

        return temp

    @reference_speed.setter
    @enforce_parameter_types
    def reference_speed(self: Self, value: "float"):
        self.wrapped.ReferenceSpeed = float(value) if value is not None else 0.0

    @property
    def temperatures(self: Self) -> "_1376.Temperatures":
        """mastapy.electric_machines.load_cases_and_analyses.Temperatures

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Temperatures

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def report_names(self: Self) -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ReportNames

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else "")

    def get_default_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else "")

    @enforce_parameter_types
    def output_active_report_as_text_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else "")

    def get_active_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_named_report_to(self: Self, report_name: "str", file_path: "str"):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: Self, report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(
            report_name if report_name else ""
        )
        return method_result

    @property
    def cast_to(
        self: Self,
    ) -> "NonLinearDQModelGeneratorSettings._Cast_NonLinearDQModelGeneratorSettings":
        return self._Cast_NonLinearDQModelGeneratorSettings(self)
