"""QualityGrade"""

from __future__ import annotations

from typing import TypeVar, Any
from enum import Enum

from mastapy._internal.python_net import python_net_import

_QUALITY_GRADE = python_net_import("SMT.MastaAPI.Materials", "QualityGrade")


__docformat__ = "restructuredtext en"
__all__ = ("QualityGrade",)


Self = TypeVar("Self", bound="QualityGrade")


class QualityGrade(Enum):
    """QualityGrade

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls):
        return _QUALITY_GRADE

    ML = 0
    MQ = 1
    ME = 2


def __enum_setattr(self: Self, attr: str, value: Any):
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: Self, attr: str):
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


QualityGrade.__setattr__ = __enum_setattr
QualityGrade.__delattr__ = __enum_delattr
